/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

public class WeakPropertyChangeListener
implements PropertyChangeListener {
    WeakReference<?> listenerRef;
    Object src;

    public WeakPropertyChangeListener(PropertyChangeListener listener, Object src) {
        this.listenerRef = new WeakReference<PropertyChangeListener>(listener);
        this.src = src;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        PropertyChangeListener listener = (PropertyChangeListener)this.listenerRef.get();
        if (listener == null) {
            this.removeListener();
        } else {
            listener.propertyChange(evt);
        }
    }

    private void removeListener() {
        try {
            Method method = this.src.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
            method.invoke(this.src, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

