/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionListBuilder;
import com.eviware.soapui.support.action.swing.ActionSupport;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeNode<T extends ModelItem>
implements SoapUITreeNode {
    private T modelItem;

    public AbstractTreeNode(T modelItem) {
        this.modelItem = modelItem;
    }

    @Override
    public boolean valueChanged(Object newValue) {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public JPopupMenu getPopup() {
        return ActionSupport.buildPopup(this.getActions());
    }

    @Override
    public ActionList getActions() {
        return ActionListBuilder.buildActions(this.modelItem);
    }

    public T getModelItem() {
        return this.modelItem;
    }

    public String toString() {
        return this.modelItem.getName();
    }

    @Override
    public void reorder(boolean notify) {
    }

    public Enumeration children() {
        Vector<TreeNode> children = new Vector<TreeNode>();
        for (int c = 0; c < this.getChildCount(); ++c) {
            children.add(this.getChildAt(c));
        }
        return children.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.getChildNode(childIndex);
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getIndexOfChild(node);
    }

    @Override
    public TreeNode getParent() {
        return this.getParentTreeNode();
    }
}

