/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.PropertiesTypeConfig;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.support.XmlBeansPropertiesTestPropertyHolder;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.settings.GlobalPropertySettings;
import com.eviware.soapui.support.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsTestPropertyHolder
implements MutableTestPropertyHolder,
Map<String, TestProperty> {
    public static final Logger log = Logger.getLogger(SettingsTestPropertyHolder.class);
    private XmlBeansPropertiesTestPropertyHolder propertyHolderSupport;
    private PropertiesTypeConfig config;
    private final ModelItem modelItem;
    private String propertiesLabel = "Test Properties";

    public SettingsTestPropertyHolder(Settings settings, ModelItem modelItem) {
        this.modelItem = modelItem;
        this.config = PropertiesTypeConfig.Factory.newInstance();
        try {
            String str = settings.getString(GlobalPropertySettings.PROPERTIES, null);
            if (StringUtils.hasContent(str)) {
                this.config = PropertiesTypeConfig.Factory.parse((String)str);
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        this.propertyHolderSupport = new XmlBeansPropertiesTestPropertyHolder(null, this.config);
    }

    @Override
    public TestProperty addProperty(String name) {
        return this.propertyHolderSupport.addProperty(name);
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolderSupport.addTestPropertyListener(listener);
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        return this.propertyHolderSupport.getProperties();
    }

    @Override
    public XmlBeansPropertiesTestPropertyHolder.PropertiesStepProperty getProperty(String name) {
        return this.propertyHolderSupport.getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyHolderSupport.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.propertyHolderSupport.getPropertyValue(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertyHolderSupport.hasProperty(name);
    }

    @Override
    public TestProperty removeProperty(String propertyName) {
        return this.propertyHolderSupport.removeProperty(propertyName);
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolderSupport.removeTestPropertyListener(listener);
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        return this.propertyHolderSupport.renameProperty(name, newName);
    }

    public void saveTo(Settings settings) {
        settings.setString(GlobalPropertySettings.PROPERTIES, this.config.toString());
    }

    @Override
    public void setPropertyValue(String name, String value) {
        this.propertyHolderSupport.setPropertyValue(name, value);
    }

    public int addPropertiesFromFile(String propFile) {
        return this.propertyHolderSupport.addPropertiesFromFile(propFile);
    }

    @Override
    public ModelItem getModelItem() {
        return this.modelItem;
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        this.propertyHolderSupport.moveProperty(propertyName, targetIndex);
    }

    @Override
    public TestProperty getPropertyAt(int index) {
        return this.propertyHolderSupport.getPropertyAt(index);
    }

    @Override
    public int getPropertyCount() {
        return this.propertyHolderSupport.getPropertyCount();
    }

    @Override
    public void clear() {
        this.propertyHolderSupport.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.propertyHolderSupport.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.propertyHolderSupport.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, TestProperty>> entrySet() {
        return this.propertyHolderSupport.entrySet();
    }

    @Override
    public TestProperty get(Object key) {
        return this.propertyHolderSupport.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.propertyHolderSupport.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.propertyHolderSupport.keySet();
    }

    @Override
    public TestProperty put(String key, TestProperty value) {
        return this.propertyHolderSupport.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends TestProperty> m) {
        this.propertyHolderSupport.putAll(m);
    }

    @Override
    public TestProperty remove(Object key) {
        return this.propertyHolderSupport.remove(key);
    }

    @Override
    public int size() {
        return this.propertyHolderSupport.size();
    }

    @Override
    public Collection<TestProperty> values() {
        return this.propertyHolderSupport.values();
    }

    @Override
    public String getPropertiesLabel() {
        return this.propertiesLabel;
    }

    public void setPropertiesLabel(String propertiesLabel) {
        this.propertiesLabel = propertiesLabel;
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.propertyHolderSupport.getPropertyList();
    }
}

