/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.jms;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.JMSEndpoint;
import com.eviware.soapui.support.StringUtils;
import hermes.Domain;
import hermes.Hermes;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.NamingException;

public class JMSConnectionHolder {
    private ConnectionFactory connectionFactory = null;
    private Connection connection = null;
    private Session session = null;
    private JMSEndpoint jmsEndpoint;
    private Hermes hermes;
    private String clientID;

    public JMSConnectionHolder(JMSEndpoint jmsEndpoint, Hermes hermes, boolean isTopicDomain, String clientID, String username, String password) throws JMSException {
        try {
            this.jmsEndpoint = jmsEndpoint;
            this.hermes = hermes;
            this.clientID = clientID;
            this.connectionFactory = hermes.getConnectionFactory();
            this.connection = this.createConnection(this.connectionFactory, isTopicDomain ? Domain.TOPIC : Domain.QUEUE, clientID, username, password);
            this.connection.start();
        }
        catch (Throwable t) {
            SoapUI.logError(t);
            if (this.connection != null) {
                this.connection.close();
            }
            throw new JMSException(t.getMessage());
        }
    }

    private Connection createConnection(ConnectionFactory connectionFactory, Domain domain, String clientId, String username, String password) throws JMSException {
        Connection connection;
        Connection connection2 = connection = StringUtils.hasContent(username) ? connectionFactory.createConnection(username, password) : connectionFactory.createConnection();
        if (!StringUtils.isNullOrEmpty(clientId) && domain.equals((Object)Domain.TOPIC)) {
            connection.setClientID(clientId);
        }
        return connection;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getClientID() {
        return this.clientID;
    }

    public Hermes getHermes() {
        return this.hermes;
    }

    public JMSEndpoint getJmsEndpoint() {
        return this.jmsEndpoint;
    }

    public Topic getTopic(String name) throws JMSException, NamingException {
        return (Topic)this.getHermes().getDestination(name, Domain.TOPIC);
    }

    public Queue getQueue(String name) throws JMSException, NamingException {
        return (Queue)this.getHermes().getDestination(name, Domain.QUEUE);
    }

    public Session getSession() throws JMSException {
        if (this.session == null) {
            this.session = this.getConnection().createSession(false, 1);
            return this.session;
        }
        return this.session;
    }

    public void closeAll() {
        try {
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException e) {
            SoapUI.logError(e);
        }
    }
}

