/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.support.components.ModelItemXmlEditor;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.AssertionsPanel;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestInterface;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestInterface;
import com.eviware.soapui.impl.wsdl.teststeps.actions.AddAssertionAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.ListDataChangeListener;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.log.JLogList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTestRequestDesktopPanel
extends AbstractHttpXmlRequestDesktopPanel<HttpTestRequestStepInterface, HttpTestRequestInterface<?>> {
    private JLogList logArea;
    private InternalTestMonitorListener testMonitorListener = new InternalTestMonitorListener();
    private JButton addAssertionButton;
    protected boolean updatingRequest;
    private AssertionsPanel assertionsPanel;
    private JInspectorPanel inspectorPanel;
    private JComponentInspector<?> assertionInspector;
    private JComponentInspector<?> logInspector;
    private InternalAssertionsListener assertionsListener = new InternalAssertionsListener();
    private long startTime;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean updating;
    private JUndoableTextField pathTextField;
    private JComboBox methodCombo;

    public HttpTestRequestDesktopPanel(HttpTestRequestStepInterface testStep) {
        super(testStep, testStep.getTestRequest());
        SoapUI.getTestMonitor().addTestMonitorListener(this.testMonitorListener);
        this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(testStep.getTestCase()));
        testStep.getTestRequest().addAssertionsListener(this.assertionsListener);
        this.getSubmitButton().setEnabled(this.getSubmit() == null && StringUtils.hasContent(((HttpTestRequestInterface)this.getRequest()).getEndpoint()));
    }

    protected JComponent buildLogPanel() {
        this.logArea = new JLogList("Request Log");
        this.logArea.getLogList().getModel().addListDataListener(new ListDataChangeListener(){

            public void dataChanged(ListModel model) {
                HttpTestRequestDesktopPanel.this.logInspector.setTitle("Request Log (" + model.getSize() + ")");
            }
        });
        return this.logArea;
    }

    protected AssertionsPanel buildAssertionsPanel() {
        return new AssertionsPanel((Assertable)this.getRequest()){

            protected void selectError(AssertionError error) {
                ModelItemXmlEditor<?, ?> editor = HttpTestRequestDesktopPanel.this.getResponseEditor();
                editor.requestFocus();
            }
        };
    }

    @Override
    public void setContent(JComponent content) {
        this.inspectorPanel.setContentComponent(content);
    }

    @Override
    public void removeContent(JComponent content) {
        this.inspectorPanel.setContentComponent(null);
    }

    @Override
    protected String getHelpUrl() {
        return "http://www.soapui.org/userguide/functional/testrequests.html#The_TestRequest_Editor";
    }

    @Override
    protected JComponent buildContent() {
        JComponent component = super.buildContent();
        this.inspectorPanel = JInspectorPanelFactory.build(component);
        this.assertionsPanel = this.buildAssertionsPanel();
        this.assertionInspector = new JComponentInspector<AssertionsPanel>(this.assertionsPanel, "Assertions (" + ((HttpTestRequestStepInterface)this.getModelItem()).getAssertionCount() + ")", "Assertions for this Test Request", true);
        this.inspectorPanel.addInspector(this.assertionInspector);
        this.logInspector = new JComponentInspector<JComponent>(this.buildLogPanel(), "Request Log (0)", "Log of requests", true);
        this.inspectorPanel.addInspector(this.logInspector);
        this.inspectorPanel.setDefaultDividerLocation(0.6f);
        this.inspectorPanel.setCurrentInspector("Assertions");
        this.updateStatusIcon();
        this.getSubmitButton().setEnabled(this.getSubmit() == null && StringUtils.hasContent(((HttpTestRequestInterface)this.getRequest()).getEndpoint()));
        return this.inspectorPanel.getComponent();
    }

    @Override
    protected JComponent buildEndpointComponent() {
        return null;
    }

    private void updateStatusIcon() {
        Assertable.AssertionStatus status = ((HttpTestRequestStepInterface)this.getModelItem()).getTestRequest().getAssertionStatus();
        switch (status) {
            case FAILED: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/failed_assertion.gif"));
                this.inspectorPanel.activate(this.assertionInspector);
                break;
            }
            case UNKNOWN: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/unknown_assertion.gif"));
                break;
            }
            case VALID: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/valid_assertion.gif"));
                this.inspectorPanel.deactivate();
            }
        }
    }

    protected void addMethodCombo(JXToolBar toolbar) {
        this.methodCombo = new JComboBox<RestRequestInterface.RequestMethod>(RestRequestInterface.RequestMethod.getMethods());
        this.methodCombo.setSelectedItem((Object)((HttpTestRequestInterface)this.getRequest()).getMethod());
        this.methodCombo.setToolTipText("Set desired HTTP method");
        this.methodCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HttpTestRequestDesktopPanel.this.updatingRequest = true;
                ((HttpTestRequestInterface)HttpTestRequestDesktopPanel.this.getRequest()).setMethod((RestRequestInterface.RequestMethod)((Object)HttpTestRequestDesktopPanel.this.methodCombo.getSelectedItem()));
                HttpTestRequestDesktopPanel.this.updatingRequest = false;
            }
        });
        toolbar.addLabeledFixed("Method", this.methodCombo);
        toolbar.addSeparator();
    }

    protected void addToolbarComponents(JXToolBar toolbar) {
        toolbar.addSeparator();
        this.addMethodCombo(toolbar);
        this.pathTextField = new JUndoableTextField();
        this.pathTextField.setPreferredSize(new Dimension(300, 20));
        this.pathTextField.setText(((HttpTestRequestInterface)this.getRequest()).getEndpoint());
        this.pathTextField.setToolTipText(this.pathTextField.getText());
        this.pathTextField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                if (HttpTestRequestDesktopPanel.this.updating) {
                    return;
                }
                HttpTestRequestDesktopPanel.this.updating = true;
                ((HttpTestRequestInterface)HttpTestRequestDesktopPanel.this.getRequest()).setEndpoint(HttpTestRequestDesktopPanel.this.pathTextField.getText());
                HttpTestRequestDesktopPanel.this.updating = false;
            }
        });
        this.pathTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        HttpTestRequestDesktopPanel.this.doSubmit();
                    }
                    catch (Request.SubmitException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        toolbar.addLabeledFixed("Request URL:", this.pathTextField);
        toolbar.addSeparator();
    }

    @Override
    protected JComponent buildToolbar() {
        this.addAssertionButton = HttpTestRequestDesktopPanel.createActionButton(new AddAssertionAction((Assertable)this.getRequest()), true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)super.buildToolbar(), "North");
        JXToolBar toolbar = UISupport.createToolbar();
        this.addToolbarComponents(toolbar);
        panel.add((Component)toolbar, "South");
        return panel;
    }

    @Override
    protected void insertButtons(JXToolBar toolbar) {
        toolbar.add(this.addAssertionButton);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            enabled = !SoapUI.getTestMonitor().hasRunningLoadTest(((HttpTestRequestStepInterface)this.getModelItem()).getTestCase());
        }
        super.setEnabled(enabled);
        this.addAssertionButton.setEnabled(enabled);
        this.assertionsPanel.setEnabled(enabled);
        if (SoapUI.getTestMonitor().hasRunningLoadTest(((HttpTestRequestInterface)this.getRequest()).getTestCase())) {
            ((HttpTestRequestInterface)this.getRequest()).removeSubmitListener(this);
        } else {
            ((HttpTestRequestInterface)this.getRequest()).addSubmitListener(this);
        }
    }

    @Override
    protected Submit doSubmit() throws Request.SubmitException {
        return ((HttpTestRequestInterface)this.getRequest()).submit(new WsdlTestRunContext((TestStep)this.getModelItem()), true);
    }

    @Override
    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        boolean result = super.beforeSubmit(submit, context);
        this.startTime = System.currentTimeMillis();
        return result;
    }

    @Override
    protected void logMessages(String message, String infoMessage) {
        super.logMessages(message, infoMessage);
        this.logArea.addLine(this.sdf.format(new Date(this.startTime)) + " - " + message);
    }

    @Override
    public void afterSubmit(Submit submit, SubmitContext context) {
        super.afterSubmit(submit, context);
        if (!this.isHasClosed()) {
            this.updateStatusIcon();
        }
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (super.onClose(canCancel)) {
            this.assertionsPanel.release();
            this.inspectorPanel.release();
            SoapUI.getTestMonitor().removeTestMonitorListener(this.testMonitorListener);
            this.logArea.release();
            ((HttpTestRequestStepInterface)this.getModelItem()).getTestRequest().removeAssertionsListener(this.assertionsListener);
            return true;
        }
        return false;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        if (((HttpTestRequestInterface)this.getRequest()).getOperation() == null) {
            return modelItem == this.getRequest() || modelItem == this.getModelItem() || ModelSupport.getModelItemProject(this.getRequest()) == modelItem || modelItem == ((HttpTestRequestStepInterface)this.getModelItem()).getTestCase() || modelItem == ((HttpTestRequestStepInterface)this.getModelItem()).getTestCase().getTestSuite();
        }
        return modelItem == this.getRequest() || modelItem == this.getModelItem() || modelItem == ((HttpTestRequestInterface)this.getRequest()).getOperation() || modelItem == ((HttpTestRequestInterface)this.getRequest()).getOperation().getInterface() || modelItem == ((HttpTestRequestInterface)this.getRequest()).getOperation().getInterface().getProject() || modelItem == ((HttpTestRequestStepInterface)this.getModelItem()).getTestCase() || modelItem == ((HttpTestRequestStepInterface)this.getModelItem()).getTestCase().getTestSuite();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(RestTestRequestInterface.STATUS_PROPERTY)) {
            this.updateStatusIcon();
        } else if (evt.getPropertyName().equals("path")) {
            this.getSubmitButton().setEnabled(this.getSubmit() == null && StringUtils.hasContent(((HttpTestRequestInterface)this.getRequest()).getEndpoint()));
        } else if (evt.getPropertyName().equals("endpoint")) {
            if (this.updating) {
                return;
            }
            this.updating = true;
            this.pathTextField.setText(String.valueOf(evt.getNewValue()));
            this.updating = false;
        }
        super.propertyChange(evt);
    }

    private class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        public void loadTestFinished(LoadTestRunner runner) {
            HttpTestRequestDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getTestCase()));
        }

        public void loadTestStarted(LoadTestRunner runner) {
            if (runner.getLoadTest().getTestCase() == ((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getTestCase()) {
                HttpTestRequestDesktopPanel.this.setEnabled(false);
            }
        }

        public void testCaseFinished(TestCaseRunner runner) {
            HttpTestRequestDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getTestCase()));
        }

        public void testCaseStarted(TestCaseRunner runner) {
            if (runner.getTestCase() == ((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getTestCase()) {
                HttpTestRequestDesktopPanel.this.setEnabled(false);
            }
        }
    }

    private final class InternalAssertionsListener
    implements AssertionsListener {
        private InternalAssertionsListener() {
        }

        public void assertionAdded(TestAssertion assertion) {
            HttpTestRequestDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        public void assertionRemoved(TestAssertion assertion) {
            HttpTestRequestDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        public void assertionMoved(TestAssertion assertion, int ix, int offset) {
            HttpTestRequestDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((HttpTestRequestStepInterface)HttpTestRequestDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }
    }
}

