/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testcase;

import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.panels.testcase.JTestRunLog;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.MessageExchangeTestStepResult;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class JTestCaseTestRunLog
extends JTestRunLog {
    private final WsdlTestCase testCase;
    private JButton addToMockServiceButton;
    private XFormDialog addDialog;

    public JTestCaseTestRunLog(WsdlTestCase testCase) {
        super(testCase.getSettings());
        this.testCase = testCase;
    }

    protected void addToolbarButtons(JXToolBar toolbar) {
        super.addToolbarButtons(toolbar);
        this.addToMockServiceButton = UISupport.createToolbarButton(UISupport.createImageIcon("/mockService.gif"));
        toolbar.addFixed(this.addToMockServiceButton);
        this.addToMockServiceButton.addActionListener(new AddToMockServiceAction());
    }

    public void release() {
        if (this.addDialog != null) {
            this.addDialog.release();
            this.addDialog = null;
        }
        super.release();
    }

    @AForm(description="Set options for adding selected requests to a MockService", name="Add To MockService")
    private class AddToMockServiceAction
    implements ActionListener {
        private static final String CREATE_NEW_OPTION = "<Create New>";
        @AField(name="Target MockService", description="The target TestSuite", type=AField.AFieldType.ENUMERATION)
        public static final String MOCKSERVICE = "Target MockService";
        @AField(name="Open Editor", description="Open the created MockService", type=AField.AFieldType.BOOLEAN)
        public static final String OPENEDITOR = "Open Editor";

        private AddToMockServiceAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (JTestCaseTestRunLog.this.getLogListModel().getSize() == 0) {
                return;
            }
            if (JTestCaseTestRunLog.this.testCase.getDiscardOkResults()) {
                UISupport.showInfoMessage("Ok Results have been discarded");
                return;
            }
            if (JTestCaseTestRunLog.this.addDialog == null) {
                JTestCaseTestRunLog.this.addDialog = ADialogBuilder.buildDialog(this.getClass());
            }
            Object[] testSuiteNames = ModelSupport.getNames(new String[]{CREATE_NEW_OPTION}, JTestCaseTestRunLog.this.testCase.getTestSuite().getProject().getMockServiceList());
            JTestCaseTestRunLog.this.addDialog.setOptions(MOCKSERVICE, testSuiteNames);
            if (JTestCaseTestRunLog.this.addDialog.show()) {
                String targetMockServiceName = JTestCaseTestRunLog.this.addDialog.getValue(MOCKSERVICE);
                WsdlMockService mockService = JTestCaseTestRunLog.this.testCase.getTestSuite().getProject().getMockServiceByName(targetMockServiceName);
                if (mockService == null) {
                    targetMockServiceName = ModelSupport.promptForUniqueName("MockService", JTestCaseTestRunLog.this.testCase.getTestSuite().getProject(), "");
                    if (targetMockServiceName == null) {
                        return;
                    }
                    mockService = JTestCaseTestRunLog.this.testCase.getTestSuite().getProject().addNewMockService(targetMockServiceName);
                }
                int cnt = 0;
                MessageExchangeTestStepResult result = null;
                for (int c = 0; c < JTestCaseTestRunLog.this.getLogListModel().getSize(); ++c) {
                    TestStepResult obj = JTestCaseTestRunLog.this.getLogListModel().getResultAt(c);
                    if (result == obj || !(obj instanceof MessageExchangeTestStepResult)) continue;
                    result = (MessageExchangeTestStepResult)obj;
                    for (MessageExchange me : result.getMessageExchanges()) {
                        if (me.isDiscarded()) continue;
                        WsdlMockOperation mockOperation = mockService.getMockOperation(me.getOperation());
                        if (mockOperation == null) {
                            mockOperation = mockService.addNewMockOperation((WsdlOperation)me.getOperation());
                        }
                        WsdlMockResponse mockResponse = mockOperation.addNewMockResponse("Recorded Test Response " + ++cnt, false);
                        mockResponse.setResponseContent(me.getResponseContent());
                        Attachment[] requestAttachments = me.getResponseAttachments();
                        if (requestAttachments == null) continue;
                        for (Attachment attachment : requestAttachments) {
                            mockResponse.addAttachment(attachment);
                        }
                    }
                }
                if (cnt == 0) {
                    UISupport.showInfoMessage("No response messages found");
                } else {
                    UISupport.showInfoMessage("Added " + cnt + " MockResponses to MockService");
                    if (JTestCaseTestRunLog.this.addDialog.getBooleanValue(OPENEDITOR)) {
                        UISupport.selectAndShow(mockService);
                    }
                }
            }
        }
    }
}

