/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.project;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.wss.IncomingWss;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainerListener;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.WssEntry;
import com.eviware.soapui.impl.wsdl.support.wss.WssEntryRegistry;
import com.eviware.soapui.impl.wsdl.support.wss.crypto.KeyMaterialWssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.support.KeystoresComboBoxModel;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class WSSTabPanel
extends JPanel {
    private JTable cryptosTable;
    private RemoveCryptoAction removeCryptoAction;
    private RemoveIncomingWssAction removeIncomingWssAction;
    private JTable incomingWssTable;
    private JComboBox incomingWssDecryptionCryptoComboBox;
    private JComboBox incomingWssSignatureCryptoComboBox;
    private JTable outgoingWssTable;
    private RemoveOutgoingWssAction removeOutgoingWssAction;
    private JButton removeOutgoingEntryButton;
    private WssEntry selectedEntry;
    private OutgoingWss selectedOutgoing;
    private JButton addOutgoingEntryButton;
    private final WssContainer wssContainer;
    private InternalWssContainerListener wssContainerListener;
    private JTabbedPane entriesTabs;

    public WSSTabPanel(WssContainer wssContainer) {
        super(new BorderLayout());
        this.wssContainer = wssContainer;
        this.wssContainerListener = new InternalWssContainerListener();
        wssContainer.addWssContainerListener(this.wssContainerListener);
        this.buildUI();
    }

    private void buildUI() {
        this.add(this.buildMainToolbar(), "North");
        this.add((Component)this.buildContent(), "Center");
    }

    private JComponent buildContent() {
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Outgoing WS-Security Configurations", this.buildOutgoingConfigurationsTab());
        tabs.addTab("Incoming WS-Security Configurations", this.buildIncomingConfigurationsTab());
        tabs.addTab("Keystores / Certificates", this.buildCryptosTable());
        tabs.setMinimumSize(new Dimension(10, 10));
        return UISupport.createTabPanel(tabs, true);
    }

    private JPanel buildIncomingConfigurationsTab() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.add(this.buildIncomingWssToolbar(), "North");
        this.incomingWssTable = new JTable(new IncomingWssTableModel());
        this.incomingWssTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                WSSTabPanel.this.removeIncomingWssAction.setEnabled(WSSTabPanel.this.incomingWssTable.getSelectedRow() != -1);
            }
        });
        this.incomingWssDecryptionCryptoComboBox = new JComboBox(new KeystoresComboBoxModel(this.wssContainer, null));
        this.incomingWssTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.incomingWssDecryptionCryptoComboBox));
        this.incomingWssSignatureCryptoComboBox = new JComboBox(new KeystoresComboBoxModel(this.wssContainer, null));
        this.incomingWssTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.incomingWssSignatureCryptoComboBox));
        this.incomingWssTable.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(new JPasswordField()));
        this.incomingWssTable.getColumnModel().getColumn(3).setCellRenderer(new PasswordTableCellRenderer());
        p.add((Component)new JScrollPane(this.incomingWssTable), "Center");
        panel.add((Component)p, "Center");
        return panel;
    }

    private JPanel buildOutgoingConfigurationsTab() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.add(this.buildOutgoingWssToolbar(), "North");
        this.outgoingWssTable = new JTable(new OutgoingWssTableModel());
        this.outgoingWssTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = WSSTabPanel.this.outgoingWssTable.getSelectedRow();
                WSSTabPanel.this.selectedOutgoing = selectedRow == -1 ? null : WSSTabPanel.this.wssContainer.getOutgoingWssAt(selectedRow);
                WSSTabPanel.this.removeOutgoingWssAction.setEnabled(selectedRow != -1);
                WSSTabPanel.this.addOutgoingEntryButton.setEnabled(selectedRow != -1);
                WSSTabPanel.this.entriesTabs.removeAll();
                if (WSSTabPanel.this.selectedOutgoing != null) {
                    for (WssEntry entry : WSSTabPanel.this.selectedOutgoing.getEntries()) {
                        WSSTabPanel.this.entriesTabs.addTab(entry.getLabel(), entry.getConfigurationPanel());
                    }
                }
                WSSTabPanel.this.entriesTabs.getParent().setVisible(WSSTabPanel.this.entriesTabs.getTabCount() > 0);
            }
        });
        this.outgoingWssTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(new JPasswordField()));
        this.outgoingWssTable.getColumnModel().getColumn(2).setCellRenderer(new PasswordTableCellRenderer());
        JSplitPane split = UISupport.createVerticalSplit(new JScrollPane(this.outgoingWssTable), this.buildOutgoingWssDetails());
        split.setDividerLocation(140);
        p.add((Component)split, "Center");
        panel.add((Component)p, "Center");
        return panel;
    }

    private Component buildOutgoingWssDetails() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildOutgoingEntriesToolbar(), "North");
        panel.add(this.buildOutgoingEntryList(), "Center");
        this.entriesTabs.getParent().setVisible(false);
        return panel;
    }

    private Component buildOutgoingEntryList() {
        this.entriesTabs = new JTabbedPane();
        this.entriesTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WSSTabPanel.this.selectedEntry = WSSTabPanel.this.entriesTabs.getSelectedIndex() == -1 ? null : WSSTabPanel.this.selectedOutgoing.getEntries().get(WSSTabPanel.this.entriesTabs.getSelectedIndex());
                WSSTabPanel.this.removeOutgoingEntryButton.setEnabled(WSSTabPanel.this.selectedEntry != null);
            }
        });
        return UISupport.createTabPanel(this.entriesTabs, true);
    }

    private Component buildOutgoingEntriesToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        this.addOutgoingEntryButton = UISupport.createToolbarButton(new AddOutgoingEntryAction());
        toolbar.addFixed(this.addOutgoingEntryButton);
        this.removeOutgoingEntryButton = UISupport.createToolbarButton(new RemoveOutgoingEntryAction(), false);
        toolbar.addFixed(this.removeOutgoingEntryButton);
        return toolbar;
    }

    private Component buildOutgoingWssToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new AddOutgoingWssAction()));
        this.removeOutgoingWssAction = new RemoveOutgoingWssAction();
        toolbar.addFixed(UISupport.createToolbarButton(this.removeOutgoingWssAction));
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/projects/wss.html#Outgoing_WSS")));
        return toolbar;
    }

    private JPanel buildCryptosTable() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.add(this.buildCryptosToolbar(), "North");
        this.cryptosTable = new JTable(new CryptosTableModel());
        this.cryptosTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                WSSTabPanel.this.removeCryptoAction.setEnabled(WSSTabPanel.this.cryptosTable.getSelectedRow() != -1);
            }
        });
        this.cryptosTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(new JPasswordField()));
        this.cryptosTable.getColumnModel().getColumn(2).setCellRenderer(new PasswordTableCellRenderer());
        this.cryptosTable.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(new JPasswordField()));
        this.cryptosTable.getColumnModel().getColumn(4).setCellRenderer(new PasswordTableCellRenderer());
        p.add((Component)new JScrollPane(this.cryptosTable), "Center");
        panel.add((Component)p, "Center");
        return panel;
    }

    private Component buildCryptosToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new AddCryptoAction()));
        this.removeCryptoAction = new RemoveCryptoAction();
        toolbar.addFixed(UISupport.createToolbarButton(this.removeCryptoAction));
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/projects/wss.html#Keystores")));
        return toolbar;
    }

    private Component buildIncomingWssToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new AddIncomingWssAction()));
        this.removeIncomingWssAction = new RemoveIncomingWssAction();
        toolbar.addFixed(UISupport.createToolbarButton(this.removeIncomingWssAction));
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/projects/wss.html#Incoming_WSS")));
        return toolbar;
    }

    private Component buildMainToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/projects/wss.html")));
        return toolbar;
    }

    public void release() {
        this.wssContainer.removeWssContainerListener(this.wssContainerListener);
        ((IncomingWssTableModel)this.incomingWssTable.getModel()).release();
        ((OutgoingWssTableModel)this.outgoingWssTable.getModel()).release();
        ((CryptosTableModel)this.cryptosTable.getModel()).release();
        ((KeystoresComboBoxModel)this.incomingWssDecryptionCryptoComboBox.getModel()).release();
        ((KeystoresComboBoxModel)this.incomingWssSignatureCryptoComboBox.getModel()).release();
        this.entriesTabs.removeAll();
    }

    public static class PasswordTableCellRenderer
    extends JPasswordField
    implements TableCellRenderer {
        public PasswordTableCellRenderer() {
            this.setEditable(false);
            this.setBorder(null);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(table.getBackground());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    public class ImportWssSettingsAction
    extends AbstractAction {
        public ImportWssSettingsAction() {
            this.putValue("ShortDescription", "Imports an existing WS-Security configuration from another project");
            this.putValue("SmallIcon", UISupport.createImageIcon("/load_properties.gif"));
        }

        public void actionPerformed(ActionEvent e) {
            String[] names = ModelSupport.getNames(((WorkspaceImpl)SoapUI.getWorkspace()).getOpenProjectList());
            String projectName = UISupport.prompt("Select project to import from", "Import WSS Settings", names);
            if (projectName != null) {
                WsdlProject prj = (WsdlProject)SoapUI.getWorkspace().getProjectByName(projectName);
                WSSTabPanel.this.wssContainer.importConfig(prj.getWssContainer());
            }
        }
    }

    private class InternalWssContainerListener
    implements WssContainerListener {
        private InternalWssContainerListener() {
        }

        public void cryptoAdded(WssCrypto crypto) {
            ((CryptosTableModel)WSSTabPanel.this.cryptosTable.getModel()).cryptoAdded(crypto);
        }

        public void cryptoRemoved(WssCrypto crypto) {
            ((CryptosTableModel)WSSTabPanel.this.cryptosTable.getModel()).cryptoRemoved(crypto);
        }

        public void incomingWssAdded(IncomingWss incomingWss) {
            ((IncomingWssTableModel)WSSTabPanel.this.incomingWssTable.getModel()).incomingWssAdded(incomingWss);
        }

        public void incomingWssRemoved(IncomingWss incomingWss) {
            ((IncomingWssTableModel)WSSTabPanel.this.incomingWssTable.getModel()).incomingWssRemoved(incomingWss);
        }

        public void outgoingWssAdded(OutgoingWss outgoingWss) {
            ((OutgoingWssTableModel)WSSTabPanel.this.outgoingWssTable.getModel()).outgoingWssAdded(outgoingWss);
        }

        public void outgoingWssEntryAdded(WssEntry entry) {
            if (entry.getOutgoingWss() == WSSTabPanel.this.selectedOutgoing) {
                WSSTabPanel.this.entriesTabs.addTab(entry.getLabel(), entry.getConfigurationPanel());
                WSSTabPanel.this.entriesTabs.getParent().setVisible(true);
            }
        }

        public void outgoingWssEntryRemoved(WssEntry entry) {
            if (entry.getOutgoingWss() == WSSTabPanel.this.selectedOutgoing) {
                int ix = WSSTabPanel.this.entriesTabs.indexOfComponent(entry.getConfigurationPanel());
                if (ix != -1) {
                    WSSTabPanel.this.entriesTabs.remove(ix);
                }
                WSSTabPanel.this.entriesTabs.getParent().setVisible(WSSTabPanel.this.entriesTabs.getTabCount() > 0);
            }
        }

        public void outgoingWssRemoved(OutgoingWss outgoingWss) {
            ((OutgoingWssTableModel)WSSTabPanel.this.outgoingWssTable.getModel()).outgoingWssRemoved(outgoingWss);
        }

        public void cryptoUpdated(WssCrypto crypto) {
        }
    }

    public class RemoveOutgoingEntryAction
    extends AbstractAction {
        public RemoveOutgoingEntryAction() {
            this.putValue("ShortDescription", "Removes the selected WSS-Entry");
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
        }

        public void actionPerformed(ActionEvent e) {
            if (WSSTabPanel.this.selectedEntry == null) {
                return;
            }
            if (UISupport.confirm("Remove entry [" + WSSTabPanel.this.selectedEntry.getLabel() + "]", "Remove WSS Entry")) {
                WSSTabPanel.this.selectedOutgoing.removeEntry(WSSTabPanel.this.selectedEntry);
            }
        }
    }

    public class AddOutgoingEntryAction
    extends AbstractAction {
        public AddOutgoingEntryAction() {
            this.putValue("ShortDescription", "Adds a new WSS Entry");
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (WSSTabPanel.this.selectedOutgoing == null) {
                return;
            }
            String type = UISupport.prompt("Select type of entry to add", "Add WSS Entry", WssEntryRegistry.get().getTypes());
            if (type != null) {
                WssEntry entry = WSSTabPanel.this.selectedOutgoing.addEntry(type);
                WSSTabPanel.this.entriesTabs.setSelectedComponent(entry.getConfigurationPanel());
            }
        }
    }

    private class RemoveOutgoingWssAction
    extends AbstractAction {
        public RemoveOutgoingWssAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes the selected Outgoing WSS Configuration");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int row = WSSTabPanel.this.outgoingWssTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            if (UISupport.confirm("Removes selected configuration?", "Remove Configuration")) {
                WSSTabPanel.this.wssContainer.removeOutgoingWssAt(row);
            }
        }
    }

    private class AddOutgoingWssAction
    extends AbstractAction {
        public AddOutgoingWssAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a new Outgoing WSS Configuration");
        }

        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify unique name for configuration", "New Outgoing WSS Configuration", "");
            if (StringUtils.hasContent(name) && WSSTabPanel.this.wssContainer.getOutgoingWssByName(name) == null) {
                WSSTabPanel.this.wssContainer.addOutgoingWss(name);
                WSSTabPanel.this.outgoingWssTable.setRowSelectionInterval(WSSTabPanel.this.outgoingWssTable.getRowCount() - 1, WSSTabPanel.this.outgoingWssTable.getRowCount() - 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OutgoingWssTableModel
    extends AbstractTableModel {
        private List<OutgoingWss> outgoingWss;

        public OutgoingWssTableModel() {
            this.outgoingWss = WSSTabPanel.this.wssContainer.getOutgoingWssList();
        }

        public void release() {
            this.outgoingWss = null;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Default Username/Alias";
                }
                case 2: {
                    return "Default Password";
                }
                case 3: {
                    return "Actor";
                }
                case 4: {
                    return "Must Understand";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 4 ? Boolean.class : String.class;
        }

        @Override
        public int getRowCount() {
            return this.outgoingWss == null ? 0 : this.outgoingWss.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            OutgoingWss outgoing = this.outgoingWss.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return outgoing.getName();
                }
                case 1: {
                    return outgoing.getUsername();
                }
                case 2: {
                    return outgoing.getPassword();
                }
                case 3: {
                    return outgoing.getActor();
                }
                case 4: {
                    return outgoing.getMustUnderstand();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            OutgoingWss outgoing = this.outgoingWss.get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    outgoing.setUsername(aValue == null ? null : aValue.toString());
                    break;
                }
                case 2: {
                    outgoing.setPassword(aValue == null ? null : aValue.toString());
                    break;
                }
                case 3: {
                    outgoing.setActor(aValue == null ? null : aValue.toString());
                    break;
                }
                case 4: {
                    outgoing.setMustUnderstand(aValue == null ? false : (Boolean)aValue);
                }
            }
        }

        public void outgoingWssAdded(OutgoingWss outgoing) {
            this.outgoingWss.add(outgoing);
            this.fireTableRowsInserted(this.outgoingWss.size() - 1, this.outgoingWss.size() - 1);
        }

        public void outgoingWssRemoved(OutgoingWss outgoing) {
            int ix = this.outgoingWss.indexOf(outgoing);
            if (ix != -1) {
                this.outgoingWss.remove(ix);
                this.fireTableRowsDeleted(ix, ix);
            }
        }
    }

    private class RemoveIncomingWssAction
    extends AbstractAction {
        public RemoveIncomingWssAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes the selected Incoming WSS Configuration");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int row = WSSTabPanel.this.incomingWssTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            if (UISupport.confirm("Removes selected configuration?", "Remove Configuration")) {
                WSSTabPanel.this.wssContainer.removeIncomingWssAt(row);
            }
        }
    }

    private class AddIncomingWssAction
    extends AbstractAction {
        public AddIncomingWssAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a new Incoming WSS Configuration");
        }

        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify unique name for configuration", "New Incoming WSS Configuration", "");
            if (StringUtils.hasContent(name) && WSSTabPanel.this.wssContainer.getIncomingWssByName(name) == null) {
                WSSTabPanel.this.wssContainer.addIncomingWss(name);
                WSSTabPanel.this.incomingWssTable.setRowSelectionInterval(WSSTabPanel.this.incomingWssTable.getRowCount() - 1, WSSTabPanel.this.incomingWssTable.getRowCount() - 1);
            }
        }
    }

    public class IncomingWssTableModel
    extends AbstractTableModel {
        private List<IncomingWss> incomingWss;

        public IncomingWssTableModel() {
            this.incomingWss = WSSTabPanel.this.wssContainer.getIncomingWssList();
        }

        public void release() {
            this.incomingWss = null;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Decrypt Keystore";
                }
                case 2: {
                    return "Signature Keystore";
                }
                case 3: {
                    return "Password";
                }
            }
            return null;
        }

        public int getRowCount() {
            return this.incomingWss == null ? 0 : this.incomingWss.size();
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            IncomingWss incoming = this.incomingWss.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return incoming.getName();
                }
                case 1: {
                    return WSSTabPanel.this.wssContainer.getCryptoByName(incoming.getDecryptCrypto());
                }
                case 2: {
                    return WSSTabPanel.this.wssContainer.getCryptoByName(incoming.getSignatureCrypto());
                }
                case 3: {
                    return incoming.getDecryptPassword();
                }
            }
            return null;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            IncomingWss incoming = this.incomingWss.get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    incoming.setDecryptCrypto(aValue == null ? null : aValue.toString());
                    break;
                }
                case 2: {
                    incoming.setSignatureCrypto(aValue == null ? null : aValue.toString());
                    break;
                }
                case 3: {
                    incoming.setDecryptPassword(aValue == null ? null : aValue.toString());
                }
            }
        }

        public void incomingWssAdded(IncomingWss incoming) {
            this.incomingWss.add(incoming);
            this.fireTableRowsInserted(this.incomingWss.size() - 1, this.incomingWss.size() - 1);
        }

        public void incomingWssRemoved(IncomingWss incoming) {
            int ix = this.incomingWss.indexOf(incoming);
            if (ix != -1) {
                this.incomingWss.remove(ix);
                this.fireTableRowsDeleted(ix, ix);
            }
        }
    }

    private class RemoveCryptoAction
    extends AbstractAction {
        public RemoveCryptoAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes the selected crypto from this configuration");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int row = WSSTabPanel.this.cryptosTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            if (UISupport.confirm("Removes selected crypto?", "Remove Crypto")) {
                WSSTabPanel.this.wssContainer.removeCryptoAt(row);
            }
        }
    }

    private class AddCryptoAction
    extends AbstractAction {
        public AddCryptoAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a new crypto to this configuration");
        }

        public void actionPerformed(ActionEvent e) {
            File file = UISupport.getFileDialogs().open(this, "Select Key Material", null, null, null);
            if (file != null) {
                String password = UISupport.prompt("Specify password for [" + file.getName() + "]", "Add Key Material", "");
                WSSTabPanel.this.wssContainer.addCrypto(file.getAbsolutePath(), password);
                WSSTabPanel.this.cryptosTable.setRowSelectionInterval(WSSTabPanel.this.cryptosTable.getRowCount() - 1, WSSTabPanel.this.cryptosTable.getRowCount() - 1);
            }
        }
    }

    public class CryptosTableModel
    extends AbstractTableModel {
        private static final String DEFAULT_OPTION = "<Default>";
        private List<WssCrypto> cryptos;

        public CryptosTableModel() {
            this.cryptos = WSSTabPanel.this.wssContainer.getCryptoList();
        }

        public void release() {
            this.cryptos = null;
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Source";
                }
                case 1: {
                    return "Status";
                }
                case 2: {
                    return "Password";
                }
                case 3: {
                    return "Default Alias";
                }
                case 4: {
                    return "Alias Password";
                }
                case 5: {
                    return "Security Provider";
                }
            }
            return null;
        }

        public int getRowCount() {
            return this.cryptos == null ? 0 : this.cryptos.size();
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 1;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            KeyMaterialWssCrypto crypto = (KeyMaterialWssCrypto)this.cryptos.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return crypto.getSource();
                }
                case 1: {
                    return crypto.getStatus();
                }
                case 2: {
                    return crypto.getPassword();
                }
                case 3: {
                    return crypto.getDefaultAlias();
                }
                case 4: {
                    return crypto.getAliasPassword();
                }
                case 5: {
                    return StringUtils.hasContent(crypto.getCryptoProvider()) ? crypto.getCryptoProvider() : DEFAULT_OPTION;
                }
            }
            return null;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            KeyMaterialWssCrypto crypto = (KeyMaterialWssCrypto)this.cryptos.get(rowIndex);
            if (aValue == null || aValue.equals(DEFAULT_OPTION)) {
                aValue = "";
            }
            switch (columnIndex) {
                case 2: {
                    crypto.setPassword(aValue.toString());
                    break;
                }
                case 3: {
                    crypto.setDefaultAlias(aValue.toString());
                    break;
                }
                case 4: {
                    crypto.setAliasPassword(aValue.toString());
                    break;
                }
                case 5: {
                    crypto.setCryptoProvider(aValue.toString());
                }
            }
        }

        public void cryptoAdded(WssCrypto crypto) {
            this.cryptos.add(crypto);
            this.fireTableRowsInserted(this.cryptos.size() - 1, this.cryptos.size() - 1);
        }

        public void cryptoRemoved(WssCrypto crypto) {
            int ix = this.cryptos.indexOf(crypto);
            if (ix != -1) {
                this.cryptos.remove(ix);
                this.fireTableRowsDeleted(ix, ix);
            }
        }
    }
}

