/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.monitor;

import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitor;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.ui.support.DefaultDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SoapMonitorDesktopPanel
extends DefaultDesktopPanel {
    private SoapMonitor soapMonitor;
    private final WsdlProject project;

    public SoapMonitorDesktopPanel(WsdlProject project, int sourcePort, String incomingRequestWss, String incomingResponseWss, boolean setAsProxy, String sslEndpoint) {
        super("SOAP Monitor [" + project.getName() + "]", null, new JPanel(new BorderLayout()));
        this.project = project;
        JPanel p = (JPanel)this.getComponent();
        JTabbedPane tabs = new JTabbedPane();
        JXToolBar toolbar = UISupport.createToolbar();
        this.soapMonitor = new SoapMonitor(project, sourcePort, incomingRequestWss, incomingResponseWss, toolbar, setAsProxy, sslEndpoint);
        tabs.add((Component)this.soapMonitor, "Traffic Log");
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/monitor/index.html")));
        p.add((Component)toolbar, "North");
        p.add((Component)UISupport.createTabPanel(tabs, true), "Center");
        p.setPreferredSize(new Dimension(700, 600));
    }

    public boolean onClose(boolean canCancel) {
        if (this.soapMonitor.isRunning() && canCancel && !UISupport.confirm("Close and stop SOAP Monitor", "Close SOAP Monitor")) {
            return false;
        }
        this.soapMonitor.stop();
        this.soapMonitor.release();
        return true;
    }

    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.project;
    }

    public WsdlProject getProject() {
        return this.project;
    }
}

