/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.impl.WsdlInterfaceFactory;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddInterfaceActionFromURL
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "AddInterfaceActionFromURL";

    public AddInterfaceActionFromURL() {
        super("Add WSDL from URL", "Adds all interfaces in a specified WSDL URL to the current project");
    }

    @Override
    public void perform(WsdlProject project, Object param) {
        String url = UISupport.prompt("Enter WSDL URL", "Add WSDL from URL", "");
        if (url == null) {
            return;
        }
        try {
            Boolean createRequests = UISupport.confirmOrCancel("Create default requests for all operations", "Import WSDL");
            if (createRequests == null) {
                return;
            }
            WsdlInterface[] ifaces = WsdlInterfaceFactory.importWsdl(project, url, createRequests);
            if (ifaces != null && ifaces.length > 0) {
                UISupport.select(ifaces[0]);
            }
        }
        catch (Exception ex) {
            UISupport.showErrorMessage(ex.getMessage() + ":" + ex.getCause());
        }
    }
}

