/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest;

import com.eviware.soapui.config.OldRestRequestConfig;
import com.eviware.soapui.config.RestMethodConfig;
import com.eviware.soapui.config.RestResourceConfig;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestResourceContainer;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.RestRequestConverter;
import com.eviware.soapui.impl.rest.support.XmlBeansRestParamsTestPropertyHolder;
import com.eviware.soapui.impl.support.AbstractHttpOperation;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.support.StringUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestResource
extends AbstractWsdlModelItem<RestResourceConfig>
implements AbstractHttpOperation,
MutableTestPropertyHolder,
RestResourceContainer,
PropertyChangeListener {
    public static final String PATH_PROPERTY = "path";
    private List<RestMethod> methods = new ArrayList<RestMethod>();
    private List<RestResource> resources = new ArrayList<RestResource>();
    private RestResource parentResource;
    private XmlBeansRestParamsTestPropertyHolder params;

    public RestResource(RestService service, RestResourceConfig resourceConfig) {
        this(service, null, resourceConfig);
    }

    public RestResource(RestResource restResource, RestResourceConfig resourceConfig) {
        this(restResource.getInterface(), restResource, resourceConfig);
        this.parentResource.addPropertyChangeListener(this);
    }

    private RestResource(RestService service, RestResource parent, RestResourceConfig resourceConfig) {
        super(resourceConfig, service, "/rest_resource.gif");
        this.parentResource = parent;
        if (resourceConfig.getParameters() == null) {
            resourceConfig.addNewParameters();
        }
        this.params = new XmlBeansRestParamsTestPropertyHolder(this, resourceConfig.getParameters());
        for (RestMethodConfig config : resourceConfig.getMethodList()) {
            this.methods.add(new RestMethod(this, config));
        }
        for (RestMethodConfig config : resourceConfig.getResourceList()) {
            this.resources.add(new RestResource(this, (RestResourceConfig)config));
        }
        for (RestMethodConfig config : resourceConfig.getRequestList()) {
            RestRequestConverter.convert(this, (OldRestRequestConfig)config);
        }
        resourceConfig.setRequestArray(new OldRestRequestConfig[0]);
        service.addPropertyChangeListener(this);
    }

    public RestResource getParentResource() {
        return this.parentResource;
    }

    public RestResourceContainer getResourceContainer() {
        return this.parentResource == null ? this.getInterface() : this.parentResource;
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        ArrayList<AbstractWsdlModelItem> result = new ArrayList<AbstractWsdlModelItem>();
        result.addAll(this.getRestMethodList());
        result.addAll(this.getChildResourceList());
        return result;
    }

    @Override
    public MessagePart[] getDefaultRequestParts() {
        return new MessagePart[0];
    }

    @Override
    public MessagePart[] getDefaultResponseParts() {
        return new MessagePart[0];
    }

    @Override
    public RestService getInterface() {
        return (RestService)this.getParent();
    }

    public String[] getRequestMediaTypes() {
        return new String[0];
    }

    public String[] getResponseMediaTypes() {
        return new String[0];
    }

    public RestResource getChildResourceByName(String name) {
        return (RestResource)this.getWsdlModelItemByName(this.resources, name);
    }

    public RestResource addNewChildResource(String name, String path) {
        RestResourceConfig resourceConfig = ((RestResourceConfig)this.getConfig()).addNewResource();
        resourceConfig.setName(name);
        resourceConfig.setPath(path);
        RestResource resource = new RestResource(this, resourceConfig);
        this.resources.add(resource);
        this.getInterface().fireOperationAdded(resource);
        this.notifyPropertyChanged("childResources", null, resource);
        return resource;
    }

    public int getChildResourceCount() {
        return this.resources.size();
    }

    public List<RestResource> getChildResourceList() {
        return new ArrayList<RestResource>(this.resources);
    }

    @Override
    public RestRequest getRequestAt(int index) {
        for (RestMethod m : this.methods) {
            if (index < m.getRequestCount()) {
                return m.getRequestAt(index);
            }
            index -= m.getRequestCount();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public RestRequest getRequestByName(String name) {
        for (RestMethod m : this.methods) {
            RestRequest r = m.getRequestByName(name);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public RestMethod addNewMethod(String name) {
        RestMethodConfig methodConfig = ((RestResourceConfig)this.getConfig()).addNewMethod();
        methodConfig.setName(name);
        RestMethod method = new RestMethod(this, methodConfig);
        this.methods.add(method);
        this.notifyPropertyChanged("childMethods", null, method);
        return method;
    }

    public int getRestMethodCount() {
        return this.methods.size();
    }

    public List<RestMethod> getRestMethodList() {
        return new ArrayList<RestMethod>(this.methods);
    }

    public RestMethod getRestMethodByName(String name) {
        return (RestMethod)this.getWsdlModelItemByName(this.methods, name);
    }

    @Override
    public int getRequestCount() {
        int size = 0;
        for (RestMethod m : this.methods) {
            size += m.getRequestCount();
        }
        return size;
    }

    @Override
    public List<Request> getRequestList() {
        ArrayList<Request> rs = new ArrayList<Request>();
        for (RestMethod m : this.methods) {
            rs.addAll(m.getRequestList());
        }
        return rs;
    }

    public String getPath() {
        return ((RestResourceConfig)this.getConfig()).getPath();
    }

    public void setPath(String path) {
        String old = this.getPath();
        ((RestResourceConfig)this.getConfig()).setPath(path);
        this.notifyPropertyChanged(PATH_PROPERTY, old, path);
    }

    @Override
    public boolean isBidirectional() {
        return false;
    }

    public boolean isNotification() {
        return false;
    }

    public boolean isOneWay() {
        return false;
    }

    public boolean isRequestResponse() {
        return true;
    }

    public boolean isSolicitResponse() {
        return false;
    }

    @Override
    public boolean isUnidirectional() {
        return false;
    }

    @Override
    public Attachment.AttachmentEncoding getAttachmentEncoding(String part, boolean isRequest) {
        return Attachment.AttachmentEncoding.NONE;
    }

    public RestParamProperty[] getDefaultParams() {
        ArrayList<RestParamProperty> result = new ArrayList<RestParamProperty>();
        HashSet<String> names = new HashSet<String>();
        if (this.parentResource != null) {
            result.addAll(Arrays.asList(this.parentResource.getDefaultParams()));
        }
        for (int c = 0; c < this.getPropertyCount(); ++c) {
            if (names.contains(this.getPropertyAt(c).getName())) continue;
            result.add(this.getPropertyAt(c));
            names.add(this.getPropertyAt(c).getName());
        }
        return result.toArray(new RestParamProperty[result.size()]);
    }

    public String getFullPath() {
        return this.getFullPath(true);
    }

    public String getFullPath(boolean includeBasePath) {
        String base = this.parentResource == null ? (includeBasePath ? this.getInterface().getBasePath() : "") : this.parentResource.getFullPath(includeBasePath);
        String path = this.getPath();
        if (StringUtils.hasContent(path) && base != null && !base.endsWith("/") && !path.startsWith("/")) {
            base = base + "/";
        }
        return path == null ? base : base + path;
    }

    @Override
    public RestParamProperty addProperty(String name) {
        return this.params.addProperty(name);
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        this.params.moveProperty(propertyName, targetIndex);
    }

    @Override
    public RestParamProperty removeProperty(String propertyName) {
        return this.params.removeProperty(propertyName);
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        return this.params.renameProperty(name, newName);
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.params.addTestPropertyListener(listener);
    }

    public RestParamsPropertyHolder getParams() {
        return this.params;
    }

    @Override
    public ModelItem getModelItem() {
        return this;
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        return this.params.getProperties();
    }

    @Override
    public RestParamProperty getProperty(String name) {
        return this.params.getProperty(name);
    }

    @Override
    public RestParamProperty getPropertyAt(int index) {
        return this.params.getPropertyAt(index);
    }

    @Override
    public int getPropertyCount() {
        return this.params.getPropertyCount();
    }

    @Override
    public String[] getPropertyNames() {
        return this.params.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.params.getPropertyValue(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.params.hasProperty(name);
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.params.removeTestPropertyListener(listener);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        this.params.setPropertyValue(name, value);
    }

    @Override
    public String getPropertiesLabel() {
        return "Resource Params";
    }

    public String buildPath(PropertyExpansionContext context) {
        return this.getFullPath(true);
    }

    public RestResource cloneChildResource(RestResource resource, String name) {
        return this.cloneResource(resource, name);
    }

    @Override
    public RestResource cloneResource(RestResource resource, String name) {
        RestResourceConfig resourceConfig = (RestResourceConfig)((RestResourceConfig)this.getConfig()).addNewResource().set(resource.getConfig());
        resourceConfig.setName(name);
        RestResource newResource = new RestResource(this, resourceConfig);
        this.resources.add(newResource);
        this.getInterface().fireOperationAdded(newResource);
        return newResource;
    }

    public RestMethod cloneMethod(RestMethod method, String name) {
        RestMethodConfig methodConfig = (RestMethodConfig)((RestResourceConfig)this.getConfig()).addNewMethod().set(method.getConfig());
        methodConfig.setName(name);
        RestMethod newMethod = new RestMethod(this, methodConfig);
        this.methods.add(newMethod);
        this.notifyPropertyChanged("childMethods", null, newMethod);
        return newMethod;
    }

    @Override
    public void release() {
        super.release();
        this.params.release();
        this.getService().removePropertyChangeListener(this);
        if (this.parentResource != null) {
            this.parentResource.removePropertyChangeListener(this);
        }
        for (RestResource resource : this.resources) {
            resource.release();
        }
        for (RestMethod method : this.methods) {
            method.release();
        }
    }

    public void deleteMethod(RestMethod method) {
        int ix = this.methods.indexOf(method);
        if (!this.methods.remove(method)) {
            return;
        }
        this.notifyPropertyChanged("childMethods", method, null);
        method.release();
        ((RestResourceConfig)this.getConfig()).removeMethod(ix);
    }

    public void deleteChildResource(RestResource resource) {
        this.deleteResource(resource);
    }

    @Override
    public void deleteResource(RestResource resource) {
        int ix = this.resources.indexOf(resource);
        if (!this.resources.remove(resource)) {
            return;
        }
        this.getInterface().fireOperationRemoved(resource);
        this.notifyPropertyChanged("childResources", resource, null);
        ((RestResourceConfig)this.getConfig()).removeResource(ix);
        resource.release();
    }

    public String createRequest(boolean b) {
        return null;
    }

    public String createResponse(boolean b) {
        return null;
    }

    public RestResource getChildResourceAt(int c) {
        return this.resources.get(c);
    }

    public RestMethod getRestMethodAt(int c) {
        return this.methods.get(c);
    }

    public RestService getService() {
        return (RestService)(this.getParentResource() == null ? this.getParent() : this.getParentResource().getService());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(PATH_PROPERTY) || evt.getPropertyName().equals("basePath")) {
            this.notifyPropertyChanged(PATH_PROPERTY, null, this.getPath());
        }
    }

    public RestResource[] getAllChildResources() {
        ArrayList<RestResource> result = new ArrayList<RestResource>();
        for (RestResource resource : this.resources) {
            this.addResourcesToResult(resource, result);
        }
        return result.toArray(new RestResource[result.size()]);
    }

    private void addResourcesToResult(RestResource resource, List<RestResource> result) {
        result.add(resource);
        for (RestResource res : resource.getChildResourceList()) {
            this.addResourcesToResult(res, result);
        }
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.params.getPropertyList();
    }
}

