# Using the Witchcraft Compiler Collection to debug ARM

## Native ARM

WCC compiles natively ARM. Follow the standard build instructions
from README.md to get started.

## Debugging ARM binaries on x86_64 Linux

It is possible to use the WCC toolchain on x86_64 intel processors
to process ARM binaries.

In particular, wsh allows loading and executing ARM functions
transparently from x86_64. Under the hood, this mode leverages
the amazing user mode emulation of qemu to perform the binary
translation from ARM to Intel.

When wsh is cross compiled this way, the analysed ARM binaries,
the wsh shell cross compiled for ARM and the qemu binary
translator share a single process in memory and can use the filesystem
and normal IPC with other processes on the system. Yes, this is batshit crazy.

The remaining of this page will guide you to the steps involved in getting
the Witchcraft Compiler Collection cross compiled for ARM and get your first ARM
applications debugged within wsh.

### Registering a binfmt_misc for qemu-arm-static

Registering a custom binfmt_misc for qemu-arm-static
allows to run ARM applications normally on a Linux
x86_64 processor. The mechanism happens at kernel level,
the interpreter chosen by the kernel for ARM binaries
once this binfmt_misc is registered will be the qemu-arm-static
binary.

You may like to read the manpage for the update-binfmts utility:

	man update-binfmts

To register a binfmt_misc for ARM, you can run the following command as root:

	echo   ':arm:M::\x7fELF\x01\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x28\x00:\xff\xff\xff\xff\xff\xff\xff\x00\xff\xff\xff\xff\xff\xff\x00\xff\xfe\xff\xff\xff:/usr/bin/qemu-arm-static:OC' > /proc/sys/fs/binfmt_misc/register 


You can verify this last command worked properly by displaying the associated entry in /proc:


	root@blackbox:/proc/sys/fs/binfmt_misc# cat qemu-arm
	enabled
	interpreter /usr/bin/qemu-arm-static
	flags: OC
	offset 0
	magic 7f454c4601010100000000000000000002002800
	mask ffffffffffffff00fffffffffffffffffeffffff
	root@blackbox:/proc/sys/fs/binfmt_misc# 


You can now run ARM applications directly as normal Intel programs : qemu-arm-static will transparently handle the binary translation.

More examples are available at https://wiki.debian.org/QemuUserEmulation

## Downloading a ARM filesystem

Let's first download a ARM filesystem :

	jonathan@blackbox:/home2/linaro$ wget -c https://releases.linaro.org/14.04/ubuntu/panda/linaro-saucy-developer-20140410-652.tar.gz

This should download a file named linaro-saucy-developer-20140410-652.tar.gz in the current directory.
You will next need to unpack it using the following command:

	jonathan@blackbox:/home2/linaro$ tar -xvzf linaro-saucy-developer-20140410-652.tar.gz

This will unpack the chroot environment into a new directory named binary the current directory.

Let's rename the output folder to simply chroot:

	jonathan@blackbox:/home2/linaro$ mv binary/ chroot/
	jonathan@blackbox:/home2/linaro$

We will now download the source code of wcc into the arm chroot:

	jonathan@blackbox:/home2/linaro$ cd chroot
	jonathan@blackbox:/home2/linaro/chroot$ git clone https://github.com/endrazine/wcc.git
	Cloning into 'wcc'...
	remote: Counting objects: 672, done.
	remote: Compressing objects: 100% (327/327), done.
	remote: Total 672 (delta 361), reused 648 (delta 337), pack-reused 0
	Receiving objects: 100% (672/672), 7.09 MiB | 1.40 MiB/s, done.
	Resolving deltas: 100% (361/361), done.
	Checking connectivity... done.
	jonathan@blackbox:/home2/linaro/chroot$ 


## Chrooting to a ARM chroot

The benefit of having a chroot is to facilitate access to shared libraries and
their dependencies. It is however not strictly required to analyze ARM binaries :
wsh can be cross compiled from Intel using simply a cross compiler, and qemu-arm-static
can be instructed to look for ARM shared libraries in a specific directory. This
is enough to perform ARM debugging on x86_64 without a chroot.

Let's not create a small script to help us automate the
chrooting process:

	jonathan@blackbox:/home2/linaro$ cat run.sh
	#!/bin/sh

	#mount /proc (only once)

	if [ -e ./chroot/proc/1 ]
	then
		echo "* /proc already mounted"
	else
		echo "* mounting /proc"
		mkdir -p ./chroot/proc
		sudo mount -t proc proc ./chroot/proc/
	fi

	sudo cp /etc/resolv.conf ./chroot/etc/resolv.conf
	sudo chroot ./chroot/
	jonathan@blackbox:/home2/linaro$ 


We can now run this script and enter the ARM chroot. Qemu-arm-static
will underneath perform the JIT binary translation to Intel transparently
for us:

	jonathan@blackbox:/home2/linaro$ ./run.sh
	* /proc already mounted
	root@blackbox:/# 
	root@blackbox:/# cat /etc/issue.net 
	Linaro 14.01
	root@blackbox:/# uname -a
	Linux blackbox 2.6.32 #111-Ubuntu SMP Fri Nov 6 18:17:06 UTC 2015 armv7l armv7l armv7l GNU/Linux
	root@blackbox:/# 

We are now running ARM binaries on top of our Linux cpu, without a full VM.


## Downloading WCC dependencies

You will need to install some dependencies to get WCC compiled
inside your chroot. In addition to a working c toolchain, you
will need the binutils headers, the libc headers, lua, and
libiberty with its headers.

For this demo, I downloaded and installed manually the following
packages:

binutils-dev_2.24-5ubuntu3_armhf.deb
libc6-dev-armel-cross_2.15-0ubuntu9cross1.82_all.deb
lua5.2_5.2.3-1.1_armhf.deb
libiberty-dev_20160215-1_armhf.deb

You can use the commands below to download all the dependencies into /tmp/dependencies and get them installed inside your ARM chroot:

	mkdir -p /tmp/dependencies
	cd /tmp/dependencies
	wget -c https://launchpad.net/ubuntu/+source/binutils/2.24-5ubuntu3/+build/5912085/+files/binutils-dev_2.24-5ubuntu3_armhf.deb
	wget -c http://archive.ubuntu.com/ubuntu/pool/universe/a/armel-cross-toolchain-base/libc6-dev-armel-cross_2.15-0ubuntu9cross1.82_all.deb
	wget -c http://ftp.gnome.org/mirror/raspbian/raspbian/pool/main/l/lua5.2/lua5.2_5.2.3-1.1_armhf.deb
	wget -c http://ftp.gnome.org/mirror/cdimage/snapshot/20050323/Debian/pool/main/libi/libiberty/libiberty-dev_20160215-1_armhf.deb
	sudo dpkg -i *.deb
	cd -

We are now ready to build WCC on ARM.

## Compiling WCC on ARM

From the root wcc directory, simply type:

	make

## Running wsh ARM

Inside the chroot, we can now run wsh and load ELF binaries transparently :

	root@blackbox:/# wsh /lib/arm-linux-gnueabihf/libssl.so.1.0.0 
	> libs()
	/lib/arm-linux-gnueabihf/libc.so.6
	/lib/ld-linux-armhf.so.3
	/lib/arm-linux-gnueabihf/libssl.so.1.0.0
	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0
	/lib/arm-linux-gnueabihf/libz.so.1

	 -- Total: 5 libraries
	> a=getpid()
	> print(a)
	12544
	> 

At this point, the getpid() function was really provided by the ARM libc, and
translated on the fly by qemu into x86_64 binary code that our real cpu can execute.

Now, on an other shell outside the chroot, let's examine the mapping of the
process with a pid of 12544.


	jonathan@blackbox:~$ sudo cat /proc/12544/maps 
	60000000-601f9000 r-xp 00000000 08:02 2360785                            /home2/linaro/chroot/usr/bin/qemu-arm-static
	602f8000-60330000 rw-p 002f8000 08:02 2360785                            /home2/linaro/chroot/usr/bin/qemu-arm-static
	60330000-60336000 rw-p 00000000 00:00 0 
	60336000-62337000 rwxp 00000000 00:00 0 
	62337000-62397000 rw-p 00000000 00:00 0 
	63df5000-63e80000 rw-p 00000000 00:00 0                                  [heap]
	7f15dfe91000-7f15dff4e000 rw-p 00000000 00:00 0 
	7f15dff4e000-7f15dff56000 ---p 00000000 00:00 0 
	7f15dff56000-7f15dffa8000 r-xp 00000000 08:02 2361314                    /home2/linaro/chroot/usr/bin/wsh
	7f15dffa8000-7f15dffaf000 ---p 00000000 00:00 0 
	7f15dffaf000-7f15dffb1000 r--p 00051000 08:02 2361314                    /home2/linaro/chroot/usr/bin/wsh
	7f15dffb1000-7f15dffb2000 rw-p 00053000 08:02 2361314                    /home2/linaro/chroot/usr/bin/wsh
	7f15dffb2000-7f15e04c2000 rw-p 00000000 00:00 0 
	7f15e04c2000-7f15f60ae000 ---p 00000000 00:00 0 
	7f15f60ae000-7f15f60b0000 r--p 00000000 00:00 0 
	7f15f60b0000-7f15f60b1000 ---p 00000000 00:00 0 
	7f15f60b1000-7f16061af000 ---p 00000000 00:00 0 
	7f16061af000-7f16061b1000 r--p 00000000 00:00 0 
	7f16061b1000-7f16061b2000 ---p 00000000 00:00 0 
	7f16061b2000-7f16162b0000 ---p 00000000 00:00 0 
	7f16162b0000-7f16162b2000 r--p 00000000 00:00 0 
	7f16162b2000-7f16162b3000 ---p 00000000 00:00 0 
	7f16162b3000-7f16263b1000 ---p 00000000 00:00 0 
	7f16263b1000-7f16263b3000 r--p 00000000 00:00 0 
	7f16263b3000-7f16263b4000 ---p 00000000 00:00 0 
	7f16263b4000-7f16364b2000 ---p 00000000 00:00 0 
	7f16364b2000-7f16364b4000 r--p 00000000 00:00 0 
	7f16364b4000-7f16364b5000 ---p 00000000 00:00 0 
	7f16364b5000-7f16465b3000 ---p 00000000 00:00 0 
	7f16465b3000-7f16465b5000 r--p 00000000 00:00 0 
	7f16465b5000-7f16465b6000 ---p 00000000 00:00 0 
	7f16465b6000-7f16566b5000 ---p 00000000 00:00 0 
	7f16566b5000-7f16566b6000 r--p 00000000 00:00 0 
	7f16566b6000-7f16667b6000 ---p 00000000 00:00 0 
	7f16667b6000-7f16667b7000 r--p 00000000 00:00 0 
	7f16667b7000-7f16768b7000 ---p 00000000 00:00 0 
	7f16768b7000-7f16768b8000 r--p 00000000 00:00 0 
	7f16768b8000-7f16869b8000 ---p 00000000 00:00 0 
	7f16869b8000-7f16869b9000 r--p 00000000 00:00 0 
	7f16869b9000-7f1696ab9000 ---p 00000000 00:00 0 
	7f1696ab9000-7f1696aba000 r--p 00000000 00:00 0 
	7f1696aba000-7f16a6bba000 ---p 00000000 00:00 0 
	7f16a6bba000-7f16a6bbb000 r--p 00000000 00:00 0 
	7f16a6bbb000-7f16d60da000 ---p 00000000 00:00 0 
	7f16d60da000-7f16d61dd000 rw-p 00000000 00:00 0 
	7f16d61dd000-7f16d6281000 ---p 00000000 00:00 0 
	7f16d6281000-7f16d6294000 r--s 00000000 08:02 2377268                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libz.so.1.2.8
	7f16d6294000-7f16d6397000 r--s 00000000 08:02 2377290                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0
	7f16d6397000-7f16d63ce000 r--s 00000000 08:02 2377289                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libssl.so.1.0.0
	7f16d63ce000-7f16d63e6000 r--s 00000000 08:02 2377175                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/ld-2.17.so
	7f16d63e6000-7f16d64c1000 r--s 00000000 08:02 2377190                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libc-2.17.so
	7f16d64c1000-7f16d64c4000 r--s 00000000 08:02 2377168                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libdl-2.17.so
	7f16d64c4000-7f16d64d5000 r-xp 00000000 08:02 2377268                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libz.so.1.2.8
	7f16d64d5000-7f16d64dd000 ---p 00011000 08:02 2377268                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libz.so.1.2.8
	7f16d64dd000-7f16d64de000 r--p 00011000 08:02 2377268                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libz.so.1.2.8
	7f16d64de000-7f16d64df000 rw-p 00012000 08:02 2377268                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libz.so.1.2.8
	7f16d64df000-7f16d65ce000 r-xp 00000000 08:02 2377290                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0
	7f16d65ce000-7f16d65d6000 ---p 000ef000 08:02 2377290                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0
	7f16d65d6000-7f16d65e3000 r--p 000ef000 08:02 2377290                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0
	7f16d65e3000-7f16d65ea000 rw-p 000fc000 08:02 2377290                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0
	7f16d65ea000-7f16d65ed000 rw-p 00000000 00:00 0 
	7f16d65ed000-7f16d65f4000 ---p 00000000 00:00 0 
	7f16d65f4000-7f16d6625000 r-xp 00000000 08:02 2377289                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libssl.so.1.0.0
	7f16d6625000-7f16d662d000 ---p 00031000 08:02 2377289                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libssl.so.1.0.0
	7f16d662d000-7f16d662f000 r--p 00031000 08:02 2377289                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libssl.so.1.0.0
	7f16d662f000-7f16d6633000 rw-p 00033000 08:02 2377289                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libssl.so.1.0.0
	7f16d6633000-7f16d6634000 ---p 00000000 00:00 0 
	7f16d6634000-7f16d6635000 rw-p 00000000 00:00 0 
	7f16d6635000-7f16d670b000 r-xp 00000000 08:02 2377190                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libc-2.17.so
	7f16d670b000-7f16d6713000 ---p 000d6000 08:02 2377190                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libc-2.17.so
	7f16d6713000-7f16d6715000 r--p 000d6000 08:02 2377190                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libc-2.17.so
	7f16d6715000-7f16d6716000 rw-p 000d8000 08:02 2377190                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libc-2.17.so
	7f16d6716000-7f16d6719000 rw-p 00000000 00:00 0 
	7f16d6719000-7f16d671b000 r-xp 00000000 08:02 2377168                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libdl-2.17.so
	7f16d671b000-7f16d6722000 ---p 00002000 08:02 2377168                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libdl-2.17.so
	7f16d6722000-7f16d6723000 r--p 00001000 08:02 2377168                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libdl-2.17.so
	7f16d6723000-7f16d6724000 rw-p 00002000 08:02 2377168                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/libdl-2.17.so
	7f16d6724000-7f16d672b000 ---p 00000000 00:00 0 
	7f16d672b000-7f16d672d000 rw-p 00000000 00:00 0 
	7f16d672d000-7f16d6744000 r-xp 00000000 08:02 2377175                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/ld-2.17.so
	7f16d6744000-7f16d674b000 ---p 00000000 00:00 0 
	7f16d674b000-7f16d674c000 r--p 00016000 08:02 2377175                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/ld-2.17.so
	7f16d674c000-7f16d674d000 rw-p 00017000 08:02 2377175                    /home2/linaro/chroot/lib/arm-linux-gnueabihf/ld-2.17.so
	7f16d674d000-7f16d674e000 ---p 00000000 00:00 0 
	7f16d674e000-7f16da34e000 rw-p 00000000 00:00 0 
	7f16dff3e000-7f16dff3f000 r--p 00000000 00:00 0 
	7ffd539a2000-7ffd539c3000 rw-p 00000000 00:00 0                          [stack]
	7ffd539e2000-7ffd539e4000 r-xp 00000000 00:00 0                          [vdso]
	ffffffffff600000-ffffffffff601000 r-xp 00000000 00:00 0                  [vsyscall]
	jonathan@blackbox:~$


We can see qemu-arm-static (and Intel x86_64 executable), /home2/linaro/chroot/usr/bin/wsh (an ARM executable), libssl.so and its dependencies (ARM shared libraries) all sharing a single address space.

There is also no Intel libc on the address space, so our call to getpid() in the previous demo actually came from the ARM C library.

Debugging should now work as usual, transparently converting ARM into Intel x86_64 thanks to qemu. Wsh does its best to hide its presence, and so does qemu.
For instance, displaying the section headers provides the following output:

	> shdrs()
	 -- Total: 145 sections
	0000f67cb134-0000f67cb158	r--	36	/lib/arm-linux-gnueabihf/libdl.so.2	       .note.gnu.build-id	PT_NOTE	r--
	0000f67cb158-0000f67cb178	r--	32	/lib/arm-linux-gnueabihf/libdl.so.2	            .note.ABI-tag	PT_NOTE	r--
	0000f67cb178-0000f67cb210	r--	152	/lib/arm-linux-gnueabihf/libdl.so.2	                .gnu.hash	PT_NOTE	r--
	0000f67cb210-0000f67cb4a0	r--	656	/lib/arm-linux-gnueabihf/libdl.so.2	                  .dynsym	PT_LOAD	r-x
	0000f67cb4a0-0000f67cb68d	r--	493	/lib/arm-linux-gnueabihf/libdl.so.2	                  .dynstr	PT_LOAD	r-x
	0000f67cb68e-0000f67cb6e0	r--	82	/lib/arm-linux-gnueabihf/libdl.so.2	             .gnu.version	PT_LOAD	r-x
	0000f67cb6e0-0000f67cb73c	r--	92	/lib/arm-linux-gnueabihf/libdl.so.2	           .gnu.version_d	PT_LOAD	r-x
	0000f67cb73c-0000f67cb78c	r--	80	/lib/arm-linux-gnueabihf/libdl.so.2	           .gnu.version_r	PT_LOAD	r-x
	0000f67cb78c-0000f67cb81c	r--	144	/lib/arm-linux-gnueabihf/libdl.so.2	                 .rel.dyn	PT_LOAD	r-x
	0000f67cb81c-0000f67cb8a4	r--	136	/lib/arm-linux-gnueabihf/libdl.so.2	                 .rel.plt	PT_LOAD	r-x
	0000f67cb8a4-0000f67cb8b0	r-x	12	/lib/arm-linux-gnueabihf/libdl.so.2	                    .init	PT_LOAD	r-x
	0000f67cb8b0-0000f67cb9a0	r-x	240	/lib/arm-linux-gnueabihf/libdl.so.2	                     .plt	PT_LOAD	r-x
	0000f67cb9a0-0000f67cc258	r-x	2232	/lib/arm-linux-gnueabihf/libdl.so.2	                    .text	PT_LOAD	r-x
	0000f67cc258-0000f67cc260	r-x	8	/lib/arm-linux-gnueabihf/libdl.so.2	                    .fini	PT_LOAD	r-x
	0000f67cc260-0000f67cc2e0	r--	128	/lib/arm-linux-gnueabihf/libdl.so.2	                  .rodata	PT_LOAD	r-x
	0000f67cc2e0-0000f67cc2fc	r--	28	/lib/arm-linux-gnueabihf/libdl.so.2	                  .interp	PT_INTERP	r--
	0000f67cc2fc-0000f67cc300	r--	4	/lib/arm-linux-gnueabihf/libdl.so.2	                .eh_frame	PT_INTERP	r--
	0000f67cc300-0000f67cc474	r--	372	/lib/arm-linux-gnueabihf/libdl.so.2	                    .hash	PT_LOAD	r-x
	0000f67d4ee4-0000f67d4eec	rw-	8	/lib/arm-linux-gnueabihf/libdl.so.2	              .init_array	PT_GNU_RELRO	r--
	0000f67d4eec-0000f67d4ef4	rw-	8	/lib/arm-linux-gnueabihf/libdl.so.2	              .fini_array	PT_GNU_RELRO	r--
	0000f67d4ef4-0000f67d4ef8	rw-	4	/lib/arm-linux-gnueabihf/libdl.so.2	                     .jcr	PT_GNU_RELRO	r--
	0000f67d4ef8-0000f67d5000	rw-	264	/lib/arm-linux-gnueabihf/libdl.so.2	                 .dynamic	PT_DYNAMIC	rw-
	0000f67d5000-0000f67d5084	rw-	132	/lib/arm-linux-gnueabihf/libdl.so.2	                     .got	PT_DYNAMIC	rw-
	0000f67d5084-0000f67d5088	rw-	4	/lib/arm-linux-gnueabihf/libdl.so.2	                    .data	PT_LOAD	rw-
	0000f67d5088-0000f67d50b8	rw-	48	/lib/arm-linux-gnueabihf/libdl.so.2	                     .bss	PT_LOAD	rw-

	0000f66e7174-0000f66e7198	r--	36	/lib/arm-linux-gnueabihf/libc.so.6	       .note.gnu.build-id	PT_NOTE	r--
	0000f66e7198-0000f66e71b8	r--	32	/lib/arm-linux-gnueabihf/libc.so.6	            .note.ABI-tag	PT_NOTE	r--
	0000f66e71b8-0000f66eabd8	r--	14880	/lib/arm-linux-gnueabihf/libc.so.6	                .gnu.hash	PT_NOTE	r--
	0000f66eabd8-0000f66f3578	r--	35232	/lib/arm-linux-gnueabihf/libc.so.6	                  .dynsym	PT_LOAD	r-x
	0000f66f3578-0000f66f8ece	r--	22870	/lib/arm-linux-gnueabihf/libc.so.6	                  .dynstr	PT_LOAD	r-x
	0000f66f8ece-0000f66fa002	r--	4404	/lib/arm-linux-gnueabihf/libc.so.6	             .gnu.version	PT_LOAD	r-x
	0000f66fa004-0000f66fa234	r--	560	/lib/arm-linux-gnueabihf/libc.so.6	           .gnu.version_d	PT_LOAD	r-x
	0000f66fa234-0000f66fa264	r--	48	/lib/arm-linux-gnueabihf/libc.so.6	           .gnu.version_r	PT_LOAD	r-x
	0000f66fa264-0000f66fca54	r--	10224	/lib/arm-linux-gnueabihf/libc.so.6	                 .rel.dyn	PT_LOAD	r-x
	0000f66fca54-0000f66fcaa4	r--	80	/lib/arm-linux-gnueabihf/libc.so.6	                 .rel.plt	PT_LOAD	r-x
	0000f66fcaa4-0000f66fcb38	r-x	148	/lib/arm-linux-gnueabihf/libc.so.6	                     .plt	PT_LOAD	r-x
	0000f66fcb40-0000f679d178	r-x	656952	/lib/arm-linux-gnueabihf/libc.so.6	                    .text	PT_LOAD	r-x
	0000f679d178-0000f679dad8	r-x	2400	/lib/arm-linux-gnueabihf/libc.so.6	        __libc_freeres_fn	PT_LOAD	r-x
	0000f679dad8-0000f679dc58	r-x	384	/lib/arm-linux-gnueabihf/libc.so.6	 __libc_thread_freeres_fn	PT_LOAD	r-x
	0000f679dc58-0000f67b74e1	r--	104585	/lib/arm-linux-gnueabihf/libc.so.6	                  .rodata	PT_LOAD	r-x
	0000f67b74e4-0000f67b7500	r--	28	/lib/arm-linux-gnueabihf/libc.so.6	                  .interp	PT_INTERP	r--
	0000f67b7500-0000f67b8138	r--	3128	/lib/arm-linux-gnueabihf/libc.so.6	               .ARM.extab	PT_INTERP	r--
	0000f67b8138-0000f67b9598	r--	5216	/lib/arm-linux-gnueabihf/libc.so.6	               .ARM.exidx	Unknown: 7000000100000000
		r--
	0000f67b9598-0000f67b959c	r--	4	/lib/arm-linux-gnueabihf/libc.so.6	                .eh_frame	Unknown: 7000000100000000
		r--
	0000f67b959c-0000f67bc7f0	r--	12884	/lib/arm-linux-gnueabihf/libc.so.6	                    .hash	PT_LOAD	r-x
	0000f67c56cc-0000f67c56d4	rw-	8	/lib/arm-linux-gnueabihf/libc.so.6	                   .tdata	PT_GNU_RELRO	r--
	0000f67c56d4-0000f67c570c	rw-	56	/lib/arm-linux-gnueabihf/libc.so.6	                    .tbss	PT_GNU_RELRO	r--
	0000f67c56d4-0000f67c574c	rw-	120	/lib/arm-linux-gnueabihf/libc.so.6	        __libc_subfreeres	PT_GNU_RELRO	r--
	0000f67c574c-0000f67c5750	rw-	4	/lib/arm-linux-gnueabihf/libc.so.6	            __libc_atexit	PT_GNU_RELRO	r--
	0000f67c5750-0000f67c5760	rw-	16	/lib/arm-linux-gnueabihf/libc.so.6	 __libc_thread_subfreeres	PT_GNU_RELRO	r--
	0000f67c5760-0000f67c6f28	rw-	6088	/lib/arm-linux-gnueabihf/libc.so.6	             .data.rel.ro	PT_GNU_RELRO	r--
	0000f67c6f28-0000f67c7000	rw-	216	/lib/arm-linux-gnueabihf/libc.so.6	                 .dynamic	PT_DYNAMIC	rw-
	0000f67c7000-0000f67c7190	rw-	400	/lib/arm-linux-gnueabihf/libc.so.6	                     .got	PT_DYNAMIC	rw-
	0000f67c7190-0000f67c7e04	rw-	3188	/lib/arm-linux-gnueabihf/libc.so.6	                    .data	PT_LOAD	rw-
	0000f67c7e08-0000f67ca588	rw-	10112	/lib/arm-linux-gnueabihf/libc.so.6	                     .bss	PT_LOAD	rw-

	0000f67df114-0000f67df138	r--	36	/lib/ld-linux-armhf.so.3	       .note.gnu.build-id	PT_NOTE	r--
	0000f67df138-0000f67df1f4	r--	188	/lib/ld-linux-armhf.so.3	                    .hash	PT_NOTE	r--
	0000f67df1f4-0000f67df2cc	r--	216	/lib/ld-linux-armhf.so.3	                .gnu.hash	PT_LOAD	r-x
	0000f67df2cc-0000f67df48c	r--	448	/lib/ld-linux-armhf.so.3	                  .dynsym	PT_LOAD	r-x
	0000f67df48c-0000f67df617	r--	395	/lib/ld-linux-armhf.so.3	                  .dynstr	PT_LOAD	r-x
	0000f67df618-0000f67df650	r--	56	/lib/ld-linux-armhf.so.3	             .gnu.version	PT_LOAD	r-x
	0000f67df650-0000f67df6ac	r--	92	/lib/ld-linux-armhf.so.3	           .gnu.version_d	PT_LOAD	r-x
	0000f67df6ac-0000f67df74c	r--	160	/lib/ld-linux-armhf.so.3	                 .rel.dyn	PT_LOAD	r-x
	0000f67df74c-0000f67df77c	r--	48	/lib/ld-linux-armhf.so.3	                 .rel.plt	PT_LOAD	r-x
	0000f67df77c-0000f67df7e4	r-x	104	/lib/ld-linux-armhf.so.3	                     .plt	PT_LOAD	r-x
	0000f67df7f0-0000f67f1ed0	r-x	75488	/lib/ld-linux-armhf.so.3	                    .text	PT_LOAD	r-x
	0000f67f1ed0-0000f67f5a8c	r--	15292	/lib/ld-linux-armhf.so.3	                  .rodata	PT_LOAD	r-x
	0000f67f5a8c-0000f67f5ae0	r--	84	/lib/ld-linux-armhf.so.3	               .ARM.extab	PT_LOAD	r-x
	0000f67f5ae0-0000f67f5b98	r--	184	/lib/ld-linux-armhf.so.3	               .ARM.exidx	Unknown: 7000000100000000
		r--
	0000f67fdd48-0000f67fdf44	rw-	508	/lib/ld-linux-armhf.so.3	             .data.rel.ro	PT_GNU_RELRO	r--
	0000f67fdf44-0000f67fdffc	rw-	184	/lib/ld-linux-armhf.so.3	                 .dynamic	PT_DYNAMIC	rw-
	0000f67fe000-0000f67fe04c	rw-	76	/lib/ld-linux-armhf.so.3	                     .got	PT_GNU_RELRO	r--
	0000f67fe050-0000f67fe884	rw-	2100	/lib/ld-linux-armhf.so.3	                    .data	PT_LOAD	rw-
	0000f67fe884-0000f67fe958	rw-	212	/lib/ld-linux-armhf.so.3	                     .bss	PT_LOAD	rw-

	0000f66a60f4-0000f66a6118	r--	36	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	       .note.gnu.build-id	PT_NOTE	r--
	0000f66a6118-0000f66a6aa0	r--	2440	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                .gnu.hash	PT_NOTE	r--
	0000f66a6aa0-0000f66a92f0	r--	10320	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                  .dynsym	PT_LOAD	r-x
	0000f66a92f0-0000f66ac100	r--	11792	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                  .dynstr	PT_LOAD	r-x
	0000f66ac100-0000f66ac60a	r--	1290	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	             .gnu.version	PT_LOAD	r-x
	0000f66ac60c-0000f66ac68c	r--	128	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	           .gnu.version_d	PT_LOAD	r-x
	0000f66ac68c-0000f66ac71c	r--	144	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	           .gnu.version_r	PT_LOAD	r-x
	0000f66ac71c-0000f66af044	r--	10536	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                 .rel.dyn	PT_LOAD	r-x
	0000f66af044-0000f66afb4c	r--	2824	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                 .rel.plt	PT_LOAD	r-x
	0000f66afb4c-0000f66afb58	r-x	12	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                    .init	PT_LOAD	r-x
	0000f66afb58-0000f66b0c68	r-x	4368	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                     .plt	PT_LOAD	r-x
	0000f66b0c68-0000f66d140c	r-x	133028	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                    .text	PT_LOAD	r-x
	0000f66d140c-0000f66d1414	r-x	8	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                    .fini	PT_LOAD	r-x
	0000f66d1414-0000f66d6d6c	r--	22872	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                  .rodata	PT_LOAD	r-x
	0000f66d6d6c-0000f66d6d70	r--	4	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                .eh_frame	PT_LOAD	r-x
	0000f66df908-0000f66df90c	rw-	4	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	              .init_array	PT_GNU_RELRO	r--
	0000f66df90c-0000f66df910	rw-	4	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	              .fini_array	PT_GNU_RELRO	r--
	0000f66df910-0000f66df914	rw-	4	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                     .jcr	PT_GNU_RELRO	r--
	0000f66df914-0000f66e0ef8	rw-	5604	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	             .data.rel.ro	PT_GNU_RELRO	r--
	0000f66e0ef8-0000f66e1000	rw-	264	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                 .dynamic	PT_DYNAMIC	rw-
	0000f66e1000-0000f66e15f4	rw-	1524	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                     .got	PT_DYNAMIC	rw-
	0000f66e15f4-0000f66e4278	rw-	11396	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                    .data	PT_LOAD	rw-
	0000f66e4278-0000f66e42e8	rw-	112	/lib/arm-linux-gnueabihf/libssl.so.1.0.0	                     .bss	PT_LOAD	rw-

	0000f6591114-0000f6591138	r--	36	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	       .note.gnu.build-id	PT_NOTE	r--
	0000f6591138-0000f6597944	r--	26636	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                .gnu.hash	PT_NOTE	r--
	0000f6597944-0000f65a60a4	r--	59232	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                  .dynsym	PT_LOAD	r-x
	0000f65a60a4-0000f65b6dc9	r--	68901	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                  .dynstr	PT_LOAD	r-x
	0000f65b6dca-0000f65b8ab6	r--	7404	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	             .gnu.version	PT_LOAD	r-x
	0000f65b8ab8-0000f65b8b38	r--	128	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	           .gnu.version_d	PT_LOAD	r-x
	0000f65b8b38-0000f65b8bb8	r--	128	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	           .gnu.version_r	PT_LOAD	r-x
	0000f65b8bb8-0000f65c86a0	r--	64232	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                 .rel.dyn	PT_LOAD	r-x
	0000f65c86a0-0000f65c8a30	r--	912	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                 .rel.plt	PT_LOAD	r-x
	0000f65c8a30-0000f65c8a3c	r-x	12	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                    .init	PT_LOAD	r-x
	0000f65c8a3c-0000f65c8fd4	r-x	1432	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                     .plt	PT_LOAD	r-x
	0000f65c9000-0000f66559c4	r-x	575940	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                    .text	PT_LOAD	r-x
	0000f66559c4-0000f66559cc	r-x	8	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                    .fini	PT_LOAD	r-x
	0000f66559d0-0000f667fe04	r--	173108	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                  .rodata	PT_LOAD	r-x
	0000f667fe04-0000f667fe0c	r--	8	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	               .ARM.exidx	Unknown: 7000000100000000
		r--
	0000f667fe0c-0000f667fe10	r--	4	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                .eh_frame	Unknown: 7000000100000000
		r--
	0000f6688044-0000f668804c	rw-	8	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	              .init_array	PT_GNU_RELRO	r--
	0000f668804c-0000f6688050	rw-	4	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	              .fini_array	PT_GNU_RELRO	r--
	0000f6688050-0000f6688054	rw-	4	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                     .jcr	PT_GNU_RELRO	r--
	0000f6688054-0000f6694ef0	rw-	52892	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	             .data.rel.ro	PT_GNU_RELRO	r--
	0000f6694ef0-0000f6695000	rw-	272	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                 .dynamic	PT_DYNAMIC	rw-
	0000f6695000-0000f66956c0	rw-	1728	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                     .got	PT_DYNAMIC	rw-
	0000f66956c0-0000f669b1c0	rw-	23296	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                    .data	PT_LOAD	rw-
	0000f669b1c0-0000f669e644	rw-	13444	/lib/arm-linux-gnueabihf/libcrypto.so.1.0.0	                     .bss	PT_LOAD	rw-

	0000f6576114-0000f6576138	r--	36	/lib/arm-linux-gnueabihf/libz.so.1	       .note.gnu.build-id	PT_NOTE	r--
	0000f6576138-0000f65763fc	r--	708	/lib/arm-linux-gnueabihf/libz.so.1	                .gnu.hash	PT_NOTE	r--
	0000f65763fc-0000f6576b4c	r--	1872	/lib/arm-linux-gnueabihf/libz.so.1	                  .dynsym	PT_LOAD	r-x
	0000f6576b4c-0000f6577099	r--	1357	/lib/arm-linux-gnueabihf/libz.so.1	                  .dynstr	PT_LOAD	r-x
	0000f657709a-0000f6577184	r--	234	/lib/arm-linux-gnueabihf/libz.so.1	             .gnu.version	PT_LOAD	r-x
	0000f6577184-0000f6577348	r--	452	/lib/arm-linux-gnueabihf/libz.so.1	           .gnu.version_d	PT_LOAD	r-x
	0000f6577348-0000f6577388	r--	64	/lib/arm-linux-gnueabihf/libz.so.1	           .gnu.version_r	PT_LOAD	r-x
	0000f6577388-0000f65774a0	r--	280	/lib/arm-linux-gnueabihf/libz.so.1	                 .rel.dyn	PT_LOAD	r-x
	0000f65774a0-0000f6577540	r--	160	/lib/arm-linux-gnueabihf/libz.so.1	                 .rel.plt	PT_LOAD	r-x
	0000f6577540-0000f657754c	r-x	12	/lib/arm-linux-gnueabihf/libz.so.1	                    .init	PT_LOAD	r-x
	0000f657754c-0000f6577658	r-x	268	/lib/arm-linux-gnueabihf/libz.so.1	                     .plt	PT_LOAD	r-x
	0000f6577658-0000f6582e54	r-x	47100	/lib/arm-linux-gnueabihf/libz.so.1	                    .text	PT_LOAD	r-x
	0000f6582e54-0000f6582e5c	r-x	8	/lib/arm-linux-gnueabihf/libz.so.1	                    .fini	PT_LOAD	r-x
	0000f6582e5c-0000f6586eac	r--	16464	/lib/arm-linux-gnueabihf/libz.so.1	                  .rodata	PT_LOAD	r-x
	0000f6586eac-0000f6586eb4	r--	8	/lib/arm-linux-gnueabihf/libz.so.1	               .ARM.exidx	Unknown: 7000000100000000
		r--
	0000f6586eb4-0000f6586eb8	r--	4	/lib/arm-linux-gnueabihf/libz.so.1	                .eh_frame	Unknown: 7000000100000000
		r--
	0000f658fe54-0000f658fe58	rw-	4	/lib/arm-linux-gnueabihf/libz.so.1	              .init_array	PT_GNU_RELRO	r--
	0000f658fe58-0000f658fe5c	rw-	4	/lib/arm-linux-gnueabihf/libz.so.1	              .fini_array	PT_GNU_RELRO	r--
	0000f658fe5c-0000f658fe60	rw-	4	/lib/arm-linux-gnueabihf/libz.so.1	                     .jcr	PT_GNU_RELRO	r--
	0000f658fe60-0000f658ff00	rw-	160	/lib/arm-linux-gnueabihf/libz.so.1	             .data.rel.ro	PT_GNU_RELRO	r--
	0000f658ff00-0000f6590000	rw-	256	/lib/arm-linux-gnueabihf/libz.so.1	                 .dynamic	PT_DYNAMIC	rw-
	0000f6590000-0000f6590078	rw-	120	/lib/arm-linux-gnueabihf/libz.so.1	                     .got	PT_DYNAMIC	rw-
	0000f6590078-0000f65900b8	rw-	64	/lib/arm-linux-gnueabihf/libz.so.1	                    .data	PT_LOAD	rw-
	0000f65900b8-0000f65900bc	rw-	4	/lib/arm-linux-gnueabihf/libz.so.1	                     .bss	PT_LOAD	rw-

	 -- Total: 145 sections
	> 


All of the wsh commands and API are similarly supported under ARM.


## Important Note

Gdb, strace or ltrace will not work within the qemu usermode emulator since ptrace() is not supported. To the contrary, wsh doesn't use ptrace() and is fully supported.

