"""
proxy.py

Copyright 2007 Andres Riancho

This file is part of w3af, http://w3af.org/ .

w3af is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation version 2 of the License.

w3af is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with w3af; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""

from w3af.core.controllers.misc.common_attack_methods import CommonAttackMethods
from w3af.core.data.kb.exploit_result import ExploitResult
from w3af.core.controllers.exceptions import BaseFrameworkException
from w3af.core.controllers.intrusion_tools.execMethodHelpers import *

# python stuff
import time


class proxy(ExploitResult, CommonAttackMethods):
    """
    This class represents the output of an attack plugin that gives a proxy to the w3af user.

    :author: Andres Riancho (andres.riancho@gmail.com)
    """

    def __init__(self, proxyDaemonObject):
        ExploitResult.__init__(self)

        self._proxyDaemon = proxyDaemonObject

    def end(self):
        """
        This method is called when the proxy is not going to be used anymore. It should be used to remove the
        auxiliary files (local and remote) generated by the proxy.

        :return: None
        """
        raise BaseFrameworkException('You should implement the end method of classes that inherit from "proxy"')

    def get_name(self):
        """
        This method is called when the proxy is used, in order to create a prompt for the user.

        :return: The name of the proxy (rfi_proxy, dav_proxy, etc.)
        """
        raise BaseFrameworkException('You should implement the get_name method of classes that inherit from "proxy"')

    def __repr__(self):
        return '<proxy server at: ' + self._proxyDaemon.get_bind_ip() + ':' + str(self._proxyDaemon.get_bind_port()) + '>'

    __str__ = __repr__
