# Voltron configuration

Voltron uses a JSON or file for configuration, located at `~/.voltron/config`. There is a set of configuration defaults included in the package (`voltron/config/default.cfg`), and a sample config (`/voltron/config/sample.cfg`).

The config is laid out the following sections:

    {
        "general": {

        },
        "server": {

        },
        "view": {

        },
        "console": {

        }
    }

Any section can be missing. The default options will be applied from `default.cfg`.

## General configuration

This section contains options that effect the operation of the entire package. 

### Debug logging

    {
        "general": {
            "debug_logging": true
        }
    }

If debug logging is enabled, the following files are created in `~/.voltron/`:

* `debugger.log`
* `main.log`

`debugger.log` contains logging from Voltron's backend running in the debugger host.

`main.log` contains logging from Voltron's frontend (ie. views).

## Server configuration

The `server` section contains options that effect only the server component of Voltron. This applies to servers running in the context of the debugger host (ie. loaded into LLDB/GDB) or the server running in Voltron's standalone console.

### Listeners

Voltron can listen on a TCP port and/or a UNIX domain socket:

    "server": {
        "listen": {
            "domain":   "~/.voltron/sock",
            "tcp":      ["127.0.0.1", 5555]
        }
    }

If you change the port or file the server listens on you'll also need to change the `api_url` field in the view configuration below.

## View configuration

The views connect to the server via the URL specified in the `api_url` field:

    "view": {
        "api_url": "http://localhost:5555/api/request"
    }

If you've changed the server's listener config, you'll need to change the view's `api_url` field to match.

Voltron's built-in terminal views can be customised quite a bit with configuration. Header and footer positions, visbility and colours are configurable along with other view-specific items (e.g. colours for labels and values in the register view).

In the example config at the top level, the `all_views` section sets up a base configuration to apply to all views. Each view can be configured individually overriding these settings. For example, the `stack_view` section in the example config overrides a number of these settings to reposition the title and info labels. The `register_view` section in the example config contains some settings overriding the default colours for the register view. Have a look at the source for other items in `format_defaults` that can be overridden in this section of the config.

There is also support for named view configurations for each type. The example configuration contains a config section called `some_named_stack_view`, which is a modified version of the example stack view configuration. If you specify this name with the `-n` option, this named configuration will be added to the existing config for that view type:

    $ voltron stack -n "some_named_stack_view"

Some options specified in the configuration file can also be overridden by command line arguments. At this stage, just the show/hide header/footer options.

Configuration settings are applied in the following order:

1. defaults in defaults.cfg
2. `all_views` config
3. view-specific config
4. named view config
5. command line args

Each configuration level is added to the previous level, and only the options specified in this level override the previous level.

See `default.cfg` for an example.