# APIs for Windows 32-bit libraries ws2_32, mswsock, wsock32, and wininet.
# Format:  rettype, retname, callconv, exactname, arglist(type, name)
#          arglist type is one of ['int', 'void *']
#          arglist name is one of [None, 'funcptr', 'obj', 'ptr']

api_defs = {
    # WS2_32
    'ws2_32.main_entry':( 'int', None, 'stdcall', 'ws2_32.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.freeaddrinfow':( 'int', None, 'stdcall', 'ws2_32.FreeAddrInfoW', (('void *', 'ptr'),) ),
    'ws2_32.getaddrinfow':( 'int', None, 'stdcall', 'ws2_32.GetAddrInfoW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.getnameinfow':( 'int', None, 'stdcall', 'ws2_32.GetNameInfoW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wep':( 'int', None, 'cdecl', 'ws2_32.WEP', () ),
    'ws2_32.wpucompleteoverlappedrequest':( 'int', None, 'stdcall', 'ws2_32.WPUCompleteOverlappedRequest', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaaccept':( 'int', None, 'stdcall', 'ws2_32.WSAAccept', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaaddresstostringa':( 'int', None, 'stdcall', 'ws2_32.WSAAddressToStringA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaaddresstostringw':( 'int', None, 'stdcall', 'ws2_32.WSAAddressToStringW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncgethostbyaddr':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncGetHostByAddr', (('int', None), ('int', None), ('int', None), ('DWORD', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncgethostbyname':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncGetHostByName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncgetprotobyname':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncGetProtoByName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncgetprotobynumber':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncGetProtoByNumber', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncgetservbyname':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncGetServByName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncgetservbyport':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncGetServByPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaasyncselect':( 'int', None, 'stdcall', 'ws2_32.WSAAsyncSelect', ( ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsacancelasyncrequest':( 'int', None, 'stdcall', 'ws2_32.WSACancelAsyncRequest', (('int', None),) ),
    'ws2_32.wsacancelblockingcall':( 'int', None, 'stdcall', 'ws2_32.WSACancelBlockingCall', () ),
    'ws2_32.wsacleanup':( 'int', None, 'stdcall', 'ws2_32.WSACleanup', () ),
    'ws2_32.wsacloseevent':( 'int', None, 'stdcall', 'ws2_32.WSACloseEvent', (('HANDLE', None),) ),
    'ws2_32.wsaconnect':( 'int', None, 'stdcall', 'ws2_32.WSAConnect', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsacreateevent':( 'int', None, 'cdecl', 'ws2_32.WSACreateEvent', () ),
    'ws2_32.wsaduplicatesocketa':( 'int', None, 'stdcall', 'ws2_32.WSADuplicateSocketA', ( ('int', None), ('int', None)) ),
    'ws2_32.wsaduplicatesocketw':( 'int', None, 'stdcall', 'ws2_32.WSADuplicateSocketW', ( ('int', None), ('void *', 'ptr')) ),
    'ws2_32.wsaenumnamespaceprovidersa':( 'int', None, 'stdcall', 'ws2_32.WSAEnumNameSpaceProvidersA', (('int', None), ('int', None)) ),
    'ws2_32.wsaenumnamespaceprovidersw':( 'int', None, 'stdcall', 'ws2_32.WSAEnumNameSpaceProvidersW', (('int', None), ('int', None)) ),
    'ws2_32.wsaenumnetworkevents':( 'int', None, 'stdcall', 'ws2_32.WSAEnumNetworkEvents', ( ('int', None), ('int', None)) ),
    'ws2_32.wsaenumprotocolsa':( 'int', None, 'stdcall', 'ws2_32.WSAEnumProtocolsA', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaenumprotocolsw':( 'int', None, 'stdcall', 'ws2_32.WSAEnumProtocolsW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ws2_32.wsaeventselect':( 'int', None, 'stdcall', 'ws2_32.WSAEventSelect', ( ('int', None), ('int', None)) ),
    'ws2_32.wsagetlasterror':( 'int', None, 'stdcall', 'ws2_32.WSAGetLastError', () ),
    'ws2_32.wsagetoverlappedresult':( 'int', None, 'stdcall', 'ws2_32.WSAGetOverlappedResult', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsagetqosbyname':( 'int', None, 'stdcall', 'ws2_32.WSAGetQOSByName', ( ('int', None), ('int', None)) ),
    'ws2_32.wsagetserviceclassinfoa':( 'int', None, 'stdcall', 'ws2_32.WSAGetServiceClassInfoA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsagetserviceclassinfow':( 'int', None, 'stdcall', 'ws2_32.WSAGetServiceClassInfoW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsagetserviceclassnamebyclassida':( 'int', None, 'stdcall', 'ws2_32.WSAGetServiceClassNameByClassIdA', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsagetserviceclassnamebyclassidw':( 'int', None, 'stdcall', 'ws2_32.WSAGetServiceClassNameByClassIdW', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsahtonl':( 'int', None, 'stdcall', 'ws2_32.WSAHtonl', ( ('int', None), ('int', None)) ),
    'ws2_32.wsahtons':( 'int', None, 'stdcall', 'ws2_32.WSAHtons', ( ('int', None), ('int', None)) ),
    'ws2_32.wsainstallserviceclassa':( 'int', None, 'stdcall', 'ws2_32.WSAInstallServiceClassA', (('int', None),) ),
    'ws2_32.wsainstallserviceclassw':( 'int', None, 'stdcall', 'ws2_32.WSAInstallServiceClassW', (('int', None),) ),
    'ws2_32.wsaioctl':( 'int', None, 'stdcall', 'ws2_32.WSAIoctl', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ws2_32.wsaisblocking':( 'int', None, 'stdcall', 'ws2_32.WSAIsBlocking', () ),
    'ws2_32.wsajoinleaf':( 'int', None, 'stdcall', 'ws2_32.WSAJoinLeaf', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsalookupservicebegina':( 'int', None, 'stdcall', 'ws2_32.WSALookupServiceBeginA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ws2_32.wsalookupservicebeginw':( 'int', None, 'stdcall', 'ws2_32.WSALookupServiceBeginW', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ws2_32.wsalookupserviceend':( 'int', None, 'stdcall', 'ws2_32.WSALookupServiceEnd', () ),
    'ws2_32.wsalookupservicenexta':( 'int', None, 'stdcall', 'ws2_32.WSALookupServiceNextA', ( ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsalookupservicenextw':( 'int', None, 'stdcall', 'ws2_32.WSALookupServiceNextW', ( ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ws2_32.wsanspioctl':( 'int', None, 'stdcall', 'ws2_32.WSANSPIoctl', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsantohl':( 'int', None, 'stdcall', 'ws2_32.WSANtohl', ( ('int', None), ('int', None)) ),
    'ws2_32.wsantohs':( 'int', None, 'stdcall', 'ws2_32.WSANtohs', ( ('int', None), ('int', None)) ),
    'ws2_32.wsaproviderconfigchange':( 'int', None, 'stdcall', 'ws2_32.WSAProviderConfigChange', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsarecv':( 'int', None, 'stdcall', 'ws2_32.WSARecv', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsarecvdisconnect':( 'int', None, 'stdcall', 'ws2_32.WSARecvDisconnect', ( ('int', None),) ),
    'ws2_32.wsarecvfrom':( 'int', None, 'stdcall', 'ws2_32.WSARecvFrom', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsaremoveserviceclass':( 'int', None, 'stdcall', 'ws2_32.WSARemoveServiceClass', (('int', None),) ),
    'ws2_32.wsaresetevent':( 'int', None, 'cdecl', 'ws2_32.WSAResetEvent', () ),
    'ws2_32.wsasend':( 'int', None, 'stdcall', 'ws2_32.WSASend', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsasenddisconnect':( 'int', None, 'stdcall', 'ws2_32.WSASendDisconnect', ( ('int', None),) ),
    'ws2_32.wsasendto':( 'int', None, 'stdcall', 'ws2_32.WSASendTo', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsasetblockinghook':( 'int', None, 'stdcall', 'ws2_32.WSASetBlockingHook', ( ('int', None),) ),
    'ws2_32.wsasetevent':( 'int', None, 'cdecl', 'ws2_32.WSASetEvent', () ),
    'ws2_32.wsasetlasterror':( 'int', None, 'cdecl', 'ws2_32.WSASetLastError', () ),
    'ws2_32.wsasetservicea':( 'int', None, 'stdcall', 'ws2_32.WSASetServiceA', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsasetservicew':( 'int', None, 'stdcall', 'ws2_32.WSASetServiceW', (('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsasocketa':( 'int', None, 'stdcall', 'ws2_32.WSASocketA', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsasocketw':( 'int', None, 'stdcall', 'ws2_32.WSASocketW', (('int', None), ('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ws2_32.wsastartup':( 'int', None, 'stdcall', 'ws2_32.WSAStartup', (('int', None), ('void *', 'ptr')) ),
    'ws2_32.wsastringtoaddressa':( 'int', None, 'stdcall', 'ws2_32.WSAStringToAddressA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wsastringtoaddressw':( 'int', None, 'stdcall', 'ws2_32.WSAStringToAddressW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ws2_32.wsaunhookblockinghook':( 'int', None, 'stdcall', 'ws2_32.WSAUnhookBlockingHook', () ),
    'ws2_32.wsawaitformultipleevents':( 'int', None, 'cdecl', 'ws2_32.WSAWaitForMultipleEvents', () ),
    'ws2_32.wsapsetpostroutine':( 'int', None, 'stdcall', 'ws2_32.WSApSetPostRoutine', (('int', None),) ),
    'ws2_32.wscdeinstallprovider':( 'int', None, 'stdcall', 'ws2_32.WSCDeinstallProvider', (('int', None), ('int', None)) ),
    'ws2_32.wscenablensprovider':( 'int', None, 'stdcall', 'ws2_32.WSCEnableNSProvider', (('int', None), ('int', None)) ),
    'ws2_32.wscenumprotocols':( 'int', None, 'stdcall', 'ws2_32.WSCEnumProtocols', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wscgetproviderpath':( 'int', None, 'stdcall', 'ws2_32.WSCGetProviderPath', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wscinstallnamespace':( 'int', None, 'stdcall', 'ws2_32.WSCInstallNameSpace', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wscinstallprovider':( 'int', None, 'stdcall', 'ws2_32.WSCInstallProvider', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wscuninstallnamespace':( 'int', None, 'stdcall', 'ws2_32.WSCUnInstallNameSpace', (('int', None),) ),
    'ws2_32.wscupdateprovider':( 'int', None, 'stdcall', 'ws2_32.WSCUpdateProvider', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.wscwritenamespaceorder':( 'int', None, 'stdcall', 'ws2_32.WSCWriteNameSpaceOrder', (('int', None), ('int', None)) ),
    'ws2_32.wscwriteproviderorder':( 'int', None, 'stdcall', 'ws2_32.WSCWriteProviderOrder', (('int', None), ('int', None)) ),
    'ws2_32.__wsafdisset':( 'int', None, 'stdcall', 'ws2_32.__WSAFDIsSet', (('int', None), ('int', None)) ),
    'ws2_32.accept':( 'int', None, 'stdcall', 'ws2_32.accept', ( ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ws2_32.bind':( 'int', None, 'stdcall', 'ws2_32.bind', ( ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.closesocket':( 'int', None, 'stdcall', 'ws2_32.closesocket', (('int', None),) ),
    'ws2_32.connect':( 'int', None, 'stdcall', 'ws2_32.connect', ( ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.freeaddrinfo':( 'int', None, 'stdcall', 'ws2_32.freeaddrinfo', (('void *', 'ptr'),) ),
    'ws2_32.getaddrinfo':( 'int', None, 'stdcall', 'ws2_32.getaddrinfo', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.gethostbyaddr':( 'int', None, 'stdcall', 'ws2_32.gethostbyaddr', ( ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.gethostbyname':( 'int', None, 'stdcall', 'ws2_32.gethostbyname', ( ('void *', 'ptr'),) ),
    'ws2_32.gethostname':( 'int', None, 'stdcall', 'ws2_32.gethostname', ( ('void *', 'ptr'), ('int', None)) ),
    'ws2_32.getnameinfo':( 'int', None, 'stdcall', 'ws2_32.getnameinfo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.getpeername':( 'int', None, 'stdcall', 'ws2_32.getpeername', ( ('int', None), ('int', None)) ),
    'ws2_32.getprotobyname':( 'int', None, 'stdcall', 'ws2_32.getprotobyname', (('int', None),) ),
    'ws2_32.getprotobynumber':( 'int', None, 'stdcall', 'ws2_32.getprotobynumber', ( ('int', None),) ),
    'ws2_32.getservbyname':( 'int', None, 'stdcall', 'ws2_32.getservbyname', (('void *', 'ptr'), ('int', None)) ),
    'ws2_32.getservbyport':( 'int', None, 'stdcall', 'ws2_32.getservbyport', (('int', None), ('int', None)) ),
    'ws2_32.getsockname':( 'int', None, 'stdcall', 'ws2_32.getsockname', ( ('int', None), ('int', None)) ),
    'ws2_32.getsockopt':( 'int', None, 'stdcall', 'ws2_32.getsockopt', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.htonl':( 'int', None, 'stdcall', 'ws2_32.htonl', (('int', None),) ),
    'ws2_32.htons':( 'int', None, 'stdcall', 'ws2_32.htons', (('int', None),) ),
    'ws2_32.inet_addr':( 'int', None, 'stdcall', 'ws2_32.inet_addr', (('int', None),) ),
    'ws2_32.inet_ntoa':( 'int', None, 'stdcall', 'ws2_32.inet_ntoa', ( ('int', None),) ),
    'ws2_32.ioctlsocket':( 'int', None, 'stdcall', 'ws2_32.ioctlsocket', ( ('int', None), ('int', None)) ),
    'ws2_32.listen':( 'int', None, 'stdcall', 'ws2_32.listen', ( ('int', None),) ),
    'ws2_32.ntohl':( 'int', None, 'stdcall', 'ws2_32.ntohl', (('int', None),) ),
    'ws2_32.ntohs':( 'int', None, 'stdcall', 'ws2_32.ntohs', (('int', None),) ),
    'ws2_32.recv':( 'int', None, 'stdcall', 'ws2_32.recv', ( ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.recvfrom':( 'int', None, 'stdcall', 'ws2_32.recvfrom', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.select':( 'int', None, 'stdcall', 'ws2_32.select', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.send':( 'int', None, 'stdcall', 'ws2_32.send', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.sendto':( 'int', None, 'stdcall', 'ws2_32.sendto', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.setsockopt':( 'int', None, 'stdcall', 'ws2_32.setsockopt', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ws2_32.shutdown':( 'int', None, 'stdcall', 'ws2_32.shutdown', ( ('int', None), ('int', None)) ),
    'ws2_32.socket':( 'int', None, 'stdcall', 'ws2_32.socket', ( ('int', None), ('int', None), ('void *', 'obj')) ),

    # MSWSOCK
    'mswsock.main_entry':( 'int', None, 'stdcall', 'mswsock.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'mswsock.acceptex':( 'int', None, 'stdcall', 'mswsock.AcceptEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.enumprotocolsa':( 'int', None, 'stdcall', 'mswsock.EnumProtocolsA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'mswsock.enumprotocolsw':( 'int', None, 'stdcall', 'mswsock.EnumProtocolsW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'mswsock.getacceptexsockaddrs':( 'int', None, 'stdcall', 'mswsock.GetAcceptExSockaddrs', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.getaddressbynamea':( 'int', None, 'stdcall', 'mswsock.GetAddressByNameA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.getaddressbynamew':( 'int', None, 'stdcall', 'mswsock.GetAddressByNameW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'mswsock.getnamebytypea':( 'int', None, 'stdcall', 'mswsock.GetNameByTypeA', (('int', None), ('int', None), ('int', None)) ),
    'mswsock.getnamebytypew':( 'int', None, 'stdcall', 'mswsock.GetNameByTypeW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'mswsock.getservicea':( 'int', None, 'stdcall', 'mswsock.GetServiceA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.getservicew':( 'int', None, 'stdcall', 'mswsock.GetServiceW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.gettypebynamea':( 'int', None, 'stdcall', 'mswsock.GetTypeByNameA', (('int', None), ('void *', 'ptr')) ),
    'mswsock.gettypebynamew':( 'int', None, 'stdcall', 'mswsock.GetTypeByNameW', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'mswsock.migratewinsockconfiguration':( 'int', None, 'stdcall', 'mswsock.MigrateWinsockConfiguration', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'mswsock.nploadnamespaces':( 'int', None, 'stdcall', 'mswsock.NPLoadNameSpaces', (('int', None), ('int', None), ('int', None)) ),
    'mswsock.nspstartup':( 'int', None, 'stdcall', 'mswsock.NSPStartup', (('int', None), ('int', None)) ),
    'mswsock.servicemain':( 'int', None, 'stdcall', 'mswsock.ServiceMain', (('int', None), ('int', None)) ),
    'mswsock.setservicea':( 'int', None, 'stdcall', 'mswsock.SetServiceA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.setservicew':( 'int', None, 'stdcall', 'mswsock.SetServiceW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.startwsdpservice':( 'int', None, 'cdecl', 'mswsock.StartWsdpService', () ),
    'mswsock.stopwsdpservice':( 'int', None, 'cdecl', 'mswsock.StopWsdpService', () ),
    'mswsock.svchostpushserviceglobals':( 'int', None, 'stdcall', 'mswsock.SvchostPushServiceGlobals', (('int', None),) ),
    'mswsock.transmitfile':( 'int', None, 'stdcall', 'mswsock.TransmitFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.wsarecvex':( 'int', None, 'stdcall', 'mswsock.WSARecvEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.wspstartup':( 'int', None, 'stdcall', 'mswsock.WSPStartup', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.dn_expand':( 'int', None, 'stdcall', 'mswsock.dn_expand', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.getnetbyname':( 'int', None, 'stdcall', 'mswsock.getnetbyname', (('int', None),) ),
    'mswsock.inet_network':( 'int', None, 'stdcall', 'mswsock.inet_network', (('int', None),) ),
    'mswsock.rcmd':( 'int', None, 'stdcall', 'mswsock.rcmd', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.rexec':( 'int', None, 'stdcall', 'mswsock.rexec', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'mswsock.rresvport':( 'int', None, 'stdcall', 'mswsock.rresvport', (('void *', 'ptr'),) ),
    'mswsock.s_perror':( 'int', None, 'stdcall', 'mswsock.s_perror', (('void *', 'ptr'), ('int', None)) ),
    'mswsock.sethostname':( 'int', None, 'stdcall', 'mswsock.sethostname', (('int', None), ('int', None)) ),

    # WSOCK32
    'wsock32.main_entry':( 'int', None, 'stdcall', 'wsock32.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'wsock32.getsockopt':( 'int', None, 'stdcall', 'wsock32.getsockopt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wsock32.recv':( 'int', None, 'stdcall', 'wsock32.recv', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wsock32.recvfrom':( 'int', None, 'stdcall', 'wsock32.recvfrom', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wsock32.setsockopt':( 'int', None, 'stdcall', 'wsock32.setsockopt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wsock32.acceptex':('int', None, 'stdcall', 'mswsock.AcceptEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.enumprotocolsa':('int', None, 'stdcall', 'mswsock.EnumProtocolsA', (('int', None), ('int', None), ('void *', 'ptr'))),
    'wsock32.enumprotocolsw':('int', None, 'stdcall', 'mswsock.EnumProtocolsW', (('int', None), ('int', None), ('void *', 'ptr'))),
    'wsock32.getacceptexsockaddrs':('int', None, 'stdcall', 'mswsock.GetAcceptExSockaddrs', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.getaddressbynamea':('int', None, 'stdcall', 'mswsock.GetAddressByNameA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.getaddressbynamew':('int', None, 'stdcall', 'mswsock.GetAddressByNameW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'))),
    'wsock32.getnamebytypea':('int', None, 'stdcall', 'mswsock.GetNameByTypeA', (('int', None), ('int', None), ('int', None))),
    'wsock32.getnamebytypew':('int', None, 'stdcall', 'mswsock.GetNameByTypeW', (('int', None), ('void *', 'ptr'), ('int', None))),
    'wsock32.getservicea':('int', None, 'stdcall', 'mswsock.GetServiceA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.getservicew':('int', None, 'stdcall', 'mswsock.GetServiceW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.gettypebynamea':('int', None, 'stdcall', 'mswsock.GetTypeByNameA', (('int', None), ('void *', 'ptr'))),
    'wsock32.gettypebynamew':('int', None, 'stdcall', 'mswsock.GetTypeByNameW', (('void *', 'ptr'), ('void *', 'ptr'))),
    'wsock32.migratewinsockconfiguration':('int', None, 'stdcall', 'mswsock.MigrateWinsockConfiguration', (('int', None), ('void *', 'funcptr'), ('int', None))),
    'wsock32.nploadnamespaces':('int', None, 'stdcall', 'mswsock.NPLoadNameSpaces', (('int', None), ('int', None), ('int', None))),
    'wsock32.setservicea':('int', None, 'stdcall', 'mswsock.SetServiceA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.setservicew':('int', None, 'stdcall', 'mswsock.SetServiceW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.transmitfile':('int', None, 'stdcall', 'mswsock.TransmitFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wep':('int', None, 'cdecl', 'ws2_32.WEP', ()),
    'wsock32.wsaasyncgethostbyaddr':('int', None, 'stdcall', 'ws2_32.WSAAsyncGetHostByAddr', (('int', None), ('int', None), ('int', None), ('DWORD', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsaasyncgethostbyname':('int', None, 'stdcall', 'ws2_32.WSAAsyncGetHostByName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsaasyncgetprotobyname':('int', None, 'stdcall', 'ws2_32.WSAAsyncGetProtoByName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsaasyncgetprotobynumber':('int', None, 'stdcall', 'ws2_32.WSAAsyncGetProtoByNumber', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsaasyncgetservbyname':('int', None, 'stdcall', 'ws2_32.WSAAsyncGetServByName', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsaasyncgetservbyport':('int', None, 'stdcall', 'ws2_32.WSAAsyncGetServByPort', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsaasyncselect':('int', None, 'stdcall', 'ws2_32.WSAAsyncSelect', ( ('int', None), ('int', None), ('int', None))),
    'wsock32.wsacancelasyncrequest':('int', None, 'stdcall', 'ws2_32.WSACancelAsyncRequest', (('int', None),)),
    'wsock32.wsacancelblockingcall':('int', None, 'stdcall', 'ws2_32.WSACancelBlockingCall', ()),
    'wsock32.wsacleanup':('int', None, 'stdcall', 'ws2_32.WSACleanup', ()),
    'wsock32.wsagetlasterror':('int', None, 'stdcall', 'ws2_32.WSAGetLastError', ()),
    'wsock32.wsaisblocking':('int', None, 'stdcall', 'ws2_32.WSAIsBlocking', ()),
    'wsock32.wsarecvex':('int', None, 'stdcall', 'mswsock.WSARecvEx', (('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.wsasetblockinghook':('int', None, 'stdcall', 'ws2_32.WSASetBlockingHook', ( ('int', None),)),
    'wsock32.wsasetlasterror':('int', None, 'cdecl', 'ws2_32.WSASetLastError', ()),
    'wsock32.wsastartup':('int', None, 'stdcall', 'ws2_32.WSAStartup', (('int', None), ('void *', 'ptr'))),
    'wsock32.wsaunhookblockinghook':('int', None, 'stdcall', 'ws2_32.WSAUnhookBlockingHook', ()),
    'wsock32.wsapsetpostroutine':('int', None, 'stdcall', 'ws2_32.WSApSetPostRoutine', (('int', None),)),
    'wsock32.__wsafdisset':('int', None, 'stdcall', 'ws2_32.__WSAFDIsSet', (('int', None), ('int', None))),
    'wsock32.accept':('int', None, 'stdcall', 'ws2_32.accept', ( ('void *', 'obj'), ('int', None), ('int', None))),
    'wsock32.bind':('int', None, 'stdcall', 'ws2_32.bind', ( ('int', None), ('int', None))),
    'wsock32.closesocket':('int', None, 'stdcall', 'ws2_32.closesocket', ()),
    'wsock32.connect':('int', None, 'stdcall', 'ws2_32.connect', ( ('int', None), ('int', None))),
    'wsock32.dn_expand':('int', None, 'stdcall', 'mswsock.dn_expand', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.gethostbyaddr':('int', None, 'stdcall', 'ws2_32.gethostbyaddr', ( ('int', None), ('int', None), ('int', None))),
    'wsock32.gethostbyname':('int', None, 'stdcall', 'ws2_32.gethostbyname', ( ('void *', 'ptr'),)),
    'wsock32.gethostname':('int', None, 'stdcall', 'ws2_32.gethostname', ( ('void *', 'ptr'), ('int', None))),
    'wsock32.getnetbyname':('int', None, 'stdcall', 'mswsock.getnetbyname', (('int', None),)),
    'wsock32.getpeername':('int', None, 'stdcall', 'ws2_32.getpeername', ( ('int', None), ('int', None))),
    'wsock32.getprotobyname':('int', None, 'stdcall', 'ws2_32.getprotobyname', (('int', None),)),
    'wsock32.getprotobynumber':('int', None, 'stdcall', 'ws2_32.getprotobynumber', ( ('int', None),)),
    'wsock32.getservbyname':('int', None, 'stdcall', 'ws2_32.getservbyname', (('void *', 'ptr'), ('int', None))),
    'wsock32.getservbyport':('int', None, 'stdcall', 'ws2_32.getservbyport', (('int', None), ('int', None))),
    'wsock32.getsockname':('int', None, 'stdcall', 'ws2_32.getsockname', ( ('int', None), ('int', None))),
    'wsock32.htonl':('int', None, 'stdcall', 'ws2_32.htonl', (('int', None),)),
    'wsock32.htons':('int', None, 'stdcall', 'ws2_32.htons', (('int', None),)),
    'wsock32.inet_addr':('int', None, 'stdcall', 'ws2_32.inet_addr', (('int', None),)),
    'wsock32.inet_network':('int', None, 'stdcall', 'mswsock.inet_network', (('int', None),)),
    'wsock32.inet_ntoa':('int', None, 'stdcall', 'ws2_32.inet_ntoa', ( ('int', None),)),
    'wsock32.ioctlsocket':('int', None, 'stdcall', 'ws2_32.ioctlsocket', ( ('int', None), ('int', None))),
    'wsock32.listen':('int', None, 'stdcall', 'ws2_32.listen', ( ('int', None),)),
    'wsock32.ntohl':('int', None, 'stdcall', 'ws2_32.ntohl', (('int', None),)),
    'wsock32.ntohs':('int', None, 'stdcall', 'ws2_32.ntohs', (('int', None),)),
    'wsock32.rcmd':('int', None, 'stdcall', 'mswsock.rcmd', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.rexec':('int', None, 'stdcall', 'mswsock.rexec', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.rresvport':('int', None, 'stdcall', 'mswsock.rresvport', (('void *', 'ptr'),)),
    'wsock32.s_perror':('int', None, 'stdcall', 'mswsock.s_perror', (('void *', 'ptr'), ('int', None))),
    'wsock32.select':('int', None, 'stdcall', 'ws2_32.select', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.send':('int', None, 'stdcall', 'ws2_32.send', ( ('int', None), ('int', None), ('int', None))),
    'wsock32.sendto':('int', None, 'stdcall', 'ws2_32.sendto', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None))),
    'wsock32.sethostname':('int', None, 'stdcall', 'mswsock.sethostname', (('int', None), ('int', None))),
    'wsock32.shutdown':('int', None, 'stdcall', 'ws2_32.shutdown', ( ('int', None),)),
    'wsock32.socket':('int', None, 'stdcall', 'ws2_32.socket', ( ('int', None), ('int', None), ('void *', 'obj'))),

    # WININET
    'wininet.main_entry':( 'int', None, 'stdcall', 'wininet.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'wininet.commiturlcacheentrya':( 'int', None, 'stdcall', 'wininet.CommitUrlCacheEntryA', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.commiturlcacheentryw':( 'int', None, 'stdcall', 'wininet.CommitUrlCacheEntryW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.createmd5ssohash':( 'int', None, 'stdcall', 'wininet.CreateMD5SSOHash', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.createurlcachecontainera':( 'int', None, 'stdcall', 'wininet.CreateUrlCacheContainerA', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.createurlcachecontainerw':( 'int', None, 'stdcall', 'wininet.CreateUrlCacheContainerW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.createurlcacheentrya':( 'int', None, 'stdcall', 'wininet.CreateUrlCacheEntryA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.createurlcacheentryw':( 'int', None, 'stdcall', 'wininet.CreateUrlCacheEntryW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.createurlcachegroup':( 'int', None, 'stdcall', 'wininet.CreateUrlCacheGroup', (('int', None), ('int', None)) ),
    'wininet.deleteie3cache':( 'int', None, 'stdcall', 'wininet.DeleteIE3Cache', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.deleteurlcachecontainera':( 'int', None, 'stdcall', 'wininet.DeleteUrlCacheContainerA', (('void *', 'ptr'), ('int', None)) ),
    'wininet.deleteurlcachecontainerw':( 'int', None, 'stdcall', 'wininet.DeleteUrlCacheContainerW', (('int', None), ('int', None)) ),
    'wininet.deleteurlcacheentry':( 'int', None, 'stdcall', 'wininet.DeleteUrlCacheEntry', (('int', None),) ),
    'wininet.deleteurlcacheentrya':( 'int', None, 'stdcall', 'wininet.DeleteUrlCacheEntryA', (('int', None),) ),
    'wininet.deleteurlcacheentryw':( 'int', None, 'stdcall', 'wininet.DeleteUrlCacheEntryW', (('void *', 'ptr'),) ),
    'wininet.deleteurlcachegroup':( 'int', None, 'stdcall', 'wininet.DeleteUrlCacheGroup', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.deletewpadcachefornetworks':( 'int', None, 'stdcall', 'wininet.DeleteWpadCacheForNetworks', (('int', None),) ),
    'wininet.detectautoproxyurl':( 'int', None, 'stdcall', 'wininet.DetectAutoProxyUrl', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.dispatchapicall':( 'int', None, 'stdcall', 'wininet.DispatchAPICall', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.dllinstall':( 'int', None, 'stdcall', 'wininet.DllInstall', (('int', None), ('int', None)) ),
    'wininet.findcloseurlcache':( 'int', None, 'stdcall', 'wininet.FindCloseUrlCache', (('int', None),) ),
    'wininet.findfirsturlcachecontainera':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheContainerA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.findfirsturlcachecontainerw':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheContainerW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.findfirsturlcacheentrya':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheEntryA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.findfirsturlcacheentryexa':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheEntryExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.findfirsturlcacheentryexw':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheEntryExW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.findfirsturlcacheentryw':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheEntryW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.findfirsturlcachegroup':( 'int', None, 'stdcall', 'wininet.FindFirstUrlCacheGroup', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.findnexturlcachecontainera':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheContainerA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.findnexturlcachecontainerw':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheContainerW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.findnexturlcacheentrya':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheEntryA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.findnexturlcacheentryexa':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheEntryExA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.findnexturlcacheentryexw':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheEntryExW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.findnexturlcacheentryw':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheEntryW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.findnexturlcachegroup':( 'int', None, 'stdcall', 'wininet.FindNextUrlCacheGroup', (('int', None), ('int', None), ('int', None)) ),
    'wininet.forcenexuslookup':( 'int', None, 'cdecl', 'wininet.ForceNexusLookup', () ),
    'wininet.forcenexuslookupexw':( 'int', None, 'stdcall', 'wininet.ForceNexusLookupExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.freeurlcachespacea':( 'int', None, 'stdcall', 'wininet.FreeUrlCacheSpaceA', (('int', None), ('int', None), ('int', None)) ),
    'wininet.freeurlcachespacew':( 'int', None, 'stdcall', 'wininet.FreeUrlCacheSpaceW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpcommanda':( 'int', None, 'stdcall', 'wininet.FtpCommandA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.ftpcommandw':( 'int', None, 'stdcall', 'wininet.FtpCommandW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpcreatedirectorya':( 'int', None, 'stdcall', 'wininet.FtpCreateDirectoryA', (('int', None), ('void *', 'ptr')) ),
    'wininet.ftpcreatedirectoryw':( 'int', None, 'stdcall', 'wininet.FtpCreateDirectoryW', (('int', None), ('int', None)) ),
    'wininet.ftpdeletefilea':( 'int', None, 'stdcall', 'wininet.FtpDeleteFileA', (('int', None), ('void *', 'ptr')) ),
    'wininet.ftpdeletefilew':( 'int', None, 'stdcall', 'wininet.FtpDeleteFileW', (('int', None), ('int', None)) ),
    'wininet.ftpfindfirstfilea':( 'int', None, 'stdcall', 'wininet.FtpFindFirstFileA', (('int', None), ('void *', 'ptr'), ('StringA', None), ('int', None), ('int', None)) ),
    'wininet.ftpfindfirstfilew':( 'int', None, 'stdcall', 'wininet.FtpFindFirstFileW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpgetcurrentdirectorya':( 'int', None, 'stdcall', 'wininet.FtpGetCurrentDirectoryA', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'wininet.ftpgetcurrentdirectoryw':( 'int', None, 'stdcall', 'wininet.FtpGetCurrentDirectoryW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpgetfilea':( 'int', None, 'stdcall', 'wininet.FtpGetFileA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('DWORD', None), ('int', None)) ),
    'wininet.ftpgetfileex':( 'int', None, 'stdcall', 'wininet.FtpGetFileEx', ( ('int', None), ('StringW', None), ('int', None), ('int', None), ('DWORD', None), ('int', None)) ),
    'wininet.ftpgetfilesize':( 'int', None, 'stdcall', 'wininet.FtpGetFileSize', (('int', None), ('int', None)) ),
    'wininet.ftpgetfilew':( 'int', None, 'stdcall', 'wininet.FtpGetFileW', ( ('int', None), ('StringW', None), ('int', None), ('int', None), ('DWORD', None), ('int', None)) ),
    'wininet.ftpopenfilea':( 'int', None, 'stdcall', 'wininet.FtpOpenFileA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpopenfilew':( 'int', None, 'stdcall', 'wininet.FtpOpenFileW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpputfilea':( 'int', None, 'stdcall', 'wininet.FtpPutFileA', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpputfileex':( 'int', None, 'stdcall', 'wininet.FtpPutFileEx', ( ('StringW', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpputfilew':( 'int', None, 'stdcall', 'wininet.FtpPutFileW', ( ('StringW', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpremovedirectorya':( 'int', None, 'stdcall', 'wininet.FtpRemoveDirectoryA', (('int', None), ('void *', 'ptr')) ),
    'wininet.ftpremovedirectoryw':( 'int', None, 'stdcall', 'wininet.FtpRemoveDirectoryW', (('int', None), ('int', None)) ),
    'wininet.ftprenamefilea':( 'int', None, 'stdcall', 'wininet.FtpRenameFileA', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'wininet.ftprenamefilew':( 'int', None, 'stdcall', 'wininet.FtpRenameFileW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.ftpsetcurrentdirectorya':( 'int', None, 'stdcall', 'wininet.FtpSetCurrentDirectoryA', (('int', None), ('void *', 'ptr')) ),
    'wininet.ftpsetcurrentdirectoryw':( 'int', None, 'stdcall', 'wininet.FtpSetCurrentDirectoryW', (('int', None), ('int', None)) ),
    'wininet.geturlcacheconfiginfoa':( 'int', None, 'stdcall', 'wininet.GetUrlCacheConfigInfoA', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.geturlcacheconfiginfow':( 'int', None, 'stdcall', 'wininet.GetUrlCacheConfigInfoW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.geturlcacheentryinfoa':( 'int', None, 'stdcall', 'wininet.GetUrlCacheEntryInfoA', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'wininet.geturlcacheentryinfoexa':( 'int', None, 'stdcall', 'wininet.GetUrlCacheEntryInfoExA', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.geturlcacheentryinfoexw':( 'int', None, 'stdcall', 'wininet.GetUrlCacheEntryInfoExW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.geturlcacheentryinfow':( 'int', None, 'stdcall', 'wininet.GetUrlCacheEntryInfoW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.geturlcachegroupattributea':( 'int', None, 'stdcall', 'wininet.GetUrlCacheGroupAttributeA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.geturlcachegroupattributew':( 'int', None, 'stdcall', 'wininet.GetUrlCacheGroupAttributeW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.geturlcacheheaderdata':( 'int', None, 'stdcall', 'wininet.GetUrlCacheHeaderData', (('int', None), ('void *', 'ptr')) ),
    'wininet.gophercreatelocatora':( 'int', None, 'stdcall', 'wininet.GopherCreateLocatorA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gophercreatelocatorw':( 'int', None, 'stdcall', 'wininet.GopherCreateLocatorW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gopherfindfirstfilea':( 'int', None, 'stdcall', 'wininet.GopherFindFirstFileA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gopherfindfirstfilew':( 'int', None, 'stdcall', 'wininet.GopherFindFirstFileW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gophergetattributea':( 'int', None, 'stdcall', 'wininet.GopherGetAttributeA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gophergetattributew':( 'int', None, 'stdcall', 'wininet.GopherGetAttributeW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gophergetlocatortypea':( 'int', None, 'stdcall', 'wininet.GopherGetLocatorTypeA', (('int', None), ('int', None)) ),
    'wininet.gophergetlocatortypew':( 'int', None, 'stdcall', 'wininet.GopherGetLocatorTypeW', (('int', None), ('int', None)) ),
    'wininet.gopheropenfilea':( 'int', None, 'stdcall', 'wininet.GopherOpenFileA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.gopheropenfilew':( 'int', None, 'stdcall', 'wininet.GopherOpenFileW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpaddrequestheadersa':( 'int', None, 'stdcall', 'wininet.HttpAddRequestHeadersA', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'wininet.httpaddrequestheadersw':( 'int', None, 'stdcall', 'wininet.HttpAddRequestHeadersW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpcheckdavcompliance':( 'int', None, 'stdcall', 'wininet.HttpCheckDavCompliance', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpendrequesta':( 'int', None, 'stdcall', 'wininet.HttpEndRequestA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpendrequestw':( 'int', None, 'stdcall', 'wininet.HttpEndRequestW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpopenrequesta':( 'int', None, 'stdcall', 'wininet.HttpOpenRequestA', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpopenrequestw':( 'int', None, 'stdcall', 'wininet.HttpOpenRequestW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpqueryinfoa':( 'int', None, 'stdcall', 'wininet.HttpQueryInfoA', (('int', None), ('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'wininet.httpqueryinfow':( 'int', None, 'stdcall', 'wininet.HttpQueryInfoW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'ptr')) ),
    'wininet.httpsendrequesta':( 'int', None, 'stdcall', 'wininet.HttpSendRequestA', (('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpsendrequestexa':( 'int', None, 'stdcall', 'wininet.HttpSendRequestExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpsendrequestexw':( 'int', None, 'stdcall', 'wininet.HttpSendRequestExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.httpsendrequestw':( 'int', None, 'stdcall', 'wininet.HttpSendRequestW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.incrementurlcacheheaderdata':( 'int', None, 'stdcall', 'wininet.IncrementUrlCacheHeaderData', (('int', None), ('int', None)) ),
    'wininet.internetalgidtostringa':( 'int', None, 'stdcall', 'wininet.InternetAlgIdToStringA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetalgidtostringw':( 'int', None, 'stdcall', 'wininet.InternetAlgIdToStringW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetattemptconnect':( 'int', None, 'stdcall', 'wininet.InternetAttemptConnect', (('int', None),) ),
    'wininet.internetautodial':( 'int', None, 'stdcall', 'wininet.InternetAutodial', (('int', None), ('int', None)) ),
    'wininet.internetautodialcallback':( 'int', None, 'stdcall', 'wininet.InternetAutodialCallback', (('int', None), ('void *', 'ptr')) ),
    'wininet.internetautodialhangup':( 'int', None, 'stdcall', 'wininet.InternetAutodialHangup', (('int', None),) ),
    'wininet.internetcanonicalizeurla':( 'int', None, 'stdcall', 'wininet.InternetCanonicalizeUrlA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetcanonicalizeurlw':( 'int', None, 'stdcall', 'wininet.InternetCanonicalizeUrlW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetcheckconnectiona':( 'int', None, 'stdcall', 'wininet.InternetCheckConnectionA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetcheckconnectionw':( 'int', None, 'msfastcall', 'wininet.InternetCheckConnectionW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetclearallpersitecookiedecisions':( 'int', None, 'cdecl', 'wininet.InternetClearAllPerSiteCookieDecisions', () ),
    'wininet.internetclosehandle':( 'int', None, 'stdcall', 'wininet.InternetCloseHandle', (('int', None),) ),
    'wininet.internetcombineurla':( 'int', None, 'stdcall', 'wininet.InternetCombineUrlA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetcombineurlw':( 'int', None, 'stdcall', 'wininet.InternetCombineUrlW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetconfirmzonecrossing':( 'int', None, 'stdcall', 'wininet.InternetConfirmZoneCrossing', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'wininet.internetconfirmzonecrossinga':( 'int', None, 'stdcall', 'wininet.InternetConfirmZoneCrossingA', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'wininet.internetconfirmzonecrossingw':( 'int', None, 'stdcall', 'wininet.InternetConfirmZoneCrossingW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetconnecta':( 'int', None, 'stdcall', 'wininet.InternetConnectA', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetconnectw':( 'int', None, 'stdcall', 'wininet.InternetConnectW', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetcrackurla':( 'int', None, 'stdcall', 'wininet.InternetCrackUrlA', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetcrackurlw':( 'int', None, 'stdcall', 'wininet.InternetCrackUrlW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetcreateurla':( 'int', None, 'stdcall', 'wininet.InternetCreateUrlA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'wininet.internetcreateurlw':( 'int', None, 'stdcall', 'wininet.InternetCreateUrlW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetdial':( 'int', None, 'stdcall', 'wininet.InternetDial', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetdiala':( 'int', None, 'stdcall', 'wininet.InternetDialA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetdialw':( 'int', None, 'stdcall', 'wininet.InternetDialW', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetenumpersitecookiedecisiona':( 'int', None, 'stdcall', 'wininet.InternetEnumPerSiteCookieDecisionA', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetenumpersitecookiedecisionw':( 'int', None, 'stdcall', 'wininet.InternetEnumPerSiteCookieDecisionW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.interneterrordlg':( 'int', None, 'stdcall', 'wininet.InternetErrorDlg', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetfindnextfilea':( 'int', None, 'stdcall', 'wininet.InternetFindNextFileA', (('int', None), ('StringA', None)) ),
    'wininet.internetfindnextfilew':( 'int', None, 'stdcall', 'wininet.InternetFindNextFileW', (('int', None), ('int', None)) ),
    'wininet.internetfortezzacommand':( 'int', None, 'stdcall', 'wininet.InternetFortezzaCommand', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetgetcertbyurl':( 'int', None, 'stdcall', 'wininet.InternetGetCertByURL', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetgetcertbyurla':( 'int', None, 'stdcall', 'wininet.InternetGetCertByURLA', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetgetconnectedstate':( 'int', None, 'stdcall', 'wininet.InternetGetConnectedState', (('void *', 'ptr'), ('int', None)) ),
    'wininet.internetgetconnectedstateex':( 'int', None, 'stdcall', 'wininet.InternetGetConnectedStateEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetgetconnectedstateexa':( 'int', None, 'stdcall', 'wininet.InternetGetConnectedStateExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetgetconnectedstateexw':( 'int', None, 'stdcall', 'wininet.InternetGetConnectedStateExW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgetcookiea':( 'int', None, 'msfastcall', 'wininet.InternetGetCookieA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetgetcookieexa':( 'int', None, 'msfastcall', 'wininet.InternetGetCookieExA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgetcookieexw':( 'int', None, 'msfastcall', 'wininet.InternetGetCookieExW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgetcookiew':( 'int', None, 'msfastcall', 'wininet.InternetGetCookieW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetgetlastresponseinfoa':( 'int', None, 'stdcall', 'wininet.InternetGetLastResponseInfoA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetgetlastresponseinfow':( 'int', None, 'stdcall', 'wininet.InternetGetLastResponseInfoW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetgetpersitecookiedecisiona':( 'int', None, 'stdcall', 'wininet.InternetGetPerSiteCookieDecisionA', (('void *', 'ptr'), ('int', None)) ),
    'wininet.internetgetpersitecookiedecisionw':( 'int', None, 'msfastcall', 'wininet.InternetGetPerSiteCookieDecisionW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetgetsecurityinfobyurl':( 'int', None, 'stdcall', 'wininet.InternetGetSecurityInfoByURL', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgetsecurityinfobyurla':( 'int', None, 'stdcall', 'wininet.InternetGetSecurityInfoByURLA', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgetsecurityinfobyurlw':( 'int', None, 'stdcall', 'wininet.InternetGetSecurityInfoByURLW', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgoonline':( 'int', None, 'msfastcall', 'wininet.InternetGoOnline', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgoonlinea':( 'int', None, 'msfastcall', 'wininet.InternetGoOnlineA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetgoonlinew':( 'int', None, 'msfastcall', 'wininet.InternetGoOnlineW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internethangup':( 'int', None, 'stdcall', 'wininet.InternetHangUp', (('int', None), ('int', None)) ),
    'wininet.internetinitializeautoproxydll':( 'int', None, 'stdcall', 'wininet.InternetInitializeAutoProxyDll', ( ('int', None),) ),
    'wininet.internetlockrequestfile':( 'int', None, 'stdcall', 'wininet.InternetLockRequestFile', ( ('void *', 'obj'), ('void *', 'ptr')) ),
    'wininet.internetopena':( 'int', None, 'stdcall', 'wininet.InternetOpenA', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetopenurla':( 'int', None, 'stdcall', 'wininet.InternetOpenUrlA', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetopenurlw':( 'int', None, 'stdcall', 'wininet.InternetOpenUrlW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetopenw':( 'int', None, 'stdcall', 'wininet.InternetOpenW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetquerydataavailable':( 'int', None, 'stdcall', 'wininet.InternetQueryDataAvailable', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetqueryfortezzastatus':( 'int', None, 'stdcall', 'wininet.InternetQueryFortezzaStatus', (('int', None), ('int', None)) ),
    'wininet.internetqueryoptiona':( 'int', None, 'stdcall', 'wininet.InternetQueryOptionA', ( ('void *', 'obj'), ('int', None), ('void *', 'obj'), ('void *', 'ptr')) ),
    'wininet.internetqueryoptionw':( 'int', None, 'msfastcall', 'wininet.InternetQueryOptionW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj'), ('void *', 'ptr')) ),
    'wininet.internetreadfile':( 'int', None, 'stdcall', 'wininet.InternetReadFile', (('int', None), ('StringA', None), ('DWORD', None), ('void *', 'ptr')) ),
    'wininet.internetreadfileexa':( 'int', None, 'stdcall', 'wininet.InternetReadFileExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetreadfileexw':( 'int', None, 'stdcall', 'wininet.InternetReadFileExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsecurityprotocoltostringa':( 'int', None, 'stdcall', 'wininet.InternetSecurityProtocolToStringA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetsecurityprotocoltostringw':( 'int', None, 'stdcall', 'wininet.InternetSecurityProtocolToStringW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetsetcookiea':( 'int', None, 'stdcall', 'wininet.InternetSetCookieA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'wininet.internetsetcookieexa':( 'int', None, 'stdcall', 'wininet.InternetSetCookieExA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetsetcookieexw':( 'int', None, 'stdcall', 'wininet.InternetSetCookieExW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsetcookiew':( 'int', None, 'stdcall', 'wininet.InternetSetCookieW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetsetdialstate':( 'int', None, 'stdcall', 'wininet.InternetSetDialState', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsetdialstatea':( 'int', None, 'stdcall', 'wininet.InternetSetDialStateA', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsetdialstatew':( 'int', None, 'stdcall', 'wininet.InternetSetDialStateW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsetfilepointer':( 'int', None, 'stdcall', 'wininet.InternetSetFilePointer', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsetoptiona':( 'int', None, 'stdcall', 'wininet.InternetSetOptionA', ( ('void *', 'obj'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetsetoptionexa':( 'int', None, 'stdcall', 'wininet.InternetSetOptionExA', ( ('void *', 'obj'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetsetoptionexw':( 'int', None, 'msfastcall', 'wininet.InternetSetOptionExW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.internetsetoptionw':( 'int', None, 'msfastcall', 'wininet.InternetSetOptionW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internetsetpersitecookiedecisiona':( 'int', None, 'stdcall', 'wininet.InternetSetPerSiteCookieDecisionA', (('int', None), ('int', None)) ),
    'wininet.internetsetpersitecookiedecisionw':( 'int', None, 'msfastcall', 'wininet.InternetSetPerSiteCookieDecisionW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetsetstatuscallback':( 'int', None, 'stdcall', 'wininet.InternetSetStatusCallback', ( ('int', None), ('int', None)) ),
    'wininet.internetsetstatuscallbacka':( 'int', None, 'stdcall', 'wininet.InternetSetStatusCallbackA', ( ('int', None), ('int', None)) ),
    'wininet.internetsetstatuscallbackw':( 'int', None, 'stdcall', 'wininet.InternetSetStatusCallbackW', ( ('int', None), ('int', None)) ),
    'wininet.internetshowsecurityinfobyurl':( 'int', None, 'stdcall', 'wininet.InternetShowSecurityInfoByURL', (('void *', 'ptr'), ('int', None)) ),
    'wininet.internetshowsecurityinfobyurla':( 'int', None, 'stdcall', 'wininet.InternetShowSecurityInfoByURLA', (('void *', 'ptr'), ('int', None)) ),
    'wininet.internetshowsecurityinfobyurlw':( 'int', None, 'stdcall', 'wininet.InternetShowSecurityInfoByURLW', (('void *', 'ptr'), ('int', None)) ),
    'wininet.internettimefromsystemtime':( 'int', None, 'stdcall', 'wininet.InternetTimeFromSystemTime', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internettimefromsystemtimea':( 'int', None, 'stdcall', 'wininet.InternetTimeFromSystemTimeA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internettimefromsystemtimew':( 'int', None, 'stdcall', 'wininet.InternetTimeFromSystemTimeW', (('void *', 'ptr'), ('int', None), ('int', None), ('DWORD', None)) ),
    'wininet.internettimetosystemtime':( 'int', None, 'stdcall', 'wininet.InternetTimeToSystemTime', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internettimetosystemtimea':( 'int', None, 'stdcall', 'wininet.InternetTimeToSystemTimeA', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.internettimetosystemtimew':( 'int', None, 'stdcall', 'wininet.InternetTimeToSystemTimeW', (('int', None), ('int', None), ('int', None)) ),
    'wininet.internetunlockrequestfile':( 'int', None, 'stdcall', 'wininet.InternetUnlockRequestFile', ( ('void *', 'ptr'),) ),
    'wininet.internetwritefile':( 'int', None, 'stdcall', 'wininet.InternetWriteFile', ( ('int', None), ('void *', 'ptr'), ('DWORD', None), ('DWORD_P', None)) ),
    'wininet.internetwritefileexa':( 'int', None, 'stdcall', 'wininet.InternetWriteFileExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.internetwritefileexw':( 'int', None, 'stdcall', 'wininet.InternetWriteFileExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.ishostinproxybypasslist':( 'int', None, 'stdcall', 'wininet.IsHostInProxyBypassList', ( ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.isurlcacheentryexpireda':( 'int', None, 'stdcall', 'wininet.IsUrlCacheEntryExpiredA', (('int', None), ('int', None), ('int', None)) ),
    'wininet.isurlcacheentryexpiredw':( 'int', None, 'stdcall', 'wininet.IsUrlCacheEntryExpiredW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.loadurlcachecontent':( 'int', None, 'cdecl', 'wininet.LoadUrlCacheContent', () ),
    'wininet.parsex509encodedcertificateforlistboxentry':( 'int', None, 'stdcall', 'wininet.ParseX509EncodedCertificateForListBoxEntry', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.privacygetzonepreferencew':( 'int', None, 'stdcall', 'wininet.PrivacyGetZonePreferenceW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.privacysetzonepreferencew':( 'int', None, 'stdcall', 'wininet.PrivacySetZonePreferenceW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'wininet.readurlcacheentrystream':( 'int', None, 'stdcall', 'wininet.ReadUrlCacheEntryStream', (('int', None), ('int', None), ('StringA', None), ('DWORD_P', None), ('int', None)) ),
    'wininet.readurlcacheentrystreamex':( 'int', None, 'stdcall', 'wininet.ReadUrlCacheEntryStreamEx', (('int', None), ('int', None), ('int', None), ('StringA', None), ('DWORD_P', None)) ),
    'wininet.registerurlcachenotification':( 'int', None, 'stdcall', 'wininet.RegisterUrlCacheNotification', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.resumesuspendeddownload':( 'int', None, 'stdcall', 'wininet.ResumeSuspendedDownload', (('int', None), ('int', None)) ),
    'wininet.retrieveurlcacheentryfilea':( 'int', None, 'stdcall', 'wininet.RetrieveUrlCacheEntryFileA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.retrieveurlcacheentryfilew':( 'int', None, 'stdcall', 'wininet.RetrieveUrlCacheEntryFileW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.retrieveurlcacheentrystreama':( 'int', None, 'stdcall', 'wininet.RetrieveUrlCacheEntryStreamA', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.retrieveurlcacheentrystreamw':( 'int', None, 'stdcall', 'wininet.RetrieveUrlCacheEntryStreamW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'wininet.runonceurlcache':( 'int', None, 'stdcall', 'wininet.RunOnceUrlCache', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.seturlcacheconfiginfoa':( 'int', None, 'stdcall', 'wininet.SetUrlCacheConfigInfoA', (('void *', 'ptr'), ('int', None)) ),
    'wininet.seturlcacheconfiginfow':( 'int', None, 'stdcall', 'wininet.SetUrlCacheConfigInfoW', (('int', None), ('int', None)) ),
    'wininet.seturlcacheentrygroup':( 'int', None, 'stdcall', 'wininet.SetUrlCacheEntryGroup', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.seturlcacheentrygroupa':( 'int', None, 'stdcall', 'wininet.SetUrlCacheEntryGroupA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.seturlcacheentrygroupw':( 'int', None, 'stdcall', 'wininet.SetUrlCacheEntryGroupW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.seturlcacheentryinfoa':( 'int', None, 'stdcall', 'wininet.SetUrlCacheEntryInfoA', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'wininet.seturlcacheentryinfow':( 'int', None, 'stdcall', 'wininet.SetUrlCacheEntryInfoW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'wininet.seturlcachegroupattributea':( 'int', None, 'stdcall', 'wininet.SetUrlCacheGroupAttributeA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'wininet.seturlcachegroupattributew':( 'int', None, 'stdcall', 'wininet.SetUrlCacheGroupAttributeW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'wininet.seturlcacheheaderdata':( 'int', None, 'stdcall', 'wininet.SetUrlCacheHeaderData', (('int', None), ('int', None)) ),
    'wininet.showcertificate':( 'int', None, 'stdcall', 'wininet.ShowCertificate', (('int', None), ('int', None)) ),
    'wininet.showclientauthcerts':( 'int', None, 'stdcall', 'wininet.ShowClientAuthCerts', (('int', None),) ),
    'wininet.showsecurityinfo':( 'int', None, 'stdcall', 'wininet.ShowSecurityInfo', (('int', None), ('void *', 'ptr')) ),
    'wininet.showx509encodedcertificate':( 'int', None, 'stdcall', 'wininet.ShowX509EncodedCertificate', (('int', None), ('int', None), ('int', None)) ),
    'wininet.unlockurlcacheentryfile':( 'int', None, 'stdcall', 'wininet.UnlockUrlCacheEntryFile', (('int', None), ('int', None)) ),
    'wininet.unlockurlcacheentryfilea':( 'int', None, 'stdcall', 'wininet.UnlockUrlCacheEntryFileA', (('int', None), ('int', None)) ),
    'wininet.unlockurlcacheentryfilew':( 'int', None, 'stdcall', 'wininet.UnlockUrlCacheEntryFileW', (('void *', 'ptr'), ('int', None)) ),
    'wininet.unlockurlcacheentrystream':( 'int', None, 'stdcall', 'wininet.UnlockUrlCacheEntryStream', (('int', None), ('int', None)) ),
    'wininet.updateurlcachecontentpath':( 'int', None, 'stdcall', 'wininet.UpdateUrlCacheContentPath', (('StringA', None),) ),
    'wininet.urlzonesdetach':( 'int', None, 'cdecl', 'wininet.UrlZonesDetach', () ),
    'wininet._getfileextensionfromurl':( 'int', None, 'stdcall', 'wininet._GetFileExtensionFromUrl', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    }
