/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.truetype;

import java.nio.charset.Charset;
import java.util.ArrayList;

public class TTCodePage {
    public static TTCodePage US_ASCII = new TTCodePage("US-ASCII", "US-ASCII", 64);
    public static TTCodePage Latin_1 = new TTCodePage("windows-1252", "Latin 1 windows-1252", 0);
    private static boolean s_isInitialized = false;
    private static ArrayList<TTCodePage> s_list = new ArrayList();
    private String m_name;
    private int m_osTwoFlag = 0;
    private Charset m_charset = null;

    public static String[] getNames() {
        TTCodePage.initList();
        String[] retval = new String[s_list.size()];
        for (int i = 0; i < s_list.size(); ++i) {
            TTCodePage codePage = s_list.get(i);
            retval[i] = codePage.getName();
        }
        return retval;
    }

    public static TTCodePage forName(String a_name) {
        TTCodePage.initList();
        TTCodePage retval = null;
        for (TTCodePage codePage : s_list) {
            if (!codePage.getName().equals(a_name)) continue;
            return codePage;
        }
        for (TTCodePage codePage : s_list) {
            if (codePage.getCharset() == null || !codePage.getCharset().name().equals(a_name)) continue;
            return codePage;
        }
        return retval;
    }

    private static void initList() {
        if (s_isInitialized) {
            return;
        }
        s_isInitialized = true;
        s_list.add(US_ASCII);
        s_list.add(Latin_1);
        s_list.add(new TTCodePage("ISO-2022-JP", "Japan-JIS", 17));
        s_list.add(new TTCodePage("windows-1250", "Latin 2: Eastern Europe windows-1250", 1));
        s_list.add(new TTCodePage("windows-1251", "Cyrillic windows-1251", 2));
        s_list.add(new TTCodePage("windows-1253", "Greek windows-1253", 3));
        s_list.add(new TTCodePage("windows-1254", "Turkish windows-1254", 4));
        s_list.add(new TTCodePage("windows-1258", "Vietnamese windows-1258", 8));
        s_list.add(new TTCodePage("windows-1255", "Hebrew windows-1255", 5));
        s_list.add(new TTCodePage("windows-1256", "Arabic windows-1256", 6));
        s_list.add(new TTCodePage("windows-1257", "Windows Baltic", 7));
        s_list.add(new TTCodePage("Thai windows-874", 16));
        s_list.add(new TTCodePage("x-mswin-936", "Chinese: Simplified", 18));
        s_list.add(new TTCodePage("Korean Wansung", 19));
        s_list.add(new TTCodePage("x-windows-950", "Chinese: Traditional", 20));
    }

    public TTCodePage(String a_charsetName, String a_name, int a_osTwoFlag) {
        if (Charset.isSupported(a_charsetName)) {
            this.m_charset = Charset.forName(a_charsetName);
        }
        this.m_name = a_name;
        this.m_osTwoFlag = a_osTwoFlag;
    }

    public TTCodePage(String a_name, int a_osTwoFlag) {
        this.m_name = a_name;
        this.m_osTwoFlag = a_osTwoFlag;
    }

    public String toString() {
        return this.m_name;
    }

    public String getName() {
        return this.m_name;
    }

    public Charset getCharset() {
        return this.m_charset;
    }

    public int getOsTwoFlag() {
        return this.m_osTwoFlag;
    }
}

