/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.truetype;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class FontFormatWriter {
    protected DataOutputStream m_buffer;
    protected ByteArrayOutputStream m_bytes;
    private int m_offset;

    public FontFormatWriter() {
        this.init();
    }

    protected void init() {
        this.m_bytes = new ByteArrayOutputStream();
        this.m_buffer = new DataOutputStream(this.m_bytes);
        this.m_offset = 0;
    }

    public void write() throws IOException {
    }

    public byte[] toByteArray() {
        return this.m_bytes.toByteArray();
    }

    public int size() {
        return this.m_bytes.size();
    }

    public void reset() {
        this.m_bytes.reset();
    }

    protected void writeFixed32(double a_value) throws IOException {
        int k_denom = 16384;
        short mantissa = (short)Math.floor(a_value);
        int fraction = (int)((a_value - (double)mantissa) * 16384.0);
        if (fraction > 16384) {
            fraction = 0;
            mantissa = (short)(mantissa + 1);
        }
        this.m_buffer.writeShort(mantissa);
        this.m_buffer.writeShort(fraction);
    }

    protected void writeUInt16(int a_value) throws IOException {
        this.writeInt16((short)(0xFFFF & a_value));
    }

    protected void writeInt16(int a_value) throws IOException {
        this.m_buffer.writeShort((short)a_value);
    }

    protected void writeFWord(int a_value) throws IOException {
        this.writeInt16(a_value);
    }

    protected void writeUFWord(int a_value) throws IOException {
        this.writeUInt16(a_value);
    }

    protected void writeUInt32(long a_value) throws IOException {
        this.writeInt32((int)(0xFFFFFFFFFFFFFFFFL & a_value));
    }

    protected void writeInt32(int a_value) throws IOException {
        this.m_buffer.writeInt(a_value);
    }

    protected void writeUInt8(int a_byte) throws IOException {
        this.m_buffer.writeByte(a_byte);
    }

    protected void writeTag(String a_value) throws IOException {
        String s = a_value + "    ";
        for (int i = 0; i < 4; ++i) {
            this.writeUInt8(s.charAt(i));
        }
    }

    protected void writeLongDateTime(Date a_date) throws IOException {
        long sec = a_date.getTime() / 1000L;
        this.m_buffer.writeLong(sec += 2081376000L);
    }

    protected String getTag() {
        throw new RuntimeException("unimplemnted call to getTag");
    }

    protected long getCheckSum() {
        long retval = 0L;
        byte[] bytes = this.toByteArray();
        for (int i = 0; i < bytes.length / 4; ++i) {
            long n = 0L;
            for (int j = 0; j < 4; ++j) {
                n += (long)(bytes[4 * i + j] << (4 - j) * 8);
            }
            retval += n;
        }
        return retval;
    }

    protected void pad() throws IOException {
        int align = 4;
        int numOfPad = align - this.m_bytes.size() % align;
        if (numOfPad == align) {
            return;
        }
        for (int i = 0; i < numOfPad; ++i) {
            this.writeUInt8(0);
        }
    }

    public int getOffset() {
        return this.m_offset;
    }

    public void setOffset(int a_value) {
        this.m_offset = a_value;
    }
}

