/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.truetype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.doubletype.ossa.truetype.FontFormatWriter;
import org.doubletype.ossa.truetype.OS2Writer;
import org.doubletype.ossa.truetype.TTUnicodeRange;

public class CmapWriter
extends FontFormatWriter {
    final long k_basicLatinStart = 32L;
    final long k_basicLatinEnd = 126L;
    final long k_tableEnd = 65535L;
    final int k_unmappedChar = 0;
    private OS2Writer m_os2;
    private List<Long> m_unicodes = new ArrayList<Long>();
    private List<Long> m_startCodes = new ArrayList<Long>();
    private List<Long> m_endCodes = new ArrayList<Long>();
    private Map<Long, Long> m_unicode2glyph = new HashMap<Long, Long>();
    private List<TTUnicodeRange> m_unicodeRanges = new ArrayList<TTUnicodeRange>();
    private List<Long> m_idDeltas = new ArrayList<Long>();
    private List<Long> m_idRangeOffsets = new ArrayList<Long>();
    private boolean m_isIncludeVersion0;
    private byte[] m_version0;
    private byte[] m_version4;
    private byte[] m_version12;

    public CmapWriter(OS2Writer a_os2) {
        this.m_os2 = a_os2;
        this.m_isIncludeVersion0 = false;
    }

    private void prepare() {
        Collections.sort(this.m_unicodeRanges);
        TTUnicodeRange range = this.m_unicodeRanges.get(0);
        this.m_os2.m_usFirstCharIndex = (int)range.getStartCode();
        this.m_os2.m_usLastCharIndex = (int)range.getEndCode();
        for (int i = 0; i < this.m_unicodeRanges.size(); ++i) {
            range = this.m_unicodeRanges.get(i);
            this.m_startCodes.add(range.getStartCode());
            this.m_endCodes.add(range.getEndCode());
            this.m_idDeltas.add(0L);
            this.m_idRangeOffsets.add(2L * (long)(this.m_unicodeRanges.size() - i) + 2L + 2L * (long)this.m_unicodes.size());
            this.m_os2.m_usLastCharIndex = (int)range.getEndCode();
            this.m_os2.setUnicodeRangeFlag(range.getOsTwoFlag());
            for (long unicode = range.getStartCode(); unicode <= range.getEndCode(); ++unicode) {
                this.m_unicodes.add(unicode);
            }
        }
        this.m_startCodes.add(65535L);
        this.m_endCodes.add(65535L);
        this.m_idDeltas.add(1L);
        this.m_idRangeOffsets.add(0L);
    }

    @Override
    public void write() throws IOException {
        this.prepare();
        if (this.m_isIncludeVersion0) {
            this.storeVersion0();
        }
        this.storeVersion4();
        this.reset();
        this.writeUInt16(0);
        this.writeUInt16(this.getNumOfEncoding());
        if (this.m_isIncludeVersion0) {
            this.writeUInt16(1);
            this.writeUInt16(0);
            this.writeUInt32(this.size() + 4 + 8);
        }
        this.writeUInt16(3);
        this.writeUInt16(1);
        int version4Offset = this.size() + 4;
        if (this.m_isIncludeVersion0) {
            version4Offset += this.m_version0.length;
        }
        this.writeUInt32(version4Offset);
        if (this.m_isIncludeVersion0) {
            this.m_buffer.write(this.m_version0);
        }
        this.m_buffer.write(this.m_version4);
        this.pad();
    }

    private int getNumOfEncoding() {
        if (this.m_isIncludeVersion0) {
            return 2;
        }
        return 1;
    }

    public void addUnicodeRange(TTUnicodeRange a_range) {
        this.m_unicodeRanges.add(a_range);
    }

    public void addMapping(long a_unicode, long a_glyfIndex) {
        this.m_unicode2glyph.put(a_unicode, a_glyfIndex);
    }

    public long getGlyfIndex(Long a_key) {
        long retval = 0L;
        if (this.m_unicode2glyph.containsKey(a_key)) {
            retval = this.m_unicode2glyph.get(a_key);
        }
        return retval;
    }

    private void storeVersion0() throws IOException {
        this.reset();
        this.writeVersion0();
        this.m_version0 = this.toByteArray();
        this.reset();
    }

    private void storeVersion4() throws IOException {
        this.reset();
        this.writeVersion4();
        this.m_version4 = this.toByteArray();
        this.reset();
    }

    private void storeVersion12() throws IOException {
        this.reset();
        this.writeVersion12();
        this.m_version12 = this.toByteArray();
        this.reset();
    }

    @Override
    protected String getTag() {
        return "cmap";
    }

    private void writeVersion0() throws IOException {
        this.writeUInt16(0);
        this.writeUInt16(262);
        this.writeUInt16(0);
        for (int i = 0; i < 256; ++i) {
            if (i == 0 || i == 8 || i == 29) {
                this.writeUInt8((int)this.getGlyfIndex(0L));
                continue;
            }
            if (i == 9 || i == 13) {
                this.writeUInt8((int)this.getGlyfIndex(13L));
                continue;
            }
            this.writeUInt8((int)this.getGlyfIndex(Long.valueOf(i)));
        }
    }

    private void writeVersion4() throws IOException {
        Long n;
        int i;
        int segCount = this.m_startCodes.size();
        for (i = 0; i < segCount; ++i) {
            n = this.m_endCodes.get(i);
            this.writeUInt16(n.intValue());
        }
        this.writeUInt16(0);
        for (i = 0; i < segCount; ++i) {
            n = this.m_startCodes.get(i);
            this.writeUInt16(n.intValue());
        }
        for (i = 0; i < segCount; ++i) {
            n = this.m_idDeltas.get(i);
            this.writeInt16(n.intValue());
        }
        for (i = 0; i < segCount; ++i) {
            n = this.m_idRangeOffsets.get(i);
            this.writeInt16(n.intValue());
        }
        for (i = 0; i < this.m_unicodes.size(); ++i) {
            Long unicode = this.m_unicodes.get(i);
            this.writeUInt16((int)this.getGlyfIndex(unicode));
        }
        byte[] bytes = this.m_bytes.toByteArray();
        this.reset();
        this.writeUInt16(4);
        this.writeUInt16(bytes.length + 14);
        this.writeUInt16(0);
        this.writeUInt16(segCount * 2);
        int searchRange = this.getSearchRange(segCount);
        this.writeUInt16(searchRange);
        this.writeUInt16(this.getEntrySelector(searchRange));
        this.writeUInt16(this.getRangeShift(segCount, searchRange));
        this.m_buffer.write(bytes);
    }

    public void writeVersion12() throws IOException {
        ArrayList<Long> startCharCode = new ArrayList<Long>();
        ArrayList<Long> endCharCode = new ArrayList<Long>();
        ArrayList<Long> startGlyphCode = new ArrayList<Long>();
        startCharCode.add(32L);
        endCharCode.add(126L);
        startGlyphCode.add(1L);
        long length = 16 + 12 * startCharCode.size();
        this.writeFixed32(12.0);
        this.writeUInt32(length);
        this.writeUInt32(0L);
        this.writeUInt32(startCharCode.size());
        for (int i = 0; i < startCharCode.size(); ++i) {
            this.writeUInt32((Long)startCharCode.get(i));
            this.writeUInt32((Long)endCharCode.get(i));
            this.writeUInt32((Long)startGlyphCode.get(i));
        }
    }

    private int getSearchRange(int a_value) {
        int retval = (int)Math.pow(2.0, Math.floor(Math.log(a_value) / Math.log(2.0)));
        return 2 * retval;
    }

    private int getEntrySelector(int a_searchRange) {
        int retval = (int)(Math.log(a_searchRange / 2) / Math.log(2.0));
        return retval;
    }

    private int getRangeShift(int a_value, int a_searchRange) {
        int retval = 2 * a_value - a_searchRange;
        return retval;
    }
}

