/*
 * Decompiled with CFR 0.152.
 */
package fontastic;

import fontastic.FContour;
import fontastic.FGlyph;
import fontastic.FPoint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.doubletype.ossa.Engine;
import org.doubletype.ossa.OutOfRangeException;
import org.doubletype.ossa.adapter.EContour;
import org.doubletype.ossa.adapter.EContourPoint;
import org.doubletype.ossa.module.GlyphFile;
import org.doubletype.ossa.module.TypefaceFile;

public class Fontastic {
    private Engine m_engine;
    private String fontName;
    private List<FGlyph> glyphs;
    private int advanceWidth = 512;
    private File ttfFile;
    private File outFile;
    private File tempDir;

    public Fontastic(String fontName, File outFile) throws IOException {
        this.fontName = fontName;
        this.outFile = outFile;
        this.intitialiseFont();
        this.glyphs = new ArrayList<FGlyph>();
    }

    public String getFontname() {
        return this.fontName;
    }

    private static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdirs()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    private void intitialiseFont() throws IOException {
        this.tempDir = Fontastic.createTempDirectory();
        this.m_engine = new Engine();
        this.m_engine.buildNewTypeface(this.fontName, this.tempDir);
        this.setFontFamilyName(this.fontName);
        this.setVersion("CC BY-SA 3.0 http://creativecommons.org/licenses/by-sa/3.0/");
        String directoryName = this.tempDir + File.separator;
        this.ttfFile = new File(directoryName + this.fontName + ".ttf");
    }

    public void buildFont() {
        for (FGlyph glyph : this.glyphs) {
            this.m_engine.checkUnicodeBlock(glyph.getGlyphChar());
            GlyphFile glyphFile = this.m_engine.addNewGlyph(glyph.getGlyphChar());
            glyphFile.setAdvanceWidth(glyph.getAdvanceWidth());
            for (FContour contour : glyph.getContours()) {
                EContour econtour = new EContour();
                econtour.setType("quadratic");
                for (FPoint point : contour.points) {
                    EContourPoint e = new EContourPoint(point.x, point.y, true);
                    if (point.hasControlPoint1()) {
                        econtour.addContourPoint(new EContourPoint(point.controlPoint.x, point.controlPoint.y, false));
                    }
                    econtour.addContourPoint(e);
                }
                glyphFile.addContour(econtour);
            }
        }
        this.m_engine.getTypeface().addRequiredGlyphs();
        this.m_engine.buildTrueType();
        if (this.outFile.exists()) {
            this.outFile.delete();
        }
        this.ttfFile.renameTo(this.outFile);
        this.cleanup();
    }

    private void cleanup() {
        File[] filesToExclude = new File[]{};
        Fontastic.deleteFolderContents(this.tempDir, true, filesToExclude);
    }

    public void setAuthor(String author) {
        this.m_engine.setAuthor(author);
    }

    public void setCopyrightYear(String copyrightYear) {
        this.m_engine.setCopyrightYear(copyrightYear);
    }

    public void setCreationDate(Date date) {
        this.m_engine.setCreationDate(date);
    }

    public void setModificationDate(Date date) {
        this.m_engine.setModificationDate(date);
    }

    public void setVersion(String version) {
        this.m_engine.getTypeface().setVersion(version);
    }

    public void setFontFamilyName(String fontFamilyName) {
        this.m_engine.setFontFamilyName(fontFamilyName);
    }

    public void setTypefaceLicense(String typefaceLicense) {
        this.m_engine.setTypefaceLicense(typefaceLicense);
    }

    public void setBaseline(float baseline) {
        this.m_engine.setBaseline(baseline);
    }

    public void setMeanline(float meanline) {
        this.m_engine.setMeanline(meanline);
    }

    public void setAdvanceWidth(int advanceWidth) {
        this.m_engine.setAdvanceWidth(advanceWidth);
        this.advanceWidth = advanceWidth;
    }

    public void setTopSideBearing(float topSideBearing) {
        try {
            this.m_engine.getTypeface().setTopSideBearing(topSideBearing);
        }
        catch (OutOfRangeException e) {
            System.out.println("Error while setting aopSideBearing (must be within range " + this.m_engine.getTypeface().getEm());
            e.printStackTrace();
        }
    }

    public void setBottomSideBearing(float bottomSideBearing) {
        try {
            this.m_engine.getTypeface().setBottomSideBearing(bottomSideBearing);
        }
        catch (OutOfRangeException e) {
            System.out.println("Error while setting bottomSideBearing (must be within range " + this.m_engine.getTypeface().getEm());
            e.printStackTrace();
        }
    }

    public void setAscender(float ascender) {
        try {
            this.m_engine.getTypeface().setAscender(ascender);
        }
        catch (OutOfRangeException e) {
            System.out.println("Error while setting ascender (must be within range 0 to " + this.m_engine.getTypeface().getEm() + ")");
            e.printStackTrace();
        }
    }

    public void setDescender(float descender) {
        try {
            this.m_engine.getTypeface().setDescender(descender);
        }
        catch (OutOfRangeException e) {
            System.out.println("Error while setting descender (must be within range 0 to " + this.m_engine.getTypeface().getEm() + ")");
            e.printStackTrace();
        }
    }

    public void setXHeight(float xHeight) {
        try {
            this.m_engine.getTypeface().setXHeight(xHeight);
        }
        catch (OutOfRangeException e) {
            System.out.println("Error while setting xHeight (must be within range 0 to " + this.m_engine.getTypeface().getEm() + " as well as lower than the ascender " + this.m_engine.getTypeface().getAscender() + ")");
            e.printStackTrace();
        }
    }

    public void setDefaultMetrics() {
        this.m_engine.getTypeface().setDefaultMetrics();
    }

    public FGlyph addGlyph(char c) {
        FGlyph glyph = new FGlyph(c);
        glyph.setAdvanceWidth(this.advanceWidth);
        this.glyphs.add(glyph);
        return glyph;
    }

    public FGlyph addGlyph(char c, FContour contour) {
        FGlyph glyph = new FGlyph(c);
        this.glyphs.add(glyph);
        glyph.addContour(contour);
        glyph.setAdvanceWidth(this.advanceWidth);
        return glyph;
    }

    public FGlyph addGlyph(char c, FContour[] contours) {
        FGlyph glyph = new FGlyph(c);
        this.glyphs.add(glyph);
        for (FContour contour : contours) {
            glyph.addContour(contour);
        }
        glyph.setAdvanceWidth(this.advanceWidth);
        return glyph;
    }

    public FGlyph getGlyph(char c) {
        FGlyph glyph = null;
        for (int i = 0; i < this.glyphs.size(); ++i) {
            if (this.glyphs.get(i).getGlyphChar() != c) continue;
            glyph = this.glyphs.get(i);
            break;
        }
        return glyph;
    }

    public Engine getEngine() {
        return this.m_engine;
    }

    public TypefaceFile getTypefaceFile() {
        return this.m_engine.getTypeface();
    }

    public String getTTFfilename() {
        return this.ttfFile.toString();
    }

    private static void deleteFolderContents(File folder, boolean deleteFolderItself) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    Fontastic.deleteFolderContents(f, true);
                    f.delete();
                    continue;
                }
                f.delete();
            }
        }
        if (deleteFolderItself) {
            folder.delete();
        }
    }

    private static void deleteFolderContents(File folder, boolean deleteFolderItself, File[] exceptions) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                boolean deleteFile = true;
                for (File exceptfile : exceptions) {
                    if (!f.equals(exceptfile)) continue;
                    deleteFile = false;
                }
                if (!deleteFile) continue;
                if (f.isDirectory()) {
                    Fontastic.deleteFolderContents(f, true, exceptions);
                    f.delete();
                    continue;
                }
                f.delete();
            }
        }
        if (deleteFolderItself) {
            folder.delete();
        }
    }
}

