/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;
import jsyntaxpane.util.Configuration;
import jsyntaxpane.util.JarServiceProvider;

public class ScriptAction
extends DefaultSyntaxAction {
    static final String SCRIPT_FUNCTION = "SCRIPT_FUNCTION";
    static final ScriptEngine engine = new ScriptEngineManager().getEngineByExtension("js");
    static final Invocable invocable = (Invocable)((Object)engine);

    public ScriptAction() {
        super("scripted-action");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        if (this.getValue(SCRIPT_FUNCTION) != null) {
            String f = this.getValue(SCRIPT_FUNCTION).toString();
            try {
                engine.put("TARGET", target);
                engine.put("SDOC", sDoc);
                engine.put("DOT", dot);
                engine.put("EVENT", e);
                engine.put("ACTION", this);
                engine.put("AU", ActionUtils.getInstance());
                invocable.invokeFunction(f, new Object[0]);
            }
            catch (ScriptException ex) {
                this.showScriptError(target, ex);
            }
            catch (NoSuchMethodException ex) {
                this.showScriptError(target, ex);
            }
        } else {
            JOptionPane.showMessageDialog(target, ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("ScriptAction.NoScriptConfigured"), ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("ScriptAction.ErrorInScript"), 2);
        }
    }

    public void setFunction(String name) {
        this.putValue(SCRIPT_FUNCTION, name);
    }

    @Override
    public void config(Configuration config, String name) {
        super.config(config, name);
        for (Configuration.StringKeyMatcher m : config.getKeys(Pattern.compile("Script\\.((\\w|-)+)\\.URL"))) {
            this.getScriptFromURL(m.value);
        }
    }

    public void getScriptFromURL(String url) {
        InputStream is = JarServiceProvider.findResource(url, this.getClass().getClassLoader());
        if (is != null) {
            InputStreamReader reader = new InputStreamReader(is);
            try {
                engine.eval(reader);
            }
            catch (ScriptException ex) {
                this.showScriptError(null, ex);
            }
        } else {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("ScriptAction.NoScriptFoundIn") + url, ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("ScriptAction.ErrorInScript"), 2);
        }
    }

    private void showScriptError(JTextComponent target, Exception ex) {
        JOptionPane.showMessageDialog(target, ex.getMessage(), ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("ScriptAction.ErrorInScript"), 2);
    }
}

