/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;

public class PythonIndentAction
extends DefaultSyntaxAction {
    public PythonIndentAction() {
        super("PYTHONINDENT");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        if (target != null) {
            SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(target);
            int pos = target.getCaretPosition();
            int start = sDoc.getParagraphElement(pos).getStartOffset();
            String line = ActionUtils.getLine(target);
            String lineToPos = line.substring(0, pos - start);
            String prefix = ActionUtils.getIndent(line);
            int tabSize = ActionUtils.getTabSize(target);
            if (lineToPos.trim().endsWith(":")) {
                prefix = prefix + "                ".substring(0, tabSize);
            } else {
                String noComment = sDoc.getUncommentedText(start, pos);
                if (noComment.trim().endsWith(":")) {
                    prefix = prefix + "                ".substring(0, tabSize);
                }
            }
            target.replaceSelection("\n" + prefix);
        }
    }
}

