/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import jsyntaxpane.TokenType;

public class Token
implements Serializable,
Comparable {
    public final TokenType type;
    public final int start;
    public final int length;
    public final byte pairValue;
    public final short kind = 0;

    public Token(TokenType type, int start, int length) {
        this.type = type;
        this.start = start;
        this.length = length;
        this.pairValue = 0;
    }

    public Token(TokenType type, int start, int length, byte pairValue) {
        this.type = type;
        this.start = start;
        this.length = length;
        this.pairValue = pairValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Object) {
            Token token = (Token)obj;
            return this.start == token.start && this.length == token.length && this.type.equals((Object)token.type);
        }
        return false;
    }

    public int hashCode() {
        return this.start;
    }

    public String toString() {
        if (this.pairValue == 0) {
            return String.format("%s (%d, %d)", new Object[]{this.type, this.start, this.length});
        }
        return String.format("%s (%d, %d) (%d)", new Object[]{this.type, this.start, this.length, this.pairValue});
    }

    public int compareTo(Object o) {
        Token t = (Token)o;
        if (this.start != t.start) {
            return this.start - t.start;
        }
        if (this.length != t.length) {
            return this.length - t.length;
        }
        return this.type.compareTo(t.type);
    }

    public int end() {
        return this.start + this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getText(Document doc) {
        Segment text = new Segment();
        try {
            doc.getText(this.start, this.length, text);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Token.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            return text;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(Document doc) {
        String result = "";
        try {
            result = doc.getText(this.start, this.length);
            return result;
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Token.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            return result;
        }
    }
}

