/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.proxy;

import java.util.Vector;

public class WorkerThread
extends Thread {
    private Runnable task;
    private String name;
    private static int nactive = 0;
    private static Vector list = new Vector();
    private static int max = 10;
    private static long lifetime = 900000L;

    private WorkerThread() {
        this.setDaemon(true);
    }

    static synchronized void setLifetime(long time) {
        lifetime = time;
    }

    static synchronized void setMaxThreads(int maxThreads) {
        max = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WorkerThread getThread() {
        WorkerThread t;
        Vector vector = list;
        synchronized (vector) {
            if (list.size() > 0) {
                t = (WorkerThread)list.firstElement();
                list.removeElement(t);
            } else if (nactive >= max) {
                do {
                    try {
                        list.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (list.size() == 0);
                t = (WorkerThread)list.firstElement();
                list.removeElement(t);
            } else {
                t = new WorkerThread();
            }
            ++nactive;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignThread(Runnable task, String name) {
        while (true) {
            try {
                WorkerThread t;
                WorkerThread workerThread = t = WorkerThread.getThread();
                synchronized (workerThread) {
                    t.task = task;
                    t.name = name;
                    if (!t.isAlive()) {
                        t.start();
                    } else {
                        t.notify();
                    }
                }
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        do {
            this.setName(this.name);
            try {
                this.task.run();
            }
            catch (Throwable t) {
                System.err.println(t);
            }
            this.setName("idle thread");
            Vector t = list;
            synchronized (t) {
                list.addElement(this);
                if (nactive >= max) {
                    list.notify();
                }
                --nactive;
            }
            this.task = null;
            try {
                this.wait(lifetime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.task != null);
        list.removeElement(this);
    }
}

