/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.proxy;

import com.jpexs.proxy.CatchedListener;
import com.jpexs.proxy.Handler;
import com.jpexs.proxy.HttpError;
import com.jpexs.proxy.Janitor;
import com.jpexs.proxy.ProxyConfig;
import com.jpexs.proxy.ReplacedListener;
import com.jpexs.proxy.Replacement;
import com.jpexs.proxy.ReusableThread;
import com.jpexs.proxy.ThreadPool;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements Runnable {
    ServerSocket server = null;
    boolean running = false;
    private List<String> catchedContentTypes;
    private CatchedListener catchedListener;
    private ReplacedListener replacedListener;
    private List<Replacement> replacements;
    static ThreadPool pool;
    static Server myServer;
    static boolean serverRunning;
    static boolean stopping;

    public static ReusableThread getThread() {
        return pool.get();
    }

    public static boolean startServer(int port, List<Replacement> replacements, List<String> catchedContentTypes, CatchedListener catchedListener, ReplacedListener replacedListener) {
        Server.stopServer();
        stopping = false;
        try {
            myServer = new Server(port, replacements, catchedContentTypes, catchedListener, replacedListener);
        }
        catch (IOException ex) {
            return false;
        }
        pool = new ThreadPool(ProxyConfig.appName + " Threads");
        Janitor j = new Janitor();
        j.add(pool);
        Server.getThread().setRunnable(j);
        serverRunning = true;
        Server.getThread().setRunnable(myServer);
        return true;
    }

    public static void stopServer() {
        if (serverRunning) {
            stopping = true;
            serverRunning = false;
            try {
                Server.myServer.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            pool.clean();
        }
    }

    Server(int port, List<Replacement> replacements, List<String> catchedContentTypes, CatchedListener catchedListener, ReplacedListener replacedListener) throws IOException {
        this.replacements = replacements;
        this.catchedContentTypes = catchedContentTypes;
        this.catchedListener = catchedListener;
        this.replacedListener = replacedListener;
        String bindaddr = ProxyConfig.bindAddress;
        this.server = bindaddr != null && bindaddr.length() > 0 ? new ServerSocket(port, 512, InetAddress.getByName(bindaddr)) : new ServerSocket(port, 512);
    }

    synchronized void suspend() {
        this.running = false;
    }

    synchronized void resume() {
        this.running = true;
    }

    @Override
    public void run() {
        Thread.currentThread().setName(ProxyConfig.appName + " Server");
        this.running = true;
        while (true) {
            Socket socket;
            try {
                socket = this.server.accept();
            }
            catch (IOException e) {
                if (!stopping) continue;
                break;
            }
            if (stopping) break;
            if (this.running) {
                Handler h = new Handler(socket, this.replacements, this.catchedContentTypes, this.catchedListener, this.replacedListener);
                ReusableThread rt = Server.getThread();
                rt.setRunnable(h);
                continue;
            }
            this.error(socket, 503, ProxyConfig.appName + " proxy service is suspended.");
        }
    }

    void error(Socket socket, int code, String message) {
        try {
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.writeBytes(new HttpError(code, message).toString());
            out.close();
            socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        serverRunning = false;
        stopping = false;
    }
}

