/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.proxy;

import com.jpexs.proxy.Client;
import com.jpexs.proxy.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Request
extends Message {
    private String command = null;
    private String url = null;
    private String protocol = null;
    private byte[] data = null;
    private Client client = null;
    private Hashtable log;
    private Vector logHeaders;
    public boolean hadKeepalive = false;

    Request(Client c) {
        this.client = c;
    }

    void read(InputStream in) throws IOException {
        this.statusLine = this.readLine(in);
        if (this.statusLine == null || this.statusLine.length() == 0) {
            throw new IOException("Empty request");
        }
        StringTokenizer st = new StringTokenizer(this.statusLine);
        this.command = st.nextToken();
        this.url = st.nextToken();
        this.protocol = st.nextToken();
        if (!this.url.startsWith("http")) {
            // empty if block
        }
        this.readHeaders(in);
        if ("POST".equals(this.command) || "PUT".equals(this.command)) {
            try {
                int n = Integer.parseInt(this.getHeaderField("Content-length"));
                this.data = new byte[n];
                for (int offset = 0; offset < this.data.length; offset += n) {
                    n = in.read(this.data, offset, this.data.length - offset);
                    if (n >= 0) continue;
                    throw new IOException("Not enough " + this.command + " data");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void write(OutputStream out) throws IOException {
        super.write(out);
        if (this.data != null) {
            out.write(this.data);
            out.flush();
        }
    }

    public String getRequest() {
        return this.statusLine;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void addSecureHostToURL(String host) {
        this.url = "https://" + host + this.url;
    }

    public String getHost() {
        String url = this.getURL();
        String s = url.startsWith("http://") ? url.substring(7, url.indexOf(47, 7)) : (url.startsWith("https://") ? url.substring(8, url.indexOf(47, 8)) : url);
        int at = s.indexOf(64);
        if (at != -1) {
            s = s.substring(at + 1);
        }
        if (s.indexOf(58) != -1) {
            return s.substring(0, s.indexOf(58));
        }
        return s;
    }

    public int getPort() {
        String s;
        int port = 80;
        String url = this.getURL();
        if (url.startsWith("http://")) {
            s = url.substring(7, url.indexOf(47, 7));
        } else if (url.startsWith("https://")) {
            s = url.substring(8, url.indexOf(47, 8));
            port = 443;
        } else {
            s = url;
        }
        int at = s.indexOf(64);
        if (at != -1) {
            s = s.substring(at + 1);
        }
        if (s.indexOf(58) != -1) {
            try {
                port = Integer.parseInt(s.substring(s.indexOf(58) + 1));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return port;
    }

    public String getData() {
        if (this.data == null) {
            return null;
        }
        return new String(this.data);
    }

    public String getPath() {
        String str = this.getURL();
        int pos = 0;
        for (int i = 0; i < 3; ++i) {
            pos = str.indexOf(47, pos);
            ++pos;
        }
        return str.substring(--pos);
    }

    public String getDocument() {
        String path = this.getPath();
        int n = path.lastIndexOf(47);
        if (n == path.length() - 1) {
            n = path.lastIndexOf(47, n - 1);
        }
        if (n < 0) {
            return "/";
        }
        return path.substring(n + 1);
    }

    public Client getClient() {
        return this.client;
    }

    public String getQueryString() {
        String path = this.getPath();
        int n = path.indexOf(63);
        if (n < 0) {
            return null;
        }
        return path.substring(n + 1);
    }

    public synchronized void addLogEntry(String header, String message) {
        if (this.log == null) {
            this.log = new Hashtable();
            this.logHeaders = new Vector();
        }
        Vector<String> v = (Vector<String>)this.log.get(header);
        if (this.log.get(header) == null) {
            v = new Vector<String>();
            this.log.put(header, v);
            this.logHeaders.addElement(header);
        }
        v.addElement(message);
    }

    public Enumeration getLogHeaders() {
        return this.logHeaders != null ? this.logHeaders.elements() : null;
    }

    public Enumeration getLogEntries(String header) {
        return this.log != null ? ((Vector)this.log.get(header)).elements() : null;
    }
}

