/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.proxy;

import com.jpexs.proxy.CatchedListener;
import com.jpexs.proxy.ProxyConfig;
import com.jpexs.proxy.ReplacedListener;
import com.jpexs.proxy.Replacement;
import com.jpexs.proxy.Server;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class Main {
    public static final String REPLACEMENTSFILE = "." + File.separator + "config" + File.separator + "replacements.ini";
    public static boolean DEBUG_MODE = false;

    public static void main(String[] argv) {
        ArrayList<Replacement> replacements = new ArrayList<Replacement>();
        if (new File(REPLACEMENTSFILE).exists()) {
            try {
                String fileName;
                BufferedReader br = new BufferedReader(new FileReader(REPLACEMENTSFILE));
                String s = "";
                while ((s = br.readLine()) != null && (fileName = br.readLine()) != null) {
                    fileName = fileName.replaceAll("[\\\\/]", File.separator);
                    Replacement r = new Replacement(s, fileName);
                    if (DEBUG_MODE) {
                        System.out.println("Added Replacement: " + r.urlPattern + " => " + r.targetFile);
                    }
                    replacements.add(r);
                }
                br.close();
            }
            catch (IOException iOException) {}
        } else if (DEBUG_MODE) {
            System.out.println("WARNING:REPLACEMENTS FILE NOT FOUND.");
        }
        Server.startServer(ProxyConfig.port, replacements, new ArrayList<String>(), new CatchedListener(){

            public byte[] catched(String contentType, String url, InputStream data) {
                return null;
            }
        }, new ReplacedListener(){

            public void replaced(Replacement replacement, String url, String contentType) {
                if (DEBUG_MODE) {
                    System.out.println("REPLACED:" + url + " (Content-type:" + contentType + ") WITH FILE " + replacement.targetFile);
                }
            }
        });
    }
}

