/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.proxy;

import com.jpexs.proxy.HttpConnection;
import com.jpexs.proxy.Reply;
import com.jpexs.proxy.Request;
import com.jpexs.proxy.RetryRequestException;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Http
extends HttpConnection {
    static final int MAX_PENDING_REQUESTS = 1;
    static Hashtable cache = new Hashtable(33);
    private static Object httpLock = new Object();
    String host;
    int port;
    boolean proxy = false;
    boolean persistent = false;
    boolean closed = false;
    long idle = 0L;
    Vector queue = new Vector();

    public Http(String host, int port) throws IOException {
        this(host, port, false);
    }

    public Http(String host, int port, boolean isProxy) throws IOException {
        super(host, port);
        this.host = host;
        this.port = port;
        this.proxy = isProxy;
    }

    public Http(String host, int port, boolean isProxy, Socket sock) throws IOException {
        super(sock);
        this.host = host;
        this.port = port;
        this.proxy = isProxy;
    }

    public synchronized void sendRequest(Request request) throws IOException, RetryRequestException {
        this.queue.addElement(request);
        try {
            this.send(request);
        }
        catch (IOException e) {
            if (this.persistent) {
                this.persistent = false;
                throw new RetryRequestException();
            }
            throw e;
        }
    }

    public synchronized Reply recvReply(Request request) throws IOException, RetryRequestException {
        while (this.queue.firstElement() != request) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        if (this.closed) {
            throw new RetryRequestException();
        }
        try {
            return this.recv();
        }
        catch (IOException e) {
            if (this.persistent) {
                this.persistent = false;
                throw new RetryRequestException();
            }
            throw e;
        }
    }

    public void reallyClose() {
        this.persistent = false;
        this.close();
    }

    public synchronized void close() {
        if (this.persistent) {
            this.idle = System.currentTimeMillis();
        } else {
            Http.cacheRemove(this.host, this.port, this);
            super.close();
            this.closed = true;
        }
        if (this.queue.size() > 0) {
            this.queue.removeElementAt(0);
            this.notify();
        }
    }

    private void send(Request request) throws IOException {
        request.removeHeaderField("Proxy-Connection");
        if (!this.proxy) {
            if (!request.containsHeaderField("Connection") || !request.getHeaderField("Connection").toLowerCase().equals("keep-alive")) {
                request.setHeaderField("Connection", "open");
            }
            if (!request.containsHeaderField("Host")) {
                request.setHeaderField("Host", request.getHost());
            }
        }
        if (this.proxy) {
            request.write(this.getOutputStream());
        } else {
            String oldStatusLine = request.statusLine;
            StringBuffer head = new StringBuffer();
            head.append(request.getCommand());
            head.append(" ");
            head.append(request.getPath());
            head.append(" ");
            head.append("HTTP/1.0");
            request.statusLine = head.toString();
            request.write(this.getOutputStream());
            request.statusLine = oldStatusLine;
        }
    }

    private Reply recv() throws IOException {
        Reply reply = new Reply(this.getInputStream());
        reply.read();
        String conn = reply.getHeaderField("Connection");
        this.persistent = reply.containsHeaderField("Connection") && reply.getHeaderField("Connection").equals("close") ? false : reply.getProtocol().equals("HTTP/1.1");
        if (reply.getStatusCode() == 100) {
            reply = this.recv();
        }
        return reply;
    }

    protected boolean isBusy() {
        return this.queue.size() >= 1;
    }

    protected boolean isPersistent() {
        return this.persistent;
    }

    private static String cacheKey(String host, int port) {
        return host.toLowerCase() + ":" + port;
    }

    private static Vector cacheLookup(String host, int port) {
        Vector v = (Vector)cache.get(Http.cacheKey(host, port));
        return v;
    }

    private static boolean cacheContains(Http http) {
        Vector v = (Vector)cache.get(Http.cacheKey(http.host, http.port));
        return v != null ? v.contains(http) : false;
    }

    private static void cacheInsert(String host, int port, Http http) {
        String key = Http.cacheKey(host, port);
        Vector<Http> v = (Vector<Http>)cache.get(key);
        if (v == null) {
            v = new Vector<Http>();
        }
        v.addElement(http);
        cache.put(key, v);
    }

    private static void cacheRemove(String host, int port, Http http) {
        Vector v = (Vector)cache.get(Http.cacheKey(host, port));
        if (v != null) {
            v.removeElement(http);
            if (v.isEmpty()) {
                cache.remove(Http.cacheKey(host, port));
            }
        }
    }

    private static void cacheClean() {
        long now = System.currentTimeMillis();
        Enumeration e = cache.keys();
        while (e.hasMoreElements()) {
            Vector v = (Vector)cache.get(e.nextElement());
            for (int i = 0; i < v.size(); ++i) {
                Http http = (Http)v.elementAt(i);
                if (http.idle <= 0L || now - http.idle <= 30000L) continue;
                http.persistent = false;
                http.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Http open(String host, int port, boolean isProxy) throws IOException {
        Http http = null;
        Object object = httpLock;
        synchronized (object) {
            Vector v = Http.cacheLookup(host, port);
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    Http pick = (Http)v.elementAt(i);
                    if (!pick.isPersistent() || pick.isBusy()) continue;
                    http = pick;
                    break;
                }
                if (http != null) {
                    http.idle = 0L;
                }
            }
        }
        if (http == null) {
            http = new Http(host, port, isProxy);
            Http.cacheInsert(host, port, http);
        }
        return http;
    }

    static Http open(String host, int port) throws IOException {
        return Http.open(host, port, false);
    }

    static Enumeration enumerate() {
        Vector list = new Vector();
        Enumeration e = cache.keys();
        while (e.hasMoreElements()) {
            Vector v = (Vector)cache.get(e.nextElement());
            for (int i = 0; i < v.size(); ++i) {
                list.addElement(v.elementAt(i));
            }
        }
        return list.elements();
    }

    static synchronized void clean() {
        Http.cacheClean();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SERVER ");
        buf.append(super.toString());
        if (this.isPersistent()) {
            buf.append(" - ");
            if (this.queue.size() > 0) {
                buf.append(this.queue.size());
                buf.append(" pending");
            } else {
                buf.append("idle " + (double)(System.currentTimeMillis() - this.idle) / 1000.0 + " sec");
            }
        }
        return buf.toString();
    }
}

