/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.monte.media.AudioFormatKeys;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.Registry;
import org.monte.media.VideoFormatKeys;

public class DefaultRegistry
extends Registry {
    private HashMap<String, LinkedList<RegistryEntry>> codecMap;
    private HashMap<String, LinkedList<RegistryEntry>> readerMap;
    private HashMap<String, LinkedList<RegistryEntry>> writerMap;
    private HashMap<String, Format> fileFormatMap;

    @Override
    public Format[] getReaderFormats() {
        return this.getFileFormats();
    }

    @Override
    public Format[] getWriterFormats() {
        return this.getFileFormats();
    }

    @Override
    public Format[] getFileFormats() {
        return this.fileFormatMap.values().toArray(new Format[this.fileFormatMap.size()]);
    }

    @Override
    protected void init() {
        this.codecMap = new HashMap();
        this.readerMap = new HashMap();
        this.writerMap = new HashMap();
        this.fileFormatMap = new HashMap();
        this.putCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, "image"}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "x-iff/anim", AudioFormatKeys.EncodingKey, "ILBM"}), "org.monte.media.anim.BitmapCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, "image"}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "DIB "}), "org.monte.media.avi.DIBCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, "image"}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "MJPG"}), "org.monte.media.jpeg.JPEGCodec");
        this.putCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, "image"}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "png "}), "org.monte.media.png.PNGCodec");
        this.putCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, "image"}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "RLE "}), "org.monte.media.avi.RunLengthCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "tscc"}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, "image"}), "org.monte.media.avi.TechSmithCodec");
        this.putCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "ZMBV"}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, "image"}), "org.monte.media.avi.ZMBVCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "\u0000\u0000\u0000\u0001"}), "org.monte.media.avi.AVIPCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_UNSIGNED}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "\u0000\u0000\u0000\u0001"}), "org.monte.media.avi.AVIPCMAudioCodec");
        this.putCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, "image"}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "raw "}), "org.monte.media.quicktime.RawCodec");
        this.putCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, "image"}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "rle "}), "org.monte.media.quicktime.AnimationCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, "image"}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "jpeg"}), "org.monte.media.jpeg.JPEGCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, "image"}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "MJPG"}), "org.monte.media.jpeg.JPEGCodec");
        this.putCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, "image"}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "png "}), "org.monte.media.png.PNGCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture"}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, "image"}), "org.monte.media.avi.TechSmithCodec");
        this.putCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "twos"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_UNSIGNED}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "twos"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "sowt"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_UNSIGNED}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "sowt"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "in24"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_UNSIGNED}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "in24"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "in32"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_UNSIGNED}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "in32"}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "raw "}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putBidiCodec(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "Java", AudioFormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_UNSIGNED}), new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, "raw "}), "org.monte.media.quicktime.QuickTimePCMAudioCodec");
        this.putReader(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, AudioFormatKeys.MimeTypeKey, "video/avi"}), "org.monte.media.avi.AVIReader");
        this.putReader(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, AudioFormatKeys.MimeTypeKey, "video/quicktime"}), "org.monte.media.quicktime.QuickTimeReader");
        this.putReader(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, AudioFormatKeys.MimeTypeKey, "x-iff/anim"}), "org.monte.media.anim.ANIMReader");
        this.putWriter(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, AudioFormatKeys.MimeTypeKey, "video/avi"}), "org.monte.media.avi.AVIWriter");
        this.putWriter(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, AudioFormatKeys.MimeTypeKey, "video/quicktime"}), "org.monte.media.quicktime.QuickTimeWriter");
        this.putWriter(new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, AudioFormatKeys.MimeTypeKey, "x-iff/anim"}), "org.monte.media.anim.ANIMWriter");
        this.putFileFormat("avi", new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, AudioFormatKeys.MimeTypeKey, "video/avi"}));
        this.putFileFormat("mov", new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, AudioFormatKeys.MimeTypeKey, "video/quicktime"}));
        this.putFileFormat("anim", new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, AudioFormatKeys.MimeTypeKey, "x-iff/anim"}));
    }

    public void putBidiCodec(Format inputFormat, Format outputFormat, String codecClass) {
        this.putCodec(inputFormat, outputFormat, codecClass);
        this.putCodec(outputFormat, inputFormat, codecClass);
    }

    @Override
    public void putCodec(Format inputFormat, Format outputFormat, String codecClass) {
        RegistryEntry entry = new RegistryEntry(inputFormat, outputFormat, codecClass);
        this.addCodecEntry((String)inputFormat.get(AudioFormatKeys.EncodingKey), entry);
        this.addCodecEntry((String)outputFormat.get(AudioFormatKeys.EncodingKey), entry);
    }

    private void addCodecEntry(String key, RegistryEntry entry) {
        LinkedList<RegistryEntry> list = this.codecMap.get(key);
        if (list == null) {
            list = new LinkedList();
            this.codecMap.put(key, list);
        }
        list.add(entry);
    }

    @Override
    public void putReader(Format fileFormat, String readerClass) {
        RegistryEntry entry = new RegistryEntry(null, fileFormat, readerClass);
        String key = (String)fileFormat.get(AudioFormatKeys.MimeTypeKey);
        LinkedList<RegistryEntry> list = this.readerMap.get(key);
        if (list == null) {
            list = new LinkedList();
            this.readerMap.put(key, list);
        }
        list.add(entry);
    }

    @Override
    public void putWriter(Format fileFormat, String writerClass) {
        RegistryEntry entry = new RegistryEntry(fileFormat, null, writerClass);
        String key = (String)fileFormat.get(AudioFormatKeys.MimeTypeKey);
        LinkedList<RegistryEntry> list = this.writerMap.get(key);
        if (list == null) {
            list = new LinkedList();
            this.writerMap.put(key, list);
        }
        list.add(entry);
    }

    @Override
    public String[] getCodecClasses(Format inputFormat, Format outputFormat) {
        LinkedList<Object> re;
        HashSet<String> classNames = new HashSet<String>();
        HashSet<Object> entries = new HashSet<Object>();
        if (inputFormat != null) {
            if (inputFormat.get(AudioFormatKeys.EncodingKey) == null) {
                re = new LinkedList();
                for (Map.Entry<String, LinkedList<RegistryEntry>> i : this.codecMap.entrySet()) {
                    for (RegistryEntry j : i.getValue()) {
                        if (!inputFormat.matches(j.inputFormat)) continue;
                        re.add(j);
                    }
                }
            } else {
                re = this.codecMap.get(inputFormat.get(AudioFormatKeys.EncodingKey));
            }
            if (re != null) {
                entries.addAll(re);
            }
        }
        if (outputFormat != null) {
            if (outputFormat.get(AudioFormatKeys.EncodingKey) == null) {
                re = new LinkedList();
                for (Map.Entry<String, LinkedList<RegistryEntry>> i : this.codecMap.entrySet()) {
                    for (RegistryEntry j : i.getValue()) {
                        if (!outputFormat.matches(j.outputFormat)) continue;
                        re.add(j);
                    }
                }
            } else {
                re = this.codecMap.get(outputFormat.get(AudioFormatKeys.EncodingKey));
            }
            if (re != null) {
                entries.addAll(re);
            }
        }
        for (RegistryEntry registryEntry : entries) {
            if (inputFormat != null && registryEntry.inputFormat != null && !inputFormat.matches(registryEntry.inputFormat) || outputFormat != null && registryEntry.outputFormat != null && !outputFormat.matches(registryEntry.outputFormat)) continue;
            classNames.add(registryEntry.className);
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    @Override
    public String[] getReaderClasses(Format fileFormat) {
        LinkedList<RegistryEntry> rr = this.readerMap.get(fileFormat.get(AudioFormatKeys.MimeTypeKey));
        String[] names = new String[rr == null ? 0 : rr.size()];
        if (rr != null) {
            int i = 0;
            for (RegistryEntry e : rr) {
                names[i++] = e.className;
            }
        }
        return names;
    }

    @Override
    public Format getFileFormat(File file) {
        String ext = file.getName();
        int p = ext.lastIndexOf(46);
        if (p != -1) {
            ext = ext.substring(p + 1);
        }
        ext = ext.toLowerCase();
        return this.fileFormatMap.get(ext);
    }

    @Override
    public String[] getWriterClasses(Format fileFormat) {
        LinkedList<RegistryEntry> rr = this.writerMap.get(fileFormat.get(AudioFormatKeys.MimeTypeKey));
        String[] names = new String[rr == null ? 0 : rr.size()];
        if (rr != null) {
            int i = 0;
            for (RegistryEntry e : rr) {
                names[i++] = e.className;
            }
        }
        return names;
    }

    @Override
    public void putFileFormat(String extension, Format format) {
        this.fileFormatMap.put(extension.toLowerCase(), format);
    }

    @Override
    public String getExtension(Format ff) {
        for (Map.Entry<String, Format> e : this.fileFormatMap.entrySet()) {
            if (!((String)e.getValue().get(AudioFormatKeys.MimeTypeKey)).equals(ff.get(AudioFormatKeys.MimeTypeKey))) continue;
            return e.getKey();
        }
        return "";
    }

    @Override
    public void unregisterCodec(String codecClass) {
        for (Map.Entry<String, LinkedList<RegistryEntry>> i : this.codecMap.entrySet()) {
            LinkedList<RegistryEntry> ll = i.getValue();
            Iterator j = ll.iterator();
            while (j.hasNext()) {
                RegistryEntry e = (RegistryEntry)j.next();
                if (!e.className.equals(codecClass)) continue;
                j.remove();
            }
        }
    }

    private static class RegistryEntry {
        Format inputFormat;
        Format outputFormat;
        String className;

        public RegistryEntry(Format inputFormat, Format outputFormat, String className) {
            this.inputFormat = inputFormat;
            this.outputFormat = outputFormat;
            this.className = className;
        }
    }
}

