/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.javactivex.example;

import com.jpexs.javactivex.ActiveX;
import com.jpexs.javactivex.ActiveXEvent;
import com.jpexs.javactivex.ActiveXEventListener;
import com.jpexs.javactivex.example.controls.mediaplayer.IWMPMedia;
import com.jpexs.javactivex.example.controls.mediaplayer.WindowsMediaPlayer;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class MediaPlayerExample
extends Frame {
    private WindowsMediaPlayer wmPlayer;
    private final Panel axPanel = new Panel();

    public MediaPlayerExample() {
        this.setSize(800, 600);
        this.setTitle("Sample ActiveX Component in Java - Media Player");
        this.setLayout(new BorderLayout());
        this.wmPlayer = ActiveX.createObject(WindowsMediaPlayer.class, this.axPanel);
        this.add((Component)this.axPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Panel buttonsPanel = new Panel(new FlowLayout());
        Button playButton = new Button("Play Media...");
        Button infoButton = new Button("Info");
        buttonsPanel.add(playButton);
        buttonsPanel.add(infoButton);
        buttonsPanel.setBackground(Color.YELLOW);
        this.add((Component)buttonsPanel, "North");
        playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileDialog fd = new FileDialog((Frame)MediaPlayerExample.this, "Open SWF");
                fd.setMultipleMode(false);
                fd.setVisible(true);
                if (fd.getFile() != null) {
                    String file = "file:///" + fd.getDirectory().replace("\\", "/") + "/" + fd.getFile();
                    MediaPlayerExample.this.wmPlayer.setURL(file);
                }
            }
        });
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IWMPMedia m = MediaPlayerExample.this.wmPlayer.getCurrentMedia();
                System.out.println("Duration:" + m.getDuration());
            }
        });
        this.axPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.axPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.out.println("Click");
            }
        });
        this.wmPlayer.addPositionChangeListener(new ActiveXEventListener(){

            @Override
            public void onEvent(ActiveXEvent ev) {
                System.out.println("Pos change:" + MediaPlayerExample.this.wmPlayer.getControls().getCurrentPositionString());
            }
        });
    }

    public static void main(String[] args) {
        new MediaPlayerExample().setVisible(true);
    }
}

