/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.javactivex;

import com.jpexs.javactivex.ActiveX;
import com.jpexs.javactivex.ActiveXEvent;
import com.jpexs.javactivex.ActiveXEventListener;
import com.jpexs.javactivex.ActiveXException;
import com.jpexs.javactivex.ClassInfo;
import com.jpexs.javactivex.GUID;
import com.jpexs.javactivex.ICOMInstance;
import com.jpexs.javactivex.MethodInfo;
import com.jpexs.javactivex.Property;
import com.jpexs.javactivex.Reference;
import com.jpexs.javactivex.jna.Kernel32;
import com.jpexs.javactivex.jna.SHELLEXECUTEINFO;
import com.jpexs.javactivex.jna.Shell32;
import com.jpexs.javactivex.jna.WinNT;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;

public class ActiveXControl {
    private static WinNT.HANDLE pipe;
    private static WinNT.HANDLE process;
    private static final int CMD_ECHO = 0;
    private static final int CMD_NEW = 1;
    private static final int CMD_OBJ_DESTROY = 2;
    private static final int CMD_DESTROYALL = 3;
    private static final int CMD_TYPE_LIST_PROPERTIES = 4;
    private static final int CMD_TYPE_LIST_METHODS = 5;
    private static final int CMD_TYPE_LIST_EVENTS = 6;
    private static final int CMD_OBJ_RESIZE = 7;
    private static final int CMD_OBJ_GET_PROPERTY = 8;
    private static final int CMD_OBJ_SET_PROPERTY = 9;
    private static final int CMD_OBJ_SET_PARENT = 10;
    private static final int CMD_OBJ_CALL_METHOD = 11;
    private static final int CMD_TYPE_GET_METHOD_PARAMS = 12;
    private static final int CMD_GET_OCX_CLASSES = 13;
    private static final int CMD_GET_REGISTERED_CLASSES = 14;
    private static final int CMD_TYPE_GET_PROPERTY_TYPE = 15;
    private static final int CMD_TYPE_GET_INFO = 16;
    private static final Object AXLOCK;
    private int hwnd;
    private String guid;
    private String docString;
    private long cid = -1L;
    private String progId;
    private boolean attached = false;
    private String className;
    private static final int ECHO_INTERVAL = 100;
    private static final Map<String, String> boxedMap;
    private static Timer syncTimer;
    private Panel panel;
    private boolean disposed = false;
    private static Map<Long, ActiveXControl> instances;
    private static boolean unloaded;
    private static Map<Long, Map<String, List<ActiveXEventListener>>> listeners;

    public static void unload() {
        if (unloaded) {
            return;
        }
        ActiveXControl.writeCommand(3);
        Kernel32.INSTANCE.CloseHandle(pipe);
        Kernel32.INSTANCE.TerminateProcess(process, 0);
        unloaded = true;
    }

    public String getClassName() {
        return this.className;
    }

    private static void addControlEventListener(String eventName, ActiveXControl control, ActiveXEventListener listener) {
        if (!listeners.containsKey(control.cid)) {
            listeners.put(control.cid, new HashMap());
        }
        if (eventName == null) {
            eventName = "*";
        }
        if (!listeners.get(control.cid).containsKey(eventName)) {
            listeners.get(control.cid).put(eventName, new ArrayList());
        }
        listeners.get(control.cid).get(eventName).add(listener);
    }

    public long getCid() {
        return this.cid;
    }

    private static void removeControlEventListener(String eventName, ActiveXControl control, ActiveXEventListener listener) {
        if (!listeners.containsKey(control.cid)) {
            return;
        }
        if (eventName == null) {
            eventName = "*";
        }
        if (!listeners.get(control.cid).containsKey(eventName)) {
            return;
        }
        listeners.get(control.cid).get(eventName).remove(listener);
    }

    public void addEventListener(ActiveXEventListener listener) {
        this.addEventListener(null, listener);
    }

    public void addEventListener(String eventName, ActiveXEventListener listener) {
        ActiveXControl.addControlEventListener(eventName, this, listener);
    }

    public void removeEventListener(ActiveXEventListener listener) {
        ActiveXControl.removeControlEventListener(null, this, listener);
    }

    public void removeEventListener(String eventName, ActiveXEventListener listener) {
        ActiveXControl.removeControlEventListener(eventName, this, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void echo() {
        ArrayList<ActiveXEvent> events = new ArrayList<ActiveXEvent>();
        Iterator iterator = AXLOCK;
        synchronized (iterator) {
            ActiveXControl.writeCommand(0);
            int cnt = ActiveXControl.readUI16();
            for (int i = 0; i < cnt; ++i) {
                long ecid = ActiveXControl.readUI32();
                String ename = ActiveXControl.readString();
                int epcount = ActiveXControl.readUI16();
                HashMap<String, Object> args = new HashMap<String, Object>();
                HashMap<String, String> argTypes = new HashMap<String, String>();
                for (int j = 0; j < epcount; ++j) {
                    String type = ActiveXControl.readString();
                    Object val = ActiveXControl.strToValue(type, ActiveXControl.readString());
                    String key = ActiveXControl.readString();
                    args.put(key, val);
                    argTypes.put(key, type);
                    ActiveXControl.readString();
                }
                if (!instances.containsKey(ecid)) continue;
                events.add(new ActiveXEvent(instances.get(ecid), ename, args, argTypes));
            }
        }
        for (ActiveXEvent ev : events) {
            if (!listeners.containsKey(ev.source.cid)) continue;
            for (String evName : listeners.get(ev.source.cid).keySet()) {
                if (!evName.equals("*") && !evName.equals(ev.name)) continue;
                List<ActiveXEventListener> list = listeners.get(ev.source.cid).get(evName);
                for (ActiveXEventListener l : list) {
                    l.onEvent(ev);
                }
            }
        }
    }

    public static String strToClassName(String type) {
        if (type.startsWith("Pointer|Dispatch:")) {
            type = type.substring("Pointer|".length());
        }
        if (type.startsWith("Dispatch:")) {
            String[] pts = type.split(":");
            return pts[1];
        }
        if (type.startsWith("Pointer|Variant")) {
            return "Object";
        }
        if (type.startsWith("Pointer|")) {
            String inc = ActiveXControl.strToClassName(type.substring("Pointer|".length()));
            if (boxedMap.containsKey(inc)) {
                inc = boxedMap.get(inc);
            }
            return "Reference<" + inc + ">";
        }
        switch (type) {
            case "Empty": {
                return null;
            }
            case "Null": {
                return null;
            }
            case "Smallint": {
                return "int";
            }
            case "Integer": {
                return "int";
            }
            case "Single": {
                return "float";
            }
            case "Double": {
                return "double";
            }
            case "Currency": {
                return "BigDecimal";
            }
            case "Date": {
                return null;
            }
            case "OleStr": {
                return "String";
            }
            case "Dispatch": {
                return null;
            }
            case "Error": {
                return null;
            }
            case "Boolean": {
                return "boolean";
            }
            case "Variant": {
                return "Object";
            }
            case "Unknown": {
                return "Object";
            }
            case "Decimal": {
                return "BigDecimal";
            }
            case "$0F": {
                return null;
            }
            case "ShortInt": {
                return "short";
            }
            case "Byte": {
                return "int";
            }
            case "Word": {
                return "int";
            }
            case "LongWord": {
                return "long";
            }
            case "Int64": {
                return "BigInteger";
            }
            case "Int": {
                return "int";
            }
            case "UInt": {
                return "int";
            }
            case "Void": {
                return "void";
            }
            case "HResult": {
                return "int";
            }
            case "Pointer": {
                return null;
            }
            case "SafeArray": {
                return null;
            }
            case "CArray": {
                return null;
            }
            case "UserDefined": {
                return "Object";
            }
            case "LPStr": {
                return "String";
            }
            case "LPWStr": {
                return "String";
            }
            case "IntPtr": 
            case "UIntPtr": 
            case "FileTime": 
            case "Blob": 
            case "Stream": 
            case "Storage": 
            case "StreamedObject": 
            case "BlobObject": 
            case "CF": 
            case "CLSID": {
                return null;
            }
        }
        return null;
    }

    private static Object strToValue(String type, String value) {
        if (type.startsWith("ByRef ")) {
            type = type.substring("ByRef ".length());
        }
        try {
            switch (type) {
                case "Empty": {
                    return null;
                }
                case "Null": {
                    return null;
                }
                case "Smallint": {
                    if (value.trim().equals("")) {
                        return null;
                    }
                    return Integer.parseInt(value);
                }
                case "Integer": {
                    if (value.trim().equals("")) {
                        return null;
                    }
                    return Integer.parseInt(value);
                }
                case "Single": {
                    if (value.trim().equals("")) {
                        return null;
                    }
                    return Float.valueOf(Float.parseFloat(value));
                }
                case "Double": {
                    if (value.trim().equals("")) {
                        return null;
                    }
                    return Double.parseDouble(value);
                }
                case "Currency": {
                    if (value.trim().equals("")) {
                        return null;
                    }
                    return new BigDecimal(value);
                }
                case "Date": {
                    return null;
                }
                case "OleStr": {
                    return value;
                }
                case "Dispatch": {
                    return null;
                }
                case "Error": {
                    return null;
                }
                case "Boolean": {
                    return value.equals("True");
                }
                case "Variant": {
                    return value;
                }
                case "Unknown": {
                    return null;
                }
                case "Decimal": {
                    return new BigDecimal(value);
                }
                case "$0F": {
                    return null;
                }
                case "ShortInt": {
                    if (value.trim().equals("")) {
                        return null;
                    }
                    return Short.parseShort(value);
                }
                case "Byte": {
                    if (value.trim().equals("")) {
                        return null;
                    }
                    return Integer.parseInt(value);
                }
                case "Word": {
                    if (value.trim().equals("")) {
                        return null;
                    }
                    return Integer.parseInt(value);
                }
                case "LongWord": {
                    if (value.trim().equals("")) {
                        return null;
                    }
                    return Long.parseLong(value);
                }
                case "Int64": {
                    if (value.trim().equals("")) {
                        return null;
                    }
                    return new BigInteger(value);
                }
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            System.err.println("WARNING: Invalid " + type + " value: " + value);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Property getProperty(String baseguid, String guid, String name) {
        Object object = AXLOCK;
        synchronized (object) {
            ActiveXControl.writeTypeCommand(15, baseguid, guid);
            ActiveXControl.writeString(name);
            ActiveXControl.readResult();
            String type = ActiveXControl.readString();
            ActiveXControl.readString();
            boolean readable = ActiveXControl.readString().equals("True");
            ActiveXControl.readString();
            boolean writable = ActiveXControl.readString().equals("True");
            return new Property(name, ActiveXControl.strToClassName(type), type, readable, writable);
        }
    }

    public static boolean methodExists(String baseguid, String guid, String name) {
        return ActiveXControl.getMethodNames(baseguid, guid).contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodInfo getMethod(String baseguid, String guid, final String name) {
        if (!ActiveXControl.methodExists(baseguid, guid, name)) {
            return null;
        }
        final ArrayList<String> argNames = new ArrayList<String>();
        final ArrayList<String> argTypes = new ArrayList<String>();
        final ArrayList<String> argTypesStr = new ArrayList<String>();
        Object object = AXLOCK;
        synchronized (object) {
            ActiveXControl.writeTypeCommand(12, baseguid, guid);
            ActiveXControl.writeString(name);
            ActiveXControl.readResult();
            final String fname = ActiveXControl.readString();
            final String returnName = ActiveXControl.readString();
            final String returnTypeStr = ActiveXControl.readString();
            final String returnType = ActiveXControl.strToClassName(returnTypeStr);
            int parameterCount = ActiveXControl.readUI16();
            final int optionalParameterCount = ActiveXControl.readUI16();
            for (int i = 0; i < parameterCount; ++i) {
                String pname = ActiveXControl.readString();
                String ptype = ActiveXControl.readString();
                argNames.add(pname);
                argTypesStr.add(ptype);
                argTypes.add(ActiveXControl.strToClassName(ptype));
            }
            final String doc = ActiveXControl.readString();
            return new MethodInfo(){

                @Override
                public int getOptionalArgumentCount() {
                    return optionalParameterCount;
                }

                private String typeToStr(Class c) {
                    if (c == null) {
                        return "Object";
                    }
                    return c.getSimpleName();
                }

                public String toString() {
                    String ret = returnType + " " + this.getName() + "(";
                    for (int i = 0; i < argNames.size(); ++i) {
                        if (i > 0) {
                            ret = ret + ", ";
                        }
                        ret = ret + (String)argTypes.get(i) + " " + (String)argNames.get(i);
                    }
                    ret = ret + ")";
                    return ret;
                }

                @Override
                public List<String> getArgumentNames() {
                    return argNames;
                }

                @Override
                public String getDoc() {
                    return doc;
                }

                @Override
                public String getReturnName() {
                    return returnName;
                }

                @Override
                public String getReturnTypeStr() {
                    return returnTypeStr;
                }

                @Override
                public String getReturnType() {
                    return returnType;
                }

                @Override
                public List<String> getArgumentTypes() {
                    return argTypes;
                }

                @Override
                public List<String> getArgumentTypesStr() {
                    return argTypesStr;
                }

                @Override
                public String getName() {
                    return fname;
                }

                public int hashCode() {
                    return name.hashCode();
                }

                public boolean equals(Object obj) {
                    if (obj == null) {
                        return false;
                    }
                    if (!(obj instanceof MethodInfo)) {
                        return false;
                    }
                    MethodInfo m = (MethodInfo)obj;
                    return this.getName().equals(m.getName());
                }
            };
        }
    }

    private void writeCid() {
        ActiveXControl.writeUI32(this.cid);
        String type = ActiveXControl.readString();
        String val = ActiveXControl.readString();
        if (type.equals("Error")) {
            throw new ActiveXException(val);
        }
    }

    private static void writeTypeCommand(int command, String baseguid, String guid) {
        ActiveXControl.writeCommand(command);
        ActiveXControl.writeString(baseguid);
        ActiveXControl.writeString(guid);
    }

    private void writeComponentCommand(int command) {
        ActiveXControl.writeCommand(command);
        this.writeCid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPropertyValue(Class c, String name) {
        Object object = AXLOCK;
        synchronized (object) {
            this.writeComponentCommand(8);
            ActiveXControl.writeString(name);
            GUID g = c.getAnnotation(GUID.class);
            if (g != null) {
                ActiveXControl.writeString("Dispatch");
                ActiveXControl.writeString(g.base().equals("") ? g.value() : g.base());
                ActiveXControl.writeString(g.value());
            } else {
                ActiveXControl.writeString("String");
            }
            ActiveXControl.readResult();
            String type = ActiveXControl.readString();
            if (type.equals("Dispatch")) {
                long cid = ActiveXControl.readUI32();
                return ActiveX.getObject(c, cid);
            }
            String val = ActiveXControl.readString();
            return ActiveXControl.strToValue(type, val);
        }
    }

    private static void readResult() {
        String type = ActiveXControl.readString();
        String val = ActiveXControl.readString();
        if ("Error".equals(type)) {
            throw new ActiveXException(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyValue(Class c, String name, Object value) {
        Object object = AXLOCK;
        synchronized (object) {
            this.writeComponentCommand(9);
            ActiveXControl.writeString(name);
            GUID g = c.getAnnotation(GUID.class);
            if (g != null && value instanceof ICOMInstance) {
                ActiveXControl.writeString("Dispatch");
                ActiveXControl.writeUI32(((ICOMInstance)value).getCid());
                ActiveXControl.writeString(g.base().equals("") ? g.value() : g.base());
                ActiveXControl.writeString(g.value());
            } else {
                ActiveXControl.writeString("String");
            }
            ActiveXControl.writeString("" + value);
            ActiveXControl.readResult();
        }
    }

    public static List<ClassInfo> getOcxClasses(File ocx) {
        ArrayList<ClassInfo> ret = new ArrayList<ClassInfo>();
        ActiveXControl.writeCommand(13);
        ActiveXControl.writeString(ocx.getAbsolutePath());
        ActiveXControl.readResult();
        int cnt = ActiveXControl.readUI16();
        for (int i = 0; i < cnt; ++i) {
            String baseguid;
            String name = ActiveXControl.readString();
            String docstring = ActiveXControl.readString();
            String guid = baseguid = ActiveXControl.readString();
            ret.add(new ClassInfo(name, docstring, baseguid, guid, ocx));
        }
        return ret;
    }

    public ActiveXControl(String baseguid, String guid, Panel panel) {
        this("", baseguid, guid, panel);
    }

    public ActiveXControl(File filename, String baseguid, String guid, Panel panel) {
        this(filename.getAbsolutePath(), baseguid, guid, panel);
    }

    public String getGuid() {
        return this.guid;
    }

    public String getDocString() {
        return this.docString;
    }

    private ActiveXControl(long cid) {
        this.cid = cid;
        instances.put(cid, this);
    }

    public static ActiveXControl getInstance(long cid) {
        if (instances.containsKey(cid)) {
            return instances.get(cid);
        }
        return new ActiveXControl(cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveXControl(String filename, String baseguid, String guid, Panel panel) {
        this.guid = guid;
        this.panel = panel;
        Object object = AXLOCK;
        synchronized (object) {
            ActiveXControl.writeCommand(1);
            ActiveXControl.writeString(filename);
            ActiveXControl.writeString(baseguid);
            ActiveXControl.writeString(guid);
            ActiveXControl.readResult();
            this.cid = ActiveXControl.readUI32();
            this.guid = ActiveXControl.readString();
            this.progId = ActiveXControl.readString();
            this.className = ActiveXControl.readString();
            this.docString = ActiveXControl.readString();
        }
        instances.put(this.cid, this);
        if (panel != null) {
            panel.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ActiveXControl.this.resize();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    this.componentResized(e);
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
        }
    }

    private static int shiftStateToModifiers(int shiftState) {
        boolean shiftDown = (shiftState & 1) == 1;
        boolean ctrlDown = (shiftState & 2) == 2;
        boolean altDown = (shiftState & 4) == 4;
        int modifiers = (shiftDown ? 1 : 0) + (ctrlDown ? 2 : 0) + (altDown ? 8 : 0);
        return modifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attach() {
        Object object = AXLOCK;
        synchronized (object) {
            this.writeComponentCommand(10);
            this.hwnd = Native.getComponentPointer((Component)this.panel).hashCode();
            ActiveXControl.writeUI32(this.hwnd);
            ActiveXEventListener mouseHandler = new ActiveXEventListener(){

                @Override
                public void onEvent(ActiveXEvent ev) {
                    boolean buttonMiddle;
                    int fX = (Integer)ev.args.get("fX");
                    int fY = (Integer)ev.args.get("fX");
                    int button = (Integer)ev.args.get("nButton");
                    int shiftState = (Integer)ev.args.get("nShiftState");
                    boolean buttonLeft = (button & 1) == 1;
                    boolean buttonRight = (button & 2) == 2;
                    boolean bl = buttonMiddle = (button & 4) == 4;
                    int oneButton = buttonLeft ? 1 : (buttonRight ? 2 : (buttonMiddle ? 3 : 0));
                    int clickCount = 0;
                    int eventType = 0;
                    switch (ev.name) {
                        case "MouseMove": {
                            eventType = 503;
                            break;
                        }
                        case "MouseUp": {
                            eventType = 502;
                            break;
                        }
                        case "MouseDown": {
                            eventType = 501;
                            break;
                        }
                        case "Click": {
                            eventType = 500;
                            clickCount = 1;
                            break;
                        }
                        case "DoubleClick": {
                            eventType = 500;
                            clickCount = 2;
                        }
                    }
                    ActiveXControl.this.panel.dispatchEvent(new MouseEvent(ActiveXControl.this.panel, eventType, System.currentTimeMillis(), ActiveXControl.shiftStateToModifiers(shiftState), fX, fY, clickCount, false, oneButton));
                }
            };
            this.addEventListener("MouseMove", mouseHandler);
            this.addEventListener("MouseUp", mouseHandler);
            this.addEventListener("MouseDown", mouseHandler);
            this.addEventListener("Click", mouseHandler);
            this.addEventListener("DoubleClick", mouseHandler);
            ActiveXEventListener keyHandler = new ActiveXEventListener(){

                @Override
                public void onEvent(ActiveXEvent ev) {
                    int nKeyCode = 0;
                    int nShiftState = 0;
                    int eventType = 0;
                    int nKeyAscii = 0;
                    switch (ev.name) {
                        case "KeyDown": 
                        case "KeyUp": {
                            nKeyCode = (Integer)ev.args.get("nKeyCode");
                            nShiftState = (Integer)ev.args.get("nShiftState");
                            break;
                        }
                        case "KeyPress": {
                            nKeyAscii = (Integer)ev.args.get("nKeyAscii");
                        }
                    }
                    switch (ev.name) {
                        case "KeyDown": {
                            eventType = 401;
                            break;
                        }
                        case "KeyUp": {
                            eventType = 402;
                            break;
                        }
                        case "KeyPress": {
                            eventType = 400;
                        }
                    }
                    ActiveXControl.this.panel.dispatchEvent(new KeyEvent(ActiveXControl.this.panel, eventType, System.currentTimeMillis(), ActiveXControl.shiftStateToModifiers(nShiftState), nKeyCode, (char)nKeyAscii));
                }
            };
            this.addEventListener("KeyUp", keyHandler);
            this.addEventListener("KeyDown", keyHandler);
            this.addEventListener("KeyPress", keyHandler);
            this.attached = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resize() {
        if (!this.attached) {
            this.attach();
        }
        Object object = AXLOCK;
        synchronized (object) {
            this.writeComponentCommand(7);
            ActiveXControl.writeUI16(this.panel.getWidth());
            ActiveXControl.writeUI16(this.panel.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPropertyNames(String baseguid, String guid) {
        Object object = AXLOCK;
        synchronized (object) {
            ActiveXControl.writeTypeCommand(4, baseguid, guid);
            ActiveXControl.readResult();
            return ActiveXControl.readStrings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getMethodNames(String baseguid, String guid) {
        Object object = AXLOCK;
        synchronized (object) {
            ActiveXControl.writeTypeCommand(5, baseguid, guid);
            ActiveXControl.readResult();
            return new HashSet<String>(ActiveXControl.readStrings());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getEventNames(String baseguid, String guid) {
        Object object = AXLOCK;
        synchronized (object) {
            ActiveXControl.writeTypeCommand(6, baseguid, guid);
            ActiveXControl.readResult();
            return ActiveXControl.readStrings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E callMethodArr(String methodName, Object[] args, Class[] paramTypes, Type[] genericParamTypes, Class<E> retType) {
        Object object = AXLOCK;
        synchronized (object) {
            this.writeComponentCommand(11);
            ActiveXControl.writeString(methodName);
            ActiveXControl.writeUI16(args.length);
            for (int i = 0; i < args.length; ++i) {
                GUID g;
                Object o = args[i];
                Class c = paramTypes[i];
                if (Reference.class.isAssignableFrom(c)) {
                    o = ((Reference)o).getVal();
                    ParameterizedType s = (ParameterizedType)genericParamTypes[i];
                    c = (Class)s.getActualTypeArguments()[0];
                    ActiveXControl.writeString("Reference");
                }
                if ((g = c.getAnnotation(GUID.class)) != null) {
                    ActiveXControl.writeString("Object");
                    ActiveXControl.writeString(g.base().equals("") ? g.value() : g.base());
                    ActiveXControl.writeString(g.value());
                    ActiveXControl.writeUI32(((ICOMInstance)o).getCid());
                    continue;
                }
                ActiveXControl.writeString("String");
                ActiveXControl.writeString("" + o);
            }
            Class c = retType;
            if (Reference.class.isAssignableFrom(c)) {
                ParameterizedType referenceType = (ParameterizedType)c.getGenericSuperclass();
                c = (Class)referenceType.getActualTypeArguments()[0];
                ActiveXControl.writeString("Reference");
            }
            if (ICOMInstance.class.isAssignableFrom(c)) {
                ActiveXControl.writeString("Object");
                GUID g = c.getAnnotation(GUID.class);
                if (g == null) {
                    throw new ActiveXException("No GUID");
                }
                ActiveXControl.writeString(g.base().equals("") ? g.value() : g.base());
                ActiveXControl.writeString(g.value());
            } else {
                ActiveXControl.writeString("String");
            }
            ActiveXControl.readResult();
            for (int i = 0; i < args.length; ++i) {
                c = paramTypes[i];
                Object o = args[i];
                if (!Reference.class.isAssignableFrom(c)) continue;
                String type = ActiveXControl.readString();
                if (type.equals("Dispatch")) {
                    long cid = ActiveXControl.readUI32();
                    ((Reference)o).setVal(ActiveX.getObject(retType, cid));
                    continue;
                }
                String val = ActiveXControl.readString();
                ((Reference)o).setVal(ActiveXControl.strToValue(type, val));
            }
            String type = ActiveXControl.readString();
            if (type.equals("Dispatch")) {
                long cid = ActiveXControl.readUI32();
                return ActiveX.getObject(retType, cid);
            }
            String val = ActiveXControl.readString();
            return (E)ActiveXControl.strToValue(type, val);
        }
    }

    private static List<String> readStrings() {
        int len = ActiveXControl.readUI16();
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            ret.add(ActiveXControl.readString());
        }
        return ret;
    }

    private static String readString() {
        int len = (int)ActiveXControl.readUI32();
        byte[] data = new byte[len];
        ActiveXControl.read(data);
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return new String(data);
        }
    }

    private static int readUI16() {
        byte[] data = new byte[2];
        ActiveXControl.read(data);
        return ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
    }

    private static long readUI32() {
        byte[] data = new byte[4];
        ActiveXControl.read(data);
        return ((data[0] & 0xFF) << 24) + ((data[1] & 0xFF) << 16) + ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
    }

    private static void writeCommand(int cmd) {
        ActiveXControl.writeUI8(cmd);
    }

    private static int readUI8() {
        byte[] data = new byte[1];
        ActiveXControl.read(data);
        return data[0] & 0xFF;
    }

    private static int read(byte[] res) {
        int readNow;
        IntByReference ibr = new IntByReference();
        for (int read = 0; read < res.length; read += readNow) {
            byte[] data = new byte[res.length - read];
            boolean result = Kernel32.INSTANCE.ReadFile(pipe, data, data.length, ibr, null);
            if (!result) {
                return Kernel32.INSTANCE.GetLastError();
            }
            readNow = ibr.getValue();
            System.arraycopy(data, 0, res, read, readNow);
        }
        return 0;
    }

    private static void writeUI8(int val) {
        ActiveXControl.write(new byte[]{(byte)val});
    }

    private static void writeUI32(long val) {
        ActiveXControl.write(new byte[]{(byte)(val >> 24 & 0xFFL), (byte)(val >> 16 & 0xFFL), (byte)(val >> 8 & 0xFFL), (byte)(val & 0xFFL)});
    }

    private static void writeUI16(long val) {
        ActiveXControl.write(new byte[]{(byte)(val >> 8 & 0xFFL), (byte)(val & 0xFFL)});
    }

    private static void writeString(String s) {
        byte[] data;
        try {
            data = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            data = s.getBytes();
        }
        ActiveXControl.writeUI32(data.length);
        ActiveXControl.write(data);
    }

    private static int write(byte[] data) {
        IntByReference ibr = new IntByReference();
        boolean result = Kernel32.INSTANCE.WriteFile(pipe, data, data.length, ibr, null);
        if (!result) {
            return Kernel32.INSTANCE.GetLastError();
        }
        if (ibr.getValue() != data.length) {
            return -1;
        }
        return 0;
    }

    public static String progIdToJavaClassName(String progId) {
        String[] parts;
        String controlName = null;
        if (!progId.isEmpty() && (parts = progId.split("\\.")).length >= 2) {
            controlName = parts[1].equals(parts[0]) ? parts[1] : parts[0] + "_" + parts[1];
        }
        return controlName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassName(String baseguid, String guid) {
        Object object = AXLOCK;
        synchronized (object) {
            ActiveXControl.writeTypeCommand(16, baseguid, guid);
            ActiveXControl.readResult();
            String name = ActiveXControl.readString();
            ActiveXControl.readString();
            return name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassDoc(String baseguid, String guid) {
        Object object = AXLOCK;
        synchronized (object) {
            ActiveXControl.writeTypeCommand(16, baseguid, guid);
            ActiveXControl.readResult();
            ActiveXControl.readString();
            String docString = ActiveXControl.readString();
            return docString;
        }
    }

    private static String firstToUpperCase(String s) {
        if (s == null) {
            return s;
        }
        if (s.isEmpty()) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static String typeToStr(String c) {
        if (c == null) {
            return "Object";
        }
        return c;
    }

    private static void parseNeededGuid(String type, Set<String> neededGuids) {
        if (type == null) {
            return;
        }
        String[] pts = !type.contains("|") ? new String[]{type} : type.split("\\|");
        for (String p : pts) {
            if (!p.startsWith("Dispatch:") && !p.startsWith("Unknown:")) continue;
            pts = p.split(":");
            neededGuids.add(pts[2] + ":" + pts[3]);
        }
    }

    public static String getJavaDefinition(String baseguid, String guid, Set<String> neededGuids, String javaPackage) {
        StringBuilder sb = new StringBuilder();
        String nl = System.lineSeparator();
        String controlName = ActiveXControl.getClassName(baseguid, guid);
        String docString = ActiveXControl.getClassDoc(baseguid, guid);
        if (controlName == null) {
            controlName = "MyClass";
        }
        sb.append("package ").append(javaPackage).append(";").append(nl).append(nl);
        sb.append("import com.jpexs.javactivex.*;").append(nl);
        sb.append(nl);
        sb.append("/**").append(nl);
        if (docString.isEmpty()) {
            sb.append(" * Class ").append(controlName).append(nl);
        }
        sb.append(" * ").append(docString).append(nl);
        sb.append(" */").append(nl);
        if (baseguid == null || baseguid.equals("") || baseguid.equals(guid)) {
            sb.append("@GUID(\"").append(guid).append("\")").append(nl);
        } else {
            sb.append("@GUID(value=\"").append(guid).append("\", base=\"").append(baseguid).append("\")").append(nl);
        }
        sb.append("public interface ").append(controlName).append(" {").append(nl);
        sb.append(nl);
        Set<String> methodNames = ActiveXControl.getMethodNames(baseguid, guid);
        String[] hiddenMethods = new String[]{"AddRef", "Release", "QueryInterface", "GetIDsOfNames", "GetTypeInfo", "GetTypeInfoCount", "Invoke"};
        List<String> events = ActiveXControl.getEventNames(baseguid, guid);
        for (String event : events) {
            sb.append(nl);
            sb.append("\t/**").append(nl);
            sb.append("\t * Adds ").append(event).append(" event listener").append(nl);
            sb.append("\t * @param l Event listener").append(nl);
            sb.append("\t */").append(nl);
            sb.append("\t@AddListener(\"").append(event).append("\")").append(nl);
            sb.append("\tpublic void add").append(ActiveXControl.firstToUpperCase(event)).append("Listener(ActiveXEventListener l);").append(nl);
            sb.append(nl);
            sb.append("\t/**").append(nl);
            sb.append("\t * Removes ").append(event).append(" event listener").append(nl);
            sb.append("\t * @param l Event listener").append(nl);
            sb.append("\t */").append(nl);
            sb.append("\t@RemoveListener(\"").append(event).append("\")").append(nl);
            sb.append("\tpublic void remove").append(ActiveXControl.firstToUpperCase(event)).append("Listener(ActiveXEventListener l);").append(nl);
        }
        for (String metName : methodNames) {
            MethodInfo m = ActiveXControl.getMethod(baseguid, guid, metName);
            String doc = m.getDoc();
            if (Arrays.asList(hiddenMethods).contains(metName)) continue;
            int optcnt = m.getOptionalArgumentCount();
            for (int k = 0; k <= optcnt; ++k) {
                sb.append(nl);
                sb.append("\t/**").append(nl);
                if (!doc.isEmpty()) {
                    sb.append("\t * ").append(doc.trim().replaceAll("\r\n|\r|\n", "\t * ")).append(nl);
                } else {
                    sb.append("\t * Method ").append(metName).append(nl);
                }
                sb.append("\t * ").append(nl);
                List<String> argnames = m.getArgumentNames();
                List<String> argtypes = m.getArgumentTypes();
                List<String> argtypesstr = m.getArgumentTypesStr();
                for (int i = 0; i < argnames.size() - k; ++i) {
                    ActiveXControl.parseNeededGuid(argtypesstr.get(i), neededGuids);
                    sb.append("\t * @param ").append(argnames.get(i));
                    if (argtypes.get(i) == null) {
                        sb.append(" (").append(argtypesstr.get(i)).append(") ");
                    }
                    sb.append(nl);
                }
                String retType = m.getReturnType();
                ActiveXControl.parseNeededGuid(m.getReturnTypeStr(), neededGuids);
                if (!"void".equals(retType)) {
                    sb.append("\t * @return");
                    if (retType == null) {
                        sb.append(" (").append(m.getReturnTypeStr()).append(")");
                    }
                    sb.append(nl);
                }
                sb.append("\t */").append(nl);
                sb.append("\tpublic ");
                sb.append(ActiveXControl.typeToStr(m.getReturnType())).append(" ").append(m.getName()).append("(");
                for (int i = 0; i < argnames.size() - k; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(ActiveXControl.typeToStr(argtypes.get(i))).append(" ").append(argnames.get(i));
                }
                sb.append(")");
                sb.append(";").append(nl).append(nl);
            }
        }
        List<String> propNames = ActiveXControl.getPropertyNames(baseguid, guid);
        for (String propName : propNames) {
            Property p = ActiveXControl.getProperty(baseguid, guid, propName);
            ActiveXControl.parseNeededGuid(p.typeStr, neededGuids);
            String type = ActiveXControl.strToClassName(p.typeStr);
            boolean customType = false;
            if (type == null) {
                type = "Object";
                customType = true;
            }
            if (p.readable) {
                sb.append(nl);
                sb.append("\t/**").append(nl);
                sb.append("\t * Getter for property ").append(propName).append(nl);
                sb.append("\t * ").append(nl);
                sb.append("\t * @return ");
                if (customType) {
                    sb.append("(").append(p.typeStr).append(") ");
                }
                sb.append(propName).append(" value").append(nl);
                sb.append("\t */").append(nl);
                sb.append("\t@Getter(\"").append(propName).append("\")").append(nl);
                sb.append("\tpublic ").append(ActiveXControl.typeToStr(type)).append(" get").append(ActiveXControl.firstToUpperCase(propName)).append(ActiveXControl.methodExists(baseguid, guid, "get" + ActiveXControl.firstToUpperCase(propName)) ? "_" : "").append("();").append(nl);
            }
            if (!p.writable) continue;
            sb.append(nl);
            sb.append("\t/**").append(nl);
            sb.append("\t * Setter for property ").append(propName).append(nl);
            sb.append("\t * ").append(nl);
            sb.append("\t * @param value ");
            if (customType) {
                sb.append("(").append(p.typeStr).append(") ");
            }
            sb.append("New ").append(propName).append(" value").append(nl);
            sb.append("\t */").append(nl);
            sb.append("\t@Setter(\"").append(propName).append("\")").append(nl);
            sb.append("\tpublic void set").append(ActiveXControl.firstToUpperCase(propName)).append(ActiveXControl.methodExists(baseguid, guid, "set" + ActiveXControl.firstToUpperCase(propName)) ? "_" : "").append("(").append(type).append(" value);").append(nl);
        }
        sb.append("}");
        return sb.toString();
    }

    public String getProgId() {
        return this.progId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ClassInfo> getRegisteredClasses() {
        ArrayList<ClassInfo> ret = new ArrayList<ClassInfo>();
        Object object = AXLOCK;
        synchronized (object) {
            ActiveXControl.writeCommand(14);
            int cnt = ActiveXControl.readUI16();
            for (int i = 0; i < cnt; ++i) {
                String baseguid;
                String name = ActiveXControl.readString();
                String docstring = ActiveXControl.readString();
                String guid = baseguid = ActiveXControl.readString();
                File file = new File(ActiveXControl.readString());
                ret.add(new ClassInfo(name, docstring, baseguid, guid, file));
            }
        }
        return ret;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (!this.disposed) {
            Object object = AXLOCK;
            synchronized (object) {
                this.writeComponentCommand(2);
            }
            this.disposed = true;
        }
    }

    static {
        InputStream exeStream;
        AXLOCK = new Object();
        boxedMap = new HashMap<String, String>();
        syncTimer = new Timer();
        instances = new WeakHashMap<Long, ActiveXControl>();
        if (!Platform.isWindows()) {
            throw new UnsupportedOperationException("Active X is available on Windows only.");
        }
        boxedMap.put("boolean", "Boolean");
        boxedMap.put("byte", "Byte");
        boxedMap.put("short", "Short");
        boxedMap.put("char", "Character");
        boxedMap.put("int", "Integer");
        boxedMap.put("long", "Long");
        boxedMap.put("float", "Float");
        boxedMap.put("double", "Double");
        String path = "";
        try {
            path = URLDecoder.decode(ActiveXControl.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
        String appDir = new File(path).getParentFile().getAbsolutePath();
        if (!appDir.endsWith("\\")) {
            appDir = appDir + "\\";
        }
        if ((exeStream = ActiveXControl.class.getClassLoader().getResourceAsStream("com/jpexs/javactivex/server/ActiveXServer.exe")) == null) {
            throw new ActiveXException("Cannot load javactivex server stream");
        }
        File exeFile = new File(System.getProperty("java.io.tmpdir") + File.separator + "javactivex_" + System.currentTimeMillis() + ".exe");
        int BUFSIZE = 1024;
        byte[] buf = new byte[1024];
        try (FileOutputStream fos = new FileOutputStream(exeFile);){
            int cnt;
            while ((cnt = exeStream.read(buf)) > 0) {
                fos.write(buf, 0, cnt);
            }
        }
        catch (IOException ex) {
            throw new ActiveXException("Cannot load JavactiveX server");
        }
        exeFile.deleteOnExit();
        String exePath = exeFile.getAbsolutePath();
        String instName = "" + System.currentTimeMillis();
        String pipeName = "\\\\.\\pipe\\activex_server_" + instName;
        pipe = Kernel32.INSTANCE.CreateNamedPipe(pipeName, 3, 0, 1, 4096, 4096, 0, null);
        SHELLEXECUTEINFO sei = new SHELLEXECUTEINFO();
        sei.fMask = 64;
        sei.lpFile = new WString(exePath);
        sei.lpParameters = new WString(instName);
        sei.nShow = 1;
        Shell32.INSTANCE.ShellExecuteEx(sei);
        process = sei.hProcess;
        Kernel32.INSTANCE.ConnectNamedPipe(pipe, null);
        ActiveXControl.echo();
        syncTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    ActiveXControl.echo();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, 100L, 100L);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ActiveXControl.unload();
            }
        });
        unloaded = false;
        listeners = new HashMap<Long, Map<String, List<ActiveXEventListener>>>();
    }
}

