/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.debugger.flash.messages.out;

import com.jpexs.debugger.flash.DebuggerConnection;
import com.jpexs.debugger.flash.OutDebuggerMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class OutSetBreakpoints
extends OutDebuggerMessage {
    public static int ID = 17;
    public List<Integer> files;
    public List<Integer> lines;

    @Override
    public String toString() {
        return super.toString() + "(bp.count=" + this.files.size() + ")";
    }

    public OutSetBreakpoints(DebuggerConnection c, int file, int line) {
        super(c, ID);
        this.files = new ArrayList<Integer>();
        this.lines = new ArrayList<Integer>();
        this.lines.add(line);
        this.files.add(file);
    }

    public OutSetBreakpoints(DebuggerConnection c, List<Integer> files, List<Integer> lines) {
        super(c, ID);
        this.files = files;
        this.lines = lines;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        this.writeDWord(os, this.files.size());
        for (int i = 0; i < this.files.size(); ++i) {
            int file = this.files.get(i);
            int line = this.lines.get(i);
            if (!this.connection.wideLines) {
                this.writeWord(os, file);
                this.writeWord(os, line);
                continue;
            }
            this.writeDWord(os, file);
            this.writeDWord(os, line);
        }
    }
}

