/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.debugger.flash.messages.in;

import com.jpexs.debugger.flash.DebuggerConnection;
import com.jpexs.debugger.flash.InDebuggerMessage;
import com.jpexs.debugger.flash.Variable;
import java.util.ArrayList;
import java.util.List;

public class InFrame
extends InDebuggerMessage {
    public static final int ID = 31;
    public int depth = (int)this.readDWord();
    public List<Variable> registers = new ArrayList<Variable>();
    public List<Variable> variables;
    public List<Long> frameIds;
    public List<Variable> arguments;
    public List<Long> argumentFrameIds;
    public List<Variable> scopeChain;
    public List<Long> scopeChainFrameIds;
    public long frameId = -1L;
    public Variable frame;

    @Override
    public String toString() {
        return super.toString() + "(depth=" + this.depth + ", registers.count=" + this.registers.size() + ", variables.count=" + this.variables.size() + ")";
    }

    public InFrame(DebuggerConnection c, byte[] data) {
        super(c, 31, data);
        if (this.depth > -1) {
            int num = (int)this.readDWord();
            for (int i = 0; i < num; ++i) {
                this.registers.add(this.readRegister(c, i + 1));
            }
        }
        int currentArg = -1;
        boolean gettingScopeChain = false;
        if (this.available() > 0) {
            this.frameId = this.readPtr(c);
            this.frame = this.readVariable(c);
        }
        this.variables = new ArrayList<Variable>();
        this.frameIds = new ArrayList<Long>();
        this.arguments = new ArrayList<Variable>();
        this.argumentFrameIds = new ArrayList<Long>();
        this.scopeChain = new ArrayList<Variable>();
        this.scopeChainFrameIds = new ArrayList<Long>();
        while (this.available() > 0) {
            long frameId = this.readPtr(c);
            Variable child = this.readVariable(c);
            if (currentArg == -1 && child.name.equals("$arguments")) {
                currentArg = 0;
                gettingScopeChain = false;
                continue;
            }
            if (child.name.equals("$scopechain")) {
                currentArg = -1;
                gettingScopeChain = true;
                continue;
            }
            if (currentArg >= 0) {
                ++currentArg;
                if (child.name.equals("undefined")) {
                    child.name = "_arg" + currentArg;
                }
            }
            if (gettingScopeChain) {
                this.scopeChain.add(child);
                this.scopeChainFrameIds.add(frameId);
                continue;
            }
            if (currentArg >= 0) {
                this.arguments.add(child);
                this.argumentFrameIds.add(frameId);
                continue;
            }
            this.variables.add(child);
            this.frameIds.add(frameId);
        }
    }
}

