/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.debugger.flash;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

public class SWD {
    public static final int bitmapAction = 1;
    public static final int bitmapOnAction = 2;
    public static final int bitmapOnClipAction = 3;
    private static final String SYNTHETIC = "synthetic: ";
    private static final String SYNTHETIC_OBJ = "synthetic: Object.registerClass() for ";
    private static final String ACTIONS_FOR = "Actions for ";
    public int swfVersion;
    public final List<DebugItem> objects;

    private static boolean isFrameworkClass(String n) {
        return n.startsWith("mx.") && n.indexOf(":") != -1 && n.endsWith(".as") || n.indexOf("/mx/") > -1;
    }

    public static String fixName(String name) {
        if (name.startsWith(SYNTHETIC) && name.startsWith(SYNTHETIC_OBJ)) {
            String componentName = name.substring(SYNTHETIC_OBJ.length());
            name = "<" + componentName + ".2>";
            return name;
        }
        return name;
    }

    public SWD(int swfVersion, List<DebugItem> items) {
        this.objects = items;
        this.swfVersion = swfVersion;
    }

    public void saveTo(OutputStream os) throws IOException {
        os.write("FWD".getBytes());
        os.write(this.swfVersion);
        for (DebugItem di : this.objects) {
            os.write(di.getBytes());
        }
    }

    public SWD(byte[] data) throws IOException {
        this(new ByteArrayInputStream(data));
    }

    public SWD(InputStream is) throws IOException {
        this.objects = new ArrayList<DebugItem>();
        byte[] hdr = SWD.readBytes(is, 3);
        if (hdr[0] != 70 || hdr[1] != 87 || hdr[2] != 68) {
            throw new IOException("Invalid SWD file - header not found");
        }
        this.swfVersion = SWD.readUI8(is);
        if (this.swfVersion < 6) {
            throw new IOException("SWD file < 6 unsupported");
        }
        do {
            int tag = SWD.readUI32(is);
            switch (tag) {
                case 0: {
                    this.objects.add(new DebugScript(is));
                    break;
                }
                case 1: {
                    this.objects.add(new DebugOffset(is));
                    break;
                }
                case 2: {
                    this.objects.add(new DebugBreakpoint(is));
                    break;
                }
                case 3: {
                    this.objects.add(new DebugId(is));
                    break;
                }
                case 5: {
                    this.objects.add(new DebugRegisters(is));
                }
            }
        } while (is.available() > 0);
    }

    private static void writeUI8(OutputStream os, int val) throws IOException {
        os.write(val);
    }

    private static void writeString(OutputStream os, String val) throws IOException {
        os.write(val.getBytes("UTF-8"));
        os.write(0);
    }

    private static void writeUI32(OutputStream os, long val) throws IOException {
        int b0 = (int)(val & 0xFFL);
        int b1 = (int)(val >> 8 & 0xFFL);
        int b2 = (int)(val >> 16 & 0xFFL);
        int b3 = (int)(val >> 24 & 0xFFL);
        os.write(b0);
        os.write(b1);
        os.write(b2);
        os.write(b3);
    }

    private static void writeUI16(OutputStream os, int val) throws IOException {
        int b0 = val & 0xFF;
        int b1 = val >> 8 & 0xFF;
        os.write(b0);
        os.write(b1);
    }

    private static String readString(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (true) {
            int r;
            if ((r = SWD.readUI8(is)) == 0) {
                try {
                    return new String(baos.toByteArray(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            baos.write(r);
        }
    }

    private static byte[] readBytes(InputStream is, int length) throws IOException {
        byte[] buf = new byte[length];
        for (int i = 0; i < length; ++i) {
            buf[i] = (byte)is.read();
        }
        return buf;
    }

    private static int readUI8(InputStream is) throws IOException {
        int v = is.read();
        if (v == -1) {
            throw new IOException("End of stream reached");
        }
        return v;
    }

    private static int readUI16(InputStream is) throws IOException {
        return SWD.readUI8(is) + (SWD.readUI8(is) << 8);
    }

    private static int readUI32(InputStream is) throws IOException {
        return SWD.readUI8(is) + (SWD.readUI8(is) << 8) + (SWD.readUI8(is) << 16) + (SWD.readUI8(is) << 24) & 0xFFFFFFFF;
    }

    public static class DebugId
    extends DebugItem {
        byte[] uid;
        public static final int ID = 3;

        public String toString() {
            return "DebugId[" + DatatypeConverter.printHexBinary((byte[])this.uid) + "]";
        }

        public DebugId() {
            super(3);
        }

        public DebugId(InputStream is) throws IOException {
            super(3);
            this.uid = new byte[16];
            for (int i = 0; i < this.uid.length; ++i) {
                this.uid[i] = (byte)SWD.readUI8(is);
            }
        }

        public DebugId(byte[] uid) {
            super(3);
            this.uid = uid;
        }

        @Override
        protected void writeTo(OutputStream os) throws IOException {
            os.write(this.uid);
        }
    }

    public static class DebugBreakpoint
    extends DebugItem {
        public static final int MAX_FILE = 65535;
        public static final int MAX_LINE = 65535;
        public int file;
        public int line;
        public static final int ID = 2;

        public String toString() {
            return "DebugBreakpoint[module=" + this.file + ", line=" + this.line + "]";
        }

        public DebugBreakpoint() {
            super(2);
        }

        public DebugBreakpoint(InputStream is) throws IOException {
            super(2);
            this.file = SWD.readUI16(is);
            this.line = SWD.readUI16(is);
        }

        public DebugBreakpoint(int file, int line) {
            super(2);
            if (file > 65535) {
                throw new IllegalArgumentException("File id exceeds 65535");
            }
            if (file > 65535) {
                throw new IllegalArgumentException("Line number exceeds 65535");
            }
            this.file = file;
            this.line = line;
        }

        @Override
        protected void writeTo(OutputStream os) throws IOException {
            SWD.writeUI16(os, this.file);
            SWD.writeUI16(os, this.line);
        }
    }

    public static class DebugRegisters
    extends DebugItem {
        public int offset;
        public List<Integer> regnums = new ArrayList<Integer>();
        public List<String> names = new ArrayList<String>();
        public static final int ID = 5;

        public String toString() {
            return "DebugRegisters[offset=" + this.offset + ", count=" + this.regnums.size() + "]";
        }

        public DebugRegisters() {
            super(5);
        }

        public DebugRegisters(int offset, List<Integer> regnums, List<String> names) {
            super(5);
            this.offset = offset;
            this.regnums = regnums;
            this.names = names;
        }

        public DebugRegisters(InputStream is) throws IOException {
            super(5);
            this.offset = SWD.readUI32(is);
            int size = SWD.readUI8(is);
            for (int i = 0; i < size; ++i) {
                this.regnums.add(SWD.readUI8(is));
                this.names.add(SWD.readString(is));
            }
        }

        @Override
        protected void writeTo(OutputStream os) throws IOException {
            SWD.writeUI32(os, this.offset);
            SWD.writeUI8(os, this.regnums.size());
            for (int i = 0; i < this.regnums.size(); ++i) {
                SWD.writeUI8(os, this.regnums.get(i));
                SWD.writeString(os, this.names.get(i));
            }
        }
    }

    public static class DebugOffset
    extends DebugItem {
        public int module;
        public int line;
        public int offset;
        public static final int ID = 1;

        public String toString() {
            return "DebugOffset[module=" + this.module + ", line=" + this.line + ", offset=" + this.offset + "]";
        }

        public DebugOffset(InputStream is) throws IOException {
            super(1);
            this.module = SWD.readUI32(is);
            this.line = SWD.readUI32(is);
            this.offset = SWD.readUI32(is);
        }

        public DebugOffset() {
            super(1);
        }

        public DebugOffset(int id, int lineno, int offset) {
            super(1);
            this.module = id;
            this.line = lineno;
            this.offset = offset;
        }

        @Override
        protected void writeTo(OutputStream os) throws IOException {
            SWD.writeUI32(os, this.module);
            SWD.writeUI32(os, this.line);
            SWD.writeUI32(os, this.offset);
        }
    }

    public static class DebugScript
    extends DebugItem {
        public int module;
        public int bitmap;
        public String name;
        public String text;
        public static final int ID = 0;

        public String toString() {
            return "DebugScript[module=" + this.module + ",bitmap=" + this.bitmap + ",name=" + this.name + "]";
        }

        public DebugScript(InputStream is) throws IOException {
            super(0);
            this.module = SWD.readUI32(is);
            this.bitmap = SWD.readUI32(is);
            this.name = SWD.readString(is);
            this.text = SWD.readString(is);
        }

        public DebugScript(int id, int bitmap, String name, String text) {
            super(0);
            this.module = id;
            this.bitmap = bitmap;
            this.name = name;
            this.text = text;
        }

        public DebugScript() {
            super(0);
        }

        @Override
        protected void writeTo(OutputStream os) throws IOException {
            SWD.writeUI32(os, this.module);
            SWD.writeUI32(os, this.bitmap);
            SWD.writeString(os, this.name);
            SWD.writeString(os, this.text);
        }
    }

    public static abstract class DebugItem {
        public final int tagId;

        public DebugItem(int tagId) {
            this.tagId = tagId;
        }

        protected abstract void writeTo(OutputStream var1) throws IOException;

        public byte[] getBytes() {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                SWD.writeUI32(baos, this.tagId);
                this.writeTo(baos);
                return baos.toByteArray();
            }
            catch (IOException ex) {
                return null;
            }
        }
    }
}

