/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.tagtree;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.ReplaceCharacterDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.tagtree.TagIdClassMap;
import com.jpexs.decompiler.flash.gui.tagtree.TagTree;
import com.jpexs.decompiler.flash.gui.tagtree.TagTreeModel;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.FolderItem;
import com.jpexs.decompiler.flash.treeitems.SWFList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.helpers.Helper;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class TagTreeContextMenu
extends JPopupMenu {
    private static final Logger logger = Logger.getLogger(TagTreeContextMenu.class.getName());
    private final MainPanel mainPanel;
    private final TagTree tagTree;
    private JMenuItem expandRecursiveMenuItem;
    private JMenuItem removeMenuItem;
    private JMenuItem removeWithDependenciesMenuItem;
    private JMenuItem undoTagMenuItem;
    private JMenuItem exportSelectionMenuItem;
    private JMenuItem replaceMenuItem;
    private JMenuItem replaceNoFillMenuItem;
    private JMenuItem replaceWithTagMenuItem;
    private JMenuItem rawEditMenuItem;
    private JMenuItem jumpToCharacterMenuItem;
    private JMenuItem exportJavaSourceMenuItem;
    private JMenuItem exportSwfXmlMenuItem;
    private JMenuItem importSwfXmlMenuItem;
    private JMenuItem closeMenuItem;
    private JMenu addTagMenu;
    private JMenu moveTagMenu;
    private JMenu copyTagMenu;
    private JMenu copyTagWithDependenciesMenu;
    private JMenuItem openSWFInsideTagMenuItem;

    public TagTreeContextMenu(final TagTree tagTree, MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.tagTree = tagTree;
        this.expandRecursiveMenuItem = new JMenuItem(mainPanel.translate("contextmenu.expandAll"));
        this.expandRecursiveMenuItem.addActionListener(this::expandRecursiveActionPerformed);
        this.add(this.expandRecursiveMenuItem);
        this.removeMenuItem = new JMenuItem(mainPanel.translate("contextmenu.remove"));
        this.removeMenuItem.addActionListener(e -> this.removeItemActionPerformed(e, false));
        this.add(this.removeMenuItem);
        this.removeWithDependenciesMenuItem = new JMenuItem(mainPanel.translate("contextmenu.removeWithDependencies"));
        this.removeWithDependenciesMenuItem.addActionListener(e -> this.removeItemActionPerformed(e, true));
        this.add(this.removeWithDependenciesMenuItem);
        this.undoTagMenuItem = new JMenuItem(mainPanel.translate("contextmenu.undo"));
        this.undoTagMenuItem.addActionListener(this::undoTagActionPerformed);
        this.add(this.undoTagMenuItem);
        this.exportSelectionMenuItem = new JMenuItem(mainPanel.translate("menu.file.export.selection"));
        this.exportSelectionMenuItem.addActionListener(mainPanel::exportSelectionActionPerformed);
        this.add(this.exportSelectionMenuItem);
        this.replaceMenuItem = new JMenuItem(mainPanel.translate("button.replace"));
        this.replaceMenuItem.addActionListener(mainPanel::replaceButtonActionPerformed);
        this.add(this.replaceMenuItem);
        this.replaceNoFillMenuItem = new JMenuItem(mainPanel.translate("button.replaceNoFill"));
        this.replaceNoFillMenuItem.addActionListener(mainPanel::replaceNoFillButtonActionPerformed);
        this.add(this.replaceNoFillMenuItem);
        this.replaceWithTagMenuItem = new JMenuItem(mainPanel.translate("button.replaceWithTag"));
        this.replaceWithTagMenuItem.addActionListener(this::replaceWithTagActionPerformed);
        this.add(this.replaceWithTagMenuItem);
        this.rawEditMenuItem = new JMenuItem(mainPanel.translate("contextmenu.rawEdit"));
        this.rawEditMenuItem.addActionListener(this::rawEditActionPerformed);
        this.add(this.rawEditMenuItem);
        this.jumpToCharacterMenuItem = new JMenuItem(mainPanel.translate("contextmenu.jumpToCharacter"));
        this.jumpToCharacterMenuItem.addActionListener(this::jumpToCharacterActionPerformed);
        this.add(this.jumpToCharacterMenuItem);
        this.exportJavaSourceMenuItem = new JMenuItem(mainPanel.translate("contextmenu.exportJavaSource"));
        this.exportJavaSourceMenuItem.addActionListener(mainPanel::exportJavaSourceActionPerformed);
        this.add(this.exportJavaSourceMenuItem);
        this.exportSwfXmlMenuItem = new JMenuItem(mainPanel.translate("contextmenu.exportSwfXml"));
        this.exportSwfXmlMenuItem.addActionListener(mainPanel::exportSwfXmlActionPerformed);
        this.add(this.exportSwfXmlMenuItem);
        this.importSwfXmlMenuItem = new JMenuItem(mainPanel.translate("contextmenu.importSwfXml"));
        this.importSwfXmlMenuItem.addActionListener(mainPanel::importSwfXmlActionPerformed);
        this.add(this.importSwfXmlMenuItem);
        this.closeMenuItem = new JMenuItem(mainPanel.translate("contextmenu.closeSwf"));
        this.closeMenuItem.addActionListener(this::closeSwfActionPerformed);
        this.add(this.closeMenuItem);
        this.addTagMenu = new JMenu(mainPanel.translate("contextmenu.addTag"));
        this.add(this.addTagMenu);
        this.moveTagMenu = new JMenu(mainPanel.translate("contextmenu.moveTag"));
        this.add(this.moveTagMenu);
        this.copyTagMenu = new JMenu(mainPanel.translate("contextmenu.copyTag"));
        this.add(this.copyTagMenu);
        this.copyTagWithDependenciesMenu = new JMenu(mainPanel.translate("contextmenu.copyTagWithDependencies"));
        this.add(this.copyTagWithDependenciesMenu);
        this.openSWFInsideTagMenuItem = new JMenuItem(mainPanel.translate("contextmenu.openswfinside"));
        this.add(this.openSWFInsideTagMenuItem);
        this.openSWFInsideTagMenuItem.addActionListener(this::openSwfInsideActionPerformed);
        tagTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    TreePath[] paths;
                    int row = tagTree.getClosestRowForLocation(e.getX(), e.getY());
                    int[] selectionRows = tagTree.getSelectionRows();
                    if (!Helper.contains((int[])selectionRows, (int)row)) {
                        tagTree.setSelectionRow(row);
                    }
                    if ((paths = tagTree.getSelectionPaths()) == null || paths.length == 0) {
                        return;
                    }
                    ArrayList<TreeItem> li = new ArrayList<TreeItem>();
                    for (TreePath treePath : paths) {
                        TreeItem item = (TreeItem)treePath.getLastPathComponent();
                        li.add(item);
                    }
                    TagTreeContextMenu.this.update(li);
                    TagTreeContextMenu.this.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void update(List<TreeItem> items) {
        void var7_24;
        boolean singleSelect;
        boolean bl;
        boolean bl2;
        if (items.isEmpty()) {
            return;
        }
        List<SWFList> swfs = this.mainPanel.getSwfs();
        boolean allSelectedIsTagOrFrame = true;
        for (TreeItem treeItem : items) {
            Tag tag;
            if (treeItem instanceof Tag || treeItem instanceof Frame || treeItem instanceof TagScript && ((tag = ((TagScript)treeItem).getTag()) instanceof DoActionTag || tag instanceof DoInitActionTag)) continue;
            allSelectedIsTagOrFrame = false;
            break;
        }
        boolean allSelectedIsTag = true;
        for (TreeItem treeItem : items) {
            Tag tag;
            if (treeItem instanceof Tag || treeItem instanceof TagScript && ((tag = ((TagScript)treeItem).getTag()) instanceof DoActionTag || tag instanceof DoInitActionTag)) continue;
            allSelectedIsTag = false;
            break;
        }
        boolean bl3 = true;
        for (TreeItem treeItem : items) {
            if (treeItem instanceof DefineBinaryDataTag) continue;
            bl2 = false;
            break;
        }
        boolean bl4 = true;
        for (TreeItem item : items) {
            if (!(item instanceof SWF) && !(item instanceof SWFList)) {
                bl = false;
                break;
            }
            if (!(item instanceof SWF)) continue;
            SWF swf = (SWF)item;
            if (swf.swfList == null || !swf.swfList.isBundle()) continue;
            boolean bl5 = false;
        }
        boolean bl6 = true;
        SWF singleSwf = null;
        for (TreeItem treeItem : items) {
            if (treeItem instanceof SWFList) {
                boolean bl7 = false;
                break;
            }
            if (singleSwf == null) {
                singleSwf = treeItem.getSwf();
                continue;
            }
            if (singleSwf == treeItem.getSwf()) continue;
            boolean bl8 = false;
            break;
        }
        this.expandRecursiveMenuItem.setVisible(false);
        this.removeMenuItem.setVisible(allSelectedIsTagOrFrame);
        this.removeWithDependenciesMenuItem.setVisible(allSelectedIsTagOrFrame);
        this.undoTagMenuItem.setVisible(allSelectedIsTag);
        this.exportSelectionMenuItem.setEnabled(this.tagTree.hasExportableNodes());
        this.replaceMenuItem.setVisible(false);
        this.replaceNoFillMenuItem.setVisible(false);
        this.replaceWithTagMenuItem.setVisible(false);
        this.rawEditMenuItem.setVisible(false);
        this.jumpToCharacterMenuItem.setVisible(false);
        this.exportJavaSourceMenuItem.setVisible(bl);
        this.exportSwfXmlMenuItem.setVisible(bl);
        this.importSwfXmlMenuItem.setVisible(bl);
        this.closeMenuItem.setVisible(bl);
        this.addTagMenu.setVisible(false);
        this.moveTagMenu.setVisible(false);
        this.copyTagMenu.setVisible(false);
        this.copyTagWithDependenciesMenu.setVisible(false);
        this.openSWFInsideTagMenuItem.setVisible(false);
        if (allSelectedIsTag) {
            boolean canUndo = false;
            for (TreeItem item : items) {
                Tag tag;
                if (!(item instanceof Tag) || !(tag = (Tag)item).canUndo()) continue;
                canUndo = true;
                break;
            }
            this.undoTagMenuItem.setEnabled(canUndo);
        }
        boolean bl9 = singleSelect = items.size() == 1;
        if (singleSelect) {
            List<Integer> allowedTagTypes;
            TreeItem treeItem = items.get(0);
            if (treeItem instanceof CharacterTag) {
                this.replaceWithTagMenuItem.setVisible(true);
            }
            if (treeItem instanceof ImageTag && ((ImageTag)treeItem).importSupported()) {
                this.replaceMenuItem.setVisible(true);
            }
            if (treeItem instanceof ShapeTag) {
                this.replaceMenuItem.setVisible(true);
                this.replaceNoFillMenuItem.setVisible(true);
            }
            if (treeItem instanceof DefineBinaryDataTag) {
                this.replaceMenuItem.setVisible(true);
            }
            if (treeItem instanceof DefineSoundTag) {
                this.replaceMenuItem.setVisible(true);
            }
            this.addTagMenu.removeAll();
            if (treeItem instanceof FolderItem) {
                FolderItem folderItem = (FolderItem)treeItem;
                SWF swf = treeItem.getSwf();
                if (folderItem.getName().equals("others")) {
                    TagTreeModel ttm = this.tagTree.getModel();
                    for (FolderItem emptyFolder : ttm.getEmptyFolders(swf)) {
                        JMenu subMenu = new JMenu(emptyFolder.toString());
                        allowedTagTypes = this.tagTree.getSwfFolderItemNestedTagIds(emptyFolder.getName(), swf.gfx);
                        this.addAddTagMenuItems(allowedTagTypes, subMenu, treeItem);
                        if (subMenu.getItemCount() <= 0) continue;
                        this.addTagMenu.add(subMenu);
                    }
                }
                allowedTagTypes = this.tagTree.getSwfFolderItemNestedTagIds(folderItem.getName(), swf.gfx);
                this.addAddTagMenuItems(allowedTagTypes, this.addTagMenu, treeItem);
            } else if (treeItem instanceof Tag) {
                allowedTagTypes = this.tagTree.getNestedTagIds((Tag)treeItem);
                this.addAddTagMenuItems(allowedTagTypes, this.addTagMenu, treeItem);
            } else if (treeItem instanceof Frame) {
                allowedTagTypes = this.tagTree.getFrameNestedTagIds();
                this.addAddTagMenuItems(allowedTagTypes, this.addTagMenu, treeItem);
            }
            this.addTagMenu.setVisible(this.addTagMenu.getItemCount() > 0);
            if (this.tagTree.getModel().getChildCount(treeItem) > 0) {
                this.expandRecursiveMenuItem.setVisible(true);
            }
            if (treeItem instanceof CharacterIdTag && !(treeItem instanceof CharacterTag)) {
                this.jumpToCharacterMenuItem.setVisible(true);
            }
            if (treeItem instanceof Tag) {
                this.rawEditMenuItem.setVisible(true);
            }
        }
        if (var7_24 != false && allSelectedIsTag && swfs.size() > 1) {
            this.moveTagMenu.removeAll();
            this.copyTagMenu.removeAll();
            this.copyTagWithDependenciesMenu.removeAll();
            for (SWFList targetSwfList : swfs) {
                for (SWF targetSwf : targetSwfList) {
                    if (targetSwf == singleSwf) continue;
                    JMenuItem swfItem = new JMenuItem(targetSwf.getShortFileName());
                    swfItem.addActionListener(ae -> this.moveTagActionPerformed(ae, items, targetSwf));
                    this.moveTagMenu.add(swfItem);
                    swfItem = new JMenuItem(targetSwf.getShortFileName());
                    swfItem.addActionListener(ae -> this.copyTagActionPerformed(ae, items, targetSwf));
                    this.copyTagMenu.add(swfItem);
                    swfItem = new JMenuItem(targetSwf.getShortFileName());
                    swfItem.addActionListener(ae -> this.copyTagWithDependenciesActionPerformed(ae, items, targetSwf));
                    this.copyTagWithDependenciesMenu.add(swfItem);
                }
            }
            this.moveTagMenu.setVisible(true);
            this.copyTagMenu.setVisible(true);
            this.copyTagWithDependenciesMenu.setVisible(true);
        }
        if (bl2) {
            boolean bl10;
            boolean bl11 = false;
            for (TreeItem item : items) {
                DefineBinaryDataTag binary = (DefineBinaryDataTag)item;
                if (binary.innerSwf != null || !binary.isSwfData()) continue;
                bl10 = true;
            }
            this.openSWFInsideTagMenuItem.setVisible(bl10);
        }
        for (TreeItem item : items) {
            if (!(item instanceof Tag) || !((Tag)item).isReadOnly()) continue;
            this.removeMenuItem.setVisible(false);
            this.removeWithDependenciesMenuItem.setVisible(false);
            this.undoTagMenuItem.setVisible(false);
            this.replaceMenuItem.setVisible(false);
            this.replaceNoFillMenuItem.setVisible(false);
            this.replaceWithTagMenuItem.setVisible(false);
            this.rawEditMenuItem.setVisible(false);
            this.jumpToCharacterMenuItem.setVisible(false);
            this.importSwfXmlMenuItem.setVisible(false);
            this.addTagMenu.setVisible(false);
            this.moveTagMenu.setVisible(false);
            this.openSWFInsideTagMenuItem.setVisible(false);
        }
    }

    private void addAddTagMenuItems(List<Integer> allowedTagTypes, JMenu addTagMenu, TreeItem item) {
        if (allowedTagTypes == null) {
            return;
        }
        for (Integer tagId : allowedTagTypes) {
            Class<?> cl = TagIdClassMap.getClassByTagId(tagId);
            JMenuItem tagItem = new JMenuItem(cl.getSimpleName());
            tagItem.addActionListener(ae -> this.addTagActionPerformed(ae, item, cl));
            addTagMenu.add(tagItem);
        }
    }

    private void addTagActionPerformed(ActionEvent evt, TreeItem firstItem, Class<?> cl) {
        try {
            SWF swf = firstItem.getSwf();
            Tag t = (Tag)cl.getDeclaredConstructor(SWF.class).newInstance(swf);
            swf.addTag(t, firstItem);
            swf.updateCharacters();
            this.mainPanel.refreshTree(swf);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private int chechUniqueCharacterId(Tag tag) {
        if (tag instanceof CharacterTag) {
            CharacterTag characterTag = (CharacterTag)tag;
            int characterId = characterTag.getCharacterId();
            SWF swf = tag.getSwf();
            if (swf.getCharacter(characterId) != null) {
                int newCharacterId = swf.getNextCharacterId();
                characterTag.setCharacterId(newCharacterId);
                logger.log(Level.WARNING, "Target SWF already contained chatacter tag with id = {0} => id changed to {1}", new Object[]{characterId, newCharacterId});
                return newCharacterId;
            }
            return characterId;
        }
        return -1;
    }

    private void moveTagActionPerformed(ActionEvent evt, List<TreeItem> items, SWF targetSwf) {
        SWF sourceSwf = items.get(0).getSwf();
        for (TreeItem item : items) {
            Tag tag = (Tag)item;
            sourceSwf.removeTag(tag);
            tag.setSwf(targetSwf, true);
            targetSwf.addTag(tag);
            this.chechUniqueCharacterId(tag);
            targetSwf.updateCharacters();
            tag.setModified(true);
        }
        sourceSwf.assignExportNamesToSymbols();
        targetSwf.assignExportNamesToSymbols();
        sourceSwf.assignClassesToSymbols();
        targetSwf.assignClassesToSymbols();
        sourceSwf.clearImageCache();
        targetSwf.clearImageCache();
        sourceSwf.updateCharacters();
        targetSwf.updateCharacters();
        sourceSwf.resetTimelines((Timelined)sourceSwf);
        targetSwf.resetTimelines((Timelined)targetSwf);
        this.mainPanel.refreshTree(new SWF[]{sourceSwf, targetSwf});
    }

    private void copyTagActionPerformed(ActionEvent evt, List<TreeItem> items, SWF targetSwf) {
        try {
            for (TreeItem item : items) {
                Tag tag = (Tag)item;
                Tag copyTag = tag.cloneTag();
                copyTag.setSwf(targetSwf, true);
                targetSwf.addTag(copyTag);
                this.chechUniqueCharacterId(copyTag);
                targetSwf.updateCharacters();
                copyTag.setModified(true);
            }
            targetSwf.assignExportNamesToSymbols();
            targetSwf.assignClassesToSymbols();
            targetSwf.clearImageCache();
            targetSwf.updateCharacters();
            this.mainPanel.refreshTree(targetSwf);
        }
        catch (IOException | InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void copyTagWithDependenciesActionPerformed(ActionEvent evt, List<TreeItem> items, SWF targetSwf) {
        try {
            SWF sourceSwf = items.get(0).getSwf();
            for (TreeItem item : items) {
                Tag copyTag;
                HashSet<Object> copiedTags = new HashSet<Object>();
                HashSet<Tag> newTags = new HashSet<Tag>();
                LinkedHashSet needed = new LinkedHashSet();
                HashMap<Integer, Integer> changedCharacterIds = new HashMap<Integer, Integer>();
                Tag tag = (Tag)item;
                tag.getNeededCharactersDeep(needed);
                ArrayList<Integer> neededList = new ArrayList<Integer>();
                for (Integer characterId : needed) {
                    neededList.add(characterId);
                }
                for (int i = neededList.size() - 1; i >= 0; --i) {
                    int characterId = (Integer)neededList.get(i);
                    CharacterTag neededTag = sourceSwf.getCharacter(characterId);
                    if (copiedTags.contains(neededTag)) continue;
                    copyTag = neededTag.cloneTag();
                    copyTag.setSwf(targetSwf, true);
                    targetSwf.addTag(copyTag);
                    int oldCharacterId = neededTag.getCharacterId();
                    int newCharacterId = this.chechUniqueCharacterId(copyTag);
                    changedCharacterIds.put(oldCharacterId, newCharacterId);
                    targetSwf.updateCharacters();
                    targetSwf.getCharacters();
                    copyTag.setModified(true);
                    copiedTags.add(neededTag);
                    newTags.add(copyTag);
                }
                copyTag = tag.cloneTag();
                copyTag.setSwf(targetSwf, true);
                targetSwf.addTag(copyTag);
                if (tag instanceof CharacterTag) {
                    CharacterTag characterTag = (CharacterTag)copyTag;
                    int oldCharacterId = characterTag.getCharacterId();
                    int newCharacterId = this.chechUniqueCharacterId(copyTag);
                    changedCharacterIds.put(oldCharacterId, newCharacterId);
                }
                targetSwf.updateCharacters();
                targetSwf.getCharacters();
                copyTag.setModified(true);
                copiedTags.add(tag);
                newTags.add(copyTag);
                Iterator<Object> iterator = changedCharacterIds.keySet().iterator();
                while (iterator.hasNext()) {
                    int oldCharacterId = (Integer)iterator.next();
                    int newCharacterId = (Integer)changedCharacterIds.get(oldCharacterId);
                    for (Tag newTag : newTags) {
                        newTag.replaceCharacter(oldCharacterId, newCharacterId);
                    }
                }
            }
            targetSwf.assignExportNamesToSymbols();
            targetSwf.assignClassesToSymbols();
            targetSwf.clearImageCache();
            targetSwf.updateCharacters();
            this.mainPanel.refreshTree(targetSwf);
        }
        catch (IOException | InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void openSwfInsideActionPerformed(ActionEvent evt) {
        List<TreeItem> sel = this.tagTree.getSelected();
        ArrayList<DefineBinaryDataTag> binaryDatas = new ArrayList<DefineBinaryDataTag>();
        for (TreeItem item : sel) {
            DefineBinaryDataTag binaryData = (DefineBinaryDataTag)item;
            if (!binaryData.isSwfData()) continue;
            binaryDatas.add((DefineBinaryDataTag)item);
        }
        this.mainPanel.loadFromBinaryTag(binaryDatas);
    }

    private void replaceWithTagActionPerformed(ActionEvent evt) {
        CharacterTag characterTag;
        int characterId;
        TreeItem itemr = this.tagTree.getCurrentTreeItem();
        if (itemr == null) {
            return;
        }
        ReplaceCharacterDialog replaceCharacterDialog = new ReplaceCharacterDialog();
        SWF swf = itemr.getSwf();
        if (replaceCharacterDialog.showDialog(swf, characterId = (characterTag = (CharacterTag)itemr).getCharacterId()) == 0) {
            int newCharacterId = replaceCharacterDialog.getCharacterId();
            swf.replaceCharacterTags(characterTag, newCharacterId);
            this.mainPanel.refreshTree(swf);
        }
    }

    private void rawEditActionPerformed(ActionEvent evt) {
        TreeItem itemr = this.tagTree.getCurrentTreeItem();
        if (itemr == null) {
            return;
        }
        this.mainPanel.showGenericTag((Tag)itemr);
    }

    private void jumpToCharacterActionPerformed(ActionEvent evt) {
        TreeItem itemj = this.tagTree.getCurrentTreeItem();
        if (itemj == null || !(itemj instanceof CharacterIdTag)) {
            return;
        }
        CharacterIdTag characterIdTag = (CharacterIdTag)itemj;
        this.mainPanel.setTagTreeSelectedNode((TreeItem)itemj.getSwf().getCharacter(characterIdTag.getCharacterId()));
    }

    private void expandRecursiveActionPerformed(ActionEvent evt) {
        TreePath path = this.tagTree.getSelectionPath();
        if (path == null) {
            return;
        }
        View.expandTreeNodes(this.tagTree, path, true);
    }

    private void removeItemActionPerformed(ActionEvent evt, boolean removeDependencies) {
        List<TreeItem> sel = this.tagTree.getSelected();
        ArrayList<Object> tagsToRemove = new ArrayList<Object>();
        for (TreeItem item : sel) {
            if (item instanceof Tag) {
                tagsToRemove.add((Tag)item);
                continue;
            }
            if (item instanceof TagScript) {
                tagsToRemove.add(((TagScript)item).getTag());
                continue;
            }
            if (!(item instanceof Frame)) continue;
            Frame frameNode = (Frame)item;
            Frame frame = frameNode.timeline.getFrame(frameNode.frame);
            if (frame.showFrameTag != null) {
                tagsToRemove.add(frame.showFrameTag);
                continue;
            }
            tagsToRemove.addAll(frame.innerTags);
        }
        if (tagsToRemove.size() > 0) {
            String confirmationMessage;
            if (tagsToRemove.size() == 1) {
                Tag tag = (Tag)tagsToRemove.get(0);
                confirmationMessage = this.mainPanel.translate("message.confirm.remove").replace("%item%", tag.toString());
            } else {
                confirmationMessage = this.mainPanel.translate("message.confirm.removemultiple").replace("%count%", Integer.toString(tagsToRemove.size()));
            }
            if (View.showConfirmDialog(this, confirmationMessage, this.mainPanel.translate("message.confirm"), 0, 3) == 0) {
                HashMap tagsToRemoveBySwf = new HashMap();
                for (Tag tag : tagsToRemove) {
                    SWF swf = tag.getSwf();
                    if (!tagsToRemoveBySwf.containsKey(swf)) {
                        tagsToRemoveBySwf.put(swf, new ArrayList());
                    }
                    ((List)tagsToRemoveBySwf.get(swf)).add(tag);
                }
                for (SWF sWF : tagsToRemoveBySwf.keySet()) {
                    sWF.removeTags((Collection)tagsToRemoveBySwf.get(sWF), removeDependencies);
                }
                this.mainPanel.refreshTree();
            }
        }
    }

    private void undoTagActionPerformed(ActionEvent evt) {
        List<TreeItem> sel = this.tagTree.getSelected();
        for (TreeItem item : sel) {
            if (!(item instanceof Tag)) continue;
            try {
                Tag tag = (Tag)item;
                tag.undo();
                tag.getSwf().clearAllCache();
                this.tagTree.getModel().updateNode(item);
            }
            catch (IOException | InterruptedException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        this.mainPanel.repaintTree();
    }

    private void closeSwfActionPerformed(ActionEvent evt) {
        List<TreeItem> sel = this.tagTree.getSelected();
        for (TreeItem item : sel) {
            if (item instanceof SWF) {
                SWF swf = (SWF)item;
                if (swf.binaryData != null) {
                    swf.binaryData.innerSwf = null;
                    swf.clearTagSwfs();
                    this.mainPanel.refreshTree();
                    continue;
                }
                Main.closeFile(swf.swfList);
                continue;
            }
            if (!(item instanceof SWFList)) continue;
            Main.closeFile((SWFList)item);
        }
    }
}

