/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.tagtree;

import com.jpexs.decompiler.flash.SWC;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.ZippedSWFBundle;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.TreeNodeType;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.tagtree.TagTreeContextMenu;
import com.jpexs.decompiler.flash.gui.tagtree.TagTreeModel;
import com.jpexs.decompiler.flash.iggy.conversion.IggySwfBundle;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineButton2Tag;
import com.jpexs.decompiler.flash.tags.DefineButtonTag;
import com.jpexs.decompiler.flash.tags.DefineFont2Tag;
import com.jpexs.decompiler.flash.tags.DefineFont3Tag;
import com.jpexs.decompiler.flash.tags.DefineFont4Tag;
import com.jpexs.decompiler.flash.tags.DefineFontTag;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.FileAttributesTag;
import com.jpexs.decompiler.flash.tags.MetadataTag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.SoundStreamHead2Tag;
import com.jpexs.decompiler.flash.tags.SoundStreamHeadTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RemoveTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.SymbolClassTypeTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.gfx.DefineCompactedFont;
import com.jpexs.decompiler.flash.timeline.AS2Package;
import com.jpexs.decompiler.flash.timeline.AS3Package;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.FrameScript;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import com.jpexs.decompiler.flash.treeitems.FolderItem;
import com.jpexs.decompiler.flash.treeitems.HeaderItem;
import com.jpexs.decompiler.flash.treeitems.SWFList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class TagTree
extends JTree {
    public TagTreeContextMenu contextPopupMenu;
    private final MainPanel mainPanel;
    private static final Map<TreeNodeType, Icon> ICONS = new HashMap<TreeNodeType, Icon>();

    public static Icon getIconForType(TreeNodeType t) {
        return ICONS.get((Object)t);
    }

    public TagTree(TagTreeModel treeModel, MainPanel mainPanel) {
        super(treeModel);
        this.mainPanel = mainPanel;
        this.setCellRenderer(new TagTreeCellRenderer());
        this.setRootVisible(false);
        this.setBackground(Color.white);
        this.setRowHeight(Math.max(this.getFont().getSize() + 5, 16));
        this.setLargeModel(true);
        this.setUI(new BasicTreeUI(){
            {
                this.setHashColor(Color.gray);
            }
        });
    }

    public void createContextMenu() {
        this.contextPopupMenu = new TagTreeContextMenu(this, this.mainPanel);
    }

    public static TreeNodeType getTreeNodeType(TreeItem t) {
        SWFList slist;
        if (t instanceof TagScript) {
            t = ((TagScript)t).getTag();
        }
        if (t instanceof HeaderItem) {
            return TreeNodeType.HEADER;
        }
        if (t instanceof DefineFontTag || t instanceof DefineFont2Tag || t instanceof DefineFont3Tag || t instanceof DefineFont4Tag || t instanceof DefineCompactedFont) {
            return TreeNodeType.FONT;
        }
        if (t instanceof TextTag) {
            return TreeNodeType.TEXT;
        }
        if (t instanceof ImageTag) {
            return TreeNodeType.IMAGE;
        }
        if (t instanceof ShapeTag) {
            return TreeNodeType.SHAPE;
        }
        if (t instanceof MorphShapeTag) {
            return TreeNodeType.MORPH_SHAPE;
        }
        if (t instanceof DefineSpriteTag) {
            return TreeNodeType.SPRITE;
        }
        if (t instanceof ButtonTag) {
            return TreeNodeType.BUTTON;
        }
        if (t instanceof DefineVideoStreamTag) {
            return TreeNodeType.MOVIE;
        }
        if (t instanceof DefineSoundTag || t instanceof SoundStreamHeadTag || t instanceof SoundStreamHead2Tag) {
            return TreeNodeType.SOUND;
        }
        if (t instanceof DefineBinaryDataTag) {
            return TreeNodeType.BINARY_DATA;
        }
        if (t instanceof ASMSource) {
            return TreeNodeType.AS;
        }
        if (t instanceof ScriptPack) {
            return TreeNodeType.AS;
        }
        if (t instanceof AS2Package) {
            return TreeNodeType.PACKAGE;
        }
        if (t instanceof AS3Package) {
            return TreeNodeType.PACKAGE;
        }
        if (t instanceof Frame || t instanceof FrameScript) {
            return TreeNodeType.FRAME;
        }
        if (t instanceof ShowFrameTag) {
            return TreeNodeType.SHOW_FRAME;
        }
        if (t instanceof SWF) {
            return TreeNodeType.FLASH;
        }
        if (t instanceof SWFList && (slist = (SWFList)t).isBundle()) {
            if (slist.bundle.getClass() == ZippedSWFBundle.class) {
                return TreeNodeType.BUNDLE_ZIP;
            }
            if (slist.bundle.getClass() == SWC.class) {
                return TreeNodeType.BUNDLE_SWC;
            }
            if (slist.bundle.getClass() == IggySwfBundle.class) {
                return TreeNodeType.BUNDLE_IGGY;
            }
            return TreeNodeType.BUNDLE_BINARY;
        }
        if (t instanceof SetBackgroundColorTag) {
            return TreeNodeType.SET_BACKGROUNDCOLOR;
        }
        if (t instanceof FileAttributesTag) {
            return TreeNodeType.FILE_ATTRIBUTES;
        }
        if (t instanceof MetadataTag) {
            return TreeNodeType.METADATA;
        }
        if (t instanceof PlaceObjectTypeTag) {
            return TreeNodeType.PLACE_OBJECT;
        }
        if (t instanceof RemoveTag) {
            return TreeNodeType.REMOVE_OBJECT;
        }
        if (t instanceof Tag) {
            return TreeNodeType.OTHER_TAG;
        }
        if (t instanceof FolderItem) {
            return TreeNodeType.FOLDER;
        }
        return TreeNodeType.FOLDER;
    }

    public List<Integer> getSwfFolderItemNestedTagIds(String folderName, boolean gfx) {
        List<Integer> ret = null;
        switch (folderName) {
            case "shapes": {
                ret = Arrays.asList(2, 22, 32, 83);
                break;
            }
            case "morphshapes": {
                ret = Arrays.asList(46, 84);
                break;
            }
            case "sprites": {
                ret = Arrays.asList(39);
                break;
            }
            case "texts": {
                ret = Arrays.asList(11, 33, 37);
                break;
            }
            case "images": {
                ret = Arrays.asList(6, 21, 35, 90, 20, 36);
                break;
            }
            case "movies": {
                ret = Arrays.asList(60);
                break;
            }
            case "sounds": {
                ret = Arrays.asList(14);
                break;
            }
            case "buttons": {
                ret = Arrays.asList(7, 34);
                break;
            }
            case "fonts": {
                if (gfx) {
                    ret = Arrays.asList(10, 48, 75, 91, 1005);
                    break;
                }
                ret = Arrays.asList(10, 48, 75, 91);
                break;
            }
            case "binaryData": {
                ret = Arrays.asList(87);
                break;
            }
            case "frames": {
                ret = Arrays.asList(4, 26, 70, 94, 5, 28, 1, 43, 15, 89, 61, 19, 18, 45, 78);
                break;
            }
            case "others": {
                ret = Arrays.asList(63, 86, 82, 72, 12, 59, 58, 64, 93, 56, 69, 57, 71, 8, 77, 41, 24, 65, 9, 66, 76);
            }
        }
        return ret;
    }

    public List<Integer> getFrameNestedTagIds() {
        return Arrays.asList(4, 26, 70, 94, 5, 28, 43, 15, 89, 61, 19, 18, 45);
    }

    public List<Integer> getNestedTagIds(Tag obj) {
        if (obj instanceof DefineSpriteTag) {
            return Arrays.asList(4, 26, 70, 94, 5, 28, 1, 43, 15, 89, 61, 19, 18, 45, 78);
        }
        if (obj instanceof FontTag) {
            return Arrays.asList(88, 73, 13, 62);
        }
        if (obj instanceof TextTag) {
            return Arrays.asList(74);
        }
        if (obj instanceof DefineButtonTag) {
            return Arrays.asList(23, 17, 78);
        }
        if (obj instanceof DefineButton2Tag) {
            return Arrays.asList(17, 78);
        }
        return null;
    }

    public boolean hasExportableNodes() {
        return !this.getSelection(this.mainPanel.getCurrentSwf()).isEmpty();
    }

    public void getAllSubs(TreeItem o, List<TreeItem> ret) {
        TagTreeModel tm = this.getModel();
        for (TreeItem treeItem : tm.getAllChildren(o)) {
            ret.add(treeItem);
            this.getAllSubs(treeItem, ret);
        }
    }

    public List<TreeItem> getAllSelected() {
        TreeSelectionModel tsm = this.getSelectionModel();
        TreePath[] tps = tsm.getSelectionPaths();
        ArrayList<TreeItem> ret = new ArrayList<TreeItem>();
        if (tps == null) {
            return ret;
        }
        for (TreePath tp : tps) {
            TreeItem treeNode = (TreeItem)tp.getLastPathComponent();
            ret.add(treeNode);
            this.getAllSubs(treeNode, ret);
        }
        return ret;
    }

    public List<TreeItem> getSelected() {
        if (!this.mainPanel.folderPreviewPanel.selectedItems.isEmpty()) {
            return new ArrayList<TreeItem>(this.mainPanel.folderPreviewPanel.selectedItems.values());
        }
        TreeSelectionModel tsm = this.getSelectionModel();
        TreePath[] tps = tsm.getSelectionPaths();
        ArrayList<TreeItem> ret = new ArrayList<TreeItem>();
        if (tps == null) {
            return ret;
        }
        for (TreePath tp : tps) {
            TreeItem treeNode = (TreeItem)tp.getLastPathComponent();
            ret.add(treeNode);
        }
        return ret;
    }

    public List<TreeItem> getSelection(SWF swf) {
        List<TreeItem> sel = this.mainPanel.folderPreviewPanel.selectedItems.isEmpty() ? this.getAllSelected() : new ArrayList<TreeItem>(this.mainPanel.folderPreviewPanel.selectedItems.values());
        return this.getSelection(swf, sel);
    }

    public List<TreeItem> getSelection(SWF swf, List<TreeItem> sel) {
        ArrayList<TreeItem> ret = new ArrayList<TreeItem>();
        for (TreeItem d : sel) {
            Tag tag;
            if (d instanceof SWFList || d.getSwf() != swf) continue;
            if (d instanceof TagScript && ((tag = ((TagScript)d).getTag()) instanceof DoActionTag || tag instanceof DoInitActionTag)) {
                d = tag;
            }
            if (d instanceof Tag || d instanceof ASMSource) {
                TreeNodeType nodeType = TagTree.getTreeNodeType(d);
                if (nodeType == TreeNodeType.IMAGE) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.SHAPE) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.MORPH_SHAPE) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.BUTTON) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.AS) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.MOVIE) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.SOUND) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.BINARY_DATA) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.TEXT) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.FONT) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.OTHER_TAG && d instanceof SymbolClassTypeTag) {
                    ret.add(d);
                }
            }
            if (d instanceof Frame) {
                ret.add(d);
            }
            if (!(d instanceof ScriptPack)) continue;
            ret.add(d);
        }
        return ret;
    }

    public List<AS3ClassTreeItem> getTagsWithType(List<AS3ClassTreeItem> list, TreeNodeType type) {
        ArrayList<AS3ClassTreeItem> ret = new ArrayList<AS3ClassTreeItem>();
        for (AS3ClassTreeItem item : list) {
            TreeNodeType ttype = TagTree.getTreeNodeType((TreeItem)item);
            if (type != ttype) continue;
            ret.add(item);
        }
        return ret;
    }

    public TreeItem getCurrentTreeItem() {
        if (!this.mainPanel.folderPreviewPanel.selectedItems.isEmpty()) {
            return this.mainPanel.folderPreviewPanel.selectedItems.entrySet().iterator().next().getValue();
        }
        TreeItem item = (TreeItem)this.getLastSelectedPathComponent();
        return item;
    }

    public void updateSwfs(SWF[] swfs) {
        TagTreeModel ttm = this.getModel();
        if (ttm != null) {
            List<List<String>> expandedNodes = View.getExpandedNodes(this);
            ttm.updateSwf(null);
            View.expandTreeNodes(this, expandedNodes);
        }
    }

    @Override
    public TagTreeModel getModel() {
        return (TagTreeModel)super.getModel();
    }

    public void expandRoot() {
        TagTreeModel ttm = this.getModel();
        TreeItem root = ttm.getRoot();
        this.expandPath(new TreePath(new Object[]{root}));
    }

    public void expandFirstLevelNodes() {
        TagTreeModel ttm = this.getModel();
        TreeItem root = ttm.getRoot();
        int childCount = ttm.getChildCount(root);
        for (int i = 0; i < childCount; ++i) {
            this.expandPath(new TreePath(new Object[]{root, ttm.getChild(root, i)}));
        }
    }

    public String getSelectionPathString() {
        StringBuilder sb = new StringBuilder();
        TreePath path = this.getSelectionPath();
        if (path != null) {
            boolean first = true;
            for (Object p : path.getPath()) {
                if (!first) {
                    sb.append("|");
                }
                first = false;
                sb.append(p.toString());
            }
        }
        return sb.toString();
    }

    public void setSelectionPathString(String pathStr) {
        String[] path;
        TreePath tp;
        if (pathStr != null && pathStr.length() > 0 && (tp = View.getTreePathByPathStrings(this, Arrays.asList(path = pathStr.split("\\|")))) != null) {
            this.mainPanel.setTagTreeSelectedNode((TreeItem)tp.getLastPathComponent());
        }
    }

    static {
        for (TreeNodeType treeNodeType : TreeNodeType.values()) {
            if (treeNodeType == TreeNodeType.UNKNOWN || treeNodeType == TreeNodeType.SHOW_FRAME) continue;
            String tagTypeStr = treeNodeType.toString().toLowerCase().replace("_", "");
            ICONS.put(treeNodeType, View.getIcon(tagTypeStr + "16"));
        }
    }

    public static class TagTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Font plainFont;
        private Font boldFont;

        public TagTreeCellRenderer() {
            this.setUI(new BasicLabelUI());
            this.setOpaque(false);
            this.setBackgroundNonSelectionColor(Color.white);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            boolean isModified;
            TreeItem val = (TreeItem)value;
            if (val != null && !(val instanceof SWFList) && val.getSwf() == null) {
                value = null;
            }
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (val == null) {
                return this;
            }
            TreeNodeType type = TagTree.getTreeNodeType(val);
            if (type == TreeNodeType.FOLDER && expanded) {
                type = TreeNodeType.FOLDER_OPEN;
            }
            if ((type == TreeNodeType.FOLDER || type == TreeNodeType.FOLDER_OPEN) && val instanceof FolderItem) {
                FolderItem si = (FolderItem)val;
                if (!"root".equals(si.getName())) {
                    String itemName = "folder" + si.getName();
                    this.setIcon(View.getIcon(itemName.toLowerCase() + "16"));
                }
            } else {
                this.setIcon((Icon)ICONS.get((Object)type));
            }
            boolean isReadOnly = false;
            if (val instanceof Tag) {
                isReadOnly = ((Tag)val).isReadOnly();
            }
            if (isModified = val.isModified()) {
                if (this.boldFont == null) {
                    Font font = this.getFont();
                    this.boldFont = font.deriveFont(1);
                }
            } else if (this.plainFont == null) {
                Font font = this.getFont();
                this.plainFont = font.deriveFont(0);
            }
            this.setFont(isModified ? this.boldFont : this.plainFont);
            if (isReadOnly) {
                this.setForeground(new Color(204, 204, 204));
            } else {
                this.setForeground(Color.BLACK);
            }
            return this;
        }
    }
}

