/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.hexview;

import com.jpexs.decompiler.flash.gui.hexview.HexViewListener;
import com.jpexs.decompiler.flash.gui.hexview.HexViewTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class HexView
extends JTable {
    private static final int bytesInRow = 16;
    private long[] highlightStarts;
    private long[] highlightEnds;
    private final String[] highlightColorsStr = new String[]{"29AEC2", "9AC88C", "DF5F80", "EEA32E", "FFD200", "5E9B4C", "D3E976", "A3AEC2"};
    private final Color[] highlightColors;
    private final Color bgColor = Color.decode("#F7F7F7");
    private final Color bgColorAlternate = Color.decode("#EDEDED");
    private int mouseOverIdx = -1;
    private int selectionStart = -1;
    private int selectionEnd = -1;
    private HexViewListener listener;

    public HexView() {
        super(new HexViewTableModel(16));
        int i;
        this.highlightColors = new Color[this.highlightColorsStr.length];
        for (int i2 = 0; i2 < this.highlightColors.length; ++i2) {
            this.highlightColors[i2] = Color.decode("#" + this.highlightColorsStr[i2]);
        }
        this.setBackground(Color.white);
        this.setFont(new Font("Monospaced", 0, 12));
        this.setTableHeader(new JTableHeader());
        this.setMaximumSize(new Dimension(200, 200));
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        HighlightCellRenderer cellRenderer = new HighlightCellRenderer();
        TableColumn column = this.columnModel.getColumn(0);
        column.setMaxWidth(80);
        for (i = 0; i < 16; ++i) {
            column = this.columnModel.getColumn(i + 1);
            column.setMaxWidth(25);
            column.setCellRenderer(cellRenderer);
        }
        column = this.columnModel.getColumn(17);
        column.setMaxWidth(10);
        for (i = 0; i < 16; ++i) {
            column = this.columnModel.getColumn(i + 16 + 1 + 1);
            column.setMaxWidth(10);
            column.setCellRenderer(cellRenderer);
        }
        this.addMouseListener(new HexViewMouseAdapter());
        this.addMouseMotionListener(new HexViewMouseMotionAdapter());
        ListSelectionModel rowSelModel = this.getSelectionModel();
        ListSelectionModel colSelModel = this.getColumnModel().getSelectionModel();
        HexViewSelectionListener selectionListener = new HexViewSelectionListener(this);
        rowSelModel.addListSelectionListener(selectionListener);
        colSelModel.addListSelectionListener(selectionListener);
    }

    @Override
    public HexViewTableModel getModel() {
        TableModel model = super.getModel();
        return (HexViewTableModel)model;
    }

    public void setData(byte[] data, long[] highlightStarts, long[] highlightEnds) {
        if (highlightStarts == null ^ highlightEnds == null) {
            throw new Error("highlightStarts and highlightEnds should be both null or not null.");
        }
        if (highlightStarts != null && highlightStarts.length != highlightEnds.length) {
            throw new Error("highlightStarts and highlightEnds should have the same number of elements.");
        }
        this.getModel().setData(data);
        this.highlightStarts = highlightStarts;
        this.highlightEnds = highlightEnds;
    }

    public byte[] getData() {
        return this.getModel().getData();
    }

    public void selectByte(long byteNum) {
        this.scrollToByte(byteNum);
        this.listener.byteValueChanged((int)byteNum, this.getData()[(int)byteNum]);
    }

    public void selectBytes(long byteNum, int length) {
        this.selectionStart = (int)byteNum;
        this.selectionEnd = (int)(byteNum + (long)length - 1L);
        this.scrollToByte(new long[]{byteNum}, new long[]{byteNum + (long)length - 1L});
        this.listener.byteValueChanged((int)byteNum, this.getData()[(int)byteNum]);
        this.getModel().fireTableDataChanged();
    }

    public void clearSelectedBytes() {
        this.selectionStart = -1;
        this.selectionEnd = -1;
        this.getModel().fireTableDataChanged();
    }

    public void scrollToByte(long byteNum) {
        int row = (int)(byteNum / 16L);
        this.getSelectionModel().setSelectionInterval(row, row);
        this.scrollRectToVisible(new Rectangle(this.getCellRect(row, 0, true)));
    }

    private int getIdxByColAndRow(int row, int col) {
        byte[] data;
        int idx = -1;
        if (row < 0 || col < 0) {
            return -1;
        }
        if (col > 0 && col != 17) {
            idx = row * 16 + (col > 17 ? col - 16 - 2 : col - 1);
        }
        if (idx >= (data = this.getModel().getData()).length) {
            idx = -1;
        }
        return idx;
    }

    public int getFocusedByteIdx() {
        int col = this.getSelectedColumn();
        int row = this.getSelectedRow();
        int idx = this.getIdxByColAndRow(row, col);
        return idx;
    }

    public void scrollToByte(long[] byteNumStarts, long[] byteNumEnds) {
        for (int i = 0; i < byteNumStarts.length; ++i) {
            this.scrollToByte(byteNumStarts[i]);
            this.scrollToByte(byteNumEnds[i]);
            this.scrollToByte(byteNumStarts[i]);
        }
    }

    public void addListener(HexViewListener listener) {
        this.listener = listener;
    }

    private class HexViewMouseMotionAdapter
    extends MouseMotionAdapter {
        private HexViewMouseMotionAdapter() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            HexView table = (HexView)e.getSource();
            Point point = e.getPoint();
            int col = table.columnAtPoint(point);
            int row = table.rowAtPoint(point);
            int idx = HexView.this.getIdxByColAndRow(row, col);
            HexView.this.mouseOverIdx = idx;
            HexView.this.getModel().fireTableCellUpdated(row, col);
            if (HexView.this.listener != null) {
                HexView.this.listener.byteMouseMoved(idx, idx == -1 ? (byte)0 : HexView.this.getModel().getData()[idx]);
            }
        }
    }

    private class HexViewMouseAdapter
    extends MouseAdapter {
        private HexViewMouseAdapter() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            HexView table = (HexView)e.getSource();
            Point point = e.getPoint();
            int col = table.columnAtPoint(point);
            int row = table.rowAtPoint(point);
            HexView.this.mouseOverIdx = -1;
            HexView.this.getModel().fireTableCellUpdated(row, col);
            if (HexView.this.listener != null) {
                HexView.this.listener.byteMouseMoved(-1, (byte)0);
            }
        }
    }

    private class HexViewSelectionListener
    implements ListSelectionListener {
        private final HexView table;

        public HexViewSelectionListener(HexView table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int col = this.table.getSelectedColumn();
            int row = this.table.getSelectedRow();
            int idx = HexView.this.getIdxByColAndRow(row, col);
            if (HexView.this.listener != null) {
                HexView.this.listener.byteValueChanged(idx, idx == -1 ? (byte)0 : HexView.this.getModel().getData()[idx]);
            }
        }
    }

    private class HighlightCellRenderer
    extends DefaultTableCellRenderer {
        public int byteIndex;

        private HighlightCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Color background;
            Color foreground;
            JLabel l = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            int level = -1;
            int idx = HexView.this.getIdxByColAndRow(row, col);
            if (HexView.this.highlightStarts != null) {
                this.byteIndex = idx;
                for (int i = 0; i < HexView.this.highlightStarts.length && HexView.this.highlightStarts[i] <= (long)idx && HexView.this.highlightEnds[i] >= (long)idx; ++i) {
                    ++level;
                }
            }
            if (level > -1) {
                foreground = Color.white;
                background = HexView.this.highlightColors[level % HexView.this.highlightColors.length];
            } else {
                foreground = Color.black;
                Color color = background = row % 2 == 0 ? HexView.this.bgColor : HexView.this.bgColorAlternate;
            }
            if (idx != -1 && (idx == HexView.this.mouseOverIdx || idx >= HexView.this.selectionStart && idx <= HexView.this.selectionEnd)) {
                foreground = new Color(255 - foreground.getRed(), 255 - foreground.getGreen(), 255 - foreground.getBlue());
                background = new Color(255 - background.getRed(), 255 - background.getGreen(), 255 - background.getBlue());
            }
            l.setForeground(foreground);
            l.setBackground(background);
            return l;
        }
    }
}

