/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.editor;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.editor.TextChangedListener;
import com.jpexs.helpers.Stopwatch;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import jsyntaxpane.SyntaxDocument;

public class UndoFixedEditorPane
extends JEditorPane {
    private static final Object setTextLock = new Object();
    private final List<TextChangedListener> textChangedListeners = new ArrayList<TextChangedListener>();
    private String originalContentType;
    private DocumentListener documentListener;

    public UndoFixedEditorPane() {
        this.addDocumentListener();
    }

    private void fireTextChanged() {
        for (TextChangedListener listener : this.textChangedListeners) {
            listener.textChanged();
        }
    }

    private void addDocumentListener() {
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                UndoFixedEditorPane.this.fireTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                UndoFixedEditorPane.this.fireTextChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                UndoFixedEditorPane.this.fireTextChanged();
            }
        };
        this.getDocument().addDocumentListener(this.documentListener);
    }

    private void removeDocumentListener() {
        this.getDocument().removeDocumentListener(this.documentListener);
    }

    public void changeContentType(String type) {
        if (!type.equals(this.getContentType())) {
            this.removeDocumentListener();
            Font oldFont = this.getFont();
            this.setContentType(type);
            this.setFont(oldFont);
            this.addDocumentListener();
        }
    }

    @Override
    public void setText(String t) {
        View.execInEventDispatch(() -> {
            this.removeDocumentListener();
            this.setText(t, this.getContentType());
            this.addDocumentListener();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setText(String t, String contentType) {
        Object object = setTextLock;
        synchronized (object) {
            if (t == null) {
                t = "";
            }
            if (!t.equals(this.getText())) {
                boolean plain;
                boolean bl = plain = t.length() > (Integer)Configuration.syntaxHighlightLimit.get();
                if (plain) {
                    contentType = "text/plain";
                    this.originalContentType = this.getContentType();
                    this.changeContentType(contentType);
                } else if (this.originalContentType != null) {
                    this.changeContentType(this.originalContentType);
                    this.originalContentType = null;
                }
                Stopwatch sw = Stopwatch.startNew();
                try {
                    StringReader r = new StringReader(t);
                    EditorKit kit = UndoFixedEditorPane.createEditorKitForContentType(contentType);
                    Document doc = kit.createDefaultDocument();
                    if (doc instanceof SyntaxDocument) {
                        ((SyntaxDocument)doc).setIgnoreUpdate(true);
                    }
                    kit.read(r, doc, 0);
                    if (doc instanceof SyntaxDocument) {
                        ((SyntaxDocument)doc).setIgnoreUpdate(false);
                    }
                    this.setDocument(doc);
                }
                catch (IOException | BadLocationException ex) {
                    Logger.getLogger(UndoFixedEditorPane.class.getName()).log(Level.SEVERE, null, ex);
                }
                sw.stop();
                if (!plain && sw.getElapsedMilliseconds() > 5000L) {
                    Logger.getLogger(UndoFixedEditorPane.class.getName()).log(Level.WARNING, "Syntax highlightig took long time. You can try to decrease the syntax highlight limit in advanced settings.");
                }
                this.clearUndos();
            }
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent ke) {
        if (!this.isEditable() && (ke.getKeyCode() == 69 && ke.isControlDown() || ke.getKeyCode() == 72 && ke.isControlDown())) {
            return;
        }
        super.processKeyEvent(ke);
    }

    public void clearUndos() {
        Document doc = this.getDocument();
        if (doc instanceof SyntaxDocument) {
            SyntaxDocument sdoc = (SyntaxDocument)doc;
            sdoc.clearUndos();
        }
    }

    public void addTextChangedListener(TextChangedListener l) {
        this.textChangedListeners.add(l);
    }

    public void removeTextChangedListener(TextChangedListener l) {
        this.textChangedListeners.remove(l);
    }
}

