/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.dumpview;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.dumpview.DumpInfo;
import com.jpexs.decompiler.flash.treeitems.SWFList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class DumpTreeModel
implements TreeModel {
    private final DumpInfo root;
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private final List<SWFList> swfs;

    public DumpTreeModel(List<SWFList> swfs) {
        this.swfs = swfs;
        this.root = new DumpInfo("root", "", null, 0L, 0L);
        this.updateSwfs();
    }

    public void updateSwfs() {
        this.root.getChildInfos().clear();
        for (SWFList swfList : this.swfs) {
            for (SWF swf : swfList) {
                swf.dumpInfo.name = swf.getFileTitle();
                this.root.getChildInfos().add(swf.dumpInfo);
            }
        }
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.root)));
    }

    private void fireTreeStructureChanged(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(e);
        }
    }

    private List<DumpInfo> searchDumpInfo(DumpInfo dumpInfo, DumpInfo parent, List<DumpInfo> path) {
        List<DumpInfo> ret = null;
        int cnt = this.getChildCount(parent);
        for (int i = 0; i < cnt; ++i) {
            DumpInfo n = this.getChild(parent, i);
            ArrayList<DumpInfo> newPath = new ArrayList<DumpInfo>();
            newPath.addAll(path);
            newPath.add(n);
            if (dumpInfo == n) {
                return newPath;
            }
            ret = this.searchDumpInfo(dumpInfo, n, newPath);
            if (ret == null) continue;
            return ret;
        }
        return ret;
    }

    public TreePath getDumpInfoPath(DumpInfo dumpInfo) {
        List<DumpInfo> path = new ArrayList<DumpInfo>();
        path.add(this.getRoot());
        path = this.searchDumpInfo(dumpInfo, this.getRoot(), path);
        if (path == null) {
            return null;
        }
        TreePath tp = new TreePath(path.toArray(new Object[path.size()]));
        return tp;
    }

    public DumpInfo getRoot() {
        return this.root;
    }

    public DumpInfo getChild(Object o, int i) {
        return (DumpInfo)((DumpInfo)o).getChildInfos().get(i);
    }

    @Override
    public int getChildCount(Object o) {
        DumpInfo di = (DumpInfo)o;
        di.resolveTag();
        return di.getChildCount();
    }

    @Override
    public boolean isLeaf(Object o) {
        DumpInfo di = (DumpInfo)o;
        return di.tagToResolve == null && di.getChildCount() == 0;
    }

    @Override
    public void valueForPathChanged(TreePath tp, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getIndexOfChild(Object o, Object o1) {
        return ((DumpInfo)o).getChildInfos().indexOf(o1);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }
}

