/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.controls;

import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Date;
import javax.swing.JSplitPane;

public class JPersistentSplitPane
extends JSplitPane {
    private ConfigurationItem<Double> config;
    private boolean painted = false;
    private Date resize = JPersistentSplitPane.getDateAfter(500);
    private ComponentListener childComponentListener;

    public JPersistentSplitPane(int newOrientation, ConfigurationItem<Double> config) {
        super(newOrientation);
        this.initialize(config);
    }

    public JPersistentSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent, ConfigurationItem<Double> config) {
        super(newOrientation, newLeftComponent, newRightComponent);
        this.initialize(config);
        newLeftComponent.addComponentListener(this.childComponentListener);
        newRightComponent.addComponentListener(this.childComponentListener);
    }

    private double getConfigValue(ConfigurationItem<Double> config) {
        double pos = (Double)config.get();
        if (pos < 0.0) {
            pos = 0.0;
        } else if (pos > 1.0) {
            pos = 1.0;
        }
        return pos;
    }

    private void initialize(final ConfigurationItem<Double> config) {
        this.config = config;
        double pos = this.getConfigValue(config);
        this.setDividerLocation(pos);
        this.setResizeWeight(pos);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JPersistentSplitPane.this.resize = JPersistentSplitPane.getDateAfter(500);
                double pos = JPersistentSplitPane.this.getConfigValue((ConfigurationItem<Double>)config);
                JPersistentSplitPane.this.setDividerLocation(pos);
                JPersistentSplitPane.this.setResizeWeight(pos);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                double pos = JPersistentSplitPane.this.getConfigValue((ConfigurationItem<Double>)config);
                JPersistentSplitPane.this.setDividerLocation(pos);
                JPersistentSplitPane.this.setResizeWeight(pos);
            }
        });
        this.childComponentListener = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                double pos = JPersistentSplitPane.this.getConfigValue((ConfigurationItem<Double>)config);
                JPersistentSplitPane.this.setDividerLocation(pos);
                JPersistentSplitPane.this.setResizeWeight(pos);
            }
        };
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                e.getChild().addComponentListener(JPersistentSplitPane.this.childComponentListener);
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                e.getChild().removeComponentListener(JPersistentSplitPane.this.childComponentListener);
            }
        });
        this.addPropertyChangeListener("dividerLocation", pce -> {
            if (!this.painted) {
                return;
            }
            long diff = new Date().getTime() - this.resize.getTime();
            if (diff < 0L) {
                this.resize = JPersistentSplitPane.getDateAfter(100);
                return;
            }
            if (this.getLeftComponent() != null && this.getRightComponent() != null && this.getLeftComponent().isVisible() && this.getRightComponent().isVisible()) {
                JPersistentSplitPane pane = (JPersistentSplitPane)pce.getSource();
                double size = (this.getOrientation() == 1 ? pane.getWidth() : pane.getHeight()) - pane.getDividerSize();
                if (size != 0.0) {
                    double p = (double)((Integer)pce.getNewValue()).intValue() / size;
                    this.setResizeWeight(p);
                    config.set((Object)p);
                }
            }
        });
    }

    @Override
    public void setSize(Dimension d) {
        this.resize = JPersistentSplitPane.getDateAfter(500);
        super.setSize(d);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.painted = true;
    }

    private static Date getDateAfter(int ms) {
        Date d = new Date();
        d.setTime(d.getTime() + (long)ms);
        return d;
    }
}

