/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.usages.InsideClassMultinameUsageInterface;
import com.jpexs.decompiler.flash.abc.usages.MethodMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.MultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.TraitMultinameUsage;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.abc.ABCPanel;
import com.jpexs.decompiler.flash.gui.abc.UsageListModel;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class UsageFrame
extends AppDialog
implements MouseListener {
    private final JButton gotoButton = new JButton(this.translate("button.goto"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private final JList usageList;
    private final UsageListModel usageListModel;
    private final ABCPanel abcPanel;

    public UsageFrame(ABC abc, int multinameIndex, ABCPanel abcPanel, boolean definitions) {
        super(abcPanel.getMainPanel().getMainFrame().getWindow());
        this.abcPanel = abcPanel;
        List usages = definitions ? abc.findMultinameDefinition(multinameIndex) : abc.findMultinameUsage(multinameIndex);
        Multiname m = abc.constants.getMultiname(multinameIndex);
        if (m.namespace_index > 0 && abc.constants.getNamespace((int)m.namespace_index).kind != 5) {
            for (ABCContainerTag at : abc.getAbcTags()) {
                int mid;
                ABC a = at.getABC();
                if (a == abc || (mid = a.constants.getMultinameId(m, false)) <= 0) continue;
                usages.addAll(definitions ? a.findMultinameDefinition(mid) : a.findMultinameUsage(mid));
            }
        }
        this.usageListModel = new UsageListModel();
        for (MultinameUsage u : usages) {
            this.usageListModel.addElement(u);
        }
        this.usageList = new JList<Object>(this.usageListModel);
        this.usageList.setBackground(Color.white);
        this.gotoButton.addActionListener(this::gotoButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout());
        buttonsPanel.add(this.gotoButton);
        buttonsPanel.add(this.cancelButton);
        this.usageList.addMouseListener(this);
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        cont.add((Component)new JScrollPane(this.usageList), "Center");
        cont.add((Component)buttonsPanel, "South");
        this.setSize(400, 300);
        this.setTitle((definitions ? this.translate("dialog.title.declaration") : this.translate("dialog.title")) + abc.constants.getMultiname(multinameIndex).getNameWithNamespace(abc.constants, true).toPrintableString(true));
        View.centerScreen(this);
        View.setWindowIcon(this);
    }

    public static void gotoUsage(final ABCPanel abcPanel, final MultinameUsage usage) {
        if (usage instanceof InsideClassMultinameUsageInterface) {
            final InsideClassMultinameUsageInterface icu = (InsideClassMultinameUsageInterface)usage;
            Runnable settrait = new Runnable(){

                @Override
                public void run() {
                    abcPanel.decompiledTextArea.removeScriptListener(this);
                    abcPanel.decompiledTextArea.setClassIndex(icu.getClassIndex());
                    if (usage instanceof TraitMultinameUsage) {
                        MethodMultinameUsage mmu;
                        TraitMultinameUsage tmu = (TraitMultinameUsage)usage;
                        int traitIndex = tmu.getParentTraitIndex() > -1 ? tmu.getParentTraitIndex() : tmu.getTraitIndex();
                        if (tmu.getTraitsType() == 2) {
                            traitIndex += ((ClassInfo)abcPanel.abc.class_info.get((int)tmu.getClassIndex())).static_traits.traits.size();
                        }
                        if (tmu instanceof MethodMultinameUsage && (mmu = (MethodMultinameUsage)usage).isInitializer()) {
                            traitIndex = ((ClassInfo)abcPanel.abc.class_info.get((int)mmu.getClassIndex())).static_traits.traits.size() + ((InstanceInfo)abcPanel.abc.instance_info.get((int)mmu.getClassIndex())).instance_traits.traits.size() + (mmu.getTraitsType() == 1 ? 1 : 0);
                        }
                        abcPanel.decompiledTextArea.gotoTrait(traitIndex);
                    }
                }
            };
            if (abcPanel.decompiledTextArea.getClassIndex() == icu.getClassIndex() && abcPanel.abc == icu.getAbc()) {
                settrait.run();
            } else {
                abcPanel.decompiledTextArea.addScriptListener(settrait);
                abcPanel.hilightScript(abcPanel.getSwf(), ((InstanceInfo)icu.getAbc().instance_info.get(icu.getClassIndex())).getName(icu.getAbc().constants).getNameWithNamespace(icu.getAbc().constants, true).toRawString());
            }
        }
    }

    private void gotoUsage() {
        if (this.usageList.getSelectedIndex() != -1) {
            MultinameUsage usage = this.usageListModel.getUsage(this.usageList.getSelectedIndex());
            UsageFrame.gotoUsage(this.abcPanel, usage);
        }
    }

    private void gotoButtonActionPerformed(ActionEvent evt) {
        this.gotoUsage();
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.gotoUsage();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

