/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.abc.TraitsListItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public final class TraitsListModel
implements ListModel<Object> {
    private List<TraitsListItem> items;
    private final ABC abc;
    private final int classIndex;
    private final int scriptIndex;

    public void setSorted(boolean sorted) {
        if (sorted) {
            Collections.sort(this.items, new Comparator<TraitsListItem>(){

                @Override
                public int compare(TraitsListItem o1, TraitsListItem o2) {
                    return o1.toStringName().compareTo(o2.toStringName());
                }
            });
        } else {
            this.reset();
        }
    }

    private void reset() {
        this.items = new ArrayList<TraitsListItem>();
        if (this.classIndex > -1) {
            int t;
            for (t = 0; t < ((ClassInfo)this.abc.class_info.get((int)this.classIndex)).static_traits.traits.size(); ++t) {
                if (!((Trait)((ClassInfo)this.abc.class_info.get((int)this.classIndex)).static_traits.traits.get(t)).isVisible(true, this.abc)) continue;
                this.items.add(new TraitsListItem(TraitsListItem.Type.getTypeForTrait((Trait)((ClassInfo)this.abc.class_info.get((int)this.classIndex)).static_traits.traits.get(t)), t, true, this.abc, this.classIndex, this.scriptIndex));
            }
            for (t = 0; t < ((InstanceInfo)this.abc.instance_info.get((int)this.classIndex)).instance_traits.traits.size(); ++t) {
                if (!((Trait)((InstanceInfo)this.abc.instance_info.get((int)this.classIndex)).instance_traits.traits.get(t)).isVisible(false, this.abc)) continue;
                this.items.add(new TraitsListItem(TraitsListItem.Type.getTypeForTrait((Trait)((InstanceInfo)this.abc.instance_info.get((int)this.classIndex)).instance_traits.traits.get(t)), t, false, this.abc, this.classIndex, this.scriptIndex));
            }
            this.items.add(new TraitsListItem(TraitsListItem.Type.INITIALIZER, 0, false, this.abc, this.classIndex, this.scriptIndex));
            this.items.add(new TraitsListItem(TraitsListItem.Type.INITIALIZER, 0, true, this.abc, this.classIndex, this.scriptIndex));
        }
        if (((Boolean)Configuration.enableScriptInitializerDisplay.get()).booleanValue()) {
            this.items.add(new TraitsListItem(TraitsListItem.Type.SCRIPT_INITIALIZER, 0, true, this.abc, this.classIndex, this.scriptIndex));
        }
    }

    public TraitsListModel(ABC abc, int classIndex, int scriptIndex, boolean sorted) {
        this.abc = abc;
        this.classIndex = classIndex;
        this.scriptIndex = scriptIndex;
        this.reset();
        if (sorted) {
            this.setSorted(true);
        }
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.items.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }
}

