/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class NewTraitDialog
extends AppDialog {
    private static final int[] modifiers = new int[]{22, 5, 24, 8, 23, 25, 26};
    private static final int[] types = new int[]{1, 2, 3, 6, 0};
    private final JComboBox<String> accessComboBox;
    private final JComboBox<String> typeComboBox;
    private final JCheckBox staticCheckbox;
    private final JTextField nameField;
    private int result = -1;

    public boolean getStatic() {
        return this.staticCheckbox.isSelected();
    }

    public int getNamespaceKind() {
        return modifiers[this.accessComboBox.getSelectedIndex()];
    }

    public int getTraitType() {
        return types[this.typeComboBox.getSelectedIndex()];
    }

    public String getTraitName() {
        return this.nameField.getText();
    }

    public NewTraitDialog() {
        this.setSize(500, 300);
        this.setTitle(this.translate("dialog.title"));
        View.centerScreen(this);
        View.setWindowIcon(this);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JPanel optionsPanel = new JPanel(new FlowLayout());
        this.typeComboBox = new JComboBox<String>(new String[]{this.translate("type.method"), this.translate("type.getter"), this.translate("type.setter"), this.translate("type.const"), this.translate("type.slot")});
        this.staticCheckbox = new JCheckBox(this.translate("checkbox.static"));
        optionsPanel.add(this.staticCheckbox);
        String[] accessStrings = new String[modifiers.length];
        for (int i = 0; i < accessStrings.length; ++i) {
            String pref = Namespace.kindToPrefix((int)modifiers[i]);
            String name = Namespace.kindToStr((int)modifiers[i]);
            accessStrings[i] = (pref.isEmpty() ? "" : pref + " ") + "(" + name + ")";
        }
        this.accessComboBox = new JComboBox<String>(accessStrings);
        optionsPanel.add(this.accessComboBox);
        optionsPanel.add(this.typeComboBox);
        this.nameField = new JTextField();
        this.nameField.setPreferredSize(new Dimension(300, this.nameField.getPreferredSize().height));
        optionsPanel.add(this.nameField);
        cnt.add((Component)optionsPanel, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton buttonOk = new JButton(AppStrings.translate("button.ok"));
        buttonOk.addActionListener(this::okButtonActionPerformed);
        JButton buttonCancel = new JButton(AppStrings.translate("button.cancel"));
        buttonCancel.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(buttonOk);
        buttonsPanel.add(buttonCancel);
        cnt.add((Component)buttonsPanel, "South");
        this.pack();
        this.setDefaultCloseOperation(1);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.nameField.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                JComponent component = event.getComponent();
                component.requestFocusInWindow();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.getRootPane().setDefaultButton(buttonOk);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.result = -1;
            this.nameField.setText("");
        }
        super.setVisible(b);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = 0;
        if (this.nameField.getText().trim().isEmpty()) {
            View.showMessageDialog(null, this.translate("error.name"), AppStrings.translate("error"), 0);
            return;
        }
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }
}

