/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.DebuggerHandler;
import com.jpexs.decompiler.flash.gui.HeaderLabel;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.TagEditorPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.abc.ABCPanel;
import com.jpexs.decompiler.flash.gui.abc.MethodTraitDetailPanel;
import com.jpexs.decompiler.flash.gui.abc.SlotConstTraitDetailPanel;
import com.jpexs.decompiler.flash.gui.abc.TraitDetail;
import com.jpexs.helpers.CancellableWorker;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class DetailPanel
extends JPanel
implements TagEditorPanel {
    public MethodTraitDetailPanel methodTraitPanel;
    public JPanel unsupportedTraitPanel;
    public SlotConstTraitDetailPanel slotConstTraitPanel;
    public static final String METHOD_GETTER_SETTER_TRAIT_CARD = "abc.detail.methodtrait";
    public static final String UNSUPPORTED_TRAIT_CARD = "abc.detail.unsupported";
    public static final String SLOT_CONST_TRAIT_CARD = "abc.detail.slotconsttrait";
    private final JPanel innerPanel;
    public JButton saveButton = new JButton(AppStrings.translate("button.save"), View.getIcon("save16"));
    public JButton editButton = new JButton(AppStrings.translate("button.edit.script.disassembled"), View.getIcon("edit16"));
    public JButton cancelButton = new JButton(AppStrings.translate("button.cancel"), View.getIcon("cancel16"));
    private final HashMap<String, JComponent> cardMap = new HashMap();
    private String selectedCard;
    private final JLabel selectedLabel;
    private final JPanel buttonsPanel;
    private final ABCPanel abcPanel;
    private final JLabel traitNameLabel;
    private boolean debugRunning = false;
    private boolean buttonsShouldBeShown = false;
    private final DebuggerHandler.ConnectionListener conListener;

    public DetailPanel(ABCPanel abcPanel) {
        this.abcPanel = abcPanel;
        this.innerPanel = new JPanel();
        CardLayout layout = new CardLayout();
        this.innerPanel.setLayout(layout);
        this.methodTraitPanel = new MethodTraitDetailPanel(abcPanel);
        this.cardMap.put(METHOD_GETTER_SETTER_TRAIT_CARD, this.methodTraitPanel);
        this.unsupportedTraitPanel = new JPanel(new BorderLayout());
        JLabel unsup = new JLabel("<html>" + AppStrings.translate("info.selecttrait") + "</html>", 0);
        this.unsupportedTraitPanel.add((Component)unsup, "Center");
        this.cardMap.put(UNSUPPORTED_TRAIT_CARD, this.unsupportedTraitPanel);
        this.slotConstTraitPanel = new SlotConstTraitDetailPanel(abcPanel.decompiledTextArea);
        this.cardMap.put(SLOT_CONST_TRAIT_CARD, this.slotConstTraitPanel);
        for (String key : this.cardMap.keySet()) {
            this.innerPanel.add((Component)this.cardMap.get(key), key);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.innerPanel, "Center");
        this.editButton.setMargin(new Insets(3, 3, 3, 10));
        this.saveButton.setMargin(new Insets(3, 3, 3, 10));
        this.cancelButton.setMargin(new Insets(3, 3, 3, 10));
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new FlowLayout());
        this.saveButton.addActionListener(this::saveButtonActionPerformed);
        this.editButton.addActionListener(this::editButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        this.saveButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.buttonsPanel.setBorder(new BevelBorder(0));
        this.buttonsPanel.add(this.editButton);
        this.buttonsPanel.add(this.saveButton);
        this.buttonsPanel.add(this.cancelButton);
        this.add((Component)this.buttonsPanel, "South");
        this.selectedCard = UNSUPPORTED_TRAIT_CARD;
        layout.show(this.innerPanel, UNSUPPORTED_TRAIT_CARD);
        this.buttonsPanel.setVisible(false);
        this.conListener = new DebuggerHandler.ConnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connected() {
                DetailPanel detailPanel = DetailPanel.this;
                synchronized (detailPanel) {
                    DetailPanel.this.debugRunning = true;
                    if (DetailPanel.this.buttonsPanel != null) {
                        DetailPanel.this.buttonsPanel.setVisible(false);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnected() {
                DetailPanel detailPanel = DetailPanel.this;
                synchronized (detailPanel) {
                    DetailPanel.this.debugRunning = false;
                    if (DetailPanel.this.buttonsPanel != null) {
                        DetailPanel.this.buttonsPanel.setVisible(DetailPanel.this.buttonsShouldBeShown);
                    }
                }
            }
        };
        Main.getDebugHandler().addConnectionListener(this.conListener);
        this.selectedLabel = new HeaderLabel("");
        this.selectedLabel.setText(this.selectedCard);
        this.selectedLabel.setHorizontalAlignment(0);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.selectedLabel, "North");
        this.traitNameLabel = new JLabel("");
        JPanel traitInfoPanel = new JPanel();
        traitInfoPanel.setLayout(new BoxLayout(traitInfoPanel, 2));
        traitInfoPanel.add(this.traitNameLabel);
        topPanel.add((Component)traitInfoPanel, "Center");
        this.methodTraitPanel.methodCodePanel.getSourceTextArea().addTextChangedListener(this::editorTextChanged);
        this.slotConstTraitPanel.slotConstEditor.addTextChangedListener(this::editorTextChanged);
        this.add((Component)topPanel, "North");
    }

    private void editorTextChanged() {
        this.setModified(true);
    }

    private boolean isModified() {
        return this.saveButton.isVisible() && this.saveButton.isEnabled();
    }

    private void setModified(boolean value) {
        this.saveButton.setEnabled(value);
        this.cancelButton.setEnabled(value);
    }

    public void setEditMode(boolean val) {
        this.slotConstTraitPanel.setEditMode(val);
        this.methodTraitPanel.setEditMode(val);
        this.saveButton.setVisible(val);
        this.saveButton.setEnabled(false);
        this.editButton.setVisible(!val);
        this.cancelButton.setVisible(val);
        this.selectedLabel.setIcon(val ? View.getIcon("editing16") : null);
    }

    public void showCard(String name, Trait trait, int traitIndex) {
        View.execInEventDispatch(() -> {
            boolean drun;
            CardLayout layout = (CardLayout)this.innerPanel.getLayout();
            layout.show(this.innerPanel, name);
            boolean b = this.cardMap.get(name) instanceof TraitDetail;
            DetailPanel detailPanel = this;
            synchronized (detailPanel) {
                this.buttonsShouldBeShown = b;
                drun = this.debugRunning;
            }
            this.buttonsPanel.setVisible(b && !drun);
            TraitDetail newDetail = null;
            if (b) {
                newDetail = (TraitDetail)((Object)this.cardMap.get(name));
            }
            for (JComponent v : this.cardMap.values()) {
                if (!(v instanceof TraitDetail) || v == newDetail) continue;
                TraitDetail oldDetail = (TraitDetail)((Object)v);
                oldDetail.setActive(false);
            }
            if (newDetail != null) {
                newDetail.setActive(true);
            }
            this.selectedCard = name;
            String detailTitleStr = AppStrings.translate("panel.disassembled") + AppStrings.translate("abc.detail.split") + "%pcode_type%";
            String traitStr = AppStrings.translate("abc.detail.trait");
            String pcodeTypeStr = null;
            if (trait != null) {
                String traitTypeLang;
                switch (trait.kindType) {
                    case 4: {
                        traitTypeLang = "abc.detail.trait.class";
                        break;
                    }
                    case 6: {
                        traitTypeLang = "abc.detail.trait.const";
                        break;
                    }
                    case 5: {
                        traitTypeLang = "abc.detail.trait.function";
                        break;
                    }
                    case 2: {
                        traitTypeLang = "abc.detail.trait.getter";
                        break;
                    }
                    case 1: {
                        traitTypeLang = "abc.detail.trait.method";
                        break;
                    }
                    case 3: {
                        traitTypeLang = "abc.detail.trait.setter";
                        break;
                    }
                    case 0: {
                        traitTypeLang = "abc.detail.trait.slot";
                        break;
                    }
                    default: {
                        traitTypeLang = UNSUPPORTED_TRAIT_CARD;
                    }
                }
                pcodeTypeStr = traitStr = traitStr.replace("%trait_type%", AppStrings.translate(traitTypeLang));
            }
            String specialMethodTypeLang = null;
            switch (traitIndex) {
                case -3: {
                    specialMethodTypeLang = "abc.detail.specialmethod.scriptinitializer";
                    break;
                }
                case -2: {
                    specialMethodTypeLang = "abc.detail.specialmethod.classinitializer";
                    break;
                }
                case -1: {
                    specialMethodTypeLang = "abc.detail.specialmethod.instanceinitializer";
                }
            }
            if (specialMethodTypeLang != null) {
                String specialMethodStr;
                pcodeTypeStr = specialMethodStr = AppStrings.translate("abc.detail.specialmethod").replace("%specialmethod_type%", AppStrings.translate(specialMethodTypeLang));
            }
            if (pcodeTypeStr == null) {
                pcodeTypeStr = METHOD_GETTER_SETTER_TRAIT_CARD.equals(name) && trait == null ? AppStrings.translate("abc.detail.innerfunction") : AppStrings.translate(UNSUPPORTED_TRAIT_CARD);
            }
            detailTitleStr = detailTitleStr.replace("%pcode_type%", pcodeTypeStr);
            this.selectedLabel.setText(detailTitleStr);
            if (trait == null) {
                this.traitNameLabel.setText("-");
            } else if (this.abcPanel != null) {
                this.traitNameLabel.setText(trait.getName(this.abcPanel.abc).getName(this.abcPanel.abc.constants, null, false, true));
            }
        });
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.setEditMode(true);
        this.methodTraitPanel.methodCodePanel.focusEditor();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setEditMode(false);
        this.abcPanel.decompiledTextArea.resetEditing();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        if (this.cardMap.get(this.selectedCard) instanceof TraitDetail && ((TraitDetail)((Object)this.cardMap.get(this.selectedCard))).save()) {
            CancellableWorker worker = new CancellableWorker(){

                public Void doInBackground() throws Exception {
                    int lasttrait = ((DetailPanel)DetailPanel.this).abcPanel.decompiledTextArea.lastTraitIndex;
                    ((DetailPanel)DetailPanel.this).abcPanel.decompiledTextArea.reloadClass();
                    ((DetailPanel)DetailPanel.this).abcPanel.decompiledTextArea.gotoTrait(lasttrait);
                    return null;
                }

                protected void done() {
                    DetailPanel.this.setEditMode(false);
                    View.showMessageDialog(null, AppStrings.translate("message.trait.saved"), AppStrings.translate("dialog.message.title"), 1, (ConfigurationItem<Boolean>)Configuration.showTraitSavedMessage);
                }
            };
            worker.execute();
        }
    }

    @Override
    public boolean tryAutoSave() {
        return false;
    }

    @Override
    public boolean isEditing() {
        return this.saveButton.isVisible() && this.saveButton.isEnabled();
    }
}

