/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.ApplicationInfo;
import com.jpexs.decompiler.flash.gui.AppFrame;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;

public class ModeFrame
extends AppFrame {
    private final JButton openButton = new JButton(this.translate("button.open"));
    private final JButton proxyButton = new JButton(this.translate("button.proxy"));
    private final JButton exitButton = new JButton(this.translate("button.exit"));

    public ModeFrame() {
        this.setSize(350, 200);
        this.openButton.addActionListener(this::openButtonActionPerformed);
        this.openButton.setIcon(View.getIcon("open32"));
        this.proxyButton.addActionListener(this::proxyButtonActionPerformed);
        this.proxyButton.setIcon(View.getIcon("proxy32"));
        this.exitButton.addActionListener(this::exitButtonActionPerformed);
        this.exitButton.setIcon(View.getIcon("exit32"));
        this.setResizable(false);
        Container cont = this.getContentPane();
        cont.setLayout(new GridLayout(4, 1));
        JLabel logoLabel = new JLabel();
        logoLabel.setIcon(View.getIcon("logo"));
        cont.add(logoLabel);
        cont.add(this.openButton);
        cont.add(this.proxyButton);
        cont.add(this.exitButton);
        View.centerScreen(this);
        View.setWindowIcon(this);
        this.setTitle(ApplicationInfo.shortApplicationVerName);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Main.exit();
            }
        });
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        if (!Main.openFileDialog()) {
            this.setVisible(true);
        }
    }

    private void proxyButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        Main.showProxy();
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        Main.exit();
    }
}

