/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.debugger.flash.DebuggerCommands;
import com.jpexs.decompiler.flash.ApplicationInfo;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFBundle;
import com.jpexs.decompiler.flash.SWFSourceInfo;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.configuration.ConfigurationItemChangeListener;
import com.jpexs.decompiler.flash.console.ContextMenuTools;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.ErrorLogFrame;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainFrame;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.MenuBuilder;
import com.jpexs.decompiler.flash.gui.OpenFileResult;
import com.jpexs.decompiler.flash.gui.ReplaceTraceDialog;
import com.jpexs.decompiler.flash.gui.SaveFileMode;
import com.jpexs.decompiler.flash.gui.SelectLanguageDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.debugger.DebuggerTools;
import com.jpexs.decompiler.flash.gui.helpers.CheckResources;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.utf8.Utf8Helper;
import com.sun.jna.Platform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;

public abstract class MainFrameMenu
implements MenuBuilder {
    private final MainFrame mainFrame;
    private KeyEventDispatcher keyEventDispatcher;
    private SWF swf;
    private ConfigurationItemChangeListener<Boolean> configListenerAutoDeobfuscate;
    private ConfigurationItemChangeListener<Boolean> configListenerSimplifyExpressions;
    private ConfigurationItemChangeListener<Boolean> configListenerInternalFlashViewer;
    private ConfigurationItemChangeListener<Boolean> configListenerParallelSpeedUp;
    private ConfigurationItemChangeListener<Boolean> configListenerDecompile;
    private ConfigurationItemChangeListener<Boolean> configListenerGotoMainClassOnStartup;
    private ConfigurationItemChangeListener<Boolean> configListenerAutoRenameIdentifiers;
    private ConfigurationItemChangeListener<Boolean> configListenerAutoOpenLoadedSWFs;
    protected final Map<String, MenuBuilder.HotKey> menuHotkeys = new HashMap<String, MenuBuilder.HotKey>();
    protected final Map<String, ActionListener> menuActions = new HashMap<String, ActionListener>();
    private final boolean externalFlashPlayerUnavailable;

    @Override
    public MenuBuilder.HotKey getMenuHotkey(String path) {
        return this.menuHotkeys.get(path);
    }

    public boolean isInternalFlashViewerSelected() {
        return this.isMenuChecked("/settings/internalViewer");
    }

    public MainFrameMenu(MainFrame mainFrame, boolean externalFlashPlayerUnavailable) {
        this.registerHotKeys();
        this.mainFrame = mainFrame;
        this.externalFlashPlayerUnavailable = externalFlashPlayerUnavailable;
    }

    protected String translate(String key) {
        return this.mainFrame.translate(key);
    }

    protected boolean openActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return false;
        }
        Main.openFileDialog();
        return true;
    }

    protected boolean saveActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return false;
        }
        if (this.swf != null) {
            boolean saved = false;
            if (this.swf.swfList != null && this.swf.swfList.isBundle()) {
                SWFBundle bundle = this.swf.swfList.bundle;
                if (!bundle.isReadOnly()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        this.swf.saveTo((OutputStream)baos);
                        saved = bundle.putSWF(this.swf.getFileTitle(), (InputStream)new ByteArrayInputStream(baos.toByteArray()));
                    }
                    catch (IOException ex) {
                        Logger.getLogger(MainFrameMenu.class.getName()).log(Level.SEVERE, "Cannot save SWF", ex);
                    }
                }
            } else if (this.swf.binaryData != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    this.swf.saveTo((OutputStream)baos);
                    this.swf.binaryData.binaryData = new ByteArrayRange(baos.toByteArray());
                    this.swf.binaryData.setModified(true);
                    saved = true;
                }
                catch (IOException ex) {
                    Logger.getLogger(MainFrameMenu.class.getName()).log(Level.SEVERE, "Cannot save SWF", ex);
                }
            } else if (this.swf.getFile() == null) {
                saved = this.saveAs(this.swf, SaveFileMode.SAVEAS);
            } else {
                try {
                    Main.saveFile(this.swf, this.swf.getFile());
                    saved = true;
                }
                catch (IOException ex) {
                    Logger.getLogger(MainFrameMenu.class.getName()).log(Level.SEVERE, null, ex);
                    View.showMessageDialog(null, this.translate("error.file.save"), this.translate("error"), 0);
                }
            }
            if (saved) {
                this.swf.clearModified();
                this.mainFrame.getPanel().refreshTree(this.swf);
            }
            return true;
        }
        return false;
    }

    protected boolean saveAsActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return false;
        }
        if (this.swf != null) {
            if (this.saveAs(this.swf, SaveFileMode.SAVEAS)) {
                this.swf.clearModified();
            }
            return true;
        }
        return false;
    }

    private boolean saveAs(SWF swf, SaveFileMode mode) {
        if (Main.saveFileDialog(swf, mode)) {
            this.updateComponents(swf);
            return true;
        }
        return false;
    }

    protected void saveAsExeActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.swf != null) {
            this.saveAs(this.swf, SaveFileMode.EXE);
        }
    }

    protected void closeActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.swf == null) {
            return;
        }
        Main.closeFile(this.swf.swfList);
    }

    protected boolean closeAllActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return false;
        }
        if (this.swf != null) {
            return Main.closeAll();
        }
        return false;
    }

    protected void importTextActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.mainFrame.getPanel().importText(this.swf);
    }

    protected void importScriptActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.mainFrame.getPanel().importScript(this.swf);
    }

    protected void importSymbolClassActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.mainFrame.getPanel().importSymbolClass(this.swf);
    }

    protected boolean exportAllActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return false;
        }
        return this.export(false);
    }

    protected boolean exportSelectedActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return false;
        }
        return this.export(true);
    }

    protected boolean export(boolean onlySelected) {
        if (this.swf != null) {
            this.mainFrame.getPanel().export(onlySelected);
            return true;
        }
        return false;
    }

    protected void exportFlaActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.mainFrame.getPanel().exportFla(this.swf);
    }

    protected void importXmlActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.mainFrame.getPanel().importSwfXml();
    }

    protected void exportXmlActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.mainFrame.getPanel().exportSwfXml();
    }

    protected boolean searchActionPerformed(ActionEvent evt) {
        return this.search(evt, null);
    }

    protected boolean searchInTextPerformed(ActionEvent evt) {
        return this.search(evt, true);
    }

    protected boolean searchInActionPerformed(ActionEvent evt) {
        return this.search(evt, false);
    }

    protected boolean search(ActionEvent evt, Boolean searchInText) {
        if (this.swf != null) {
            this.mainFrame.getPanel().searchInActionScriptOrText(searchInText, this.swf);
            return true;
        }
        return false;
    }

    protected boolean replaceActionPerformed(ActionEvent evt) {
        if (this.swf != null) {
            this.mainFrame.getPanel().replaceText();
            return true;
        }
        return false;
    }

    protected void showProxyActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        Main.showProxy();
    }

    protected boolean clearLog(ActionEvent evt) {
        ErrorLogFrame.getInstance().clearLog();
        return true;
    }

    protected void renameOneIdentifier(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.mainFrame.getPanel().renameOneIdentifier(this.swf);
    }

    protected void renameColliding(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.mainFrame.getPanel().renameColliding(this.swf);
    }

    protected void renameInvalidIdentifiers(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.mainFrame.getPanel().renameIdentifiers(this.swf);
    }

    protected void deobfuscationActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.mainFrame.getPanel().deobfuscate();
    }

    protected void setSubLimiter(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Main.setSubLimiter(selected);
    }

    protected void switchDebugger() {
        DebuggerTools.switchDebugger(this.swf);
    }

    protected void debuggerShowLogActionPerformed(ActionEvent evt) {
        DebuggerTools.debuggerShowLog();
    }

    protected void debuggerInjectLoader(ActionEvent evt) {
        DebuggerTools.injectDebugLoader(this.swf);
        this.refreshDecompiled();
    }

    protected void debuggerReplaceTraceCallsActionPerformed(ActionEvent evt) {
        ReplaceTraceDialog rtd = new ReplaceTraceDialog((String)Configuration.lastDebuggerReplaceFunction.get());
        rtd.setVisible(true);
        if (rtd.getValue() != null) {
            String fname = rtd.getValue();
            DebuggerTools.replaceTraceCalls(this.swf, fname);
            this.mainFrame.getPanel().refreshDecompiled();
            Configuration.lastDebuggerReplaceFunction.set((Object)rtd.getValue());
        }
    }

    protected void clearRecentFilesActionPerformed(ActionEvent evt) {
        Configuration.recentFiles.set(null);
    }

    protected void removeNonScripts() {
        this.mainFrame.getPanel().removeNonScripts(this.swf);
    }

    protected void removeExceptSelected() {
        this.mainFrame.getPanel().removeExceptSelected(this.swf);
    }

    protected void refreshDecompiled() {
        this.mainFrame.getPanel().refreshDecompiled();
    }

    protected boolean previousTag(ActionEvent evt) {
        return this.mainFrame.getPanel().previousTag();
    }

    protected boolean nextTag(ActionEvent evt) {
        return this.mainFrame.getPanel().nextTag();
    }

    protected void checkResources() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(os);
        CheckResources.checkResources(stream, null);
        final String str = new String(os.toByteArray(), Utf8Helper.charset);
        JDialog dialog = new JDialog(){

            @Override
            public void setVisible(boolean bln) {
                this.setSize(new Dimension(800, 600));
                Container cnt = this.getContentPane();
                cnt.setLayout(new BorderLayout());
                String[] languages = (String[])SelectLanguageDialog.getAvailableLanguages().clone();
                languages[0] = "all";
                JComboBox<String> languagesComboBox = new JComboBox<String>(languages);
                this.add(languagesComboBox, "North");
                ScrollPane scrollPane = new ScrollPane();
                JEditorPane editor = new JEditorPane();
                editor.setEditable(false);
                editor.setText(str);
                scrollPane.add(editor);
                this.add((Component)scrollPane, "Center");
                this.setModal(true);
                View.centerScreen(this);
                languagesComboBox.addActionListener(e -> {
                    String lang = (String)languagesComboBox.getSelectedItem();
                    if (lang.equals("all")) {
                        lang = null;
                    }
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    try (PrintStream stream = new PrintStream((OutputStream)os, false, "UTF-8");){
                        CheckResources.checkResources(stream, lang);
                        String str2 = new String(os.toByteArray(), Utf8Helper.charset);
                        editor.setText(str2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                });
                super.setVisible(bln);
            }
        };
        dialog.setVisible(true);
    }

    protected void checkUpdatesActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (!Main.checkForUpdates()) {
            View.showMessageDialog(null, this.translate("update.check.nonewversion"), this.translate("update.check.title"), 1);
        }
    }

    protected void helpUsActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        String helpUsURL = "https://www.free-decompiler.com/flash/help_us.html?utm_source=app&utm_medium=menu&utm_campaign=app";
        if (!View.navigateUrl(helpUsURL)) {
            View.showMessageDialog(null, this.translate("message.helpus").replace("%url%", helpUsURL));
        }
    }

    protected void homePageActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        String homePageURL = "https://www.free-decompiler.com/flash?utm_source=app&utm_medium=menu&utm_campaign=app";
        if (!View.navigateUrl(homePageURL)) {
            View.showMessageDialog(null, this.translate("message.homepage").replace("%url%", homePageURL));
        }
    }

    protected void aboutActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        Main.about();
    }

    protected boolean reloadActionPerformed(ActionEvent evt) {
        if (this.swf != null && View.showConfirmDialog(null, this.translate("message.confirm.reload"), this.translate("message.warning"), 0, 2) == 0) {
            Main.reloadFile(this.swf.swfList);
        }
        return true;
    }

    protected boolean reloadAllActionPerformed(ActionEvent evt) {
        if (this.swf != null) {
            if (View.showConfirmDialog(null, this.translate("message.confirm.reloadAll"), this.translate("message.warning"), 0, 2) == 0) {
                Main.reloadApp();
            }
            return true;
        }
        Main.reloadApp();
        return true;
    }

    protected void advancedSettingsActionPerformed(ActionEvent evt) {
        Main.advancedSettings();
    }

    protected void searchMemoryActionPerformed(ActionEvent evt) {
        Main.loadFromMemory();
    }

    protected void searchCacheActionPerformed(ActionEvent evt) {
        Main.loadFromCache();
    }

    protected void gotoDucumentClassOnStartupActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Configuration.gotoMainClassOnStartup.set((Object)selected);
    }

    protected void autoOpenLoadedSWFsActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Configuration.autoOpenLoadedSWFs.set((Object)selected);
    }

    protected void autoRenameIdentifiersActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Configuration.autoRenameIdentifiers.set((Object)selected);
    }

    protected void setLanguageActionPerformed(ActionEvent evt) {
        new SelectLanguageDialog().display();
    }

    protected void disableDecompilationActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Configuration.decompile.set((Object)(!selected ? 1 : 0));
        this.mainFrame.getPanel().disableDecompilationChanged();
    }

    protected void associateActionPerformed(ActionEvent evt) {
        final AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        if (selected == ContextMenuTools.isAddedToContextMenu()) {
            return;
        }
        ContextMenuTools.addToContextMenu(selected, false);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                button.setSelected(ContextMenuTools.isAddedToContextMenu());
            }
        }, 1000L);
    }

    protected void gotoDucumentClassActionPerformed(ActionEvent evt) {
        this.mainFrame.getPanel().gotoDocumentClass(this.mainFrame.getPanel().getCurrentSwf());
    }

    protected void parallelSpeedUpActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        String confStr = this.translate("message.confirm.parallel") + "\r\n";
        confStr = selected ? confStr + " " + this.translate("message.confirm.on") : confStr + " " + this.translate("message.confirm.off");
        if (View.showConfirmDialog(null, confStr, this.translate("message.parallel"), 2) == 0) {
            Configuration.parallelSpeedUp.set((Object)selected);
        } else {
            button.setSelected((Boolean)Configuration.parallelSpeedUp.get());
        }
    }

    protected void internalViewerSwitchActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Configuration.internalFlashViewer.set((Object)selected);
        this.mainFrame.getPanel().reload(true);
    }

    protected void simplifyExpressionsActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Configuration.simplifyExpressions.set((Object)selected);
        this.mainFrame.getPanel().autoDeobfuscateChanged();
    }

    protected void autoDeobfuscationActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        if (View.showConfirmDialog(this.mainFrame.getPanel(), this.translate("message.confirm.autodeobfuscate") + "\r\n" + (selected ? this.translate("message.confirm.on") : this.translate("message.confirm.off")), this.translate("message.confirm"), 2) == 0) {
            Configuration.autoDeobfuscate.set((Object)selected);
            this.mainFrame.getPanel().autoDeobfuscateChanged();
        } else {
            button.setSelected((Boolean)Configuration.autoDeobfuscate.get());
        }
    }

    protected void exitActionPerformed(ActionEvent evt) {
        JFrame frame = (JFrame)((Object)this.mainFrame);
        frame.dispatchEvent(new WindowEvent(frame, 201));
    }

    public void updateComponents() {
        this.updateComponents(this.swf);
    }

    public void updateComponents(SWF swf) {
        this.swf = swf;
        boolean isRunning = Main.isRunning();
        boolean isDebugRunning = Main.isDebugRunning();
        boolean isDebugPaused = Main.isDebugPaused();
        boolean isRunningOrDebugging = isRunning || isDebugRunning;
        boolean swfSelected = swf != null;
        boolean isWorking = Main.isWorking();
        List abcList = swf != null ? swf.getAbcList() : null;
        boolean hasAbc = swfSelected && abcList != null && !abcList.isEmpty();
        boolean hasDebugger = hasAbc && DebuggerTools.hasDebugger(swf);
        MainPanel mainPanel = this.mainFrame.getPanel();
        boolean swfLoaded = mainPanel != null ? !mainPanel.getSwfs().isEmpty() : false;
        this.setMenuEnabled("_/open", !isWorking);
        this.setMenuEnabled("/file/open", !isWorking);
        this.setMenuEnabled("_/save", swfSelected && !isWorking);
        this.setMenuEnabled("/file/save", swfSelected && !isWorking);
        this.setMenuEnabled("_/saveAs", swfSelected && !isWorking);
        this.setMenuEnabled("/file/saveAs", swfSelected && !isWorking);
        this.setMenuEnabled("/file/saveAsExe", swfSelected && !isWorking);
        this.setMenuEnabled("_/close", swfSelected && !isWorking);
        this.setMenuEnabled("/file/close", swfSelected && !isWorking);
        this.setMenuEnabled("_/closeAll", swfLoaded && !isWorking);
        this.setMenuEnabled("/file/closeAll", swfLoaded && !isWorking);
        this.setMenuEnabled("/file/export", swfSelected);
        this.setMenuEnabled("_/exportAll", swfSelected && !isWorking);
        this.setMenuEnabled("/file/export/exportAll", swfSelected && !isWorking);
        this.setMenuEnabled("_/exportFla", swfSelected && !isWorking);
        this.setMenuEnabled("/file/export/exportFla", swfSelected && !isWorking);
        this.setMenuEnabled("_/exportSelected", swfSelected && !isWorking);
        this.setMenuEnabled("/file/export/exportSelected", swfSelected && !isWorking);
        this.setMenuEnabled("/file/export/exportXml", swfSelected && !isWorking);
        this.setMenuEnabled("/file/import", swfSelected);
        this.setMenuEnabled("/file/import/importText", swfSelected && !isWorking);
        this.setMenuEnabled("/file/import/importScript", swfSelected && !isWorking);
        this.setMenuEnabled("/file/import/importSymbolClass", swfSelected && !isWorking);
        this.setMenuEnabled("/file/import/importXml", swfSelected && !isWorking);
        this.setMenuEnabled("/tools/deobfuscation", swfSelected);
        this.setMenuEnabled("/tools/deobfuscation/renameOneIdentifier", swfSelected && !isWorking);
        this.setMenuEnabled("/tools/deobfuscation/renameInvalidIdentifiers", swfSelected && !isWorking);
        this.setMenuEnabled("/tools/deobfuscation/renameColliding", swfSelected && !isWorking);
        this.setMenuEnabled("/tools/deobfuscation/deobfuscation", hasAbc);
        this.setMenuEnabled("/tools/search", swfSelected);
        this.setMenuEnabled("/tools/replace", swfSelected);
        this.setMenuEnabled("/tools/timeline", swfSelected);
        this.setMenuEnabled("/tools/showProxy", !isWorking);
        this.setMenuEnabled("/tools/gotoDocumentClass", hasAbc);
        this.setMenuEnabled("_/checkUpdates", !isWorking);
        this.setMenuEnabled("/help/checkUpdates", !isWorking);
        this.setMenuEnabled("/help/helpUs", !isWorking);
        this.setMenuEnabled("/help/homePage", !isWorking);
        this.setMenuEnabled("_/about", !isWorking);
        this.setMenuEnabled("/help/about", !isWorking);
        this.setMenuEnabled("/file/start/run", swfSelected && !isRunningOrDebugging);
        this.setMenuEnabled("/file/start/debug", swfSelected && !isRunningOrDebugging);
        this.setMenuEnabled("/file/start/debugpcode", swfSelected && !isRunningOrDebugging);
        this.setMenuEnabled("/file/start/stop", isRunningOrDebugging);
        this.setMenuEnabled("/debugging/debug/stop", isRunningOrDebugging);
        this.setPathVisible("/debugging", isDebugRunning);
        this.setMenuEnabled("/debugging/debug", isDebugRunning);
        this.setMenuEnabled("/debugging/debug/stepOver", isDebugPaused);
        this.setMenuEnabled("/debugging/debug/stepInto", isDebugPaused);
        this.setMenuEnabled("/debugging/debug/stepOut", isDebugPaused);
        this.setMenuEnabled("/debugging/debug/continue", isDebugPaused);
        StringBuilder titleBuilder = new StringBuilder();
        titleBuilder.append(ApplicationInfo.applicationVerName);
        if (((Boolean)Configuration.displayFileName.get()).booleanValue() && swf != null) {
            titleBuilder.append(" - ");
            if (swf.swfList != null && swf.swfList.isBundle()) {
                titleBuilder.append(swf.swfList.name).append("/");
            }
            titleBuilder.append(swf.getFileTitle());
        }
        this.mainFrame.setTitle(titleBuilder.toString());
    }

    private void registerHotKeys() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.keyEventDispatcher = this::dispatchKeyEvent;
        manager.addKeyEventDispatcher(this.keyEventDispatcher);
    }

    public void createMenuBar() {
        this.initMenu();
        if (this.supportsAppMenu()) {
            this.addMenuItem("_", null, null, null, 0, null, false, null, false);
            this.addMenuItem("_/open", this.translate("menu.file.open"), "open32", this::openActionPerformed, 3, this::loadRecent, false, null, false);
            this.addMenuItem("_/save", this.translate("menu.file.save"), "save32", this::saveActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/saveAs", this.translate("menu.file.saveas"), "saveas32", this::saveAsActionPerformed, 3, null, true, null, false);
            this.addSeparator("_");
            this.addMenuItem("_/exportFla", this.translate("menu.file.export.fla"), "exportfla32", this::exportFlaActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/exportAll", this.translate("menu.file.export.all"), "export32", this::exportAllActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/exportSelected", this.translate("menu.file.export.selection"), "exportsel32", this::exportSelectedActionPerformed, 3, null, true, null, false);
            this.addSeparator("_");
            this.addMenuItem("_/checkUpdates", this.translate("menu.help.checkupdates"), "update32", this::checkUpdatesActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/about", this.translate("menu.help.about"), "about32", this::aboutActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/close", this.translate("menu.file.close"), "close32", this::closeActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/closeAll", this.translate("menu.file.closeAll"), "closeall32", this::closeAllActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/$exit", this.translate("menu.file.exit"), "exit32", this::exitActionPerformed, 3, null, true, null, false);
            this.finishMenu("_");
        }
        this.addMenuItem("/file", this.translate("menu.file"), null, null, 0, null, false, null, false);
        this.addMenuItem("/file/open", this.translate("menu.file.open"), "open32", this::openActionPerformed, 3, this::loadRecent, !this.supportsMenuAction(), new MenuBuilder.HotKey("CTRL+SHIFT+O"), false);
        if (!this.supportsMenuAction()) {
            this.addMenuItem("/file/recent", this.translate("menu.recentFiles"), null, null, 0, this::loadRecent, false, null, false);
            this.finishMenu("/file/recent");
        } else {
            this.finishMenu("/file/open");
        }
        this.addMenuItem("/file/save", this.translate("menu.file.save"), "save32", this::saveActionPerformed, 3, null, true, new MenuBuilder.HotKey("CTRL+SHIFT+S"), false);
        this.addMenuItem("/file/saveAs", this.translate("menu.file.saveas"), "saveas16", this::saveAsActionPerformed, 2, null, true, new MenuBuilder.HotKey("CTRL+SHIFT+A"), false);
        this.addMenuItem("/file/saveAsExe", this.translate("menu.file.saveasexe"), "saveasexe16", this::saveAsExeActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/file/reload", this.translate("menu.file.reload"), "reload16", this::reloadActionPerformed, 2, null, true, new MenuBuilder.HotKey("CTRL+SHIFT+R"), false);
        this.addMenuItem("/file/reloadAll", this.translate("menu.file.reloadAll"), "reload16", this::reloadAllActionPerformed, 2, null, true, null, false);
        this.addSeparator("/file");
        this.addMenuItem("/file/export", this.translate("menu.export"), null, null, 0, null, false, null, false);
        this.addMenuItem("/file/export/exportFla", this.translate("menu.file.export.fla"), "exportfla32", this::exportFlaActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/file/export/exportXml", this.translate("menu.file.export.xml"), "exportxml32", this::exportXmlActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/file/export/exportAll", this.translate("menu.file.export.all"), "export16", this::exportAllActionPerformed, 2, null, true, new MenuBuilder.HotKey("CTRL+SHIFT+E"), false);
        this.addMenuItem("/file/export/exportSelected", this.translate("menu.file.export.selection"), "exportsel16", this::exportSelectedActionPerformed, 2, null, true, null, false);
        this.finishMenu("/file/export");
        this.addMenuItem("/file/import", this.translate("menu.import"), null, null, 0, null, false, null, false);
        this.addMenuItem("/file/import/importXml", this.translate("menu.file.import.xml"), "importxml32", this::importXmlActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/file/import/importText", this.translate("menu.file.import.text"), "importtext32", this::importTextActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/file/import/importScript", this.translate("menu.file.import.script"), "importscript32", this::importScriptActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/file/import/importSymbolClass", this.translate("menu.file.import.symbolClass"), "importsymbolclass32", this::importSymbolClassActionPerformed, 2, null, true, null, false);
        this.finishMenu("/file/import");
        this.addMenuItem("/file/start", this.translate("menu.file.start"), null, null, 0, null, false, null, false);
        this.addMenuItem("/file/start/run", this.translate("menu.file.start.run"), "play32", this::runActionPerformed, 3, null, true, new MenuBuilder.HotKey("F6"), false);
        this.addMenuItem("/file/start/debug", this.translate("menu.file.start.debug"), "debug32", this::debugActionPerformed, 3, null, true, new MenuBuilder.HotKey("CTRL+F5"), false);
        this.addMenuItem("/file/start/stop", this.translate("menu.file.start.stop"), "stop32", this::stopActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/file/start/debugpcode", this.translate("menu.file.start.debugpcode"), "debug32", this::debugPCodeActionPerformed, 2, null, true, null, false);
        this.finishMenu("/file/start");
        this.addMenuItem("/file/view", this.translate("menu.view"), null, null, 0, null, false, null, false);
        this.addToggleMenuItem("/file/view/viewResources", this.translate("menu.file.view.resources"), "view", "viewresources16", this::viewResourcesActionPerformed, 2, null);
        this.addToggleMenuItem("/file/view/viewHex", this.translate("menu.file.view.hex"), "view", "viewhex16", this::viewHexActionPerformed, 2, null);
        this.finishMenu("/file/view");
        this.addSeparator("/file");
        this.addMenuItem("/file/close", this.translate("menu.file.close"), "close32", this::closeActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/file/closeAll", this.translate("menu.file.closeAll"), "closeall32", this::closeAllActionPerformed, 2, null, true, new MenuBuilder.HotKey("CTRL+SHIFT+X"), false);
        if (!this.supportsAppMenu()) {
            this.addSeparator("/file");
            this.addMenuItem("/file/exit", this.translate("menu.file.exit"), "exit32", this::exitActionPerformed, 3, null, true, null, false);
        }
        this.finishMenu("/file");
        if (((Boolean)Configuration.dumpView.get()).booleanValue()) {
            this.setGroupSelection("view", "/file/view/viewHex");
        } else {
            this.setGroupSelection("view", "/file/view/viewResources");
        }
        this.addMenuItem("/debugging", this.translate("menu.debugging"), null, null, 0, null, false, null, true);
        this.addMenuItem("/debugging/debug", this.translate("menu.debugging.debug"), null, null, 0, null, false, null, false);
        this.addMenuItem("/debugging/debug/stop", this.translate("menu.file.start.stop"), "stop32", this::stopActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/debugging/debug/continue", this.translate("menu.debugging.debug.continue"), "continue32", this::continueActionPerformed, 3, null, true, new MenuBuilder.HotKey("F5"), false);
        this.addMenuItem("/debugging/debug/stepOver", this.translate("menu.debugging.debug.stepOver"), "stepover32", this::stepOverActionPerformed, 2, null, true, new MenuBuilder.HotKey("F8"), false);
        this.addMenuItem("/debugging/debug/stepInto", this.translate("menu.debugging.debug.stepInto"), "stepinto32", this::stepIntoActionPerformed, 2, null, true, new MenuBuilder.HotKey("F7"), false);
        this.addMenuItem("/debugging/debug/stepOut", this.translate("menu.debugging.debug.stepOut"), "stepout32", this::stepOutActionPerformed, 2, null, true, new MenuBuilder.HotKey("CTRL+F7"), false);
        this.finishMenu("/debugging/debug");
        this.finishMenu("/debugging");
        this.addMenuItem("/tools", this.translate("menu.tools"), null, null, 0, null, false, null, false);
        this.addMenuItem("/tools/search", this.translate("menu.tools.search"), "search16", this::searchActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/tools/replace", this.translate("menu.tools.replace"), "replace32", this::replaceActionPerformed, 3, null, true, null, false);
        this.addToggleMenuItem("/tools/timeline", this.translate("menu.tools.timeline"), null, "timeline32", this::timelineActionPerformed, 3, null);
        this.addMenuItem("/tools/showProxy", this.translate("menu.tools.proxy"), "proxy16", this::showProxyActionPerformed, 2, null, true, null, false);
        if (Platform.isWindows()) {
            this.addMenuItem("/tools/searchMemory", this.translate("menu.tools.searchMemory"), "loadmemory16", this::searchMemoryActionPerformed, 2, null, true, null, false);
        }
        this.addMenuItem("/tools/deobfuscation", this.translate("menu.tools.deobfuscation"), "deobfuscate16", null, 0, null, false, null, false);
        this.addMenuItem("/tools/deobfuscation/renameOneIdentifier", this.translate("menu.tools.deobfuscation.globalrename"), "rename16", this::renameOneIdentifier, 2, null, true, null, false);
        this.addMenuItem("/tools/deobfuscation/renameInvalidIdentifiers", this.translate("menu.tools.deobfuscation.renameinvalid"), "renameall16", this::renameInvalidIdentifiers, 2, null, true, null, false);
        this.addMenuItem("/tools/deobfuscation/renameColliding", this.translate("menu.tools.deobfuscation.renameColliding"), "renameall16", this::renameColliding, 2, null, true, null, false);
        this.addMenuItem("/tools/deobfuscation/deobfuscation", this.translate("menu.tools.deobfuscation.pcode"), "deobfuscate32", this::deobfuscationActionPerformed, 3, null, true, null, false);
        this.finishMenu("/tools/deobfuscation");
        this.addMenuItem("/tools/gotoDocumentClass", this.translate("menu.tools.gotoDocumentClass"), "gotomainclass32", this::gotoDucumentClassActionPerformed, 3, null, true, null, false);
        this.finishMenu("/tools");
        this.addMenuItem("/settings", this.translate("menu.settings"), null, null, 0, null, false, null, false);
        this.addToggleMenuItem("/settings/autoDeobfuscation", this.translate("menu.settings.autodeobfuscation"), null, null, this::autoDeobfuscationActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/simplifyExpressions", this.translate("menu.settings.simplifyExpressions"), null, null, this::simplifyExpressionsActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/internalViewer", this.translate("menu.settings.internalflashviewer"), null, null, this::internalViewerSwitchActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/parallelSpeedUp", this.translate("menu.settings.parallelspeedup"), null, null, this::parallelSpeedUpActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/disableDecompilation", this.translate("menu.settings.disabledecompilation"), null, null, this::disableDecompilationActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/gotoMainClassOnStartup", this.translate("menu.settings.gotoMainClassOnStartup"), null, null, this::gotoDucumentClassOnStartupActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/autoRenameIdentifiers", this.translate("menu.settings.autoRenameIdentifiers"), null, null, this::autoRenameIdentifiersActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/autoOpenLoadedSWFs", this.translate("menu.settings.autoOpenLoadedSWFs"), null, null, this::autoOpenLoadedSWFsActionPerformed, 0, null);
        if (Platform.isWindows()) {
            this.addToggleMenuItem("/settings/associate", this.translate("menu.settings.addtocontextmenu"), null, null, this::associateActionPerformed, 0, null);
        }
        this.addMenuItem("/settings/language", this.translate("menu.language"), null, null, 0, null, false, null, false);
        this.addMenuItem("/settings/language/setLanguage", this.translate("menu.settings.language"), "setlanguage32", this::setLanguageActionPerformed, 3, null, true, null, false);
        this.finishMenu("/settings/language");
        this.addMenuItem("/settings/advancedSettings", this.translate("menu.advancedsettings.advancedsettings"), null, null, 0, null, false, null, false);
        this.addMenuItem("/settings/advancedSettings/advancedSettings", this.translate("menu.advancedsettings.advancedsettings"), "settings32", this::advancedSettingsActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/settings/advancedSettings/clearRecentFiles", this.translate("menu.tools.otherTools.clearRecentFiles"), "clearrecent16", this::clearRecentFilesActionPerformed, 2, null, true, null, false);
        this.finishMenu("/settings/advancedSettings");
        this.finishMenu("/settings");
        this.setMenuChecked("/settings/autoDeobfuscation", (Boolean)Configuration.autoDeobfuscate.get());
        this.configListenerAutoDeobfuscate = newValue -> this.setMenuChecked("/settings/autoDeobfuscation", (boolean)newValue);
        Configuration.autoDeobfuscate.addListener(this.configListenerAutoDeobfuscate);
        this.setMenuChecked("/settings/simplifyExpressions", (Boolean)Configuration.simplifyExpressions.get());
        this.configListenerSimplifyExpressions = newValue -> this.setMenuChecked("/settings/simplifyExpressions", (boolean)newValue);
        Configuration.simplifyExpressions.addListener(this.configListenerSimplifyExpressions);
        this.setMenuChecked("/settings/internalViewer", (Boolean)Configuration.internalFlashViewer.get() != false || this.externalFlashPlayerUnavailable);
        this.configListenerInternalFlashViewer = newValue -> this.setMenuChecked("/settings/internalViewer", newValue != false || this.externalFlashPlayerUnavailable);
        Configuration.internalFlashViewer.addListener(this.configListenerInternalFlashViewer);
        this.setMenuChecked("/settings/parallelSpeedUp", (Boolean)Configuration.parallelSpeedUp.get());
        this.configListenerParallelSpeedUp = newValue -> this.setMenuChecked("/settings/parallelSpeedUp", (boolean)newValue);
        Configuration.parallelSpeedUp.addListener(this.configListenerParallelSpeedUp);
        this.setMenuChecked("/settings/disableDecompilation", (Boolean)Configuration.decompile.get() == false);
        this.configListenerDecompile = newValue -> this.setMenuChecked("/settings/disableDecompilation", newValue == false);
        Configuration.decompile.addListener(this.configListenerDecompile);
        this.setMenuChecked("/settings/gotoMainClassOnStartup", (Boolean)Configuration.gotoMainClassOnStartup.get());
        this.configListenerGotoMainClassOnStartup = newValue -> this.setMenuChecked("/settings/gotoMainClassOnStartup", (boolean)newValue);
        Configuration.gotoMainClassOnStartup.addListener(this.configListenerGotoMainClassOnStartup);
        this.setMenuChecked("/settings/autoRenameIdentifiers", (Boolean)Configuration.autoRenameIdentifiers.get());
        this.configListenerAutoRenameIdentifiers = newValue -> this.setMenuChecked("/settings/autoRenameIdentifiers", (boolean)newValue);
        Configuration.autoRenameIdentifiers.addListener(this.configListenerAutoRenameIdentifiers);
        this.setMenuChecked("/settings/autoOpenLoadedSWFs", (Boolean)Configuration.autoOpenLoadedSWFs.get());
        this.configListenerAutoOpenLoadedSWFs = newValue -> this.setMenuChecked("/settings/autoOpenLoadedSWFs", (boolean)newValue);
        Configuration.autoOpenLoadedSWFs.addListener(this.configListenerAutoOpenLoadedSWFs);
        if (this.externalFlashPlayerUnavailable) {
            this.setMenuEnabled("/settings/internalViewer", false);
            this.setMenuEnabled("/settings/autoOpenLoadedSWFs", false);
        }
        if (Platform.isWindows()) {
            this.setMenuChecked("/settings/associate", ContextMenuTools.isAddedToContextMenu());
        }
        this.addMenuItem("/help", this.translate("menu.help"), null, null, 0, null, false, null, false);
        this.addMenuItem("/help/helpUs", this.translate("menu.help.helpus"), "donate32", this::helpUsActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/help/homePage", this.translate("menu.help.homepage"), "homepage16", this::homePageActionPerformed, 2, null, true, null, false);
        this.addSeparator("/help");
        this.addMenuItem("/help/checkUpdates", this.translate("menu.help.checkupdates"), "update16", this::checkUpdatesActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/help/about", this.translate("menu.help.about"), "about32", this::aboutActionPerformed, 3, null, true, null, false);
        this.finishMenu("/help");
        if (((Boolean)Configuration._showDebugMenu.get()).booleanValue() || ((Boolean)Configuration._debugMode.get()).booleanValue()) {
            this.addMenuItem("/debug", "# FFDec Debug #", null, null, 0, null, false, null, false);
            this.addMenuItem("/debug/removeNonScripts", "Remove non scripts", "continue16", e -> this.removeNonScripts(), 2, null, true, null, false);
            this.addMenuItem("/debug/removeExceptSelected", "Remove except selected", "continue16", e -> this.removeExceptSelected(), 2, null, true, null, false);
            this.addMenuItem("/debug/refreshDecompiled", "Refresh decompiled script", "continue16", e -> this.refreshDecompiled(), 2, null, true, null, false);
            this.addMenuItem("/debug/checkResources", "Check resources", "continue16", e -> this.checkResources(), 2, null, true, null, false);
            this.addMenuItem("/debug/callGc", "Call System.gc()", "continue16", e -> System.gc(), 2, null, true, null, false);
            this.addMenuItem("/debug/emptyCache", "Empty cache", "continue16", e -> {
                SWF nswf = this.mainFrame.getPanel().getCurrentSwf();
                if (nswf != null) {
                    nswf.clearAllCache();
                }
            }, 2, null, true, null, false);
            this.addMenuItem("/debug/memoryInformation", "Memory information", "continue16", e -> {
                String architecture = System.getProperty("sun.arch.data.model");
                Runtime runtime = Runtime.getRuntime();
                String info = "Architecture: " + architecture + Helper.newLine + "Jre 64bit: " + Helper.is64BitJre() + Helper.newLine + "Os 64bit: " + Helper.is64BitOs() + Helper.newLine + "Max: " + runtime.maxMemory() / 1024L / 1024L + "MB" + Helper.newLine + "Used: " + runtime.totalMemory() / 1024L / 1024L + "MB" + Helper.newLine + "Free: " + runtime.freeMemory() / 1024L / 1024L + "MB";
                View.showMessageDialog(null, info);
                SWF nswf = this.mainFrame.getPanel().getCurrentSwf();
                if (nswf != null) {
                    nswf.clearAllCache();
                }
            }, 2, null, true, null, false);
            this.addMenuItem("/debug/fixAs3Code", "Fix AS3 code", "continue16", e -> {
                SWF nswf = this.mainFrame.getPanel().getCurrentSwf();
                if (nswf != null) {
                    nswf.fixAS3Code();
                }
            }, 2, null, true, null, false);
            this.addMenuItem("/debug/openTestSwfs", "Open test SWFs", "continue16", e -> {
                SWFSourceInfo[] sourceInfos = new SWFSourceInfo[2];
                String mainPath = Main.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                String path = mainPath + "\\..\\..\\libsrc\\ffdec_lib\\testdata\\as2\\as2.swf";
                sourceInfos[0] = new SWFSourceInfo(null, path, null);
                path = mainPath + "\\..\\..\\libsrc\\ffdec_lib\\testdata\\as3\\as3.swf";
                sourceInfos[1] = new SWFSourceInfo(null, path, null);
                Main.openFile(sourceInfos);
            }, 2, null, true, null, false);
            this.addMenuItem("/debug/createNewSwf", "Create new SWF", "continue16", e -> {
                SWF swf = new SWF();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    swf.saveTo((OutputStream)baos);
                }
                catch (IOException ex) {
                    Logger.getLogger(MainFrameMenu.class.getName()).log(Level.SEVERE, null, ex);
                }
                Main.openFile(new SWFSourceInfo((InputStream)new ByteArrayInputStream(baos.toByteArray()), "New SWF", "New SWF"));
            }, 2, null, true, null, false);
            this.finishMenu("/debug");
        }
        this.finishMenu("");
    }

    public void showResourcesView() {
        this.viewResourcesActionPerformed(null);
    }

    private void viewResourcesActionPerformed(ActionEvent evt) {
        Configuration.dumpView.set((Object)false);
        this.mainFrame.getPanel().showView(0);
        this.setGroupSelection("view", "/file/view/viewResources");
        this.setMenuChecked("/tools/timeline", false);
    }

    private void viewHexActionPerformed(ActionEvent evt) {
        Configuration.dumpView.set((Object)true);
        MainPanel mainPanel = this.mainFrame.getPanel();
        if (mainPanel.isModified()) {
            View.showMessageDialog(null, this.translate("message.warning.hexViewNotUpToDate"), this.translate("message.warning"), 2, (ConfigurationItem<Boolean>)Configuration.warningHexViewNotUpToDate);
        }
        mainPanel.showView(1);
        this.setGroupSelection("view", "/file/view/viewHex");
        this.setMenuChecked("/tools/timeline", false);
    }

    private void debuggerSwitchActionPerformed(ActionEvent evt) {
        boolean debuggerOn = this.isMenuChecked("/tools/debugger/debuggerSwitch");
        if (!debuggerOn || View.showConfirmDialog((Component)((Object)this.mainFrame), this.translate("message.debugger"), this.translate("dialog.message.title"), 2, 1, (ConfigurationItem<Boolean>)Configuration.displayDebuggerInfo, 0) == 0) {
            this.switchDebugger();
            this.mainFrame.getPanel().refreshDecompiled();
        } else {
            this.setMenuChecked("/tools/debugger/debuggerSwitch", false);
        }
        this.setMenuEnabled("/tools/debugger/debuggerReplaceTrace", this.isMenuChecked("/tools/debugger/debuggerSwitch"));
    }

    private void timelineActionPerformed(ActionEvent evt) {
        if (this.isMenuChecked("/tools/timeline")) {
            if (!this.mainFrame.getPanel().showView(2)) {
                this.setMenuChecked("/tools/timeline", false);
            } else {
                this.setGroupSelection("view", null);
            }
        } else if (((Boolean)Configuration.dumpView.get()).booleanValue()) {
            this.setGroupSelection("view", "/file/view/viewHex");
            this.mainFrame.getPanel().showView(1);
        } else {
            this.setGroupSelection("view", "/file/view/viewResources");
            this.mainFrame.getPanel().showView(0);
        }
    }

    protected void loadRecent(ActionEvent evt) {
        List recentFiles = Configuration.getRecentFiles();
        this.clearMenu("/file/" + (this.supportsMenuAction() ? "open" : "recent"));
        this.clearMenu("_/open");
        for (int i = recentFiles.size() - 1; i >= 0; --i) {
            String f = (String)recentFiles.get(i);
            ActionListener a = e -> {
                if (Main.openFile(f, null) == OpenFileResult.NOT_FOUND && View.showConfirmDialog(null, this.translate("message.confirm.recentFileNotFound"), this.translate("message.confirm"), 0) == 0) {
                    Configuration.removeRecentFile((String)f);
                }
            };
            this.addMenuItem("/file/" + (this.supportsMenuAction() ? "open" : "recent") + "/" + i, f, null, a, 0, null, true, null, false);
            this.addMenuItem("_/open/" + i, f, null, a, 0, null, true, null, false);
        }
        this.finishMenu("/file/" + (this.supportsMenuAction() ? "open" : "recent"));
        this.finishMenu("_/open");
    }

    public void dispose() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.removeKeyEventDispatcher(this.keyEventDispatcher);
        Configuration.autoDeobfuscate.removeListener(this.configListenerAutoDeobfuscate);
        Configuration.simplifyExpressions.removeListener(this.configListenerSimplifyExpressions);
        Configuration.internalFlashViewer.removeListener(this.configListenerInternalFlashViewer);
        Configuration.parallelSpeedUp.removeListener(this.configListenerParallelSpeedUp);
        Configuration.decompile.removeListener(this.configListenerDecompile);
        Configuration.gotoMainClassOnStartup.removeListener(this.configListenerGotoMainClassOnStartup);
        Configuration.autoRenameIdentifiers.removeListener(this.configListenerAutoRenameIdentifiers);
        Configuration.autoOpenLoadedSWFs.removeListener(this.configListenerAutoOpenLoadedSWFs);
        Main.stopRun();
    }

    public boolean runActionPerformed(ActionEvent evt) {
        Main.run(this.swf);
        return true;
    }

    public boolean debugActionPerformed(ActionEvent evt) {
        Main.runDebug(this.swf, false);
        return true;
    }

    public boolean debugPCodeActionPerformed(ActionEvent evt) {
        Main.runDebug(this.swf, true);
        return true;
    }

    public boolean stopActionPerformed(ActionEvent evt) {
        Main.stopRun();
        return true;
    }

    public boolean pauseActionPerformed(ActionEvent evt) {
        try {
            DebuggerCommands debuggerCommands = Main.getDebugHandler().getCommands();
        }
        catch (IOException ex) {
            Main.getDebugHandler().disconnect();
        }
        return true;
    }

    public boolean stepOverActionPerformed(ActionEvent evt) {
        try {
            DebuggerCommands cmd = Main.getDebugHandler().getCommands();
            this.mainFrame.getPanel().clearDebuggerColors();
            Main.startWork(AppStrings.translate("work.debugging") + "...", null);
            cmd.stepOver();
        }
        catch (IOException ex) {
            Main.getDebugHandler().disconnect();
        }
        return true;
    }

    public boolean stepIntoActionPerformed(ActionEvent evt) {
        try {
            DebuggerCommands cmd = Main.getDebugHandler().getCommands();
            this.mainFrame.getPanel().clearDebuggerColors();
            Main.startWork(AppStrings.translate("work.debugging") + "...", null);
            cmd.stepInto();
        }
        catch (IOException ex) {
            Main.getDebugHandler().disconnect();
        }
        return true;
    }

    public boolean stepOutActionPerformed(ActionEvent evt) {
        try {
            DebuggerCommands cmd = Main.getDebugHandler().getCommands();
            this.mainFrame.getPanel().clearDebuggerColors();
            Main.startWork(AppStrings.translate("work.debugging") + "...", null);
            cmd.stepOut();
        }
        catch (IOException ex) {
            Main.getDebugHandler().disconnect();
        }
        return true;
    }

    public boolean continueActionPerformed(ActionEvent evt) {
        try {
            DebuggerCommands cmd = Main.getDebugHandler().getCommands();
            this.mainFrame.getPanel().clearDebuggerColors();
            Main.startWork(AppStrings.translate("work.debugging") + "...", null);
            cmd.sendContinue();
        }
        catch (IOException ex) {
            Main.getDebugHandler().disconnect();
        }
        return true;
    }

    public boolean stackActionPerformed(ActionEvent evt) {
        return true;
    }

    public boolean watchActionPerformed(ActionEvent evt) {
        return true;
    }

    public boolean dispatchKeyEvent(KeyEvent e) {
        if (((JFrame)((Object)this.mainFrame)).isActive() && e.getID() == 401) {
            MenuBuilder.HotKey ek = new MenuBuilder.HotKey(e);
            for (String path : this.menuHotkeys.keySet()) {
                MenuBuilder.HotKey mk = this.menuHotkeys.get(path);
                if (!ek.equals(mk) || !this.menuActions.containsKey(path)) continue;
                this.menuActions.get(path).actionPerformed(null);
                return true;
            }
            int code = e.getKeyCode();
            if (e.isControlDown() && e.isShiftDown()) {
                switch (code) {
                    case 70: {
                        return this.searchInActionPerformed(null);
                    }
                    case 84: {
                        return this.searchInTextPerformed(null);
                    }
                    case 68: {
                        return this.clearLog(null);
                    }
                }
            } else if (e.isControlDown() && !e.isShiftDown()) {
                switch (code) {
                    case 38: {
                        return this.previousTag(null);
                    }
                    case 40: {
                        return this.nextTag(null);
                    }
                }
            }
        }
        return false;
    }

    public abstract void hilightPath(String var1);

    public abstract void setPathVisible(String var1, boolean var2);
}

