/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.debugger.flash.DebugConnectionListener;
import com.jpexs.debugger.flash.Debugger;
import com.jpexs.debugger.flash.DebuggerCommands;
import com.jpexs.debugger.flash.Variable;
import com.jpexs.debugger.flash.messages.in.InCallFunction;
import com.jpexs.decompiler.flash.ApplicationInfo;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFBundle;
import com.jpexs.decompiler.flash.SWFSourceInfo;
import com.jpexs.decompiler.flash.SearchMode;
import com.jpexs.decompiler.flash.SwfOpenException;
import com.jpexs.decompiler.flash.UrlResolver;
import com.jpexs.decompiler.flash.Version;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.Reference;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.SwfSpecificConfiguration;
import com.jpexs.decompiler.flash.console.CommandLineArgumentParser;
import com.jpexs.decompiler.flash.console.ContextMenuTools;
import com.jpexs.decompiler.flash.exporters.modes.ExeExportMode;
import com.jpexs.decompiler.flash.gui.AboutDialog;
import com.jpexs.decompiler.flash.gui.AdvancedSettingsDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.DebugLogDialog;
import com.jpexs.decompiler.flash.gui.DebuggerHandler;
import com.jpexs.decompiler.flash.gui.ErrorLogFrame;
import com.jpexs.decompiler.flash.gui.LoadFromCacheFrame;
import com.jpexs.decompiler.flash.gui.LoadFromMemoryFrame;
import com.jpexs.decompiler.flash.gui.LoadingDialog;
import com.jpexs.decompiler.flash.gui.LogFormatter;
import com.jpexs.decompiler.flash.gui.MainFrame;
import com.jpexs.decompiler.flash.gui.MainFrameClassic;
import com.jpexs.decompiler.flash.gui.MainFrameRibbon;
import com.jpexs.decompiler.flash.gui.NewVersionDialog;
import com.jpexs.decompiler.flash.gui.OpenFileResult;
import com.jpexs.decompiler.flash.gui.SaveFileMode;
import com.jpexs.decompiler.flash.gui.SelectLanguageDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.debugger.DebugListener;
import com.jpexs.decompiler.flash.gui.debugger.DebuggerTools;
import com.jpexs.decompiler.flash.gui.pipes.FirstInstance;
import com.jpexs.decompiler.flash.gui.proxy.ProxyFrame;
import com.jpexs.decompiler.flash.helpers.SWFDecompilerPlugin;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImportTag;
import com.jpexs.decompiler.flash.treeitems.SWFList;
import com.jpexs.helpers.Cache;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.ProgressListener;
import com.jpexs.helpers.Stopwatch;
import com.jpexs.helpers.streams.SeekableInputStream;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinReg;
import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;

public class Main {
    protected static ProxyFrame proxyFrame;
    private static List<SWFSourceInfo> sourceInfos;
    public static LoadingDialog loadingDialog;
    private static boolean working;
    private static TrayIcon trayIcon;
    private static MenuItem stopMenuItem;
    private static volatile MainFrame mainFrame;
    public static final int UPDATE_SYSTEM_MAJOR = 1;
    public static final int UPDATE_SYSTEM_MINOR = 3;
    private static LoadFromMemoryFrame loadFromMemoryFrame;
    private static LoadFromCacheFrame loadFromCacheFrame;
    private static final Logger logger;
    public static DebugLogDialog debugDialog;
    public static boolean shouldCloseWhenClosingLoadingDialog;
    private static Debugger flashDebugger;
    private static DebuggerHandler debugHandler;
    private static Process runProcess;
    private static boolean runProcessDebug;
    private static boolean runProcessDebugPCode;
    private static boolean inited;
    private static File runTempFile;
    private static List<File> runTempFiles;
    private static FileHandler fileTxt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeRun() {
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            if (runTempFile != null) {
                runTempFile.delete();
                runTempFile = null;
            }
            for (File f : runTempFiles) {
                f.delete();
            }
            runTempFiles.clear();
            runProcess = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            if (mainFrame != null && mainFrame.getPanel() != null) {
                mainFrame.getPanel().clearDebuggerColors();
            }
            if (runProcessDebug) {
                Main.getDebugHandler().disconnect();
            }
            return;
        }
    }

    public static synchronized boolean isDebugPaused() {
        return runProcess != null && runProcessDebug && Main.getDebugHandler().isPaused();
    }

    public static synchronized boolean isDebugRunning() {
        return runProcess != null && runProcessDebug;
    }

    public static synchronized boolean isDebugPCode() {
        return runProcessDebugPCode;
    }

    public static synchronized boolean isDebugConnected() {
        return Main.getDebugHandler().isConnected();
    }

    public static synchronized boolean isRunning() {
        return runProcess != null && !runProcessDebug;
    }

    public static synchronized void dumpBytes(Variable v) {
        try {
            long objectId = 0L;
            if (v.vType == 3 || v.vType == 5) {
                objectId = (Long)v.value;
            }
            Object oldPos = Main.getDebugHandler().getVariable((long)objectId, (String)"position", (boolean)true).parent.value;
            Main.getDebugHandler().setVariable(objectId, "position", 0, 0);
            InCallFunction icf = Main.getDebugHandler().callFunction(false, "readUTF", v, new ArrayList<Object>());
            System.out.println("Result=" + ((Variable)icf.variables.get((int)0)).value);
            Main.getDebugHandler().setVariable(objectId, "position", 0, oldPos);
        }
        catch (DebuggerHandler.ActionScriptException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static synchronized boolean addWatch(Variable v, long v_id, boolean watchRead, boolean watchWrite) {
        DebuggerCommands.Watch w = Main.getDebugHandler().addWatch(v, v_id, watchRead, watchWrite);
        return w != null;
    }

    public static void runPlayer(String title, final String exePath, String file, String flashVars) {
        if (!new File(file).exists()) {
            return;
        }
        if (flashVars != null && !flashVars.isEmpty()) {
            file = file + "?" + flashVars;
        }
        final String ffile = file;
        CancellableWorker runWorker = new CancellableWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground() throws Exception {
                Process proc;
                try {
                    proc = Runtime.getRuntime().exec(new String[]{exePath, ffile});
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                    return null;
                }
                Class<Main> clazz = Main.class;
                synchronized (Main.class) {
                    block11: {
                        runProcess = proc;
                        boolean isDebug = runProcessDebug;
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        if (isDebug) {
                            mainFrame.getMenu().hilightPath("/debugging");
                        }
                        mainFrame.getMenu().updateComponents();
                        try {
                            if (proc != null) {
                                proc.waitFor();
                            }
                        }
                        catch (InterruptedException ex) {
                            if (proc == null) break block11;
                            try {
                                proc.destroy();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    Main.freeRun();
                    Main.stopDebugger();
                    mainFrame.getMenu().updateComponents();
                    return null;
                }
            }

            protected void done() {
                Main.stopWork();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void workerCancelled() {
                Main.stopWork();
                Class<Main> clazz = Main.class;
                synchronized (Main.class) {
                    if (runProcess != null) {
                        try {
                            runProcess.destroy();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    Main.freeRun();
                    mainFrame.getMenu().updateComponents();
                    return;
                }
            }
        };
        mainFrame.getMenu().updateComponents();
        Main.startWork(title + "...", runWorker);
        runWorker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopRun() {
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            if (runProcess != null) {
                runProcess.destroy();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            Main.freeRun();
            Main.stopDebugger();
            mainFrame.getMenu().updateComponents();
            return;
        }
    }

    private static void prepareSwf(SwfPreparation prep, File toPrepareFile, File origFile, List<File> tempFiles) throws IOException {
        Throwable throwable;
        SWF instrSWF = null;
        try {
            throwable = null;
            try (FileInputStream fis = new FileInputStream(toPrepareFile);){
                instrSWF = new SWF((InputStream)fis, toPrepareFile.getAbsolutePath(), origFile.getName(), false);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        if (instrSWF != null) {
            for (Tag t : instrSWF.getLocalTags()) {
                if (!(t instanceof ImportTag)) continue;
                ImportTag it = (ImportTag)t;
                String url = it.getUrl();
                File importedFile = new File(origFile.getParentFile(), url);
                if (!importedFile.exists()) continue;
                File newTempFile = File.createTempFile("ffdec_run_import_", ".swf");
                it.setUrl("./" + newTempFile.getName());
                byte[] impData = Helper.readFile((String[])new String[]{importedFile.getAbsolutePath()});
                Helper.writeFile((String)newTempFile.getAbsolutePath(), (byte[][])new byte[][]{impData});
                tempFiles.add(newTempFile);
                Main.prepareSwf(prep, newTempFile, importedFile, tempFiles);
            }
            if (prep != null) {
                instrSWF = prep.prepare(instrSWF);
            }
            throwable = null;
            try (FileOutputStream fos = new FileOutputStream(toPrepareFile);){
                instrSWF.saveTo((OutputStream)fos);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void run(SWF swf) {
        File tempFile;
        String flashVars = "";
        String playerLocation = (String)Configuration.playerLocation.get();
        if (playerLocation.isEmpty() || !new File(playerLocation).exists()) {
            View.showMessageDialog(null, AppStrings.translate("message.playerpath.notset"), AppStrings.translate("error"), 0);
            Main.advancedSettings("paths");
            return;
        }
        if (swf == null) {
            return;
        }
        ArrayList<File> tempFiles = new ArrayList<File>();
        try {
            tempFile = File.createTempFile("ffdec_run_", ".swf");
            try (FileOutputStream fos = new FileOutputStream(tempFile);){
                swf.saveTo((OutputStream)fos);
            }
            Main.prepareSwf(new SwfRunPrepare(), tempFile, new File(swf.getFile()), tempFiles);
        }
        catch (IOException ex) {
            return;
        }
        if (tempFile == null) return;
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            runTempFile = tempFile;
            runTempFiles = tempFiles;
            runProcessDebug = false;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            Main.runPlayer(AppStrings.translate("work.running"), playerLocation, tempFile.getAbsolutePath(), flashVars);
            return;
        }
    }

    public static void runDebug(final SWF swf, final boolean doPCode) {
        final String flashVars = "";
        final String playerLocation = (String)Configuration.playerDebugLocation.get();
        if (playerLocation.isEmpty() || !new File(playerLocation).exists()) {
            View.showMessageDialog(null, AppStrings.translate("message.playerpath.debug.notset"), AppStrings.translate("error"), 0);
            Main.advancedSettings("paths");
            return;
        }
        if (swf == null) {
            return;
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile("ffdec_debug_", ".swf");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tempFile != null) {
            final File fTempFile = tempFile;
            final ArrayList tempFiles = new ArrayList();
            CancellableWorker instrumentWorker = new CancellableWorker(){

                protected Object doInBackground() throws Exception {
                    try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(fTempFile));){
                        swf.saveTo((OutputStream)fos);
                    }
                    Main.prepareSwf(new SwfDebugPrepare(doPCode), fTempFile, new File(swf.getFile()), tempFiles);
                    return null;
                }

                public void workerCancelled() {
                    Main.stopWork();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void done() {
                    Class<Main> clazz = Main.class;
                    synchronized (Main.class) {
                        runTempFile = fTempFile;
                        runProcessDebug = true;
                        runProcessDebugPCode = doPCode;
                        runTempFiles = tempFiles;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        Main.stopWork();
                        Main.startDebugger();
                        Main.runPlayer(AppStrings.translate("work.debugging.wait"), playerLocation, fTempFile.getAbsolutePath(), flashVars);
                        return;
                    }
                }
            };
            Main.startWork(AppStrings.translate("work.debugging.instrumenting"), instrumentWorker);
            instrumentWorker.execute();
        }
    }

    public static boolean isDebugging() {
        return Main.isDebugRunning();
    }

    public static synchronized int getIp(Object pack) {
        return Main.getDebugHandler().getBreakIp();
    }

    public static synchronized String getIpClass() {
        return Main.getDebugHandler().getBreakScriptName();
    }

    public static synchronized boolean isBreakPointValid(String scriptName, int line) {
        return !Main.getDebugHandler().isBreakpointInvalid(scriptName, line);
    }

    public static synchronized void addBreakPoint(String scriptName, int line) {
        Main.getDebugHandler().addBreakPoint(scriptName, line);
    }

    public static synchronized void removeBreakPoint(String scriptName, int line) {
        Main.getDebugHandler().removeBreakPoint(scriptName, line);
    }

    public static synchronized boolean toggleBreakPoint(String scriptName, int line) {
        if (Main.getDebugHandler().isBreakpointToAdd(scriptName, line) || Main.getDebugHandler().isBreakpointConfirmed(scriptName, line) || Main.getDebugHandler().isBreakpointInvalid(scriptName, line)) {
            Main.getDebugHandler().removeBreakPoint(scriptName, line);
            return false;
        }
        Main.getDebugHandler().addBreakPoint(scriptName, line);
        return true;
    }

    public static synchronized Map<String, Set<Integer>> getPackBreakPoints(boolean validOnly) {
        return Main.getDebugHandler().getAllBreakPoints(validOnly);
    }

    public static synchronized Set<Integer> getScriptBreakPoints(String pack, boolean onlyValid) {
        return Main.getDebugHandler().getBreakPoints(pack, onlyValid);
    }

    public static DebuggerHandler getDebugHandler() {
        return debugHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void ensureMainFrame() {
        if (mainFrame != null) return;
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            if (mainFrame != null) return;
            MainFrame frame = (Boolean)Configuration.useRibbonInterface.get() != false ? new MainFrameRibbon() : new MainFrameClassic();
            frame.getPanel().setErrorState(ErrorLogFrame.getInstance().getErrorState());
            mainFrame = frame;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static MainFrame getMainFrame() {
        return mainFrame;
    }

    public static void loadFromCache() {
        if (loadFromCacheFrame == null) {
            loadFromCacheFrame = new LoadFromCacheFrame();
        }
        loadFromCacheFrame.setVisible(true);
    }

    public static void loadFromMemory() {
        if (loadFromMemoryFrame == null) {
            loadFromMemoryFrame = new LoadFromMemoryFrame(mainFrame);
        }
        loadFromMemoryFrame.setVisible(true);
    }

    public static void setVariable(long parentId, String varName, int valueType, Object value) {
        Main.getDebugHandler().setVariable(parentId, varName, valueType, value);
    }

    public static void setSubLimiter(boolean value) {
        AVM2Code.toSourceLimit = value ? (Integer)Configuration.sublimiter.get() : -1;
    }

    public static synchronized boolean isInited() {
        return inited;
    }

    public static synchronized void setSessionLoaded(boolean v) {
        inited = v;
    }

    public static boolean isWorking() {
        return working;
    }

    public static void startProxy(int port) {
        if (proxyFrame == null) {
            proxyFrame = new ProxyFrame(mainFrame);
        }
        proxyFrame.setPort(port);
        Main.addTrayIcon();
        Main.switchProxy();
    }

    public static void showProxy() {
        if (proxyFrame == null) {
            proxyFrame = new ProxyFrame(mainFrame);
        }
        proxyFrame.setVisible(true);
        proxyFrame.setState(0);
    }

    public static void startWork(String name, CancellableWorker worker) {
        Main.startWork(name, -1, worker);
    }

    public static void startWork(String name, int percent, CancellableWorker worker) {
        working = true;
        View.execInEventDispatchLater(() -> {
            if (mainFrame != null) {
                mainFrame.getPanel().setWorkStatus(name, worker);
                if (percent == -1) {
                    mainFrame.getPanel().hidePercent();
                } else {
                    mainFrame.getPanel().setPercent(percent);
                }
            }
            if (loadingDialog != null) {
                loadingDialog.setDetail(name);
                loadingDialog.setPercent(percent);
            }
            if (CommandLineArgumentParser.isCommandLineMode()) {
                System.out.println(name);
            }
        });
    }

    public static void stopWork() {
        working = false;
        View.execInEventDispatchLater(() -> {
            if (mainFrame != null) {
                mainFrame.getPanel().setWorkStatus("", null);
            }
            if (loadingDialog != null) {
                loadingDialog.setDetail("");
            }
        });
    }

    public static SWFList parseSWF(final SWFSourceInfo sourceInfo) throws Exception {
        SWFList result = new SWFList();
        InputStream inputStream = sourceInfo.getInputStream();
        SWFBundle bundle = null;
        FileInputStream fis = null;
        if (inputStream == null) {
            fis = new FileInputStream(sourceInfo.getFile());
            inputStream = new BufferedInputStream(fis);
            bundle = sourceInfo.getBundle(false, SearchMode.ALL);
            logger.log(Level.INFO, "Load file: {0}", sourceInfo.getFile());
        } else if (inputStream instanceof SeekableInputStream || inputStream instanceof BufferedInputStream) {
            try {
                inputStream.reset();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            logger.log(Level.INFO, "Load stream: {0}", sourceInfo.getFileTitle());
        }
        Stopwatch sw = Stopwatch.startNew();
        if (bundle != null) {
            result.bundle = bundle;
            result.name = new File(sourceInfo.getFileTitleOrName()).getName();
            for (final Map.Entry streamEntry : bundle.getAll().entrySet()) {
                final InputStream stream = (InputStream)streamEntry.getValue();
                stream.reset();
                CancellableWorker<SWF> worker = new CancellableWorker<SWF>(){

                    public SWF doInBackground() throws Exception {
                        final 3 worker = this;
                        SWF swf = new SWF(stream, null, (String)streamEntry.getKey(), new ProgressListener(){

                            public void progress(int p) {
                                Main.startWork(AppStrings.translate("work.reading.swf"), p, worker);
                            }
                        }, ((Boolean)Configuration.parallelSpeedUp.get()).booleanValue());
                        return swf;
                    }
                };
                loadingDialog.setWroker(worker);
                worker.execute();
                try {
                    result.add((SWF)worker.get());
                }
                catch (CancellationException ex) {
                    logger.log(Level.WARNING, "Loading SWF {0} was cancelled.", streamEntry.getKey());
                }
            }
        } else {
            final InputStream fInputStream = inputStream;
            final String[] yesno = new String[]{AppStrings.translate("button.yes"), AppStrings.translate("button.no"), AppStrings.translate("button.yes.all"), AppStrings.translate("button.no.all")};
            CancellableWorker<SWF> worker = new CancellableWorker<SWF>(){
                private boolean yestoall = false;
                private boolean notoall = false;

                private SWF open(InputStream is, final String file, String fileTitle) throws IOException, InterruptedException {
                    final 4 worker = this;
                    SWF swf = new SWF(is, file, fileTitle, new ProgressListener(){

                        public void progress(int p) {
                            Main.startWork(AppStrings.translate("work.reading.swf"), p, worker);
                        }
                    }, ((Boolean)Configuration.parallelSpeedUp.get()).booleanValue(), false, true, new UrlResolver(){

                        public SWF resolveUrl(final String url) {
                            int opt = -1;
                            if (!yestoall && !notoall) {
                                opt = View.showOptionDialog(null, AppStrings.translate("message.imported.swf").replace("%url%", url), AppStrings.translate("message.warning"), 0, 2, null, yesno, AppStrings.translate("button.yes"));
                                if (opt == 2) {
                                    yestoall = true;
                                }
                                if (opt == 3) {
                                    notoall = true;
                                }
                            }
                            if (yestoall) {
                                opt = 0;
                            } else if (notoall) {
                                opt = 1;
                            }
                            if (opt == 1) {
                                return null;
                            }
                            if (url.startsWith("http://") || url.startsWith("https://")) {
                                try {
                                    URL u = new URL(url);
                                    return this.open(u.openStream(), null, url);
                                }
                                catch (Exception u) {}
                            } else {
                                File f = new File(new File(file).getParentFile(), url);
                                if (f.exists()) {
                                    try {
                                        return this.open(new FileInputStream(f), f.getAbsolutePath(), f.getName());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            final Reference ret = new Reference(null);
                            View.execInEventDispatch(new Runnable(){

                                @Override
                                public void run() {
                                    while (0 == View.showConfirmDialog(null, AppStrings.translate("message.imported.swf.manually").replace("%url%", url), AppStrings.translate("error"), 0, 0)) {
                                        JFileChooser fc = new JFileChooser();
                                        fc.setCurrentDirectory(new File((String)Configuration.lastOpenDir.get()));
                                        FileFilter allSupportedFilter = new FileFilter(){
                                            private final String[] supportedExtensions = new String[]{".swf", ".gfx"};

                                            @Override
                                            public boolean accept(File f) {
                                                String name = f.getName().toLowerCase();
                                                for (String ext : this.supportedExtensions) {
                                                    if (!name.endsWith(ext)) continue;
                                                    return true;
                                                }
                                                return f.isDirectory();
                                            }

                                            @Override
                                            public String getDescription() {
                                                String exts = Helper.joinStrings((String[])this.supportedExtensions, (String)"*%s", (String)"; ");
                                                return AppStrings.translate("filter.supported") + " (" + exts + ")";
                                            }
                                        };
                                        fc.setFileFilter(allSupportedFilter);
                                        FileFilter swfFilter = new FileFilter(){

                                            @Override
                                            public boolean accept(File f) {
                                                return f.getName().toLowerCase().endsWith(".swf") || f.isDirectory();
                                            }

                                            @Override
                                            public String getDescription() {
                                                return AppStrings.translate("filter.swf");
                                            }
                                        };
                                        fc.addChoosableFileFilter(swfFilter);
                                        FileFilter gfxFilter = new FileFilter(){

                                            @Override
                                            public boolean accept(File f) {
                                                return f.getName().toLowerCase().endsWith(".gfx") || f.isDirectory();
                                            }

                                            @Override
                                            public String getDescription() {
                                                return AppStrings.translate("filter.gfx");
                                            }
                                        };
                                        fc.addChoosableFileFilter(gfxFilter);
                                        fc.setAcceptAllFileFilterUsed(false);
                                        JFrame f = new JFrame();
                                        View.setWindowIcon(f);
                                        int returnVal = fc.showOpenDialog(f);
                                        if (returnVal != 0) break;
                                        Configuration.lastOpenDir.set((Object)Helper.fixDialogFile((File)fc.getSelectedFile()).getParentFile().getAbsolutePath());
                                        File selFile = Helper.fixDialogFile((File)fc.getSelectedFile());
                                        try {
                                            ret.setVal((Object)this.open(new FileInputStream(selFile), selFile.getAbsolutePath(), selFile.getName()));
                                            break;
                                        }
                                        catch (Exception exception) {
                                        }
                                    }
                                }
                            });
                            return (SWF)ret.getVal();
                        }
                    });
                    return swf;
                }

                public SWF doInBackground() throws Exception {
                    return this.open(fInputStream, sourceInfo.getFile(), sourceInfo.getFileTitle());
                }
            };
            if (loadingDialog != null) {
                loadingDialog.setWroker(worker);
            }
            worker.execute();
            try {
                result.add((SWF)worker.get());
            }
            catch (CancellationException ex) {
                logger.log(Level.WARNING, "Loading SWF {0} was cancelled.", sourceInfo.getFileTitleOrName());
            }
        }
        if (fis != null) {
            logger.log(Level.INFO, "File loaded in {0} seconds.", sw.getElapsedMilliseconds() / 1000L);
            fis.close();
        } else {
            logger.log(Level.INFO, "Stream loaded in {0} seconds.", sw.getElapsedMilliseconds() / 1000L);
        }
        result.sourceInfo = sourceInfo;
        for (SWF swf : result) {
            logger.log(Level.INFO, "");
            logger.log(Level.INFO, "== File information ==");
            logger.log(Level.INFO, "Size: {0}", Helper.formatFileSize((long)swf.fileSize));
            logger.log(Level.INFO, "Flash version: {0}", swf.version);
            int width = (int)((double)(swf.displayRect.Xmax - swf.displayRect.Xmin) / 20.0);
            int height = (int)((double)(swf.displayRect.Ymax - swf.displayRect.Ymin) / 20.0);
            logger.log(Level.INFO, "Width: {0}", width);
            logger.log(Level.INFO, "Height: {0}", height);
            swf.swfList = result;
            swf.addEventListener(new EventListener(){

                public void handleExportingEvent(String type, int index, int count, Object data) {
                    String text = AppStrings.translate("work.exporting");
                    if (type != null && type.length() > 0) {
                        text = text + " " + type;
                    }
                    Main.startWork(text + " " + index + "/" + count + " " + data, null);
                }

                public void handleExportedEvent(String type, int index, int count, Object data) {
                    String text = AppStrings.translate("work.exported");
                    if (type != null && type.length() > 0) {
                        text = text + " " + type;
                    }
                    Main.startWork(text + " " + index + "/" + count + " " + data, null);
                }

                public void handleEvent(String event, Object data) {
                    if (event.equals("exporting") || event.equals("exported")) {
                        throw new Error("Event is not supported by this handler.");
                    }
                    if (event.equals("getVariables")) {
                        Main.startWork(AppStrings.translate("work.gettingvariables") + "..." + (String)data, null);
                    }
                    if (event.equals("deobfuscate")) {
                        Main.startWork(AppStrings.translate("work.deobfuscating") + "..." + (String)data, null);
                    }
                    if (event.equals("rename")) {
                        Main.startWork(AppStrings.translate("work.renaming") + "..." + (String)data, null);
                    }
                }
            });
        }
        return result;
    }

    public static void saveFile(SWF swf, String outfile) throws IOException {
        Main.saveFile(swf, outfile, SaveFileMode.SAVE, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveFile(SWF swf, String outfile, SaveFileMode mode, ExeExportMode exeExportMode) throws IOException {
        if (mode == SaveFileMode.SAVEAS && !swf.swfList.isBundle()) {
            swf.setFile(outfile);
            swf.swfList.sourceInfo.setFile(outfile);
        }
        File outfileF = new File(outfile);
        File tmpFile = new File(outfile + ".tmp");
        try (FileOutputStream fos = new FileOutputStream(tmpFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            if (mode == SaveFileMode.EXE) {
                switch (exeExportMode) {
                    case WRAPPER: {
                        InputStream exeStream = View.class.getClassLoader().getResourceAsStream("com/jpexs/helpers/resource/Swf2Exe.bin");
                        Helper.copyStream((InputStream)exeStream, (OutputStream)bos);
                        int width = swf.displayRect.Xmax - swf.displayRect.Xmin;
                        int height = swf.displayRect.Ymax - swf.displayRect.Ymin;
                        bos.write(width & 0xFF);
                        bos.write(width >> 8 & 0xFF);
                        bos.write(width >> 16 & 0xFF);
                        bos.write(width >> 24 & 0xFF);
                        bos.write(height & 0xFF);
                        bos.write(height >> 8 & 0xFF);
                        bos.write(height >> 16 & 0xFF);
                        bos.write(height >> 24 & 0xFF);
                        bos.write((Integer)Configuration.saveAsExeScaleMode.get());
                        break;
                    }
                    case PROJECTOR_WIN: 
                    case PROJECTOR_MAC: 
                    case PROJECTOR_LINUX: {
                        File projectorFile = Configuration.getProjectorFile((ExeExportMode)exeExportMode);
                        if (projectorFile == null) {
                            String message = "Projector not found, please place it to " + Configuration.getProjectorPath();
                            logger.log(Level.SEVERE, message);
                            throw new IOException(message);
                        }
                        Helper.copyStream((InputStream)new FileInputStream(projectorFile), (OutputStream)bos);
                        bos.flush();
                        break;
                    }
                }
            }
            long pos = fos.getChannel().position();
            swf.saveTo((OutputStream)bos);
            if (mode == SaveFileMode.EXE) {
                switch (exeExportMode) {
                    case PROJECTOR_WIN: 
                    case PROJECTOR_MAC: 
                    case PROJECTOR_LINUX: {
                        bos.flush();
                        int swfSize = (int)(fos.getChannel().position() - pos);
                        bos.write(86);
                        bos.write(52);
                        bos.write(18);
                        bos.write(250);
                        bos.write(swfSize & 0xFF);
                        bos.write(swfSize >> 8 & 0xFF);
                        bos.write(swfSize >> 16 & 0xFF);
                        bos.write(swfSize >> 24 & 0xFF);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        if (!tmpFile.exists()) {
            throw new IOException("Output not found");
        }
        if (tmpFile.length() <= 0L) {
            throw new IOException("Output is empty");
        }
        outfileF.delete();
        if (!tmpFile.renameTo(outfileF)) {
            tmpFile.delete();
            throw new IOException("Cannot access " + outfile);
        }
    }

    public static boolean reloadSWFs() {
        CancellableWorker.cancelBackgroundThreads();
        if (sourceInfos.isEmpty()) {
            Helper.freeMem();
            Main.showModeFrame();
            return true;
        }
        SWFSourceInfo[] sourceInfosCopy = new SWFSourceInfo[sourceInfos.size()];
        sourceInfos.toArray(sourceInfosCopy);
        sourceInfos.clear();
        Main.openFile(sourceInfosCopy);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void reloadApp() {
        if (debugDialog != null) {
            debugDialog.setVisible(false);
            debugDialog.dispose();
            debugDialog = null;
        }
        if (loadingDialog != null) {
            Class<Main> clazz = Main.class;
            // MONITORENTER : com.jpexs.decompiler.flash.gui.Main.class
            if (loadingDialog != null) {
                loadingDialog.setVisible(false);
                loadingDialog.dispose();
                loadingDialog = null;
            }
            // MONITOREXIT : clazz
        }
        if (proxyFrame != null) {
            proxyFrame.setVisible(false);
            proxyFrame.dispose();
            proxyFrame = null;
        }
        if (loadFromMemoryFrame != null) {
            loadFromMemoryFrame.setVisible(false);
            loadFromMemoryFrame.dispose();
            loadFromMemoryFrame = null;
        }
        if (loadFromCacheFrame != null) {
            loadFromCacheFrame.setVisible(false);
            loadFromCacheFrame.dispose();
            loadFromCacheFrame = null;
        }
        if (mainFrame != null) {
            mainFrame.setVisible(false);
            mainFrame.getPanel().closeAll(false);
            mainFrame.dispose();
            mainFrame = null;
        }
        FontTag.reload();
        Cache.clearAll();
        Main.initGui();
        Main.reloadSWFs();
    }

    public static OpenFileResult openFile(String swfFile, String fileTitle) {
        return Main.openFile(swfFile, fileTitle, null);
    }

    public static OpenFileResult openFile(String swfFile, String fileTitle, Runnable executeAfterOpen) {
        try {
            File file = new File(swfFile);
            if (!file.exists()) {
                View.showMessageDialog(null, AppStrings.translate("open.error.fileNotFound"), AppStrings.translate("open.error"), 0);
                return OpenFileResult.NOT_FOUND;
            }
            swfFile = file.getCanonicalPath();
            SWFSourceInfo sourceInfo = new SWFSourceInfo(null, swfFile, fileTitle);
            OpenFileResult openResult = Main.openFile(sourceInfo);
            return openResult;
        }
        catch (IOException ex) {
            View.showMessageDialog(null, AppStrings.translate("open.error.cannotOpen"), AppStrings.translate("open.error"), 0);
            return OpenFileResult.ERROR;
        }
    }

    public static OpenFileResult openFile(SWFSourceInfo sourceInfo) {
        return Main.openFile(new SWFSourceInfo[]{sourceInfo});
    }

    public static OpenFileResult openFile(SWFSourceInfo sourceInfo, Runnable executeAfterOpen) {
        return Main.openFile(new SWFSourceInfo[]{sourceInfo}, executeAfterOpen);
    }

    public static OpenFileResult openFile(SWFSourceInfo sourceInfo, Runnable executeAfterOpen, int reloadIndex) {
        return Main.openFile(new SWFSourceInfo[]{sourceInfo}, executeAfterOpen, new int[]{reloadIndex});
    }

    public static OpenFileResult openFile(SWFSourceInfo[] newSourceInfos) {
        return Main.openFile(newSourceInfos, null);
    }

    public static OpenFileResult openFile(SWFSourceInfo[] newSourceInfos, Runnable executeAfterOpen) {
        return Main.openFile(newSourceInfos, executeAfterOpen, null);
    }

    public static OpenFileResult openFile(SWFSourceInfo[] newSourceInfos, Runnable executeAfterOpen, int[] reloadIndices) {
        if (mainFrame != null && !((Boolean)Configuration.openMultipleFiles.get()).booleanValue()) {
            sourceInfos.clear();
            mainFrame.getPanel().closeAll(false);
            mainFrame.setVisible(false);
            Helper.freeMem();
            reloadIndices = null;
        }
        loadingDialog.setVisible(true);
        for (int i = 0; i < newSourceInfos.length; ++i) {
            SWFSourceInfo si = newSourceInfos[i];
            String fileName = si.getFile();
            if (fileName == null) continue;
            Configuration.addRecentFile((String)fileName);
        }
        OpenFileWorker wrk = new OpenFileWorker(newSourceInfos, executeAfterOpen, reloadIndices);
        wrk.execute();
        if (reloadIndices == null) {
            sourceInfos.addAll(Arrays.asList(newSourceInfos));
        } else {
            for (int i = 0; i < reloadIndices.length; ++i) {
                sourceInfos.set(reloadIndices[i], newSourceInfos[i]);
            }
        }
        return OpenFileResult.OK;
    }

    public static void closeFile(SWFList swf) {
        sourceInfos.remove(swf.sourceInfo);
        mainFrame.getPanel().close(swf);
    }

    public static void reloadFile(SWFList swf) {
        Main.openFile(swf.sourceInfo, null, sourceInfos.indexOf(swf.sourceInfo));
    }

    public static boolean closeAll() {
        boolean closeResult = mainFrame.getPanel().closeAll(true);
        if (closeResult) {
            sourceInfos.clear();
        }
        return closeResult;
    }

    public static boolean saveFileDialog(SWF swf, SaveFileMode mode) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File((String)Configuration.lastSaveDir.get()));
        String ext = ".swf";
        switch (mode) {
            case SAVE: 
            case SAVEAS: {
                if (swf.getFile() == null) break;
                ext = Path.getExtension((String)swf.getFile());
                break;
            }
            case EXE: {
                ext = ".exe";
            }
        }
        FileFilter swfFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".swf") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.swf");
            }
        };
        FileFilter gfxFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".gfx") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.gfx");
            }
        };
        ExeExportMode exeExportMode = null;
        if (mode == SaveFileMode.EXE) {
            exeExportMode = (ExeExportMode)Configuration.exeExportMode.get();
            if (exeExportMode == null) {
                exeExportMode = ExeExportMode.WRAPPER;
            }
            String filterDescription = null;
            switch (exeExportMode) {
                case WRAPPER: 
                case PROJECTOR_WIN: {
                    ext = ".exe";
                    filterDescription = "filter.exe";
                    break;
                }
                case PROJECTOR_MAC: {
                    ext = ".dmg";
                    filterDescription = "filter.dmg";
                    break;
                }
                case PROJECTOR_LINUX: {
                    ext = "";
                    filterDescription = "filter.linuxExe";
                }
            }
            final String fext = ext;
            final String ffilterDescription = filterDescription;
            FileFilter exeFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(fext) || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return AppStrings.translate(ffilterDescription);
                }
            };
            fc.setFileFilter(exeFilter);
        } else if (swf.gfx) {
            fc.addChoosableFileFilter(swfFilter);
            fc.setFileFilter(gfxFilter);
        } else {
            fc.setFileFilter(swfFilter);
            fc.addChoosableFileFilter(gfxFilter);
        }
        String extension = ext;
        fc.setAcceptAllFileFilterUsed(false);
        JFrame f = new JFrame();
        View.setWindowIcon(f);
        if (fc.showSaveDialog(f) == 0) {
            File file = Helper.fixDialogFile((File)fc.getSelectedFile());
            FileFilter selFilter = fc.getFileFilter();
            try {
                String fileName = file.getAbsolutePath();
                if (selFilter == swfFilter) {
                    if (!fileName.toLowerCase().endsWith(extension)) {
                        fileName = fileName + extension;
                    }
                    swf.gfx = false;
                }
                if (selFilter == gfxFilter) {
                    if (!fileName.toLowerCase().endsWith(".gfx")) {
                        fileName = fileName + ".gfx";
                    }
                    swf.gfx = true;
                }
                Main.saveFile(swf, fileName, mode, exeExportMode);
                Configuration.lastSaveDir.set((Object)file.getParentFile().getAbsolutePath());
                return true;
            }
            catch (IOException ex) {
                View.showMessageDialog(null, AppStrings.translate("error.file.write"));
            }
        }
        return false;
    }

    public static boolean openFileDialog() {
        JFileChooser fc = new JFileChooser();
        if (((Boolean)Configuration.openMultipleFiles.get()).booleanValue()) {
            fc.setMultiSelectionEnabled(true);
        }
        fc.setCurrentDirectory(new File((String)Configuration.lastOpenDir.get()));
        FileFilter allSupportedFilter = new FileFilter(){
            private final String[] supportedExtensions = new String[]{".swf", ".gfx", ".swc", ".zip", ".iggy"};

            @Override
            public boolean accept(File f) {
                String name = f.getName().toLowerCase();
                for (String ext : this.supportedExtensions) {
                    if (!name.endsWith(ext)) continue;
                    return true;
                }
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                String exts = Helper.joinStrings((String[])this.supportedExtensions, (String)"*%s", (String)"; ");
                return AppStrings.translate("filter.supported") + " (" + exts + ")";
            }
        };
        fc.setFileFilter(allSupportedFilter);
        FileFilter swfFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".swf") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.swf");
            }
        };
        fc.addChoosableFileFilter(swfFilter);
        FileFilter swcFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".swc") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.swc");
            }
        };
        fc.addChoosableFileFilter(swcFilter);
        FileFilter gfxFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".gfx") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.gfx");
            }
        };
        fc.addChoosableFileFilter(gfxFilter);
        FileFilter iggyFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".iggy") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.iggy");
            }
        };
        fc.addChoosableFileFilter(iggyFilter);
        FileFilter zipFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".zip") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.zip");
            }
        };
        fc.addChoosableFileFilter(zipFilter);
        FileFilter binaryFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.binary");
            }
        };
        fc.addChoosableFileFilter(binaryFilter);
        fc.setAcceptAllFileFilterUsed(false);
        JFrame f = new JFrame();
        View.setWindowIcon(f);
        int returnVal = fc.showOpenDialog(f);
        if (returnVal == 0) {
            File[] selFiles;
            Configuration.lastOpenDir.set((Object)Helper.fixDialogFile((File)fc.getSelectedFile()).getParentFile().getAbsolutePath());
            for (File file : selFiles = fc.getSelectedFiles()) {
                File selfile = Helper.fixDialogFile((File)file);
                Main.openFile(selfile.getAbsolutePath(), null);
            }
            return true;
        }
        return false;
    }

    public static void displayErrorFrame() {
        ErrorLogFrame.getInstance().setVisible(true);
    }

    private static String md5(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(data);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static void initGui() {
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println("Error: Your system does not support Graphic User Interface");
            Main.exit();
        }
        System.setProperty("sun.java2d.d3d", "false");
        System.setProperty("sun.java2d.noddraw", "true");
        if (((Boolean)Configuration.hwAcceleratedGraphics.get()).booleanValue()) {
            System.setProperty("sun.java2d.opengl", (Boolean)Configuration._debugMode.get() != false ? "True" : "true");
        } else {
            System.setProperty("sun.java2d.opengl", "false");
        }
        Main.initUiLang();
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            View.setLookAndFeel();
        } else {
            try {
                UIManager.put("substancelaf.colorizationFactor", null);
                UIManager.put("Tree.expandedIcon", null);
                UIManager.put("Tree.collapsedIcon", null);
                UIManager.put("ColorChooserUI", null);
                UIManager.put("ColorChooser.swatchesRecentSwatchSize", null);
                UIManager.put("ColorChooser.swatchesSwatchSize", null);
                UIManager.put("RibbonApplicationMenuPopupPanelUI", null);
                UIManager.put("RibbonApplicationMenuButtonUI", null);
                UIManager.put("ProgressBarUI", null);
                UIManager.put("TextField.background", null);
                UIManager.put("FormattedTextField.background", null);
                UIManager.put("CommandButtonUI", null);
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        View.execInEventDispatch(() -> {
            ErrorLogFrame.createNewInstance();
            Main.autoCheckForUpdates();
            Main.offerAssociation();
            loadingDialog = new LoadingDialog();
            DebuggerTools.initDebugger().addMessageListener(new DebugListener(){

                @Override
                public void onMessage(String clientId, String msg) {
                }

                @Override
                public void onLoaderURL(String clientId, String url) {
                }

                @Override
                public void onLoaderBytes(String clientId, byte[] data) {
                    String hash = Main.md5(data);
                    for (SWFList sl : Main.getMainFrame().getPanel().getSwfs()) {
                        for (int s = 0; s < sl.size(); ++s) {
                            String t = sl.get(s).getFileTitle();
                            if (t == null) {
                                t = "";
                            }
                            if (!t.endsWith(":" + hash)) continue;
                            return;
                        }
                    }
                    SWF swf = Main.getMainFrame().getPanel().getCurrentSwf();
                    String title = swf == null ? "?" : swf.getFileTitle();
                    title = title + ":" + hash;
                    try {
                        String tfile = Main.tempFile(title);
                        Helper.writeFile((String)tfile, (byte[][])new byte[][]{data});
                        Main.openFile(new SWFSourceInfo(null, tfile, title));
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, "Cannot create tempfile");
                    }
                }

                @Override
                public void onFinish(String clientId) {
                }
            });
            try {
                flashDebugger = new Debugger();
                debugHandler = new DebuggerHandler();
                debugHandler.addBreakListener(new DebuggerHandler.BreakListener(){

                    @Override
                    public void doContinue() {
                        mainFrame.getPanel().clearDebuggerColors();
                    }

                    @Override
                    public void breakAt(final String scriptName, final int line, final int classIndex, final int traitIndex, final int methodIndex) {
                        View.execInEventDispatch(new Runnable(){

                            @Override
                            public void run() {
                                mainFrame.getPanel().gotoScriptLine(Main.getMainFrame().getPanel().getCurrentSwf(), scriptName, line, classIndex, traitIndex, methodIndex);
                            }
                        });
                    }
                });
                debugHandler.addConnectionListener(new DebuggerHandler.ConnectionListener(){

                    @Override
                    public void connected() {
                        mainFrame.getMenu().updateComponents();
                    }

                    @Override
                    public void disconnected() {
                        if (mainFrame != null && mainFrame.getPanel() != null) {
                            mainFrame.getPanel().refreshBreakPoints();
                        }
                    }
                });
                flashDebugger.addConnectionListener((DebugConnectionListener)debugHandler);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "eeex", ex);
            }
        });
    }

    public static void startDebugger() {
        flashDebugger.startDebugger();
    }

    public static void stopDebugger() {
        flashDebugger.stopDebugger();
    }

    public static void showModeFrame() {
        Main.ensureMainFrame();
        mainFrame.setVisible(true);
    }

    private static void offerAssociation() {
        boolean offered = (Boolean)Configuration.offeredAssociation.get();
        if (!offered) {
            if (Platform.isWindows() && !ContextMenuTools.isAddedToContextMenu() && View.showConfirmDialog(null, "Do you want to add FFDec to context menu of SWF files?\n(Can be changed later from main menu)", "Context menu", 0, 3) == 0) {
                ContextMenuTools.addToContextMenu(true, false);
            }
            Configuration.offeredAssociation.set((Object)true);
        }
    }

    public static void initUiLang() {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        try {
            Class<?> cl = Class.forName("org.pushingpixels.substance.api.SubstanceLookAndFeel");
            Field field = cl.getDeclaredField("LABEL_BUNDLE");
            field.setAccessible(true);
            field.set(null, null);
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        UIManager.put("OptionPane.okButtonText", AppStrings.translate("button.ok"));
        UIManager.put("OptionPane.yesButtonText", AppStrings.translate("button.yes"));
        UIManager.put("OptionPane.noButtonText", AppStrings.translate("button.no"));
        UIManager.put("OptionPane.cancelButtonText", AppStrings.translate("button.cancel"));
        UIManager.put("OptionPane.messageDialogTitle", AppStrings.translate("dialog.message.title"));
        UIManager.put("OptionPane.titleText", AppStrings.translate("dialog.select.title"));
        UIManager.put("FileChooser.acceptAllFileFilterText", AppStrings.translate("FileChooser.acceptAllFileFilterText"));
        UIManager.put("FileChooser.lookInLabelText", AppStrings.translate("FileChooser.lookInLabelText"));
        UIManager.put("FileChooser.cancelButtonText", AppStrings.translate("button.cancel"));
        UIManager.put("FileChooser.cancelButtonToolTipText", AppStrings.translate("button.cancel"));
        UIManager.put("FileChooser.openButtonText", AppStrings.translate("FileChooser.openButtonText"));
        UIManager.put("FileChooser.openButtonToolTipText", AppStrings.translate("FileChooser.openButtonToolTipText"));
        UIManager.put("FileChooser.filesOfTypeLabelText", AppStrings.translate("FileChooser.filesOfTypeLabelText"));
        UIManager.put("FileChooser.fileNameLabelText", AppStrings.translate("FileChooser.fileNameLabelText"));
        UIManager.put("FileChooser.listViewButtonToolTipText", AppStrings.translate("FileChooser.listViewButtonToolTipText"));
        UIManager.put("FileChooser.listViewButtonAccessibleName", AppStrings.translate("FileChooser.listViewButtonAccessibleName"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", AppStrings.translate("FileChooser.detailsViewButtonToolTipText"));
        UIManager.put("FileChooser.detailsViewButtonAccessibleName", AppStrings.translate("FileChooser.detailsViewButtonAccessibleName"));
        UIManager.put("FileChooser.upFolderToolTipText", AppStrings.translate("FileChooser.upFolderToolTipText"));
        UIManager.put("FileChooser.upFolderAccessibleName", AppStrings.translate("FileChooser.upFolderAccessibleName"));
        UIManager.put("FileChooser.homeFolderToolTipText", AppStrings.translate("FileChooser.homeFolderToolTipText"));
        UIManager.put("FileChooser.homeFolderAccessibleName", AppStrings.translate("FileChooser.homeFolderAccessibleName"));
        UIManager.put("FileChooser.fileNameHeaderText", AppStrings.translate("FileChooser.fileNameHeaderText"));
        UIManager.put("FileChooser.fileSizeHeaderText", AppStrings.translate("FileChooser.fileSizeHeaderText"));
        UIManager.put("FileChooser.fileTypeHeaderText", AppStrings.translate("FileChooser.fileTypeHeaderText"));
        UIManager.put("FileChooser.fileDateHeaderText", AppStrings.translate("FileChooser.fileDateHeaderText"));
        UIManager.put("FileChooser.fileAttrHeaderText", AppStrings.translate("FileChooser.fileAttrHeaderText"));
        UIManager.put("FileChooser.openDialogTitleText", AppStrings.translate("FileChooser.openDialogTitleText"));
        UIManager.put("FileChooser.directoryDescriptionText", AppStrings.translate("FileChooser.directoryDescriptionText"));
        UIManager.put("FileChooser.directoryOpenButtonText", AppStrings.translate("FileChooser.directoryOpenButtonText"));
        UIManager.put("FileChooser.directoryOpenButtonToolTipText", AppStrings.translate("FileChooser.directoryOpenButtonToolTipText"));
        UIManager.put("FileChooser.fileDescriptionText", AppStrings.translate("FileChooser.fileDescriptionText"));
        UIManager.put("FileChooser.fileNameLabelText", AppStrings.translate("FileChooser.fileNameLabelText"));
        UIManager.put("FileChooser.helpButtonText", AppStrings.translate("FileChooser.helpButtonText"));
        UIManager.put("FileChooser.helpButtonToolTipText", AppStrings.translate("FileChooser.helpButtonToolTipText"));
        UIManager.put("FileChooser.newFolderAccessibleName", AppStrings.translate("FileChooser.newFolderAccessibleName"));
        UIManager.put("FileChooser.newFolderErrorText", AppStrings.translate("FileChooser.newFolderErrorText"));
        UIManager.put("FileChooser.newFolderToolTipText", AppStrings.translate("FileChooser.newFolderToolTipText"));
        UIManager.put("FileChooser.other.newFolder", AppStrings.translate("FileChooser.other.newFolder"));
        UIManager.put("FileChooser.other.newFolder.subsequent", AppStrings.translate("FileChooser.other.newFolder.subsequent"));
        UIManager.put("FileChooser.win32.newFolder", AppStrings.translate("FileChooser.win32.newFolder"));
        UIManager.put("FileChooser.win32.newFolder.subsequent", AppStrings.translate("FileChooser.win32.newFolder.subsequent"));
        UIManager.put("FileChooser.saveButtonText", AppStrings.translate("FileChooser.saveButtonText"));
        UIManager.put("FileChooser.saveButtonToolTipText", AppStrings.translate("FileChooser.saveButtonToolTipText"));
        UIManager.put("FileChooser.saveDialogTitleText", AppStrings.translate("FileChooser.saveDialogTitleText"));
        UIManager.put("FileChooser.saveInLabelText", AppStrings.translate("FileChooser.saveInLabelText"));
        UIManager.put("FileChooser.updateButtonText", AppStrings.translate("FileChooser.updateButtonText"));
        UIManager.put("FileChooser.updateButtonToolTipText", AppStrings.translate("FileChooser.updateButtonToolTipText"));
        UIManager.put("FileChooser.detailsViewActionLabel.textAndMnemonic", AppStrings.translate("FileChooser.detailsViewActionLabel.textAndMnemonic"));
        UIManager.put("FileChooser.detailsViewButtonToolTip.textAndMnemonic", AppStrings.translate("FileChooser.detailsViewButtonToolTip.textAndMnemonic"));
        UIManager.put("FileChooser.fileAttrHeader.textAndMnemonic", AppStrings.translate("FileChooser.fileAttrHeader.textAndMnemonic"));
        UIManager.put("FileChooser.fileDateHeader.textAndMnemonic", AppStrings.translate("FileChooser.fileDateHeader.textAndMnemonic"));
        UIManager.put("FileChooser.fileNameHeader.textAndMnemonic", AppStrings.translate("FileChooser.fileNameHeader.textAndMnemonic"));
        UIManager.put("FileChooser.fileNameLabel.textAndMnemonic", AppStrings.translate("FileChooser.fileNameLabel.textAndMnemonic"));
        UIManager.put("FileChooser.fileSizeHeader.textAndMnemonic", AppStrings.translate("FileChooser.fileSizeHeader.textAndMnemonic"));
        UIManager.put("FileChooser.fileTypeHeader.textAndMnemonic", AppStrings.translate("FileChooser.fileTypeHeader.textAndMnemonic"));
        UIManager.put("FileChooser.filesOfTypeLabel.textAndMnemonic", AppStrings.translate("FileChooser.filesOfTypeLabel.textAndMnemonic"));
        UIManager.put("FileChooser.folderNameLabel.textAndMnemonic", AppStrings.translate("FileChooser.folderNameLabel.textAndMnemonic"));
        UIManager.put("FileChooser.homeFolderToolTip.textAndMnemonic", AppStrings.translate("FileChooser.homeFolderToolTip.textAndMnemonic"));
        UIManager.put("FileChooser.listViewActionLabel.textAndMnemonic", AppStrings.translate("FileChooser.listViewActionLabel.textAndMnemonic"));
        UIManager.put("FileChooser.listViewButtonToolTip.textAndMnemonic", AppStrings.translate("FileChooser.listViewButtonToolTip.textAndMnemonic"));
        UIManager.put("FileChooser.lookInLabel.textAndMnemonic", AppStrings.translate("FileChooser.lookInLabel.textAndMnemonic"));
        UIManager.put("FileChooser.newFolderActionLabel.textAndMnemonic", AppStrings.translate("FileChooser.newFolderActionLabel.textAndMnemonic"));
        UIManager.put("FileChooser.newFolderToolTip.textAndMnemonic", AppStrings.translate("FileChooser.newFolderToolTip.textAndMnemonic"));
        UIManager.put("FileChooser.refreshActionLabel.textAndMnemonic", AppStrings.translate("FileChooser.refreshActionLabel.textAndMnemonic"));
        UIManager.put("FileChooser.saveInLabel.textAndMnemonic", AppStrings.translate("FileChooser.saveInLabel.textAndMnemonic"));
        UIManager.put("FileChooser.upFolderToolTip.textAndMnemonic", AppStrings.translate("FileChooser.upFolderToolTip.textAndMnemonic"));
        UIManager.put("FileChooser.viewMenuButtonAccessibleName", AppStrings.translate("FileChooser.viewMenuButtonAccessibleName"));
        UIManager.put("FileChooser.viewMenuButtonToolTipText", AppStrings.translate("FileChooser.viewMenuButtonToolTipText"));
        UIManager.put("FileChooser.viewMenuLabel.textAndMnemonic", AppStrings.translate("FileChooser.viewMenuLabel.textAndMnemonic"));
        UIManager.put("FileChooser.newFolderActionLabelText", AppStrings.translate("FileChooser.newFolderActionLabelText"));
        UIManager.put("FileChooser.listViewActionLabelText", AppStrings.translate("FileChooser.listViewActionLabelText"));
        UIManager.put("FileChooser.detailsViewActionLabelText", AppStrings.translate("FileChooser.detailsViewActionLabelText"));
        UIManager.put("FileChooser.refreshActionLabelText", AppStrings.translate("FileChooser.refreshActionLabelText"));
        UIManager.put("FileChooser.sortMenuLabelText", AppStrings.translate("FileChooser.sortMenuLabelText"));
        UIManager.put("FileChooser.viewMenuLabelText", AppStrings.translate("FileChooser.viewMenuLabelText"));
        UIManager.put("FileChooser.fileSizeKiloBytes", AppStrings.translate("FileChooser.fileSizeKiloBytes"));
        UIManager.put("FileChooser.fileSizeMegaBytes", AppStrings.translate("FileChooser.fileSizeMegaBytes"));
        UIManager.put("FileChooser.fileSizeGigaBytes", AppStrings.translate("FileChooser.fileSizeGigaBytes"));
        UIManager.put("FileChooser.folderNameLabelText", AppStrings.translate("FileChooser.folderNameLabelText"));
        UIManager.put("ColorChooser.okText", AppStrings.translate("ColorChooser.okText"));
        UIManager.put("ColorChooser.cancelText", AppStrings.translate("ColorChooser.cancelText"));
        UIManager.put("ColorChooser.resetText", AppStrings.translate("ColorChooser.resetText"));
        UIManager.put("ColorChooser.previewText", AppStrings.translate("ColorChooser.previewText"));
        UIManager.put("ColorChooser.swatchesNameText", AppStrings.translate("ColorChooser.swatchesNameText"));
        UIManager.put("ColorChooser.swatchesRecentText", AppStrings.translate("ColorChooser.swatchesRecentText"));
        UIManager.put("ColorChooser.sampleText", AppStrings.translate("ColorChooser.sampleText"));
    }

    public static void initLang() {
        if (!Configuration.locale.hasValue() && Platform.isWindows()) {
            String uninstKey = "{E618D276-6596-41F4-8A98-447D442A77DB}_is1";
            uninstKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + uninstKey;
            try {
                if (Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, uninstKey) && Advapi32Util.registryValueExists(WinReg.HKEY_LOCAL_MACHINE, uninstKey, "NSIS: Language")) {
                    String installedLoc = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, uninstKey, "NSIS: Language");
                    int lcid = Integer.parseInt(installedLoc);
                    char[] buf = new char[9];
                    int cnt = Kernel32.INSTANCE.GetLocaleInfo(lcid, 89, buf, 9);
                    String langCode = new String(buf, 0, cnt).trim().toLowerCase();
                    cnt = Kernel32.INSTANCE.GetLocaleInfo(lcid, 90, buf, 9);
                    String countryCode = new String(buf, 0, cnt).trim().toLowerCase();
                    List<String> langs = Arrays.asList(SelectLanguageDialog.getAvailableLanguages());
                    for (int i = 0; i < langs.size(); ++i) {
                        langs.set(i, langs.get(i).toLowerCase());
                    }
                    String selectedLang = null;
                    if (langs.contains(langCode + "-" + countryCode)) {
                        selectedLang = SelectLanguageDialog.getAvailableLanguages()[langs.indexOf(langCode + "-" + countryCode)];
                    } else if (langs.contains(langCode)) {
                        selectedLang = SelectLanguageDialog.getAvailableLanguages()[langs.indexOf(langCode)];
                    }
                    if (selectedLang != null) {
                        Configuration.locale.set(selectedLang);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Locale.setDefault(Locale.forLanguageTag((String)Configuration.locale.get()));
        AppStrings.updateLanguage();
        Helper.decompilationErrorAdd = AppStrings.translate((Boolean)Configuration.autoDeobfuscate.get() != false ? "deobfuscation.comment.failed" : "deobfuscation.comment.tryenable");
    }

    private static void clearTemp() {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        if (tempDirPath == null) {
            return;
        }
        File tempDir = new File(tempDirPath);
        if (!tempDir.exists()) {
            return;
        }
        File[] delFiles = tempDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("ffdec_cache.*\\.tmp") || name.matches("javactivex_.*\\.exe") || name.matches("temp[0-9]+\\.swf") || name.matches("ffdec_view_.*\\.swf");
            }
        });
        if (delFiles != null) {
            for (File f : delFiles) {
                try {
                    f.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        Main.setSessionLoaded(false);
        Main.clearTemp();
        try {
            SWFDecompilerPlugin.loadPlugins();
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Failed to load plugins", ex);
        }
        AppStrings.setResourceClass(MainFrame.class);
        Main.initLogging((Boolean)Configuration._debugMode.get());
        Main.initLang();
        if (((Boolean)Configuration.cacheOnDisk.get()).booleanValue()) {
            Cache.setStorageType((int)1);
        } else {
            Cache.setStorageType((int)2);
        }
        if (args.length == 0) {
            Main.initGui();
            Main.checkLibraryVersion();
            View.execInEventDispatch(() -> {
                if (((Boolean)Configuration.allowOnlyOneInstance.get()).booleanValue() && FirstInstance.focus()) {
                    Main.exit();
                } else {
                    Main.showModeFrame();
                    Main.reloadLastSession();
                }
            });
        } else {
            Main.checkLibraryVersion();
            Main.setSessionLoaded(true);
            String[] filesToOpen = CommandLineArgumentParser.parseArguments(args);
            if (filesToOpen != null && filesToOpen.length > 0) {
                View.execInEventDispatch(() -> {
                    Main.initGui();
                    shouldCloseWhenClosingLoadingDialog = true;
                    if (((Boolean)Configuration.allowOnlyOneInstance.get()).booleanValue() && FirstInstance.openFiles(Arrays.asList(filesToOpen))) {
                        Main.exit();
                    } else {
                        for (String fileToOpen : filesToOpen) {
                            Main.openFile(fileToOpen, null);
                        }
                    }
                });
            }
        }
    }

    private static void checkLibraryVersion() {
        if (!(ApplicationInfo.version.equals("unknown") || ApplicationInfo.libraryVersion.equals("unknown") || Objects.equals(ApplicationInfo.version, ApplicationInfo.libraryVersion))) {
            logger.log(Level.WARNING, "Application version is different from library version. FFDec may not work properly.");
        }
    }

    private static void reloadLastSession() {
        String lastSession;
        boolean openingFiles = false;
        if (((Boolean)Configuration.saveSessionOnExit.get()).booleanValue() && (lastSession = (String)Configuration.lastSessionFiles.get()) != null && lastSession.length() > 0) {
            String[] filesToOpen = lastSession.split(File.pathSeparator, -1);
            ArrayList<String> exfiles = new ArrayList<String>();
            ArrayList<String> extitles = new ArrayList<String>();
            String lastSessionTitles = (String)Configuration.lastSessionFileTitles.get();
            String[] fileTitles = new String[]{};
            if (lastSessionTitles != null && !lastSessionTitles.isEmpty()) {
                fileTitles = lastSessionTitles.split(File.pathSeparator, -1);
            }
            for (int i = 0; i < filesToOpen.length; ++i) {
                if (!new File(filesToOpen[i]).exists()) continue;
                exfiles.add(filesToOpen[i]);
                if (fileTitles.length > i) {
                    extitles.add(fileTitles[i]);
                    continue;
                }
                extitles.add(null);
            }
            SWFSourceInfo[] sourceInfos = new SWFSourceInfo[exfiles.size()];
            for (int i = 0; i < exfiles.size(); ++i) {
                String extitle = (String)extitles.get(i);
                sourceInfos[i] = new SWFSourceInfo(null, (String)exfiles.get(i), extitle == null || extitle.isEmpty() ? null : extitle);
            }
            if (sourceInfos.length > 0) {
                openingFiles = true;
                Main.openFile(sourceInfos, () -> {
                    Main.mainFrame.getPanel().tagTree.setSelectionPathString((String)Configuration.lastSessionSelection.get());
                    Main.setSessionLoaded(true);
                });
            }
        }
        if (!openingFiles) {
            Main.setSessionLoaded(true);
        }
    }

    public static String tempFile(String url) throws IOException {
        File f = new File(Configuration.getFFDecHome() + "saved" + File.separator);
        Path.createDirectorySafe((File)f);
        return Configuration.getFFDecHome() + "saved" + File.separator + "asdec_" + Integer.toHexString(url.hashCode()) + ".tmp";
    }

    public static void removeTrayIcon() {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            if (trayIcon != null) {
                tray.remove(trayIcon);
                trayIcon = null;
            }
        }
    }

    public static void switchProxy() {
        proxyFrame.switchState();
        if (stopMenuItem != null) {
            if (proxyFrame.isRunning()) {
                stopMenuItem.setLabel(AppStrings.translate("proxy.stop"));
            } else {
                stopMenuItem.setLabel(AppStrings.translate("proxy.start"));
            }
        }
    }

    public static void addTrayIcon() {
        if (trayIcon != null) {
            return;
        }
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            trayIcon = new TrayIcon(View.loadImage("proxy16"), "JPEXS FFDec " + AppStrings.translate("proxy"));
            trayIcon.setImageAutoSize(true);
            PopupMenu trayPopup = new PopupMenu();
            ActionListener trayListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("EXIT")) {
                        Main.exit();
                    }
                    if (e.getActionCommand().equals("SHOW")) {
                        Main.showProxy();
                    }
                    if (e.getActionCommand().equals("SWITCH")) {
                        Main.switchProxy();
                    }
                }
            };
            MenuItem showMenuItem = new MenuItem(AppStrings.translate("proxy.show"));
            showMenuItem.setActionCommand("SHOW");
            showMenuItem.addActionListener(trayListener);
            trayPopup.add(showMenuItem);
            stopMenuItem = new MenuItem(AppStrings.translate("proxy.start"));
            stopMenuItem.setActionCommand("SWITCH");
            stopMenuItem.addActionListener(trayListener);
            trayPopup.add(stopMenuItem);
            trayPopup.addSeparator();
            MenuItem exitMenuItem = new MenuItem(AppStrings.translate("exit"));
            exitMenuItem.setActionCommand("EXIT");
            exitMenuItem.addActionListener(trayListener);
            trayPopup.add(exitMenuItem);
            trayIcon.setPopupMenu(trayPopup);
            trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        Main.showProxy();
                    }
                }
            });
            try {
                tray.add(trayIcon);
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
    }

    public static void exit() {
        Configuration.saveConfig();
        if (mainFrame != null && mainFrame.getPanel() != null) {
            mainFrame.getPanel().unloadFlashPlayer();
            mainFrame.dispose();
        }
        if (fileTxt != null) {
            try {
                fileTxt.flush();
                fileTxt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.exit(0);
    }

    public static void about() {
        new AboutDialog().setVisible(true);
    }

    public static void advancedSettings() {
        Main.advancedSettings(null);
    }

    public static void advancedSettings(String category) {
        new AdvancedSettingsDialog(category).setVisible(true);
    }

    public static void autoCheckForUpdates() {
        Calendar lastUpdatesCheckDate;
        if (((Boolean)Configuration.checkForUpdatesAuto.get()).booleanValue() && ((lastUpdatesCheckDate = (Calendar)Configuration.lastUpdatesCheckDate.get()) == null || lastUpdatesCheckDate.getTime().getTime() < Calendar.getInstance().getTime().getTime() - (long)((Integer)Configuration.checkForUpdatesDelay.get()).intValue())) {
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    Main.checkForUpdates();
                    return null;
                }
            }.execute();
        }
    }

    public static boolean checkForUpdates() {
        String currentVersion = ApplicationInfo.version;
        if (currentVersion.equals("unknown")) {
            return false;
        }
        ArrayList<String> accepted = new ArrayList<String>();
        if (((Boolean)Configuration.checkForUpdatesStable.get()).booleanValue()) {
            accepted.add("stable");
        }
        if (((Boolean)Configuration.checkForUpdatesNightly.get()).booleanValue()) {
            accepted.add("nightly");
        }
        if (accepted.isEmpty()) {
            return false;
        }
        String acceptVersions = String.join((CharSequence)",", accepted);
        try {
            String s;
            URLConnection uc;
            String proxyAddress = (String)Configuration.updateProxyAddress.get();
            URL url = new URL(ApplicationInfo.updateCheckUrl);
            if (proxyAddress != null && !proxyAddress.isEmpty()) {
                int port = 8080;
                if (proxyAddress.contains(":")) {
                    String[] parts = proxyAddress.split(":");
                    port = Integer.parseInt(parts[1]);
                    proxyAddress = parts[0];
                }
                uc = url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyAddress, port)));
            } else {
                uc = url.openConnection();
            }
            uc.setRequestProperty("X-Accept-Versions", acceptVersions);
            uc.setRequestProperty("X-Update-Major", "1");
            uc.setRequestProperty("X-Update-Minor", "3");
            uc.setRequestProperty("User-Agent", ApplicationInfo.shortApplicationVerName);
            String currentLoc = (String)Configuration.locale.get((Object)"en");
            uc.setRequestProperty("Accept-Language", currentLoc + ("en".equals(currentLoc) ? "" : ", en;q=0.8"));
            uc.connect();
            BufferedReader br = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            ArrayList<Version> versions = new ArrayList<Version>();
            String header = "";
            Pattern headerPat = Pattern.compile("\\[([a-zA-Z0-9]+)\\]");
            Version ver = null;
            while ((s = br.readLine()) != null) {
                Matcher m = headerPat.matcher(s);
                if (m.matches()) {
                    header = m.group(1);
                    if (header.equals("version")) {
                        ver = new Version();
                        versions.add(ver);
                    }
                    if (!header.equals("noversion")) continue;
                    break;
                }
                if (!s.contains("=")) continue;
                String key = s.substring(0, s.indexOf(61));
                String val = s.substring(s.indexOf(61) + 1);
                if ("updateSystem".equals(header)) {
                    int updateMajor;
                    if (key.equals("majorVersion") && (updateMajor = Integer.parseInt(val)) > 1) break;
                    if (key.equals("minorVersion")) {
                        int n = Integer.parseInt(val);
                    }
                }
                if (!"version".equals(header) || ver == null) continue;
                if (key.equals("versionId")) {
                    ver.versionId = Integer.parseInt(val);
                }
                if (key.equals("versionName")) {
                    ver.versionName = val;
                }
                if (key.equals("nightly")) {
                    ver.nightly = val.equals("true");
                }
                if (key.equals("revision")) {
                    ver.revision = val;
                }
                if (key.equals("build")) {
                    ver.build = Integer.parseInt(val);
                }
                if (key.equals("major")) {
                    ver.major = Integer.parseInt(val);
                }
                if (key.equals("minor")) {
                    ver.minor = Integer.parseInt(val);
                }
                if (key.equals("release")) {
                    ver.release = Integer.parseInt(val);
                }
                if (key.equals("longVersionName")) {
                    ver.longVersionName = val;
                }
                if (key.equals("releaseDate")) {
                    ver.releaseDate = val;
                }
                if (key.equals("appName")) {
                    ver.appName = val;
                }
                if (key.equals("appFullName")) {
                    ver.appFullName = val;
                }
                if (key.equals("updateLink")) {
                    ver.updateLink = val;
                }
                if (!key.equals("change[]")) continue;
                String changeType = val.substring(0, val.indexOf(124));
                String change = val.substring(val.indexOf(124) + 1);
                if (!ver.changes.containsKey(changeType)) {
                    ver.changes.put(changeType, new ArrayList());
                }
                List chlist = (List)ver.changes.get(changeType);
                chlist.add(change);
            }
            if (!versions.isEmpty()) {
                View.execInEventDispatch(() -> {
                    NewVersionDialog newVersionDialog = new NewVersionDialog(versions);
                    newVersionDialog.setVisible(true);
                    Configuration.lastUpdatesCheckDate.set((Object)Calendar.getInstance());
                });
                return true;
            }
        }
        catch (IOException | NumberFormatException ex) {
            return false;
        }
        Configuration.lastUpdatesCheckDate.set((Object)Calendar.getInstance());
        return false;
    }

    public static void clearLogFile() {
        final Logger logger = Logger.getLogger("");
        FileHandler oldFileTxt = fileTxt;
        fileTxt = null;
        if (oldFileTxt != null) {
            logger.removeHandler(fileTxt);
            oldFileTxt.flush();
            oldFileTxt.close();
        }
        String fileName = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
        try {
            fileName = Configuration.getFFDecHome() + "logs" + File.separator;
            fileName = (Boolean)Configuration.useDetailedLogging.get() != false ? fileName + "log-" + sdf.format(new Date()) + ".txt" : fileName + "log.txt";
            File f = new File(fileName).getParentFile();
            if (!f.exists()) {
                f.mkdir();
            }
            fileTxt = new FileHandler(fileName);
        }
        catch (IOException | SecurityException ex) {
            if (ex.getMessage().contains("lock for")) {
                for (int i = 0; i <= 100; ++i) {
                    File flog = new File(fileName + (i == 0 ? "" : "." + i));
                    File flog_lock = new File(fileName + (i == 0 ? "" : "." + i) + ".lck");
                    flog.delete();
                    flog_lock.delete();
                }
                try {
                    fileTxt = new FileHandler(fileName);
                }
                catch (IOException | SecurityException ex1) {
                    logger.log(Level.SEVERE, "Cannot initialize logging", ex);
                }
            }
            logger.log(Level.SEVERE, "Cannot initialize logging", ex);
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.log(Level.SEVERE, "Uncaught exception in thread: " + t.getName(), e);
                if (e instanceof OutOfMemoryError || !Helper.is64BitJre() && Helper.is64BitOs()) {
                    View.showMessageDialog(null, AppStrings.translate("message.warning.outOfMemory32BitJre"), AppStrings.translate("message.warning"), 2);
                }
            }
        });
        LogFormatter formatterTxt = new LogFormatter();
        if (fileTxt != null) {
            fileTxt.setFormatter(formatterTxt);
            logger.addHandler(fileTxt);
        }
        if (!GraphicsEnvironment.isHeadless() && ErrorLogFrame.hasInstance()) {
            ErrorLogFrame.getInstance().clearErrorState();
        }
        sdf = new SimpleDateFormat("yyyy-MM-dd");
        logger.log(Level.INFO, "Date: {0}", sdf.format(new Date()));
        logger.log(Level.INFO, ApplicationInfo.applicationVerName);
        logger.log(Level.INFO, "{0} {1} {2}", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")});
        logger.log(Level.INFO, "{0} {1} {2}", new Object[]{System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("os.arch")});
    }

    public static void initLogging(boolean debug) {
        try {
            Logger logger = Logger.getLogger("");
            logger.setLevel(Configuration.logLevel);
            Handler[] handlers = logger.getHandlers();
            for (int i = handlers.length - 1; i >= 0; --i) {
                logger.removeHandler(handlers[i]);
            }
            ConsoleHandler conHan = new ConsoleHandler();
            conHan.setLevel(debug ? Level.CONFIG : Level.WARNING);
            SimpleFormatter formatterTxt = new SimpleFormatter();
            conHan.setFormatter(formatterTxt);
            logger.addHandler(conHan);
            Main.clearLogFile();
        }
        catch (Exception ex) {
            throw new RuntimeException("Problems with creating the log files");
        }
    }

    static {
        sourceInfos = new ArrayList<SWFSourceInfo>();
        working = false;
        logger = Logger.getLogger(Main.class.getName());
        debugHandler = null;
        inited = false;
        runTempFiles = new ArrayList<File>();
    }

    private static class OpenFileWorker
    extends SwingWorker {
        private final SWFSourceInfo[] sourceInfos;
        private final Runnable executeAfterOpen;
        private final int[] reloadIndices;

        public OpenFileWorker(SWFSourceInfo sourceInfo) {
            this(sourceInfo, -1);
        }

        public OpenFileWorker(SWFSourceInfo sourceInfo, int reloadIndex) {
            this(sourceInfo, null, reloadIndex);
        }

        public OpenFileWorker(SWFSourceInfo sourceInfo, Runnable executeAfterOpen) {
            this(sourceInfo, executeAfterOpen, -1);
        }

        public OpenFileWorker(SWFSourceInfo sourceInfo, Runnable executeAfterOpen, int reloadIndex) {
            this.sourceInfos = new SWFSourceInfo[]{sourceInfo};
            this.executeAfterOpen = executeAfterOpen;
            this.reloadIndices = new int[]{reloadIndex};
        }

        public OpenFileWorker(SWFSourceInfo[] sourceInfos) {
            this(sourceInfos, null, null);
        }

        public OpenFileWorker(SWFSourceInfo[] sourceInfos, Runnable executeAfterOpen) {
            this(sourceInfos, executeAfterOpen, null);
        }

        public OpenFileWorker(SWFSourceInfo[] sourceInfos, Runnable executeAfterOpen, int[] reloadIndices) {
            this.sourceInfos = sourceInfos;
            this.executeAfterOpen = executeAfterOpen;
            int[] indices = new int[sourceInfos.length];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = -1;
            }
            this.reloadIndices = reloadIndices == null ? indices : reloadIndices;
        }

        protected Object doInBackground() throws Exception {
            boolean first = true;
            SWF firstSWF = null;
            for (int index = 0; index < this.sourceInfos.length; ++index) {
                SWFSourceInfo sourceInfo = this.sourceInfos[index];
                SWFList swfs = null;
                try {
                    Main.startWork(AppStrings.translate("work.reading.swf") + "...", null);
                    try {
                        swfs = Main.parseSWF(sourceInfo);
                    }
                    catch (ExecutionException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof SwfOpenException) {
                            throw (SwfOpenException)cause;
                        }
                        throw ex;
                    }
                }
                catch (OutOfMemoryError ex) {
                    logger.log(Level.SEVERE, null, ex);
                    View.showMessageDialog(null, "Cannot load SWF file. Out of memory.");
                    continue;
                }
                catch (SwfOpenException ex) {
                    logger.log(Level.SEVERE, null, ex);
                    View.showMessageDialog(null, ex.getMessage());
                    continue;
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                    View.showMessageDialog(null, "Cannot load SWF file.");
                    continue;
                }
                SWFList swfs1 = swfs;
                boolean first1 = first;
                first = false;
                if (firstSWF == null && swfs1.size() > 0) {
                    firstSWF = swfs1.get(0);
                }
                int findex = index;
                try {
                    View.execInEventDispatch(() -> {
                        Main.startWork(AppStrings.translate("work.creatingwindow") + "...", null);
                        Main.ensureMainFrame();
                        if (this.reloadIndices[findex] > -1) {
                            mainFrame.getPanel().loadSwfAtPos(swfs1, this.reloadIndices[findex]);
                        } else {
                            mainFrame.getPanel().load(swfs1, first1);
                        }
                    });
                    continue;
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            loadingDialog.setVisible(false);
            shouldCloseWhenClosingLoadingDialog = false;
            SWF fswf = firstSWF;
            View.execInEventDispatch(() -> {
                SwfSpecificConfiguration swfConf;
                if (mainFrame != null) {
                    mainFrame.setVisible(true);
                }
                Main.stopWork();
                if (mainFrame != null && ((Boolean)Configuration.gotoMainClassOnStartup.get()).booleanValue()) {
                    mainFrame.getPanel().gotoDocumentClass(fswf);
                }
                if (mainFrame != null && fswf != null && (swfConf = Configuration.getSwfSpecificConfiguration((String)fswf.getShortFileName())) != null) {
                    String pathStr = swfConf.lastSelectedPath;
                    mainFrame.getPanel().tagTree.setSelectionPathString(pathStr);
                }
                if (this.executeAfterOpen != null) {
                    this.executeAfterOpen.run();
                }
            });
            return true;
        }
    }

    private static class SwfDebugPrepare
    extends SwfRunPrepare {
        private boolean doPCode;

        public SwfDebugPrepare(boolean doPCode) {
            this.doPCode = doPCode;
        }

        @Override
        public SWF prepare(SWF instrSWF) {
            block19: {
                instrSWF = super.prepare(instrSWF);
                try {
                    File fTempFile = new File(instrSWF.getFile());
                    instrSWF.enableDebugging(true, new File("."), true, this.doPCode);
                    FileOutputStream fos = new FileOutputStream(fTempFile);
                    instrSWF.saveTo((OutputStream)fos);
                    fos.close();
                    if (instrSWF.isAS3()) break block19;
                    instrSWF = null;
                    try (FileInputStream fis = new FileInputStream(fTempFile);){
                        instrSWF = new SWF((InputStream)fis, false, false);
                    }
                    catch (InterruptedException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                    if (instrSWF != null) {
                        String swfFileName = fTempFile.getAbsolutePath();
                        swfFileName = swfFileName.toLowerCase().endsWith(".swf") ? swfFileName.substring(0, swfFileName.length() - 4) + ".swd" : swfFileName + ".swd";
                        File swdFile = new File(swfFileName);
                        if (this.doPCode) {
                            instrSWF.generatePCodeSwdFile(swdFile, Main.getPackBreakPoints(true));
                        } else {
                            instrSWF.generateSwdFile(swdFile, Main.getPackBreakPoints(true));
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return instrSWF;
        }
    }

    private static class SwfRunPrepare
    implements SwfPreparation {
        private SwfRunPrepare() {
        }

        @Override
        public SWF prepare(SWF swf) {
            if (((Boolean)Configuration.autoOpenLoadedSWFs.get()).booleanValue()) {
                if (!DebuggerTools.hasDebugger(swf)) {
                    DebuggerTools.switchDebugger(swf);
                }
                DebuggerTools.injectDebugLoader(swf);
            }
            return swf;
        }
    }

    private static interface SwfPreparation {
        public SWF prepare(SWF var1);
    }
}

