/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;

public class LoadingPanel
extends JPanel {
    BufferedImage lastImage;
    int lastSize = 0;
    Color col = new Color(0, 0, 255);
    double rotation = 0.0;
    Timer drawTimer;

    public LoadingPanel(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    private synchronized void setRotation(double rotation) {
        this.rotation = rotation;
    }

    private synchronized double getRotation() {
        return this.rotation;
    }

    private synchronized int getLastSize() {
        return this.lastSize;
    }

    private synchronized void redrawImage(int size) {
        double delay;
        if (this.drawTimer != null) {
            this.drawTimer.cancel();
            this.drawTimer = null;
        }
        BufferedImage bi = new BufferedImage(size, size, 2);
        Graphics2D big = bi.createGraphics();
        big.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        big.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        big.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int br = size / 16;
        if (br < 2) {
            br = 2;
        }
        int border = 2;
        int r = size / 2 - br - border;
        int o = (int)Math.round(Math.PI * 2 * (double)r);
        double max = Math.PI * 2;
        double skip = max / (double)o;
        big.setComposite(AlphaComposite.Src);
        for (int i = 0; i < o; ++i) {
            int c = i * 256 / o;
            double alfa = skip * (double)i;
            double x = (long)(border + br + r) + Math.round(Math.sin(alfa) * (double)r);
            double y = (long)(border + br + r) + Math.round(Math.cos(alfa) * (double)r);
            big.setColor(new Color(this.col.getRed(), this.col.getGreen(), this.col.getBlue(), c));
            big.fill(new Ellipse2D.Double(x - (double)br, y - (double)br, 2 * br, 2 * br));
        }
        this.lastImage = bi;
        this.lastSize = size;
        this.drawTimer = new Timer();
        double timeSpin = 1000.0;
        while (true) {
            double d;
            delay = timeSpin / (double)o;
            if (!(d < 10.0)) break;
            --o;
        }
        final int segments = o;
        int idelay = (int)Math.round(delay);
        this.drawTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (LoadingPanel.this.isVisible()) {
                    double rot2 = LoadingPanel.this.rotation - Math.PI * 2 / (double)segments;
                    if (rot2 < 0.0) {
                        rot2 += Math.PI * 2;
                    }
                    LoadingPanel.this.setRotation(rot2);
                    LoadingPanel.this.repaint();
                }
            }
        }, idelay, (long)idelay);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int size = Math.min(this.getWidth(), this.getHeight());
        if (this.lastImage == null || this.getLastSize() != size) {
            this.redrawImage(size);
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform t = AffineTransform.getRotateInstance(this.getRotation(), (double)size / 2.0, (double)size / 2.0);
        g2.setTransform(t);
        g2.drawImage((Image)this.lastImage, 0, 0, this);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.drawTimer != null) {
            this.drawTimer.cancel();
            this.drawTimer = null;
        }
        super.setVisible(visible);
    }
}

