/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.browsers.cache.CacheEntry;
import com.jpexs.browsers.cache.CacheImplementation;
import com.jpexs.browsers.cache.CacheReader;
import com.jpexs.decompiler.flash.SWFSourceInfo;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppFrame;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ReReadableInputStream;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;

public class LoadFromCacheFrame
extends AppFrame {
    private final JList<CacheEntry> list;
    private final JTextField searchField;
    private List<CacheImplementation> caches;
    private List<CacheEntry> entries;
    private final JProgressBar progressBar;
    private final JButton saveButton;
    private final JButton refreshButton;
    private final JButton openButton;

    public LoadFromCacheFrame() {
        this.setSize(900, 600);
        View.setWindowIcon(this);
        View.centerScreen(this);
        this.setTitle(this.translate("dialog.title"));
        this.setDefaultCloseOperation(1);
        Container cnt = this.getContentPane();
        this.list = new JList();
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    LoadFromCacheFrame.this.openSWF();
                }
            }
        });
        this.searchField = new JTextField();
        this.searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                LoadFromCacheFrame.this.filter();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        cnt.setLayout(new BorderLayout());
        cnt.add((Component)this.searchField, "North");
        cnt.add((Component)new JScrollPane(this.list), "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.openButton = new JButton(this.translate("button.open"));
        this.openButton.addActionListener(this::openButtonActionPerformed);
        buttonsPanel.add(this.openButton);
        this.saveButton = new JButton(this.translate("button.save"));
        this.saveButton.addActionListener(this::saveButtonActionPerformed);
        buttonsPanel.add(this.saveButton);
        this.refreshButton = new JButton(this.translate("button.refresh"));
        this.refreshButton.addActionListener(this::refreshButtonActionPerformed);
        buttonsPanel.add(this.refreshButton);
        JPanel browsersPanel = new JPanel(new FlowLayout());
        browsersPanel.add(new JLabel(this.translate("supported.browsers")));
        JLabel chromeLabel = new JLabel("Google Chrome", View.getIcon("chrome16"), 0);
        JLabel firefoxLabel = new JLabel("Mozilla Firefox*", View.getIcon("firefox16"), 0);
        browsersPanel.add(chromeLabel);
        browsersPanel.add(firefoxLabel);
        buttonsPanel.setAlignmentX(0.5f);
        this.progressBar = new JProgressBar();
        this.progressBar.setAlignmentX(0.5f);
        this.progressBar.setIndeterminate(true);
        bottomPanel.add(this.progressBar);
        bottomPanel.add(buttonsPanel);
        browsersPanel.setAlignmentX(0.5f);
        bottomPanel.add(browsersPanel);
        JLabel infoLabel = new JLabel(this.translate("info.closed"));
        infoLabel.setAlignmentX(0.5f);
        bottomPanel.add(infoLabel);
        cnt.add((Component)bottomPanel, "South");
        this.progressBar.setVisible(false);
        this.openButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        images.add(View.loadImage("loadcache16"));
        images.add(View.loadImage("loadcache32"));
        this.setIconImages(images);
        this.refresh();
    }

    private void refresh() {
        this.progressBar.setVisible(true);
        this.openButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                if (LoadFromCacheFrame.this.caches == null) {
                    LoadFromCacheFrame.this.caches = new ArrayList();
                    for (String b : CacheReader.availableBrowsers()) {
                        LoadFromCacheFrame.this.caches.add(CacheReader.getBrowserCache(b));
                    }
                } else {
                    for (CacheImplementation c : LoadFromCacheFrame.this.caches) {
                        c.refresh();
                    }
                }
                LoadFromCacheFrame.this.entries = new ArrayList();
                for (CacheImplementation c : LoadFromCacheFrame.this.caches) {
                    List<CacheEntry> list = c.getEntries();
                    if (list == null) continue;
                    for (CacheEntry en : c.getEntries()) {
                        String contentType = en.getHeader("Content-Type");
                        if (!"application/x-shockwave-flash".equals(contentType)) continue;
                        LoadFromCacheFrame.this.entries.add(en);
                    }
                }
                LoadFromCacheFrame.this.filter();
                return null;
            }

            @Override
            protected void done() {
                LoadFromCacheFrame.this.openButton.setEnabled(true);
                LoadFromCacheFrame.this.saveButton.setEnabled(true);
                LoadFromCacheFrame.this.refreshButton.setEnabled(true);
                LoadFromCacheFrame.this.progressBar.setVisible(false);
            }
        }.execute();
    }

    private void filter() {
        String search = this.searchField.getText();
        ArrayList<CacheEntry> filtered = new ArrayList<CacheEntry>();
        for (CacheEntry en : this.entries) {
            if (!search.isEmpty() && !en.getRequestURL().contains(search)) continue;
            filtered.add(en);
        }
        this.list.setListData(new Vector(filtered));
    }

    private static String entryToFileName(CacheEntry en) {
        String ret = en.getRequestURL();
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf(63));
        }
        if (ret.contains("/")) {
            ret = ret.substring(ret.lastIndexOf(47) + 1);
        }
        return ret;
    }

    private void openSWF() {
        CacheEntry en = this.list.getSelectedValue();
        if (en != null) {
            ReReadableInputStream str = new ReReadableInputStream(en.getResponseDataStream());
            SWFSourceInfo sourceInfo = new SWFSourceInfo((InputStream)str, null, LoadFromCacheFrame.entryToFileName(en));
            Main.openFile(sourceInfo);
        }
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.openSWF();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        List<CacheEntry> selected = this.list.getSelectedValuesList();
        if (!selected.isEmpty()) {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File((String)Configuration.lastSaveDir.get()));
            if (selected.size() > 1) {
                fc.setFileSelectionMode(1);
            } else {
                fc.setSelectedFile(new File((String)Configuration.lastSaveDir.get(), LoadFromCacheFrame.entryToFileName(selected.get(0))));
                fc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getName().endsWith(".swf") || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return AppStrings.translate("filter.swf");
                    }
                });
            }
            fc.setAcceptAllFileFilterUsed(false);
            JFrame f = new JFrame();
            View.setWindowIcon(f);
            if (fc.showSaveDialog(f) == 0) {
                File file = Helper.fixDialogFile((File)fc.getSelectedFile());
                try {
                    if (selected.size() == 1) {
                        Helper.saveStream((InputStream)selected.get(0).getResponseDataStream(), (File)file);
                    } else {
                        for (CacheEntry sel : selected) {
                            Helper.saveStream((InputStream)sel.getResponseDataStream(), (File)new File(file, LoadFromCacheFrame.entryToFileName(sel)));
                        }
                    }
                    Configuration.lastSaveDir.set((Object)file.getParentFile().getAbsolutePath());
                }
                catch (IOException ex) {
                    View.showMessageDialog(null, this.translate("error.file.write"));
                }
            }
        }
    }
}

