/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.AppFrame;
import com.jpexs.decompiler.flash.gui.ErrorState;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainFrame;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;

public class ErrorLogFrame
extends AppFrame {
    private static ErrorLogFrame instance;
    private final JPanel logView = new JPanel();
    private final JPanel logViewInner = new JPanel();
    private final Handler handler;
    private final ImageIcon expandIcon;
    private final ImageIcon collapseIcon;
    private ErrorState errorState = ErrorState.NO_ERROR;
    private static final int MAX_LOG_ITEM_COUNT = 100;
    private final AtomicInteger logItemCount = new AtomicInteger();

    public Handler getHandler() {
        return this.handler;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static ErrorLogFrame getInstance() {
        if (instance == null) {
            instance = new ErrorLogFrame();
            Logger logger = Logger.getLogger("");
            logger.addHandler(instance.getHandler());
        }
        return instance;
    }

    public static ErrorLogFrame createNewInstance() {
        if (instance != null) {
            Logger logger = Logger.getLogger("");
            logger.removeHandler(instance.getHandler());
            instance.setVisible(false);
            instance.dispose();
            instance = null;
        }
        return ErrorLogFrame.getInstance();
    }

    public ErrorState getErrorState() {
        return this.errorState;
    }

    public ErrorLogFrame() {
        this.setTitle(this.translate("dialog.title"));
        this.setSize(700, 400);
        this.setBackground(Color.white);
        View.centerScreen(this);
        View.setWindowIcon(this);
        this.setDefaultCloseOperation(1);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        this.logView.setBackground(Color.white);
        this.logView.setLayout(new BorderLayout());
        cnt.setBackground(Color.white);
        this.logViewInner.setLayout(new BoxLayout(this.logViewInner, 1));
        this.logView.add((Component)this.logViewInner, "North");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton clearButton = new JButton(this.translate("clear"));
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorLogFrame.this.clearLog();
            }
        });
        buttonsPanel.add(clearButton);
        this.expandIcon = View.getIcon("expand16");
        this.collapseIcon = View.getIcon("collapse16");
        cnt.add((Component)buttonsPanel, "South");
        cnt.add((Component)new JScrollPane(this.logView), "Center");
        this.handler = new Handler(){
            SimpleFormatter formatter = new SimpleFormatter();

            @Override
            public void publish(LogRecord record) {
                if (this.getLevel().intValue() <= record.getLevel().intValue()) {
                    ErrorLogFrame.this.log(record.getLevel(), this.formatter.formatMessage(record), record.getThrown());
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        this.handler.setLevel(Level.WARNING);
    }

    public void clearLog() {
        this.logViewInner.removeAll();
        this.logItemCount.set(0);
        Main.clearLogFile();
        this.revalidate();
        this.repaint();
    }

    public void clearErrorState() {
        this.errorState = ErrorState.NO_ERROR;
        MainFrame mainFrame = Main.getMainFrame();
        if (mainFrame != null) {
            mainFrame.getPanel().setErrorState(this.errorState);
        }
    }

    private void notifyMainFrame(Level level) {
        MainFrame mainFrame;
        boolean stateChanged = false;
        if (level.intValue() >= Level.SEVERE.intValue()) {
            if (this.errorState != ErrorState.ERROR) {
                this.errorState = ErrorState.ERROR;
                stateChanged = true;
            }
        } else if (level.intValue() >= Level.WARNING.intValue()) {
            if (this.errorState != ErrorState.ERROR && this.errorState != ErrorState.WARNING) {
                this.errorState = ErrorState.WARNING;
                stateChanged = true;
            }
        } else if (level.intValue() >= Level.INFO.intValue() && this.errorState == ErrorState.NO_ERROR) {
            this.errorState = ErrorState.INFO;
            stateChanged = true;
        }
        if (stateChanged && (mainFrame = Main.getMainFrame()) != null) {
            mainFrame.getPanel().setErrorState(this.errorState);
        }
    }

    private void log(final Level level, final String msg, final String detail) {
        if (this.logItemCount.getAndIncrement() < 100) {
            View.execInEventDispatchLater(() -> {
                JScrollPane scrollPane;
                JTextArea detailComponent;
                this.notifyMainFrame(level);
                JPanel pan = new JPanel();
                pan.setBackground(Color.white);
                pan.setLayout(new BoxLayout(pan, 1));
                if (detail == null) {
                    detailComponent = null;
                } else {
                    JTextArea detailTextArea = new JTextArea(detail);
                    detailTextArea.setEditable(false);
                    detailTextArea.setOpaque(false);
                    detailTextArea.setFont(new JLabel().getFont());
                    detailTextArea.setBackground(Color.white);
                    detailComponent = detailTextArea;
                }
                JPanel header = new JPanel();
                header.setLayout(new BoxLayout(header, 0));
                header.setBackground(Color.white);
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/YYYY HH:mm:ss");
                final String dateStr = format.format(new Date());
                JToggleButton copyButton = new JToggleButton(View.getIcon("copy16"));
                copyButton.setFocusPainted(false);
                copyButton.setBorderPainted(false);
                copyButton.setFocusable(false);
                copyButton.setContentAreaFilled(false);
                copyButton.setCursor(Cursor.getPredefinedCursor(12));
                copyButton.setMargin(new Insets(2, 2, 2, 2));
                copyButton.setToolTipText(this.translate("copy"));
                copyButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        StringSelection stringSelection = new StringSelection(dateStr + " " + level.toString() + " " + msg + "\r\n" + detail);
                        clipboard.setContents(stringSelection, null);
                    }
                });
                final JToggleButton expandButton = new JToggleButton(this.collapseIcon);
                expandButton.setFocusPainted(false);
                expandButton.setBorderPainted(false);
                expandButton.setFocusable(false);
                expandButton.setContentAreaFilled(false);
                expandButton.setCursor(Cursor.getPredefinedCursor(12));
                expandButton.setMargin(new Insets(2, 2, 2, 2));
                expandButton.setToolTipText(this.translate("details"));
                if (detailComponent != null) {
                    scrollPane = new JScrollPane(detailComponent);
                    scrollPane.setAlignmentX(0.0f);
                } else {
                    scrollPane = null;
                }
                if (detailComponent != null) {
                    expandButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            expandButton.setIcon(expandButton.isSelected() ? ErrorLogFrame.this.expandIcon : ErrorLogFrame.this.collapseIcon);
                            scrollPane.setVisible(expandButton.isSelected());
                            ErrorLogFrame.this.revalidate();
                            ErrorLogFrame.this.repaint();
                        }
                    });
                }
                if (detailComponent != null) {
                    header.add(expandButton);
                }
                JLabel dateLabel = new JLabel(dateStr);
                dateLabel.setPreferredSize(new Dimension(200, (int)dateLabel.getPreferredSize().getHeight()));
                dateLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                header.add(dateLabel);
                JLabel levelLabel = new JLabel(level.getName());
                levelLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                header.add(levelLabel);
                JTextArea msgLabel = new JTextArea(msg);
                msgLabel.setEditable(false);
                msgLabel.setOpaque(false);
                msgLabel.setFont(levelLabel.getFont());
                msgLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                header.add(msgLabel);
                header.setAlignmentX(0.0f);
                header.add(copyButton);
                pan.add(header);
                if (detailComponent != null) {
                    pan.add(scrollPane);
                    scrollPane.setVisible(false);
                }
                pan.setAlignmentX(0.0f);
                this.logViewInner.add(pan);
                this.revalidate();
                this.repaint();
            });
        }
    }

    public void log(Level level, String msg) {
        this.log(level, msg, (String)null);
    }

    public void log(Level level, String msg, Throwable ex) {
        StringWriter sw = new StringWriter();
        if (ex != null) {
            ex.printStackTrace(new PrintWriter(sw));
        }
        this.log(level, msg, sw.toString());
    }

    @Override
    public void dispose() {
        this.removeAll();
        Helper.emptyObject((Object)this);
        super.dispose();
    }
}

