/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.ApplicationInfo;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.LinkLabel;
import com.jpexs.decompiler.flash.gui.SelectLanguageDialog;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutDialog
extends AppDialog {
    private static final String[] DEVELOPERS = new String[]{"JPEXS", "honfika", "others"};
    private static final String AUTHOR = "JPEXS";

    public AboutDialog() {
        this.setDefaultCloseOperation(1);
        this.setTitle(this.translate("dialog.title"));
        AboutDialog.DEVELOPERS[AboutDialog.DEVELOPERS.length - 1] = this.translate("developers.others");
        JPanel twoPanes = new JPanel();
        twoPanes.setLayout(new BoxLayout(twoPanes, 0));
        Container cnt = this.getContentPane();
        JPanel cp = new JPanel();
        cp.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        cnt.setLayout(new BorderLayout());
        JPanel appNamePanel = new JPanel(new FlowLayout());
        JLabel jpLabel = new JLabel(AUTHOR);
        jpLabel.setAlignmentX(0.5f);
        jpLabel.setForeground(new Color(0, 0, 160));
        jpLabel.setFont(new Font("Tahoma", 1, 25));
        jpLabel.setHorizontalAlignment(0);
        appNamePanel.add(jpLabel);
        JLabel ffLabel = new JLabel("Free Flash");
        ffLabel.setAlignmentX(0.5f);
        ffLabel.setFont(new Font("Tahoma", 1, 25));
        ffLabel.setHorizontalAlignment(0);
        appNamePanel.add(ffLabel);
        JLabel decLabel = new JLabel("Decompiler");
        decLabel.setAlignmentX(0.5f);
        decLabel.setForeground(Color.red);
        decLabel.setFont(new Font("Tahoma", 1, 25));
        decLabel.setHorizontalAlignment(0);
        appNamePanel.add(decLabel);
        appNamePanel.setAlignmentX(0.5f);
        cp = new JPanel();
        cp.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        cp.setLayout(new BoxLayout(cp, 1));
        cp.add(appNamePanel);
        JLabel verLabel = new JLabel(this.translate("version") + " " + ApplicationInfo.version);
        verLabel.setAlignmentX(0.5f);
        verLabel.setFont(new Font("Tahoma", 1, 15));
        verLabel.setHorizontalAlignment(0);
        cp.add(verLabel);
        cnt.add((Component)cp, "North");
        cp = new JPanel();
        cp.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        cp.setLayout(new BoxLayout(cp, 1));
        JLabel byLabel = new JLabel(this.translate("by"));
        byLabel.setAlignmentX(0.5f);
        byLabel.setHorizontalAlignment(0);
        cp.add(byLabel);
        JLabel authorLabel = new JLabel(AUTHOR);
        authorLabel.setAlignmentX(0.5f);
        authorLabel.setForeground(new Color(0, 0, 160));
        authorLabel.setFont(new Font("Tahoma", 1, 20));
        authorLabel.setHorizontalAlignment(0);
        cp.add(authorLabel);
        JLabel dateLabel = new JLabel("2010-2016");
        dateLabel.setAlignmentX(0.5f);
        dateLabel.setHorizontalAlignment(0);
        cp.add(dateLabel);
        LinkLabel wwwLabel = new LinkLabel("https://www.free-decompiler.com/flash", "https://www.free-decompiler.com/flash?utm_source=app&utm_medium=about&utm_campaign=app");
        wwwLabel.setAlignmentX(0.5f);
        wwwLabel.setForeground(Color.blue);
        wwwLabel.setHorizontalAlignment(0);
        cp.add(wwwLabel);
        cp.add(Box.createVerticalStrut(20));
        JLabel transAuthorLabel = new JLabel(this.translate("translation.author.label"));
        transAuthorLabel.setAlignmentX(0.5f);
        transAuthorLabel.setHorizontalAlignment(0);
        JLabel transAuthor = new JLabel(this.translate("translation.author"));
        transAuthor.setAlignmentX(0.5f);
        transAuthor.setHorizontalAlignment(0);
        cp.add(transAuthorLabel);
        cp.add(transAuthor);
        cp.add(Box.createVerticalStrut(50));
        JLabel developersLabel = new JLabel(this.translate("developers"));
        developersLabel.setAlignmentX(0.5f);
        developersLabel.setHorizontalAlignment(0);
        developersLabel.setFont(developersLabel.getFont().deriveFont(1));
        cp.add(developersLabel);
        for (String c : DEVELOPERS) {
            JLabel developerNameLabel = new JLabel(c);
            developerNameLabel.setAlignmentX(0.5f);
            developerNameLabel.setHorizontalAlignment(0);
            cp.add(developerNameLabel);
        }
        cp.setAlignmentY(0.0f);
        twoPanes.add(cp);
        cp = new JPanel();
        cp.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        cp.setLayout(new BoxLayout(cp, 1));
        JLabel translatorsLabel = new JLabel(this.translate("translators"));
        translatorsLabel.setAlignmentX(0.5f);
        translatorsLabel.setHorizontalAlignment(0);
        translatorsLabel.setFont(translatorsLabel.getFont().deriveFont(1));
        cp.add(translatorsLabel);
        ArrayList<String> translators = new ArrayList<String>();
        for (String code : SelectLanguageDialog.languages) {
            Locale l = Locale.forLanguageTag(code.equals("en") ? "" : code);
            ResourceBundle b = ResourceBundle.getBundle(AppStrings.getResourcePath(AboutDialog.class), l);
            translators.add(Locale.forLanguageTag(code).getDisplayName() + " - " + b.getString("translation.author"));
        }
        for (String c : translators) {
            JLabel translatorName = new JLabel(c);
            translatorName.setAlignmentX(0.5f);
            translatorName.setHorizontalAlignment(0);
            cp.add(translatorName);
        }
        cp.add(Box.createVerticalStrut(10));
        cp.setAlignmentY(0.0f);
        twoPanes.add(cp);
        cnt.add((Component)twoPanes, "Center");
        cp = new JPanel(new FlowLayout());
        cnt.add((Component)cp, "South");
        JButton okButton = new JButton(this.translate("button.ok"));
        okButton.setAlignmentX(0.5f);
        cp.add(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        this.setModal(true);
        View.setWindowIcon(this);
        this.setResizable(false);
        this.pack();
        View.centerScreen(this);
    }
}

