/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache.firefox;

import com.jpexs.browsers.cache.CacheEntry;
import com.jpexs.browsers.cache.CacheImplementation;
import com.jpexs.browsers.cache.firefox.CacheMap;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FirefoxCache
implements CacheImplementation {
    private static volatile FirefoxCache instance;
    private boolean loaded = false;
    private CacheMap map;

    private FirefoxCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FirefoxCache getInstance() {
        if (instance != null) return instance;
        Class<FirefoxCache> clazz = FirefoxCache.class;
        synchronized (FirefoxCache.class) {
            if (instance != null) return instance;
            instance = new FirefoxCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void refresh() {
        File dir = FirefoxCache.getCacheDirectory();
        if (dir == null) {
            return;
        }
        File cacheMapFile = new File(dir, "_CACHE_MAP_");
        try {
            this.map = new CacheMap(cacheMapFile);
        }
        catch (IOException ex) {
            Logger.getLogger(FirefoxCache.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.loaded = true;
    }

    @Override
    public List<CacheEntry> getEntries() {
        if (!this.loaded) {
            this.refresh();
        }
        if (this.map == null) {
            return null;
        }
        ArrayList<CacheEntry> ret = new ArrayList<CacheEntry>();
        ret.addAll(this.map.mapBuckets);
        return ret;
    }

    private static OSId getOSId() {
        PrivilegedAction<String> doGetOSName = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        };
        OSId id = OSId.UNIX;
        String osName = AccessController.doPrivileged(doGetOSName);
        if (osName != null) {
            if (osName.toLowerCase().startsWith("mac os x")) {
                id = OSId.OSX;
            } else if (osName.contains("Windows")) {
                id = OSId.WINDOWS;
            }
        }
        return id;
    }

    public static File getProfileDirectory() {
        File profilesDir = FirefoxCache.getProfilesDirectory();
        if (profilesDir == null) {
            return null;
        }
        File[] profiles = profilesDir.listFiles();
        File profileDir = null;
        for (File f : profiles) {
            if (!f.isDirectory() || !f.getName().matches("[a-z0-9]+\\.default")) continue;
            profileDir = f;
            break;
        }
        return profileDir;
    }

    public static File getCacheDirectory() {
        File profileDir = FirefoxCache.getProfileDirectory();
        File cacheDir = null;
        if (profileDir != null) {
            cacheDir = new File(profileDir, "Cache");
        }
        if (cacheDir == null) {
            return null;
        }
        if (!cacheDir.exists()) {
            return null;
        }
        return cacheDir;
    }

    public static File getProfilesDirectory() {
        String userHome = null;
        File profilesDir = null;
        try {
            userHome = System.getProperty("user.home");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (userHome != null) {
            OSId osId = FirefoxCache.getOSId();
            if (osId == OSId.WINDOWS) {
                profilesDir = new File(userHome + "\\AppData\\Local\\Mozilla\\Firefox\\Profiles");
                if (!profilesDir.exists()) {
                    profilesDir = new File(userHome + "\\Local Settings\\Application Data\\Mozilla\\Firefox\\Profiles");
                }
            } else {
                profilesDir = osId == OSId.OSX ? new File(userHome + "/Library/Caches/Firefox/Profiles") : new File(userHome + "/.mozilla/firefox");
            }
        }
        if (profilesDir == null || !profilesDir.exists()) {
            return null;
        }
        return profilesDir;
    }

    private static enum OSId {
        WINDOWS,
        OSX,
        UNIX;

    }
}

